# Generated by default/object.tt
package Paws::WAFV2::HTTPHeader;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::HTTPHeader

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::HTTPHeader object:

  $service_obj->Method(Att1 => { Name => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::HTTPHeader object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

Part of the response from GetSampledRequests. This is a complex type
that appears as C<Headers> in the response syntax. C<HTTPHeader>
contains the names and values of all of the headers that appear in one
of the web requests.

=head1 ATTRIBUTES


=head2 Name => Str

The name of the HTTP header.


=head2 Value => Str

The value of the HTTP header.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

