use strict;

use Test::More tests => 6;
BEGIN { push @INC, qw(blib/script) if -d 'blib' };

my $perl_ostype = eval { require Perl::OSType; };

SKIP: {
   skip "No Perl::OSType", 3 unless $perl_ostype;
   ok( Perl::OSType::os_type(), 'Perl::OSType::os_type' );
   ok( Perl::OSType::is_os_type('Windows','MSWin32'), 'MSWin32 is Windows');
   ok( !Perl::OSType::is_os_type('Windows','darwin'), 'darwin isn\'t Windows');
}


SKIP: {
    skip "Not darwin", 3 unless $^O eq 'darwin';
    ok( eval { require('rename') }, 'darwin: script is rename');
    ok( !eval { require('file-rename') }, 'darwin: script not file-rename');
    like( $INC{rename}, qr{/ rename \z}msx, "required script in \%INC");
}
