# Generated by default/object.tt
package Paws::ApplicationMigration::JobLog;
  use Moose;
  has Event => (is => 'ro', isa => 'Str', request_name => 'event', traits => ['NameInRequest']);
  has EventData => (is => 'ro', isa => 'Paws::ApplicationMigration::JobLogEventData', request_name => 'eventData', traits => ['NameInRequest']);
  has LogDateTime => (is => 'ro', isa => 'Str', request_name => 'logDateTime', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::JobLog

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::JobLog object:

  $service_obj->Method(Att1 => { Event => $value, ..., LogDateTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::JobLog object:

  $result = $service_obj->Method(...);
  $result->Att1->Event

=head1 DESCRIPTION

Job log.

=head1 ATTRIBUTES


=head2 Event => Str

Job log event.


=head2 EventData => L<Paws::ApplicationMigration::JobLogEventData>

Job event data


=head2 LogDateTime => Str

Job log event date and time.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

