#!/usr/local/bin/perl

use strict;
use warnings;

use Config;
use File::Basename qw(&basename &dirname);
use File::Spec;
use Cwd;

# List explicitly here the variables you want Configure to
# generate.  Metaconfig only looks for shell variables, so you
# have to mention them as if they were shell variables, not
# %Config entries:
#  $startperl
#  $perlpath
#  $eunicefix

# This forces PL files to create target in same directory as PL file.
# This is so that make depend always knows where to find PL derivatives.
my $origdir = cwd;
chdir dirname($0);
my $file = basename($0, '.PL');
$file .= '.com' if $^O eq 'VMS';

# Open input file before creating output file.
my $in = File::Spec->catfile(File::Spec->updir, 'lib', 'diagnostics.pm');
open IN, '<', $in or die "Can't open $in: $!\n";

# Create output file.
open OUT, '>', $file or die "Can't create $file: $!";

print "Extracting $file (with variable substitutions)\n";

# In this section, perl variables will be expanded during extraction.
# You can use $Config{...} to use Configure variables.

print OUT <<"!GROK!THIS!";
$Config{startperl}
    eval 'exec $Config{perlpath} -S \$0 \${1+"\$@"}'
	if 0; # ^ Run only under a shell
!GROK!THIS!

print OUT <<'!NO!SUBS!';

BEGIN { pop @INC if $INC[-1] eq '.' }

!NO!SUBS!

while (<IN>) {
    print OUT unless /^package diagnostics/;
}

close IN;

close OUT or die "Can't close $file: $!";
chmod 0755, $file or die "Can't reset permissions for $file: $!\n";
exec("$Config{'eunicefix'} $file") if $Config{'eunicefix'} ne ':';
chdir $origdir;
