#!/usr/bin/pugs

use v6;
use Test;

plan 880;

is(("abc" ~~ rx:P5/abc/ && $<>), "abc", 're_tests 1/0 (1)');
is(("abc" ~~ rx:P5/abc/ && $/.from), 0, 're_tests 1/0 (2)');
ok((not ("xbc" ~~ rx:P5/abc/)), 're_tests 3  (5)');
ok((not ("axc" ~~ rx:P5/abc/)), 're_tests 5  (7)');
ok((not ("abx" ~~ rx:P5/abc/)), 're_tests 7  (9)');
is(("xabcy" ~~ rx:P5/abc/ && $<>), "abc", 're_tests 9/0 (11)');
is(("xabcy" ~~ rx:P5/abc/ && $/.from), 1, 're_tests 9/0 (12)');
is(("ababc" ~~ rx:P5/abc/ && $<>), "abc", 're_tests 11/0 (15)');
is(("ababc" ~~ rx:P5/abc/ && $/.from), 2, 're_tests 11/0 (16)');
is(("abc" ~~ rx:P5/ab*c/ && $<>), "abc", 're_tests 13/0 (19)');
is(("abc" ~~ rx:P5/ab*c/ && $/.from), 0, 're_tests 13/0 (20)');
is(("abc" ~~ rx:P5/ab*bc/ && $<>), "abc", 're_tests 15/0 (23)');
is(("abc" ~~ rx:P5/ab*bc/ && $/.from), 0, 're_tests 15/0 (24)');
is(("abbc" ~~ rx:P5/ab*bc/ && $<>), "abbc", 're_tests 17/0 (27)');
is(("abbc" ~~ rx:P5/ab*bc/ && $/.from), 0, 're_tests 17/0 (28)');
is(("abbbbc" ~~ rx:P5/ab*bc/ && $<>), "abbbbc", 're_tests 19/0 (31)');
is(("abbbbc" ~~ rx:P5/ab*bc/ && $/.from), 0, 're_tests 19/0 (32)');
is(("abbbbc" ~~ rx:P5/.{1}/ && $<>), "a", 're_tests 21/0 (35)');
is(("abbbbc" ~~ rx:P5/.{1}/ && $/.from), 0, 're_tests 21/0 (36)');
is(("abbbbc" ~~ rx:P5/.{3,4}/ && $<>), "abbb", 're_tests 23/0 (39)');
is(("abbbbc" ~~ rx:P5/.{3,4}/ && $/.from), 0, 're_tests 23/0 (40)');
is(("abbbbc" ~~ rx:P5/ab{0,}bc/ && $<>), "abbbbc", 're_tests 25/0 (43)');
is(("abbbbc" ~~ rx:P5/ab{0,}bc/ && $/.from), 0, 're_tests 25/0 (44)');
is(("abbc" ~~ rx:P5/ab+bc/ && $<>), "abbc", 're_tests 27/0 (47)');
is(("abbc" ~~ rx:P5/ab+bc/ && $/.from), 0, 're_tests 27/0 (48)');
ok((not ("abc" ~~ rx:P5/ab+bc/)), 're_tests 29  (51)');
ok((not ("abq" ~~ rx:P5/ab+bc/)), 're_tests 31  (53)');
ok((not ("abq" ~~ rx:P5/ab{1,}bc/)), 're_tests 33  (55)');
is(("abbbbc" ~~ rx:P5/ab+bc/ && $<>), "abbbbc", 're_tests 35/0 (57)');
is(("abbbbc" ~~ rx:P5/ab+bc/ && $/.from), 0, 're_tests 35/0 (58)');
is(("abbbbc" ~~ rx:P5/ab{1,}bc/ && $<>), "abbbbc", 're_tests 37/0 (61)');
is(("abbbbc" ~~ rx:P5/ab{1,}bc/ && $/.from), 0, 're_tests 37/0 (62)');
is(("abbbbc" ~~ rx:P5/ab{1,3}bc/ && $<>), "abbbbc", 're_tests 39/0 (65)');
is(("abbbbc" ~~ rx:P5/ab{1,3}bc/ && $/.from), 0, 're_tests 39/0 (66)');
is(("abbbbc" ~~ rx:P5/ab{3,4}bc/ && $<>), "abbbbc", 're_tests 41/0 (69)');
is(("abbbbc" ~~ rx:P5/ab{3,4}bc/ && $/.from), 0, 're_tests 41/0 (70)');
ok((not ("abbbbc" ~~ rx:P5/ab{4,5}bc/)), 're_tests 43  (73)');
is(("abbc" ~~ rx:P5/ab?bc/ && $<>), "abbc", 're_tests 45/0 (75)');
is(("abc" ~~ rx:P5/ab?bc/ && $<>), "abc", 're_tests 47/0 (77)');
is(("abc" ~~ rx:P5/ab{0,1}bc/ && $<>), "abc", 're_tests 49/0 (79)');
ok((not ("abbbbc" ~~ rx:P5/ab?bc/)), 're_tests 51  (81)');
is(("abc" ~~ rx:P5/ab?c/ && $<>), "abc", 're_tests 53/0 (83)');
is(("abc" ~~ rx:P5/ab{0,1}c/ && $<>), "abc", 're_tests 55/0 (85)');
is(("abc" ~~ rx:P5/^abc$/ && $<>), "abc", 're_tests 57/0 (87)');
ok((not ("abcc" ~~ rx:P5/^abc$/)), 're_tests 59  (89)');
is(("abcc" ~~ rx:P5/^abc/ && $<>), "abc", 're_tests 61/0 (91)');
ok((not ("aabc" ~~ rx:P5/^abc$/)), 're_tests 63  (93)');
is(("aabc" ~~ rx:P5/abc$/ && $<>), "abc", 're_tests 65/0 (95)');
ok((not ("aabcd" ~~ rx:P5/abc$/)), 're_tests 67  (97)');
is(("abc" ~~ rx:P5/^/ && $<>), "", 're_tests 69/0 (99)');
is(("abc" ~~ rx:P5/$/ && $<>), "", 're_tests 71/0 (101)');
is(("abc" ~~ rx:P5/a.c/ && $<>), "abc", 're_tests 73/0 (103)');
is(("axc" ~~ rx:P5/a.c/ && $<>), "axc", 're_tests 75/0 (105)');
is(("axyzc" ~~ rx:P5/a.*c/ && $<>), "axyzc", 're_tests 77/0 (107)');
ok((not ("axyzd" ~~ rx:P5/a.*c/)), 're_tests 79  (109)');
ok((not ("abc" ~~ rx:P5/a[bc]d/)), 're_tests 81  (111)');
is(("abd" ~~ rx:P5/a[bc]d/ && $<>), "abd", 're_tests 83/0 (113)');
ok((not ("abd" ~~ rx:P5/a[b-d]e/)), 're_tests 85  (115)');
is(("ace" ~~ rx:P5/a[b-d]e/ && $<>), "ace", 're_tests 87/0 (117)');
is(("aac" ~~ rx:P5/a[b-d]/ && $<>), "ac", 're_tests 89/0 (119)');
is(("a-" ~~ rx:P5/a[-b]/ && $<>), "a-", 're_tests 91/0 (121)');
is(("a-" ~~ rx:P5/a[b-]/ && $<>), "a-", 're_tests 93/0 (123)');
is(("a]" ~~ rx:P5/a]/ && $<>), "a]", 're_tests 95/0 (125)');
is(("a]b" ~~ rx:P5/a[]]b/ && $<>), "a]b", 're_tests 97/0 (127)');
is(("aed" ~~ rx:P5/a[^bc]d/ && $<>), "aed", 're_tests 99/0 (129)');
ok((not ("abd" ~~ rx:P5/a[^bc]d/)), 're_tests 101  (131)');
is(("adc" ~~ rx:P5/a[^-b]c/ && $<>), "adc", 're_tests 103/0 (133)');
ok((not ("a-c" ~~ rx:P5/a[^-b]c/)), 're_tests 105  (135)');
ok((not ("a]c" ~~ rx:P5/a[^]b]c/)), 're_tests 107  (137)');
is(("adc" ~~ rx:P5/a[^]b]c/ && $<>), "adc", 're_tests 109/0 (139)');
ok(("a-" ~~ rx:P5/\ba\b/), 're_tests 111  (141)');
ok(("-a" ~~ rx:P5/\ba\b/), 're_tests 113  (143)');
ok(("-a-" ~~ rx:P5/\ba\b/), 're_tests 115  (145)');
ok((not ("xy" ~~ rx:P5/\by\b/)), 're_tests 117  (147)');
ok((not ("yz" ~~ rx:P5/\by\b/)), 're_tests 119  (149)');
ok((not ("xyz" ~~ rx:P5/\by\b/)), 're_tests 121  (151)');
ok((not ("a-" ~~ rx:P5/\Ba\B/)), 're_tests 123  (153)');
ok((not ("-a" ~~ rx:P5/\Ba\B/)), 're_tests 125  (155)');
ok((not ("-a-" ~~ rx:P5/\Ba\B/)), 're_tests 127  (157)');
ok(("xy" ~~ rx:P5/\By\b/), 're_tests 129  (159)');
is(("xy" ~~ rx:P5/\By\b/ && $/.from), 1, 're_tests 131/0 (161)');
ok(("xy" ~~ rx:P5/\By\b/), 're_tests 133  (163)');
ok(("yz" ~~ rx:P5/\by\B/), 're_tests 135  (165)');
ok(("xyz" ~~ rx:P5/\By\B/), 're_tests 137  (167)');
ok(("a" ~~ rx:P5/\w/), 're_tests 139  (169)');
ok((not ("-" ~~ rx:P5/\w/)), 're_tests 141  (171)');
ok((not ("a" ~~ rx:P5/\W/)), 're_tests 143  (173)');
ok(("-" ~~ rx:P5/\W/), 're_tests 145  (175)');
ok(("a b" ~~ rx:P5/a\sb/), 're_tests 147  (177)');
ok((not ("a-b" ~~ rx:P5/a\sb/)), 're_tests 149  (179)');
ok((not ("a b" ~~ rx:P5/a\Sb/)), 're_tests 151  (181)');
ok(("a-b" ~~ rx:P5/a\Sb/), 're_tests 153  (183)');
ok(("1" ~~ rx:P5/\d/), 're_tests 155  (185)');
ok((not ("-" ~~ rx:P5/\d/)), 're_tests 157  (187)');
ok((not ("1" ~~ rx:P5/\D/)), 're_tests 159  (189)');
ok(("-" ~~ rx:P5/\D/), 're_tests 161  (191)');
ok(("a" ~~ rx:P5/[\w]/), 're_tests 163  (193)');
ok((not ("-" ~~ rx:P5/[\w]/)), 're_tests 165  (195)');
ok((not ("a" ~~ rx:P5/[\W]/)), 're_tests 167  (197)');
ok(("-" ~~ rx:P5/[\W]/), 're_tests 169  (199)');
ok(("a b" ~~ rx:P5/a[\s]b/), 're_tests 171  (201)');
ok((not ("a-b" ~~ rx:P5/a[\s]b/)), 're_tests 173  (203)');
ok((not ("a b" ~~ rx:P5/a[\S]b/)), 're_tests 175  (205)');
ok(("a-b" ~~ rx:P5/a[\S]b/), 're_tests 177  (207)');
ok(("1" ~~ rx:P5/[\d]/), 're_tests 179  (209)');
ok((not ("-" ~~ rx:P5/[\d]/)), 're_tests 181  (211)');
ok((not ("1" ~~ rx:P5/[\D]/)), 're_tests 183  (213)');
ok(("-" ~~ rx:P5/[\D]/), 're_tests 185  (215)');
is(("abc" ~~ rx:P5/ab|cd/ && $<>), "ab", 're_tests 187/0 (217)');
is(("abcd" ~~ rx:P5/ab|cd/ && $<>), "ab", 're_tests 189/0 (219)');
is(("def" ~~ rx:P5/()ef/ && $<>), "ef", 're_tests 191/0 (221)');
is(("def" ~~ rx:P5/()ef/ && $0), "", 're_tests 191/1 (222)');
is(("def" ~~ rx:P5/()ef/ && $/.from), 1, 're_tests 193/0 (225)');
is(("def" ~~ rx:P5/()ef/ && $/[0].from), 1, 're_tests 195/1 (227)');
my $b = 'x';
ok((not ("b" ~~ rx:P5/$b/)), 're_tests 197  (229)');
is(("a(b" ~~ rx:P5/a\(b/ && $<>), "a(b", 're_tests 199/0 (231)');
is(("a(b" ~~ rx:P5/a\(b/ && $0), "", 're_tests 199/1 (232)');
is(("ab" ~~ rx:P5/a\(*b/ && $<>), "ab", 're_tests 201/0 (235)');
is(("a((b" ~~ rx:P5/a\(*b/ && $<>), "a((b", 're_tests 203/0 (237)');
is(("a\b" ~~ rx:P5/a\\b/ && $<>), "a\b", 're_tests 205/0 (239)', :todo<bug>);
is(("abc" ~~ rx:P5/((a))/ && $<>), "a", 're_tests 207/0 (241)');
is(("abc" ~~ rx:P5/((a))/ && $0), "a", 're_tests 207/1 (242)');
is(("abc" ~~ rx:P5/((a))/ && $1), "a", 're_tests 207/2 (243)');
is(("abc" ~~ rx:P5/(a)b(c)/ && $<>), "abc", 're_tests 209/0 (247)');
is(("abc" ~~ rx:P5/(a)b(c)/ && $0), "a", 're_tests 209/1 (248)');
is(("abc" ~~ rx:P5/(a)b(c)/ && $1), "c", 're_tests 209/2 (249)');
is(("aabbabc" ~~ rx:P5/a+b+c/ && $<>), "abc", 're_tests 211/0 (253)');
is(("aabbabc" ~~ rx:P5/a{1,}b{1,}c/ && $<>), "abc", 're_tests 213/0 (255)');
is(("abcabc" ~~ rx:P5/a.+?c/ && $<>), "abc", 're_tests 215/0 (257)');
is(("ab" ~~ rx:P5/(a+|b)*/ && $<>), "ab", 're_tests 217/0 (259)');
is(("ab" ~~ rx:P5/(a+|b)*/ && $0), "b", 're_tests 217/1 (260)');
is(("ab" ~~ rx:P5/(a+|b)*/ && $/.from), 0, 're_tests 219/0 (263)');
is(("ab" ~~ rx:P5/(a+|b)*/ && $/[0].from), 1, 're_tests 221/1 (265)');
is(("ab" ~~ rx:P5/(a+|b){0,}/ && $<>), "ab", 're_tests 223/0 (267)');
is(("ab" ~~ rx:P5/(a+|b){0,}/ && $0), "b", 're_tests 223/1 (268)');
is(("ab" ~~ rx:P5/(a+|b)+/ && $<>), "ab", 're_tests 225/0 (271)');
is(("ab" ~~ rx:P5/(a+|b)+/ && $0), "b", 're_tests 225/1 (272)');
is(("ab" ~~ rx:P5/(a+|b){1,}/ && $<>), "ab", 're_tests 227/0 (275)');
is(("ab" ~~ rx:P5/(a+|b){1,}/ && $0), "b", 're_tests 227/1 (276)');
is(("ab" ~~ rx:P5/(a+|b)?/ && $<>), "a", 're_tests 229/0 (279)');
is(("ab" ~~ rx:P5/(a+|b)?/ && $0), "a", 're_tests 229/1 (280)');
is(("ab" ~~ rx:P5/(a+|b){0,1}/ && $<>), "a", 're_tests 231/0 (283)');
is(("ab" ~~ rx:P5/(a+|b){0,1}/ && $0), "a", 're_tests 231/1 (284)');
is(("cde" ~~ rx:P5/[^ab]*/ && $<>), "cde", 're_tests 233/0 (287)');
ok((not ("" ~~ rx:P5/abc/)), 're_tests 235  (289)');
is(("" ~~ rx:P5/a*/ && $<>), "", 're_tests 237/0 (291)');
is(("abbbcd" ~~ rx:P5/([abc])*d/ && $<>), "abbbcd", 're_tests 239/0 (293)');
is(("abbbcd" ~~ rx:P5/([abc])*d/ && $0), "c", 're_tests 239/1 (294)');
is(("abcd" ~~ rx:P5/([abc])*bcd/ && $<>), "abcd", 're_tests 241/0 (297)');
is(("abcd" ~~ rx:P5/([abc])*bcd/ && $0), "a", 're_tests 241/1 (298)');
is(("e" ~~ rx:P5/a|b|c|d|e/ && $<>), "e", 're_tests 243/0 (301)');
is(("ef" ~~ rx:P5/(a|b|c|d|e)f/ && $<>), "ef", 're_tests 245/0 (303)');
is(("ef" ~~ rx:P5/(a|b|c|d|e)f/ && $0), "e", 're_tests 245/1 (304)');
is(("ef" ~~ rx:P5/(a|b|c|d|e)f/ && $/.from), 0, 're_tests 247/0 (307)');
is(("ef" ~~ rx:P5/(a|b|c|d|e)f/ && $/[0].from), 0, 're_tests 249/1 (309)');
is(("abcdefg" ~~ rx:P5/abcd*efg/ && $<>), "abcdefg", 're_tests 251/0 (311)');
is(("xabyabbbz" ~~ rx:P5/ab*/ && $<>), "ab", 're_tests 253/0 (313)');
is(("xayabbbz" ~~ rx:P5/ab*/ && $<>), "a", 're_tests 255/0 (315)');
is(("abcde" ~~ rx:P5/(ab|cd)e/ && $<>), "cde", 're_tests 257/0 (317)');
is(("abcde" ~~ rx:P5/(ab|cd)e/ && $0), "cd", 're_tests 257/1 (318)');
is(("hij" ~~ rx:P5/[abhgefdc]ij/ && $<>), "hij", 're_tests 259/0 (321)');
is(("abcdef" ~~ rx:P5/(abc|)ef/ && $<>), "ef", 're_tests 261/0 (323)');
is(("abcdef" ~~ rx:P5/(abc|)ef/ && $0), "", 're_tests 261/1 (324)');
is(("abcd" ~~ rx:P5/(a|b)c*d/ && $<>), "bcd", 're_tests 263/0 (327)');
is(("abcd" ~~ rx:P5/(a|b)c*d/ && $0), "b", 're_tests 263/1 (328)');
is(("abc" ~~ rx:P5/(ab|ab*)bc/ && $<>), "abc", 're_tests 265/0 (331)');
is(("abc" ~~ rx:P5/(ab|ab*)bc/ && $0), "a", 're_tests 265/1 (332)');
is(("abc" ~~ rx:P5/a([bc]*)c*/ && $<>), "abc", 're_tests 267/0 (335)');
is(("abc" ~~ rx:P5/a([bc]*)c*/ && $0), "bc", 're_tests 267/1 (336)');
is(("abcd" ~~ rx:P5/a([bc]*)(c*d)/ && $<>), "abcd", 're_tests 269/0 (339)');
is(("abcd" ~~ rx:P5/a([bc]*)(c*d)/ && $0), "bc", 're_tests 269/1 (340)');
is(("abcd" ~~ rx:P5/a([bc]*)(c*d)/ && $1), "d", 're_tests 269/2 (341)');
is(("abcd" ~~ rx:P5/a([bc]*)(c*d)/ && $/.from), 0, 're_tests 271/0 (345)');
is(("abcd" ~~ rx:P5/a([bc]*)(c*d)/ && $/[0].from), 1, 're_tests 273/1 (347)');
is(("abcd" ~~ rx:P5/a([bc]*)(c*d)/ && $/[1].from), 3, 're_tests 275/2 (349)');
is(("abcd" ~~ rx:P5/a([bc]+)(c*d)/ && $<>), "abcd", 're_tests 277/0 (351)');
is(("abcd" ~~ rx:P5/a([bc]+)(c*d)/ && $0), "bc", 're_tests 277/1 (352)');
is(("abcd" ~~ rx:P5/a([bc]+)(c*d)/ && $1), "d", 're_tests 277/2 (353)');
is(("abcd" ~~ rx:P5/a([bc]*)(c+d)/ && $<>), "abcd", 're_tests 279/0 (357)');
is(("abcd" ~~ rx:P5/a([bc]*)(c+d)/ && $0), "b", 're_tests 279/1 (358)');
is(("abcd" ~~ rx:P5/a([bc]*)(c+d)/ && $1), "cd", 're_tests 279/2 (359)');
is(("abcd" ~~ rx:P5/a([bc]*)(c+d)/ && $/.from), 0, 're_tests 281/0 (363)');
is(("abcd" ~~ rx:P5/a([bc]*)(c+d)/ && $/[0].from), 1, 're_tests 283/1 (365)');
is(("abcd" ~~ rx:P5/a([bc]*)(c+d)/ && $/[1].from), 2, 're_tests 285/2 (367)');
is(("adcdcde" ~~ rx:P5/a[bcd]*dcdcde/ && $<>), "adcdcde", 're_tests 287/0 (369)');
ok((not ("adcdcde" ~~ rx:P5/a[bcd]+dcdcde/)), 're_tests 289  (371)');
is(("abc" ~~ rx:P5/(ab|a)b*c/ && $<>), "abc", 're_tests 291/0 (373)');
is(("abc" ~~ rx:P5/(ab|a)b*c/ && $0), "ab", 're_tests 291/1 (374)');
is(("abc" ~~ rx:P5/(ab|a)b*c/ && $/.from), 0, 're_tests 293/0 (377)');
is(("abc" ~~ rx:P5/(ab|a)b*c/ && $/[0].from), 0, 're_tests 295/1 (379)');
is(("abcd" ~~ rx:P5/((a)(b)c)(d)/ && $/.from), 0, 're_tests 297/0 (381)');
is(("abcd" ~~ rx:P5/((a)(b)c)(d)/ && $/[0].from), 0, 're_tests 299/1 (383)');
is(("abcd" ~~ rx:P5/((a)(b)c)(d)/ && $/[1].from), 0, 're_tests 301/2 (385)');
is(("abcd" ~~ rx:P5/((a)(b)c)(d)/ && $/[2].from), 1, 're_tests 303/3 (387)');
is(("abcd" ~~ rx:P5/((a)(b)c)(d)/ && $/[3].from), 3, 're_tests 305/4 (389)');
is(("alpha" ~~ rx:P5/[a-zA-Z_][a-zA-Z0-9_]*/ && $<>), "alpha", 're_tests 307/0 (391)');
is(("abh" ~~ rx:P5/^a(bc+|b[eh])g|.h$/ && $<>), "bh", 're_tests 309/0 (393)');
is(("abh" ~~ rx:P5/^a(bc+|b[eh])g|.h$/ && $0), "", 're_tests 309/1 (394)');
is(("effgz" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $<>), "effgz", 're_tests 311/0 (397)');
is(("effgz" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $0), "effgz", 're_tests 311/1 (398)');
is(("effgz" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $1), "", 're_tests 311/2 (399)');
is(("ij" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $<>), "ij", 're_tests 313/0 (403)');
is(("ij" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $0), "ij", 're_tests 313/1 (404)');
is(("ij" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $1), "j", 're_tests 313/2 (405)');
ok((not ("effg" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/)), 're_tests 315  (409)');
ok((not ("bcdd" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/)), 're_tests 317  (411)');
is(("reffgz" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $<>), "effgz", 're_tests 319/0 (413)');
is(("reffgz" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $0), "effgz", 're_tests 319/1 (414)');
is(("reffgz" ~~ rx:P5/(bc+d$|ef*g.|h?i(j|k))/ && $1), "", 're_tests 319/2 (415)');
is(("a" ~~ rx:P5/((((((((((a))))))))))/ && $00), "a", 're_tests 321/10 (419)');
is(("a" ~~ rx:P5/((((((((((a))))))))))/ && $/.from), 0, 're_tests 323/0 (421)');
is(("a" ~~ rx:P5/((((((((((a))))))))))/ && $/[0].from), 0, 're_tests 325/10 (423)');
is(("aa" ~~ rx:P5/((((((((((a))))))))))\10/ && $<>), "aa", 're_tests 327/0 (425)');
my $bang = '!';
ok((not ("aa" ~~ rx:P5/((((((((((a))))))))))$bang/)), 're_tests 329  (427)');
is(("a!" ~~ rx:P5/((((((((((a))))))))))$bang/ && $<>), "a!", 're_tests 330/0 (428)');
is(("a" ~~ rx:P5/(((((((((a)))))))))/ && $<>), "a", 're_tests 331/0 (429)');
ok((not ("uh-uh" ~~ rx:P5/multiple words of text/)), 're_tests 333  (431)');
is(("multiple words, yeah" ~~ rx:P5/multiple words/ && $<>), "multiple words", 're_tests 335/0 (433)');
is(("abcde" ~~ rx:P5/(.*)c(.*)/ && $<>), "abcde", 're_tests 337/0 (435)');
is(("abcde" ~~ rx:P5/(.*)c(.*)/ && $0), "ab", 're_tests 337/1 (436)');
is(("abcde" ~~ rx:P5/(.*)c(.*)/ && $1), "de", 're_tests 337/2 (437)');
ok((not ("ab" ~~ rx:P5/[k]/)), 're_tests 339  (441)');
is(("ac" ~~ rx:P5/a[-]?c/ && $<>), "ac", 're_tests 341/0 (443)');
is(("abcabc" ~~ rx:P5/(abc)\1/ && $0), "abc", 're_tests 343/1 (445)');
is(("abcabc" ~~ rx:P5/([a-c]*)\1/ && $0), "abc", 're_tests 345/1 (447)');
ok(("a" ~~ rx:P5/(a)|\1/), 're_tests 347  (449)');
ok((not ("x" ~~ rx:P5/(a)|\1/)), 're_tests 349  (451)');
is(("ababbbcbc" ~~ rx:P5/(([a-c])b*?\2)*/ && $<>), "ababb", 're_tests 351/0 (453)');
is(("ababbbcbc" ~~ rx:P5/(([a-c])b*?\2)*/ && $0), "bb", 're_tests 351/1 (454)');
is(("ababbbcbc" ~~ rx:P5/(([a-c])b*?\2)*/ && $1), "b", 're_tests 351/2 (455)');
is(("ababbbcbc" ~~ rx:P5/(([a-c])b*?\2){3}/ && $<>), "ababbbcbc", 're_tests 353/0 (459)');
is(("ababbbcbc" ~~ rx:P5/(([a-c])b*?\2){3}/ && $0), "cbc", 're_tests 353/1 (460)');
is(("ababbbcbc" ~~ rx:P5/(([a-c])b*?\2){3}/ && $1), "c", 're_tests 353/2 (461)');
ok((not ("aaxabxbaxbbx" ~~ rx:P5/((\3|b)\2(a)x)+/)), 're_tests 355  (465)');
is(("b" ~~ rx:P5/(a)|(b)/ && $/.from), 0, 're_tests 357/0 (467)');
is(("b" ~~ rx:P5/(a)|(b)/ && $/[1].from), 0, 're_tests 359/2 (469)');
is(("ABC" ~~ rx:P5/(?i)abc/ && $<>), "ABC", 're_tests 361/0 (471)');
ok((not ("XBC" ~~ rx:P5/(?i)abc/)), 're_tests 363  (473)');
ok((not ("AXC" ~~ rx:P5/(?i)abc/)), 're_tests 365  (475)');
ok((not ("ABX" ~~ rx:P5/(?i)abc/)), 're_tests 367  (477)');
is(("XABCY" ~~ rx:P5/(?i)abc/ && $<>), "ABC", 're_tests 369/0 (479)');
is(("ABABC" ~~ rx:P5/(?i)abc/ && $<>), "ABC", 're_tests 371/0 (481)');
is(("ABC" ~~ rx:P5/(?i)ab*c/ && $<>), "ABC", 're_tests 373/0 (483)');
is(("ABC" ~~ rx:P5/(?i)ab*bc/ && $<>), "ABC", 're_tests 375/0 (485)');
is(("ABBC" ~~ rx:P5/(?i)ab*bc/ && $<>), "ABBC", 're_tests 377/0 (487)');
is(("ABBBBC" ~~ rx:P5/(?i)ab*?bc/ && $<>), "ABBBBC", 're_tests 379/0 (489)');
is(("ABBBBC" ~~ rx:P5/(?i)ab{0,}?bc/ && $<>), "ABBBBC", 're_tests 381/0 (491)');
is(("ABBC" ~~ rx:P5/(?i)ab+?bc/ && $<>), "ABBC", 're_tests 383/0 (493)');
ok((not ("ABC" ~~ rx:P5/(?i)ab+bc/)), 're_tests 385  (495)');
ok((not ("ABQ" ~~ rx:P5/(?i)ab+bc/)), 're_tests 387  (497)');
ok((not ("ABQ" ~~ rx:P5/(?i)ab{1,}bc/)), 're_tests 389  (499)');
is(("ABBBBC" ~~ rx:P5/(?i)ab+bc/ && $<>), "ABBBBC", 're_tests 391/0 (501)');
is(("ABBBBC" ~~ rx:P5/(?i)ab{1,}?bc/ && $<>), "ABBBBC", 're_tests 393/0 (503)');
is(("ABBBBC" ~~ rx:P5/(?i)ab{1,3}?bc/ && $<>), "ABBBBC", 're_tests 395/0 (505)');
is(("ABBBBC" ~~ rx:P5/(?i)ab{3,4}?bc/ && $<>), "ABBBBC", 're_tests 397/0 (507)');
ok((not ("ABBBBC" ~~ rx:P5/(?i)ab{4,5}?bc/)), 're_tests 399  (509)');
is(("ABBC" ~~ rx:P5/(?i)ab??bc/ && $<>), "ABBC", 're_tests 401/0 (511)');
is(("ABC" ~~ rx:P5/(?i)ab??bc/ && $<>), "ABC", 're_tests 403/0 (513)');
is(("ABC" ~~ rx:P5/(?i)ab{0,1}?bc/ && $<>), "ABC", 're_tests 405/0 (515)');
ok((not ("ABBBBC" ~~ rx:P5/(?i)ab??bc/)), 're_tests 407  (517)');
is(("ABC" ~~ rx:P5/(?i)ab??c/ && $<>), "ABC", 're_tests 409/0 (519)');
is(("ABC" ~~ rx:P5/(?i)ab{0,1}?c/ && $<>), "ABC", 're_tests 411/0 (521)');
is(("ABC" ~~ rx:P5/(?i)^abc$/ && $<>), "ABC", 're_tests 413/0 (523)');
ok((not ("ABCC" ~~ rx:P5/(?i)^abc$/)), 're_tests 415  (525)');
is(("ABCC" ~~ rx:P5/(?i)^abc/ && $<>), "ABC", 're_tests 417/0 (527)');
ok((not ("AABC" ~~ rx:P5/(?i)^abc$/)), 're_tests 419  (529)');
is(("AABC" ~~ rx:P5/(?i)abc$/ && $<>), "ABC", 're_tests 421/0 (531)');
is(("ABC" ~~ rx:P5/(?i)^/ && $<>), "", 're_tests 423/0 (533)');
is(("ABC" ~~ rx:P5/(?i)$/ && $<>), "", 're_tests 425/0 (535)');
is(("ABC" ~~ rx:P5/(?i)a.c/ && $<>), "ABC", 're_tests 427/0 (537)');
is(("AXC" ~~ rx:P5/(?i)a.c/ && $<>), "AXC", 're_tests 429/0 (539)');
is(("AXYZC" ~~ rx:P5/(?i)a.*?c/ && $<>), "AXYZC", 're_tests 431/0 (541)');
ok((not ("AXYZD" ~~ rx:P5/(?i)a.*c/)), 're_tests 433  (543)');
ok((not ("ABC" ~~ rx:P5/(?i)a[bc]d/)), 're_tests 435  (545)');
is(("ABD" ~~ rx:P5/(?i)a[bc]d/ && $<>), "ABD", 're_tests 437/0 (547)');
ok((not ("ABD" ~~ rx:P5/(?i)a[b-d]e/)), 're_tests 439  (549)');
is(("ACE" ~~ rx:P5/(?i)a[b-d]e/ && $<>), "ACE", 're_tests 441/0 (551)');
is(("AAC" ~~ rx:P5/(?i)a[b-d]/ && $<>), "AC", 're_tests 443/0 (553)');
is(("A-" ~~ rx:P5/(?i)a[-b]/ && $<>), "A-", 're_tests 445/0 (555)');
is(("A-" ~~ rx:P5/(?i)a[b-]/ && $<>), "A-", 're_tests 447/0 (557)');
is(("A]" ~~ rx:P5/(?i)a]/ && $<>), "A]", 're_tests 449/0 (559)');
is(("A]B" ~~ rx:P5/(?i)a[]]b/ && $<>), "A]B", 're_tests 451/0 (561)');
is(("AED" ~~ rx:P5/(?i)a[^bc]d/ && $<>), "AED", 're_tests 453/0 (563)');
ok((not ("ABD" ~~ rx:P5/(?i)a[^bc]d/)), 're_tests 455  (565)');
is(("ADC" ~~ rx:P5/(?i)a[^-b]c/ && $<>), "ADC", 're_tests 457/0 (567)');
ok((not ("A-C" ~~ rx:P5/(?i)a[^-b]c/)), 're_tests 459  (569)');
ok((not ("A]C" ~~ rx:P5/(?i)a[^]b]c/)), 're_tests 461  (571)');
is(("ADC" ~~ rx:P5/(?i)a[^]b]c/ && $<>), "ADC", 're_tests 463/0 (573)');
is(("ABC" ~~ rx:P5/(?i)ab|cd/ && $<>), "AB", 're_tests 465/0 (575)');
is(("ABCD" ~~ rx:P5/(?i)ab|cd/ && $<>), "AB", 're_tests 467/0 (577)');
is(("DEF" ~~ rx:P5/(?i)()ef/ && $<>), "EF", 're_tests 469/0 (579)');
is(("DEF" ~~ rx:P5/(?i)()ef/ && $0), "", 're_tests 469/1 (580)');
ok((not ("B" ~~ rx:P5/(?i)$b/)), 're_tests 471  (583)');
is(("A(B" ~~ rx:P5/(?i)a\(b/ && $<>), "A(B", 're_tests 473/0 (585)');
is(("A(B" ~~ rx:P5/(?i)a\(b/ && $0), "", 're_tests 473/1 (586)');
is(("AB" ~~ rx:P5/(?i)a\(*b/ && $<>), "AB", 're_tests 475/0 (589)');
is(("A((B" ~~ rx:P5/(?i)a\(*b/ && $<>), "A((B", 're_tests 477/0 (591)');
is(("A\B" ~~ rx:P5/(?i)a\\b/ && $<>), "A\B", 're_tests 479/0 (593)', :todo);
is(("ABC" ~~ rx:P5/(?i)((a))/ && $<>), "A", 're_tests 481/0 (595)');
is(("ABC" ~~ rx:P5/(?i)((a))/ && $0), "A", 're_tests 481/1 (596)');
is(("ABC" ~~ rx:P5/(?i)((a))/ && $1), "A", 're_tests 481/2 (597)');
is(("ABC" ~~ rx:P5/(?i)(a)b(c)/ && $<>), "ABC", 're_tests 483/0 (601)');
is(("ABC" ~~ rx:P5/(?i)(a)b(c)/ && $0), "A", 're_tests 483/1 (602)');
is(("ABC" ~~ rx:P5/(?i)(a)b(c)/ && $1), "C", 're_tests 483/2 (603)');
is(("AABBABC" ~~ rx:P5/(?i)a+b+c/ && $<>), "ABC", 're_tests 485/0 (607)');
is(("AABBABC" ~~ rx:P5/(?i)a{1,}b{1,}c/ && $<>), "ABC", 're_tests 487/0 (609)');
is(("ABCABC" ~~ rx:P5/(?i)a.+?c/ && $<>), "ABC", 're_tests 489/0 (611)');
is(("ABCABC" ~~ rx:P5/(?i)a.*?c/ && $<>), "ABC", 're_tests 491/0 (613)');
is(("ABCABC" ~~ rx:P5/(?i)a.{0,5}?c/ && $<>), "ABC", 're_tests 493/0 (615)');
is(("AB" ~~ rx:P5/(?i)(a+|b)*/ && $<>), "AB", 're_tests 495/0 (617)');
is(("AB" ~~ rx:P5/(?i)(a+|b)*/ && $0), "B", 're_tests 495/1 (618)');
is(("AB" ~~ rx:P5/(?i)(a+|b){0,}/ && $<>), "AB", 're_tests 497/0 (621)');
is(("AB" ~~ rx:P5/(?i)(a+|b){0,}/ && $0), "B", 're_tests 497/1 (622)');
is(("AB" ~~ rx:P5/(?i)(a+|b)+/ && $<>), "AB", 're_tests 499/0 (625)');
is(("AB" ~~ rx:P5/(?i)(a+|b)+/ && $0), "B", 're_tests 499/1 (626)');
is(("AB" ~~ rx:P5/(?i)(a+|b){1,}/ && $<>), "AB", 're_tests 501/0 (629)');
is(("AB" ~~ rx:P5/(?i)(a+|b){1,}/ && $0), "B", 're_tests 501/1 (630)');
is(("AB" ~~ rx:P5/(?i)(a+|b)?/ && $<>), "A", 're_tests 503/0 (633)');
is(("AB" ~~ rx:P5/(?i)(a+|b)?/ && $0), "A", 're_tests 503/1 (634)');
is(("AB" ~~ rx:P5/(?i)(a+|b){0,1}/ && $<>), "A", 're_tests 505/0 (637)');
is(("AB" ~~ rx:P5/(?i)(a+|b){0,1}/ && $0), "A", 're_tests 505/1 (638)');
is(("AB" ~~ rx:P5/(?i)(a+|b){0,1}?/ && $<>), "", 're_tests 507/0 (641)');
is(("AB" ~~ rx:P5/(?i)(a+|b){0,1}?/ && $0), "", 're_tests 507/1 (642)');
is(("CDE" ~~ rx:P5/(?i)[^ab]*/ && $<>), "CDE", 're_tests 509/0 (645)');
ok((not ("" ~~ rx:P5/(?i)abc/)), 're_tests 511  (647)');
is(("" ~~ rx:P5/(?i)a*/ && $<>), "", 're_tests 513/0 (649)');
is(("ABBBCD" ~~ rx:P5/(?i)([abc])*d/ && $<>), "ABBBCD", 're_tests 515/0 (651)');
is(("ABBBCD" ~~ rx:P5/(?i)([abc])*d/ && $0), "C", 're_tests 515/1 (652)');
is(("ABCD" ~~ rx:P5/(?i)([abc])*bcd/ && $<>), "ABCD", 're_tests 517/0 (655)');
is(("ABCD" ~~ rx:P5/(?i)([abc])*bcd/ && $0), "A", 're_tests 517/1 (656)');
is(("E" ~~ rx:P5/(?i)a|b|c|d|e/ && $<>), "E", 're_tests 519/0 (659)');
is(("EF" ~~ rx:P5/(?i)(a|b|c|d|e)f/ && $<>), "EF", 're_tests 521/0 (661)');
is(("EF" ~~ rx:P5/(?i)(a|b|c|d|e)f/ && $0), "E", 're_tests 521/1 (662)');
is(("ABCDEFG" ~~ rx:P5/(?i)abcd*efg/ && $<>), "ABCDEFG", 're_tests 523/0 (665)');
is(("XABYABBBZ" ~~ rx:P5/(?i)ab*/ && $<>), "AB", 're_tests 525/0 (667)');
is(("XAYABBBZ" ~~ rx:P5/(?i)ab*/ && $<>), "A", 're_tests 527/0 (669)');
is(("ABCDE" ~~ rx:P5/(?i)(ab|cd)e/ && $<>), "CDE", 're_tests 529/0 (671)');
is(("ABCDE" ~~ rx:P5/(?i)(ab|cd)e/ && $0), "CD", 're_tests 529/1 (672)');
is(("HIJ" ~~ rx:P5/(?i)[abhgefdc]ij/ && $<>), "HIJ", 're_tests 531/0 (675)');
is(("ABCDEF" ~~ rx:P5/(?i)(abc|)ef/ && $<>), "EF", 're_tests 533/0 (677)');
is(("ABCDEF" ~~ rx:P5/(?i)(abc|)ef/ && $0), "", 're_tests 533/1 (678)');
is(("ABCD" ~~ rx:P5/(?i)(a|b)c*d/ && $<>), "BCD", 're_tests 535/0 (681)');
is(("ABCD" ~~ rx:P5/(?i)(a|b)c*d/ && $0), "B", 're_tests 535/1 (682)');
is(("ABC" ~~ rx:P5/(?i)(ab|ab*)bc/ && $<>), "ABC", 're_tests 537/0 (685)');
is(("ABC" ~~ rx:P5/(?i)(ab|ab*)bc/ && $0), "A", 're_tests 537/1 (686)');
is(("ABC" ~~ rx:P5/(?i)a([bc]*)c*/ && $<>), "ABC", 're_tests 539/0 (689)');
is(("ABC" ~~ rx:P5/(?i)a([bc]*)c*/ && $0), "BC", 're_tests 539/1 (690)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]*)(c*d)/ && $<>), "ABCD", 're_tests 541/0 (693)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]*)(c*d)/ && $0), "BC", 're_tests 541/1 (694)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]*)(c*d)/ && $1), "D", 're_tests 541/2 (695)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]+)(c*d)/ && $<>), "ABCD", 're_tests 543/0 (699)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]+)(c*d)/ && $0), "BC", 're_tests 543/1 (700)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]+)(c*d)/ && $1), "D", 're_tests 543/2 (701)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]*)(c+d)/ && $<>), "ABCD", 're_tests 545/0 (705)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]*)(c+d)/ && $0), "B", 're_tests 545/1 (706)');
is(("ABCD" ~~ rx:P5/(?i)a([bc]*)(c+d)/ && $1), "CD", 're_tests 545/2 (707)');
is(("ADCDCDE" ~~ rx:P5/(?i)a[bcd]*dcdcde/ && $<>), "ADCDCDE", 're_tests 547/0 (711)');
ok((not ("ADCDCDE" ~~ rx:P5/(?i)a[bcd]+dcdcde/)), 're_tests 549  (713)');
is(("ABC" ~~ rx:P5/(?i)(ab|a)b*c/ && $<>), "ABC", 're_tests 551/0 (715)');
is(("ABC" ~~ rx:P5/(?i)(ab|a)b*c/ && $0), "AB", 're_tests 551/1 (716)');
is(("ALPHA" ~~ rx:P5/(?i)[a-zA-Z_][a-zA-Z0-9_]*/ && $<>), "ALPHA", 're_tests 553/0 (719)');
is(("ABH" ~~ rx:P5/(?i)^a(bc+|b[eh])g|.h$/ && $<>), "BH", 're_tests 555/0 (721)');
is(("ABH" ~~ rx:P5/(?i)^a(bc+|b[eh])g|.h$/ && $0), "", 're_tests 555/1 (722)');
is(("EFFGZ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $<>), "EFFGZ", 're_tests 557/0 (725)');
is(("EFFGZ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $0), "EFFGZ", 're_tests 557/1 (726)');
is(("EFFGZ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $1), "", 're_tests 557/2 (727)');
is(("IJ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $<>), "IJ", 're_tests 559/0 (731)');
is(("IJ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $0), "IJ", 're_tests 559/1 (732)');
is(("IJ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $1), "J", 're_tests 559/2 (733)');
ok((not ("EFFG" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/)), 're_tests 561  (737)');
ok((not ("BCDD" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/)), 're_tests 563  (739)');
is(("REFFGZ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $<>), "EFFGZ", 're_tests 565/0 (741)');
is(("REFFGZ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $0), "EFFGZ", 're_tests 565/1 (742)');
is(("REFFGZ" ~~ rx:P5/(?i)(bc+d$|ef*g.|h?i(j|k))/ && $1), "", 're_tests 565/2 (743)');
is(("A" ~~ rx:P5/(?i)((((((((((a))))))))))/ && $00), "A", 're_tests 567/10 (747)');
is(("AA" ~~ rx:P5/(?i)((((((((((a))))))))))\10/ && $<>), "AA", 're_tests 569/0 (749)');
ok((not ("AA" ~~ rx:P5/(?i)((((((((((a))))))))))$bang/)), 're_tests 571  (751)');
is(("A!" ~~ rx:P5/(?i)((((((((((a))))))))))$bang/ && $<>), "A!", 're_tests 572/0 (752)');
is(("A" ~~ rx:P5/(?i)(((((((((a)))))))))/ && $<>), "A", 're_tests 573/0 (753)');
is(("A" ~~ rx:P5/(?i)(?:(?:(?:(?:(?:(?:(?:(?:(?:(a))))))))))/ && $0), "A", 're_tests 575/1 (755)');
is(("C" ~~ rx:P5/(?i)(?:(?:(?:(?:(?:(?:(?:(?:(?:(a|b|c))))))))))/ && $0), "C", 're_tests 577/1 (757)');
ok((not ("UH-UH" ~~ rx:P5/(?i)multiple words of text/)), 're_tests 579  (759)');
is(("MULTIPLE WORDS, YEAH" ~~ rx:P5/(?i)multiple words/ && $<>), "MULTIPLE WORDS", 're_tests 581/0 (761)');
is(("ABCDE" ~~ rx:P5/(?i)(.*)c(.*)/ && $<>), "ABCDE", 're_tests 583/0 (763)');
is(("ABCDE" ~~ rx:P5/(?i)(.*)c(.*)/ && $0), "AB", 're_tests 583/1 (764)');
is(("ABCDE" ~~ rx:P5/(?i)(.*)c(.*)/ && $1), "DE", 're_tests 583/2 (765)');
ok((not ("AB" ~~ rx:P5/(?i)[k]/)), 're_tests 585  (769)');
is(("AC" ~~ rx:P5/(?i)a[-]?c/ && $<>), "AC", 're_tests 587/0 (771)');
is(("ABCABC" ~~ rx:P5/(?i)(abc)\1/ && $0), "ABC", 're_tests 589/1 (773)');
is(("ABCABC" ~~ rx:P5/(?i)([a-c]*)\1/ && $0), "ABC", 're_tests 591/1 (775)');
is(("abad" ~~ rx:P5/a(?!b)./ && $<>), "ad", 're_tests 593/0 (777)');
is(("abad" ~~ rx:P5/a(?=d)./ && $<>), "ad", 're_tests 595/0 (779)');
is(("abad" ~~ rx:P5/a(?=c|d)./ && $<>), "ad", 're_tests 597/0 (781)');
is(("ace" ~~ rx:P5/a(?:b|c|d)(.)/ && $0), "e", 're_tests 599/1 (783)');
is(("ace" ~~ rx:P5/a(?:b|c|d)*(.)/ && $0), "e", 're_tests 601/1 (785)');
is(("ace" ~~ rx:P5/a(?:b|c|d)+?(.)/ && $0), "e", 're_tests 603/1 (787)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d)+?(.)/ && $0), "d", 're_tests 605/1 (789)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d)+(.)/ && $0), "e", 're_tests 607/1 (791)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){2}(.)/ && $0), "b", 're_tests 609/1 (793)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){4,5}(.)/ && $0), "b", 're_tests 611/1 (795)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){4,5}?(.)/ && $0), "d", 're_tests 613/1 (797)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){6,7}(.)/ && $0), "e", 're_tests 615/1 (799)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){6,7}?(.)/ && $0), "e", 're_tests 617/1 (801)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){5,6}(.)/ && $0), "e", 're_tests 619/1 (803)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){5,6}?(.)/ && $0), "b", 're_tests 621/1 (805)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){5,7}(.)/ && $0), "e", 're_tests 623/1 (807)');
is(("acdbcdbe" ~~ rx:P5/a(?:b|c|d){5,7}?(.)/ && $0), "b", 're_tests 625/1 (809)');
is(("AB" ~~ rx:P5/^(.+)?B/ && $0), "A", 're_tests 627/1 (811)');
is(("." ~~ rx:P5/^([^a-z])|(\^)$/ && $0), ".", 're_tests 629/1 (813)');
is(("<&OUT" ~~ rx:P5/^[<>]&/ && $<>), "<&", 're_tests 631/0 (815)');
is(("aaaaaaaaaa" ~~ rx:P5/^(a\1?){4}$/ && $0), "aaaa", 're_tests 633/1 (817)');
ok((not ("aaaaaaaaa" ~~ rx:P5/^(a\1?){4}$/)), 're_tests 635  (819)');
ok((not ("aaaaaaaaaaa" ~~ rx:P5/^(a\1?){4}$/)), 're_tests 637  (821)');
is(("aaaaaaaaaa" ~~ rx:P5/^(a(?(1)\1)){4}$/ && $0), "aaaa", 're_tests 639/1 (823)');
ok((not ("aaaaaaaaa" ~~ rx:P5/^(a(?(1)\1)){4}$/)), 're_tests 641  (825)');
ok((not ("aaaaaaaaaaa" ~~ rx:P5/^(a(?(1)\1)){4}$/)), 're_tests 643  (827)');
is(("aaaaaaaaa" ~~ rx:P5/((a{4})+)/ && $0), "aaaaaaaa", 're_tests 645/1 (829)');
is(("aaaaaaaaaa" ~~ rx:P5/(((aa){2})+)/ && $0), "aaaaaaaa", 're_tests 647/1 (831)');
is(("aaaaaaaaaa" ~~ rx:P5/(((a{2}){2})+)/ && $0), "aaaaaaaa", 're_tests 649/1 (833)');
is(("ab" ~~ rx:P5/(?<=a)b/ && $<>), "b", 're_tests 651/0 (835)');
ok((not ("cb" ~~ rx:P5/(?<=a)b/)), 're_tests 653  (837)');
ok((not ("b" ~~ rx:P5/(?<=a)b/)), 're_tests 655  (839)');
is(("ab" ~~ rx:P5/(?<!c)b/ && $<>), "b", 're_tests 657/0 (841)');
ok((not ("cb" ~~ rx:P5/(?<!c)b/)), 're_tests 659  (843)');
ok(("b" ~~ rx:P5/(?<!c)b/), 're_tests 661  (845)');
is(("b" ~~ rx:P5/(?<!c)b/ && $<>), "b", 're_tests 663/0 (847)');
is(("aba" ~~ rx:P5/(?:..)*a/ && $<>), "aba", 're_tests 665/0 (849)');
is(("aba" ~~ rx:P5/(?:..)*?a/ && $<>), "a", 're_tests 667/0 (851)');
is(("abc" ~~ rx:P5/^(?:b|a(?=(.)))*\1/ && $<>), "ab", 're_tests 669/0 (853)');
is(("aax" ~~ rx:P5/^(a+)*ax/ && $0), "a", 're_tests 671/1 (855)');
is(("aax" ~~ rx:P5/^((a|b)+)*ax/ && $0), "a", 're_tests 673/1 (857)');
is(("aax" ~~ rx:P5/^((a|bc)+)*ax/ && $0), "a", 're_tests 675/1 (859)');
is(("ab" ~~ rx:P5/(?:(?i)a)b/ && $<>), "ab", 're_tests 677/0 (861)');
is(("ab" ~~ rx:P5/((?i)a)b/ && $<>), "ab", 're_tests 679/0 (863)');
is(("ab" ~~ rx:P5/((?i)a)b/ && $0), "a", 're_tests 679/1 (864)');
is(("Ab" ~~ rx:P5/(?:(?i)a)b/ && $<>), "Ab", 're_tests 681/0 (867)');
is(("Ab" ~~ rx:P5/((?i)a)b/ && $<>), "Ab", 're_tests 683/0 (869)');
is(("Ab" ~~ rx:P5/((?i)a)b/ && $0), "A", 're_tests 683/1 (870)');
ok((not ("aB" ~~ rx:P5/(?:(?i)a)b/)), 're_tests 685  (873)');
ok((not ("aB" ~~ rx:P5/((?i)a)b/)), 're_tests 687  (875)');
is(("ab" ~~ rx:P5/(?i:a)b/ && $<>), "ab", 're_tests 689/0 (877)');
is(("ab" ~~ rx:P5/((?i:a))b/ && $<>), "ab", 're_tests 691/0 (879)');
is(("ab" ~~ rx:P5/((?i:a))b/ && $0), "a", 're_tests 691/1 (880)');
is(("Ab" ~~ rx:P5/(?i:a)b/ && $<>), "Ab", 're_tests 693/0 (883)');
is(("Ab" ~~ rx:P5/((?i:a))b/ && $<>), "Ab", 're_tests 695/0 (885)');
is(("Ab" ~~ rx:P5/((?i:a))b/ && $0), "A", 're_tests 695/1 (886)');
ok((not ("aB" ~~ rx:P5/(?i:a)b/)), 're_tests 697  (889)');
ok((not ("aB" ~~ rx:P5/((?i:a))b/)), 're_tests 699  (891)');
is(("ab" ~~ rx:P5/(?i)(?:(?-i)a)b/ && $<>), "ab", 're_tests 701/0 (893)');
is(("ab" ~~ rx:P5/(?i)((?-i)a)b/ && $<>), "ab", 're_tests 702/0 (894)');
is(("ab" ~~ rx:P5/(?i)((?-i)a)b/ && $0), "a", 're_tests 702/1 (895)');
is(("aB" ~~ rx:P5/(?i)(?:(?-i)a)b/ && $<>), "aB", 're_tests 703/0 (896)');
is(("aB" ~~ rx:P5/(?i)((?-i)a)b/ && $<>), "aB", 're_tests 704/0 (897)');
is(("aB" ~~ rx:P5/(?i)((?-i)a)b/ && $0), "a", 're_tests 704/1 (898)');
ok((not ("Ab" ~~ rx:P5/(?i)(?:(?-i)a)b/)), 're_tests 705  (899)');
ok((not ("Ab" ~~ rx:P5/(?i)((?-i)a)b/)), 're_tests 706  (900)');
is(("aB" ~~ rx:P5/(?i)(?:(?-i)a)b/ && $<>), "aB", 're_tests 707/0 (901)');
is(("aB" ~~ rx:P5/(?i)((?-i)a)b/ && $0), "a", 're_tests 708/1 (902)');
ok((not ("AB" ~~ rx:P5/(?i)(?:(?-i)a)b/)), 're_tests 709  (903)');
ok((not ("AB" ~~ rx:P5/(?i)((?-i)a)b/)), 're_tests 710  (904)');
is(("ab" ~~ rx:P5/(?i)(?-i:a)b/ && $<>), "ab", 're_tests 711/0 (905)');
is(("ab" ~~ rx:P5/(?i)((?-i:a))b/ && $<>), "ab", 're_tests 712/0 (906)');
is(("ab" ~~ rx:P5/(?i)((?-i:a))b/ && $0), "a", 're_tests 712/1 (907)');
is(("aB" ~~ rx:P5/(?i)(?-i:a)b/ && $<>), "aB", 're_tests 713/0 (908)');
is(("aB" ~~ rx:P5/(?i)((?-i:a))b/ && $<>), "aB", 're_tests 714/0 (909)');
is(("aB" ~~ rx:P5/(?i)((?-i:a))b/ && $0), "a", 're_tests 714/1 (910)');
ok((not ("Ab" ~~ rx:P5/(?i)(?-i:a)b/)), 're_tests 715  (911)');
ok((not ("Ab" ~~ rx:P5/(?i)((?-i:a))b/)), 're_tests 716  (912)');
is(("aB" ~~ rx:P5/(?i)(?-i:a)b/ && $<>), "aB", 're_tests 717/0 (913)');
is(("aB" ~~ rx:P5/(?i)((?-i:a))b/ && $0), "a", 're_tests 718/1 (914)');
ok((not ("AB" ~~ rx:P5/(?i)(?-i:a)b/)), 're_tests 719  (915)');
ok((not ("AB" ~~ rx:P5/(?i)((?-i:a))b/)), 're_tests 720  (916)');
ok((not ("a\nB" ~~ rx:P5/(?i)((?-i:a.))b/)), 're_tests 721  (917)');
is(("a\nB" ~~ rx:P5/(?i)((?s-i:a.))b/ && $0), "a\n", 're_tests 722/1 (918)');
ok((not ("B\nB" ~~ rx:P5/(?i)((?s-i:a.))b/)), 're_tests 723  (919)');
is(("cabbbb" ~~ rx:P5/(?:c|d)(?:)(?:a(?:)(?:b)(?:b(?:))(?:b(?:)(?:b)))/ && $<>), "cabbbb", 're_tests 724/0 (920)');
is(("caaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb" ~~ rx:P5/(?:c|d)(?:)(?:aaaaaaaa(?:)(?:bbbbbbbb)(?:bbbbbbbb(?:))(?:bbbbbbbb(?:)(?:bbbbbbbb)))/ && $<>), "caaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb", 're_tests 726/0 (922)');
is(("Ab4ab" ~~ rx:P5/(?i)(ab)\d\1/ && $0), "Ab", 're_tests 728/1 (924)');
is(("ab4Ab" ~~ rx:P5/(?i)(ab)\d\1/ && $0), "ab", 're_tests 730/1 (926)');
is(("foobar1234baz" ~~ rx:P5/foo\w*\d{4}baz/ && $<>), "foobar1234baz", 're_tests 732/0 (928)');
#todo_is(("cabd" ~~ rx:P5/a(?{})b/ && $<>), "ab", 're_tests 734/0 (930)');
#todo_is(("cabd" ~~ rx:P5/a(?{"\{"})b/ && $<>), "ab", 're_tests 735/0 (931)');
ok(("x~~" ~~ rx:P5/x(~~)*(?:(?:F)?)?/), 're_tests 736  (932)');
is(("aaac" ~~ rx:P5/^a(?#xxx){3}c/ && $<>), "aaac", 're_tests 738/0 (934)');
is(("aaac" ~~ rx:P5/(?x)^a (?#xxx) (?#yyy) {3}c/ && $<>), "aaac", 're_tests 739/0 (935)');
ok((not ("dbcb" ~~ rx:P5/(?<![cd])b/)), 're_tests 740  (936)');
is(("dbaacb" ~~ rx:P5/(?<![cd])[ab]/ && $<>), "a", 're_tests 742/0 (938)');
ok((not ("dbcb" ~~ rx:P5/(?<!(c|d))b/)), 're_tests 744  (940)');
is(("dbaacb" ~~ rx:P5/(?<!(c|d))[ab]/ && $<>), "a", 're_tests 746/0 (942)');
is(("cdaccb" ~~ rx:P5/(?<!cd)[ab]/ && $<>), "b", 're_tests 748/0 (944)');
ok((not ("a--" ~~ rx:P5/^(?:a?b?)*$/)), 're_tests 750  (946)');
is(("a\nb\nc\n" ~~ rx:P5/((?m)^b$)/ && $0), "b", 're_tests 752/1 (948)');
is(("a\nb\n" ~~ rx:P5/(?m)^b/ && $<>), "b", 're_tests 753/0 (949)');
is(("a\nb\n" ~~ rx:P5/(?m)^(b)/ && $0), "b", 're_tests 754/1 (950)');
is(("a\nb\n" ~~ rx:P5/((?m)^b)/ && $0), "b", 're_tests 755/1 (951)');
is(("a\nb\n" ~~ rx:P5/\n((?m)^b)/ && $0), "b", 're_tests 756/1 (952)');
is(("a\nb\nc\n" ~~ rx:P5/((?s).)c(?!.)/ && $0), "\n", 're_tests 757/1 (953)');
is(("a\nb\nc\n" ~~ rx:P5/((?s)b.)c(?!.)/ && $0), "b\n", 're_tests 758/1 (954)');
ok((not ("a\nb\nc\n" ~~ rx:P5/^b/)), 're_tests 759  (955)');
ok((not ("a\nb\nc\n" ~~ rx:P5/()^b/)), 're_tests 761  (957)');
is(("a\nb\nc\n" ~~ rx:P5/((?m)^b)/ && $0), "b", 're_tests 763/1 (959)');
ok((not ("a" ~~ rx:P5/(?(1)a|b)/)), 're_tests 764  (960)');
is(("a" ~~ rx:P5/(?(1)b|a)/ && $<>), "a", 're_tests 766/0 (962)');
ok((not ("a" ~~ rx:P5/(x)?(?(1)a|b)/)), 're_tests 768  (964)');
is(("a" ~~ rx:P5/(x)?(?(1)b|a)/ && $<>), "a", 're_tests 770/0 (966)');
is(("a" ~~ rx:P5/()?(?(1)b|a)/ && $<>), "a", 're_tests 772/0 (968)');
ok((not ("a" ~~ rx:P5/()(?(1)b|a)/)), 're_tests 774  (970)');
is(("a" ~~ rx:P5/()?(?(1)a|b)/ && $<>), "a", 're_tests 776/0 (972)');
is(("(blah)" ~~ rx:P5/^(\()?blah(?(1)(\)))$/ && $1), ")", 're_tests 778/2 (974)');
ok((not ("blah)" ~~ rx:P5/^(\()?blah(?(1)(\)))$/)), 're_tests 780  (976)');
ok((not ("(blah" ~~ rx:P5/^(\()?blah(?(1)(\)))$/)), 're_tests 782  (978)');
is(("(blah)" ~~ rx:P5/^(\(+)?blah(?(1)(\)))$/ && $1), ")", 're_tests 784/2 (980)');
ok((not ("blah)" ~~ rx:P5/^(\(+)?blah(?(1)(\)))$/)), 're_tests 786  (982)');
ok((not ("(blah" ~~ rx:P5/^(\(+)?blah(?(1)(\)))$/)), 're_tests 788  (984)');
#todo_ok((not ("a" ~~ rx:P5/(?(?{0})a|b)/)), 're_tests 790  (986)');
#todo_is(("a" ~~ rx:P5/(?(?{0})b|a)/ && $<>), "a", 're_tests 791/0 (987)');
#todo_ok((not ("a" ~~ rx:P5/(?(?{1})b|a)/)), 're_tests 792  (988)');
#todo_is(("a" ~~ rx:P5/(?(?{1})a|b)/ && $<>), "a", 're_tests 793/0 (989)');
ok((not ("a" ~~ rx:P5/(?(?!a)a|b)/)), 're_tests 794  (990)');
is(("a" ~~ rx:P5/(?(?!a)b|a)/ && $<>), "a", 're_tests 795/0 (991)');
ok((not ("a" ~~ rx:P5/(?(?=a)b|a)/)), 're_tests 796  (992)');
is(("a" ~~ rx:P5/(?(?=a)a|b)/ && $<>), "a", 're_tests 797/0 (993)');
is(("aaab" ~~ rx:P5/(?=(a+?))(\1ab)/ && $1), "aab", 're_tests 798/2 (994)');
ok((not ("aaab" ~~ rx:P5/^(?=(a+?))\1ab/)), 're_tests 800  (996)');
is(("one:" ~~ rx:P5/(\w+:)+/ && $0), "one:", 're_tests 802/1 (998)');
is(("a" ~~ rx:P5/$(?<=^(a))/ && $0), "a", 're_tests 804/1 (1000)');
is(("aaab" ~~ rx:P5/(?=(a+?))(\1ab)/ && $1), "aab", 're_tests 806/2 (1002)');
ok((not ("aaab" ~~ rx:P5/^(?=(a+?))\1ab/)), 're_tests 808  (1004)');
ok((not ("abcd:" ~~ rx:P5/([\w:]+::)?(\w+)$/)), 're_tests 810  (1006)');
is(("abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $0), "", 're_tests 812/1 (1008)');
is(("abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $1), "abcd", 're_tests 812/2 (1009)');
is(("xy:z:::abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $0), "xy:z:::", 're_tests 814/1 (1012)');
is(("xy:z:::abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $1), "abcd", 're_tests 814/2 (1013)');
is(("aexycd" ~~ rx:P5/^[^bcd]*(c+)/ && $0), "c", 're_tests 816/1 (1016)');
is(("caab" ~~ rx:P5/(a*)b+/ && $0), "aa", 're_tests 818/1 (1018)');
ok((not ("abcd:" ~~ rx:P5/([\w:]+::)?(\w+)$/)), 're_tests 820  (1020)');
is(("abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $0), "", 're_tests 822/1 (1022)');
is(("abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $1), "abcd", 're_tests 822/2 (1023)');
is(("xy:z:::abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $0), "xy:z:::", 're_tests 824/1 (1026)');
is(("xy:z:::abcd" ~~ rx:P5/([\w:]+::)?(\w+)$/ && $1), "abcd", 're_tests 824/2 (1027)');
is(("aexycd" ~~ rx:P5/^[^bcd]*(c+)/ && $0), "c", 're_tests 826/1 (1030)');
ok((not ("aaab" ~~ rx:P5/(>a+)ab/)), 're_tests 828  (1032)');
ok(("aaab" ~~ rx:P5/(?>a+)b/), 're_tests 829  (1033)');
is(("a:[b]:" ~~ rx:P5/([[:]+)/ && $0), ":[", 're_tests 831/1 (1035)');
is(("a=[b]=" ~~ rx:P5/([[=]+)/ && $0), "=[", 're_tests 832/1 (1036)');
is(("a.[b]." ~~ rx:P5/([[.]+)/ && $0), ".[", 're_tests 833/1 (1037)');
is(("abc" ~~ rx:P5/[a[:]b[:c]/ && $<>), "abc", 're_tests 834/0 (1038)');
is(("abc" ~~ rx:P5/[a[:]b[:c]/ && $<>), "abc", 're_tests 835/0 (1039)');
is(("aaab" ~~ rx:P5/((?>a+)b)/ && $0), "aaab", 're_tests 836/1 (1040)');
is(("aaab" ~~ rx:P5/(?>(a+))b/ && $0), "aaa", 're_tests 838/1 (1042)');
is(("((abc(ade)ufh()()x" ~~ rx:P5/((?>[^()]+)|\([^()]*\))+/ && $<>), "abc(ade)ufh()()x", 're_tests 840/0 (1044)');
is(("a\nb\n" ~~ rx:P5/\Z/ && $/.from), 3, 're_tests 842/0 (1046)');
is(("a\nb\n" ~~ rx:P5/\z/ && $/.from), 4, 're_tests 844/0 (1048)');
is(("a\nb\n" ~~ rx:P5/$/ && $/.from), 3, 're_tests 846/0 (1050)');
is(("b\na\n" ~~ rx:P5/\Z/ && $/.from), 3, 're_tests 847/0 (1051)');
is(("b\na\n" ~~ rx:P5/\z/ && $/.from), 4, 're_tests 849/0 (1053)');
is(("b\na\n" ~~ rx:P5/$/ && $/.from), 3, 're_tests 851/0 (1055)');
is(("b\na" ~~ rx:P5/\Z/ && $/.from), 3, 're_tests 852/0 (1056)');
is(("b\na" ~~ rx:P5/\z/ && $/.from), 3, 're_tests 854/0 (1058)');
is(("b\na" ~~ rx:P5/$/ && $/.from), 3, 're_tests 856/0 (1060)');
is(("a\nb\n" ~~ rx:P5/(?m)\Z/ && $/.from), 3, 're_tests 857/0 (1061)');
is(("a\nb\n" ~~ rx:P5/(?m)\z/ && $/.from), 4, 're_tests 858/0 (1062)');
is(("a\nb\n" ~~ rx:P5/(?m)$/ && $/.from), 1, 're_tests 859/0 (1063)');
is(("b\na\n" ~~ rx:P5/(?m)\Z/ && $/.from), 3, 're_tests 860/0 (1064)');
is(("b\na\n" ~~ rx:P5/(?m)\z/ && $/.from), 4, 're_tests 861/0 (1065)');
is(("b\na\n" ~~ rx:P5/(?m)$/ && $/.from), 1, 're_tests 862/0 (1066)');
is(("b\na" ~~ rx:P5/(?m)\Z/ && $/.from), 3, 're_tests 863/0 (1067)');
is(("b\na" ~~ rx:P5/(?m)\z/ && $/.from), 3, 're_tests 864/0 (1068)');
is(("b\na" ~~ rx:P5/(?m)$/ && $/.from), 1, 're_tests 865/0 (1069)');
ok((not ("a\nb\n" ~~ rx:P5/a\Z/)), 're_tests 866  (1070)');
ok((not ("a\nb\n" ~~ rx:P5/a\z/)), 're_tests 868  (1072)');
ok((not ("a\nb\n" ~~ rx:P5/a$/)), 're_tests 870  (1074)');
is(("b\na\n" ~~ rx:P5/a\Z/ && $/.from), 2, 're_tests 871/0 (1075)');
ok((not ("b\na\n" ~~ rx:P5/a\z/)), 're_tests 873  (1077)');
is(("b\na\n" ~~ rx:P5/a$/ && $/.from), 2, 're_tests 875/0 (1079)');
is(("b\na" ~~ rx:P5/a\Z/ && $/.from), 2, 're_tests 876/0 (1080)');
is(("b\na" ~~ rx:P5/a\z/ && $/.from), 2, 're_tests 878/0 (1082)');
is(("b\na" ~~ rx:P5/a$/ && $/.from), 2, 're_tests 880/0 (1084)');
ok((not ("a\nb\n" ~~ rx:P5/(?m)a\Z/)), 're_tests 881  (1085)');
ok((not ("a\nb\n" ~~ rx:P5/(?m)a\z/)), 're_tests 882  (1086)');
is(("a\nb\n" ~~ rx:P5/(?m)a$/ && $/.from), 0, 're_tests 883/0 (1087)');
is(("b\na\n" ~~ rx:P5/(?m)a\Z/ && $/.from), 2, 're_tests 884/0 (1088)');
ok((not ("b\na\n" ~~ rx:P5/(?m)a\z/)), 're_tests 885  (1089)');
is(("b\na\n" ~~ rx:P5/(?m)a$/ && $/.from), 2, 're_tests 886/0 (1090)');
is(("b\na" ~~ rx:P5/(?m)a\Z/ && $/.from), 2, 're_tests 887/0 (1091)');
is(("b\na" ~~ rx:P5/(?m)a\z/ && $/.from), 2, 're_tests 888/0 (1092)');
is(("b\na" ~~ rx:P5/(?m)a$/ && $/.from), 2, 're_tests 889/0 (1093)');
ok((not ("aa\nb\n" ~~ rx:P5/aa\Z/)), 're_tests 890  (1094)');
ok((not ("aa\nb\n" ~~ rx:P5/aa\z/)), 're_tests 892  (1096)');
ok((not ("aa\nb\n" ~~ rx:P5/aa$/)), 're_tests 894  (1098)');
is(("b\naa\n" ~~ rx:P5/aa\Z/ && $/.from), 2, 're_tests 895/0 (1099)');
ok((not ("b\naa\n" ~~ rx:P5/aa\z/)), 're_tests 897  (1101)');
is(("b\naa\n" ~~ rx:P5/aa$/ && $/.from), 2, 're_tests 899/0 (1103)');
is(("b\naa" ~~ rx:P5/aa\Z/ && $/.from), 2, 're_tests 900/0 (1104)');
is(("b\naa" ~~ rx:P5/aa\z/ && $/.from), 2, 're_tests 902/0 (1106)');
is(("b\naa" ~~ rx:P5/aa$/ && $/.from), 2, 're_tests 904/0 (1108)');
ok((not ("aa\nb\n" ~~ rx:P5/(?m)aa\Z/)), 're_tests 905  (1109)');
ok((not ("aa\nb\n" ~~ rx:P5/(?m)aa\z/)), 're_tests 906  (1110)');
is(("aa\nb\n" ~~ rx:P5/(?m)aa$/ && $/.from), 0, 're_tests 907/0 (1111)');
is(("b\naa\n" ~~ rx:P5/(?m)aa\Z/ && $/.from), 2, 're_tests 908/0 (1112)');
ok((not ("b\naa\n" ~~ rx:P5/(?m)aa\z/)), 're_tests 909  (1113)');
is(("b\naa\n" ~~ rx:P5/(?m)aa$/ && $/.from), 2, 're_tests 910/0 (1114)');
is(("b\naa" ~~ rx:P5/(?m)aa\Z/ && $/.from), 2, 're_tests 911/0 (1115)');
is(("b\naa" ~~ rx:P5/(?m)aa\z/ && $/.from), 2, 're_tests 912/0 (1116)');
is(("b\naa" ~~ rx:P5/(?m)aa$/ && $/.from), 2, 're_tests 913/0 (1117)');
ok((not ("ac\nb\n" ~~ rx:P5/aa\Z/)), 're_tests 914  (1118)');
ok((not ("ac\nb\n" ~~ rx:P5/aa\z/)), 're_tests 916  (1120)');
ok((not ("ac\nb\n" ~~ rx:P5/aa$/)), 're_tests 918  (1122)');
ok((not ("b\nac\n" ~~ rx:P5/aa\Z/)), 're_tests 919  (1123)');
ok((not ("b\nac\n" ~~ rx:P5/aa\z/)), 're_tests 921  (1125)');
ok((not ("b\nac\n" ~~ rx:P5/aa$/)), 're_tests 923  (1127)');
ok((not ("b\nac" ~~ rx:P5/aa\Z/)), 're_tests 924  (1128)');
ok((not ("b\nac" ~~ rx:P5/aa\z/)), 're_tests 926  (1130)');
ok((not ("b\nac" ~~ rx:P5/aa$/)), 're_tests 928  (1132)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)aa\Z/)), 're_tests 929  (1133)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)aa\z/)), 're_tests 930  (1134)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)aa$/)), 're_tests 931  (1135)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)aa\Z/)), 're_tests 932  (1136)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)aa\z/)), 're_tests 933  (1137)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)aa$/)), 're_tests 934  (1138)');
ok((not ("b\nac" ~~ rx:P5/(?m)aa\Z/)), 're_tests 935  (1139)');
ok((not ("b\nac" ~~ rx:P5/(?m)aa\z/)), 're_tests 936  (1140)');
ok((not ("b\nac" ~~ rx:P5/(?m)aa$/)), 're_tests 937  (1141)');
ok((not ("ca\nb\n" ~~ rx:P5/aa\Z/)), 're_tests 938  (1142)');
ok((not ("ca\nb\n" ~~ rx:P5/aa\z/)), 're_tests 940  (1144)');
ok((not ("ca\nb\n" ~~ rx:P5/aa$/)), 're_tests 942  (1146)');
ok((not ("b\nca\n" ~~ rx:P5/aa\Z/)), 're_tests 943  (1147)');
ok((not ("b\nca\n" ~~ rx:P5/aa\z/)), 're_tests 945  (1149)');
ok((not ("b\nca\n" ~~ rx:P5/aa$/)), 're_tests 947  (1151)');
ok((not ("b\nca" ~~ rx:P5/aa\Z/)), 're_tests 948  (1152)');
ok((not ("b\nca" ~~ rx:P5/aa\z/)), 're_tests 950  (1154)');
ok((not ("b\nca" ~~ rx:P5/aa$/)), 're_tests 952  (1156)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)aa\Z/)), 're_tests 953  (1157)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)aa\z/)), 're_tests 954  (1158)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)aa$/)), 're_tests 955  (1159)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)aa\Z/)), 're_tests 956  (1160)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)aa\z/)), 're_tests 957  (1161)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)aa$/)), 're_tests 958  (1162)');
ok((not ("b\nca" ~~ rx:P5/(?m)aa\Z/)), 're_tests 959  (1163)');
ok((not ("b\nca" ~~ rx:P5/(?m)aa\z/)), 're_tests 960  (1164)');
ok((not ("b\nca" ~~ rx:P5/(?m)aa$/)), 're_tests 961  (1165)');
ok((not ("ab\nb\n" ~~ rx:P5/ab\Z/)), 're_tests 962  (1166)');
ok((not ("ab\nb\n" ~~ rx:P5/ab\z/)), 're_tests 964  (1168)');
ok((not ("ab\nb\n" ~~ rx:P5/ab$/)), 're_tests 966  (1170)');
is(("b\nab\n" ~~ rx:P5/ab\Z/ && $/.from), 2, 're_tests 967/0 (1171)');
ok((not ("b\nab\n" ~~ rx:P5/ab\z/)), 're_tests 969  (1173)');
is(("b\nab\n" ~~ rx:P5/ab$/ && $/.from), 2, 're_tests 971/0 (1175)');
is(("b\nab" ~~ rx:P5/ab\Z/ && $/.from), 2, 're_tests 972/0 (1176)');
is(("b\nab" ~~ rx:P5/ab\z/ && $/.from), 2, 're_tests 974/0 (1178)');
is(("b\nab" ~~ rx:P5/ab$/ && $/.from), 2, 're_tests 976/0 (1180)');
ok((not ("ab\nb\n" ~~ rx:P5/(?m)ab\Z/)), 're_tests 977  (1181)');
ok((not ("ab\nb\n" ~~ rx:P5/(?m)ab\z/)), 're_tests 978  (1182)');
is(("ab\nb\n" ~~ rx:P5/(?m)ab$/ && $/.from), 0, 're_tests 979/0 (1183)');
is(("b\nab\n" ~~ rx:P5/(?m)ab\Z/ && $/.from), 2, 're_tests 980/0 (1184)');
ok((not ("b\nab\n" ~~ rx:P5/(?m)ab\z/)), 're_tests 981  (1185)');
is(("b\nab\n" ~~ rx:P5/(?m)ab$/ && $/.from), 2, 're_tests 982/0 (1186)');
is(("b\nab" ~~ rx:P5/(?m)ab\Z/ && $/.from), 2, 're_tests 983/0 (1187)');
is(("b\nab" ~~ rx:P5/(?m)ab\z/ && $/.from), 2, 're_tests 984/0 (1188)');
is(("b\nab" ~~ rx:P5/(?m)ab$/ && $/.from), 2, 're_tests 985/0 (1189)');
ok((not ("ac\nb\n" ~~ rx:P5/ab\Z/)), 're_tests 986  (1190)');
ok((not ("ac\nb\n" ~~ rx:P5/ab\z/)), 're_tests 988  (1192)');
ok((not ("ac\nb\n" ~~ rx:P5/ab$/)), 're_tests 990  (1194)');
ok((not ("b\nac\n" ~~ rx:P5/ab\Z/)), 're_tests 991  (1195)');
ok((not ("b\nac\n" ~~ rx:P5/ab\z/)), 're_tests 993  (1197)');
ok((not ("b\nac\n" ~~ rx:P5/ab$/)), 're_tests 995  (1199)');
ok((not ("b\nac" ~~ rx:P5/ab\Z/)), 're_tests 996  (1200)');
ok((not ("b\nac" ~~ rx:P5/ab\z/)), 're_tests 998  (1202)');
ok((not ("b\nac" ~~ rx:P5/ab$/)), 're_tests 1000  (1204)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)ab\Z/)), 're_tests 1001  (1205)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)ab\z/)), 're_tests 1002  (1206)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)ab$/)), 're_tests 1003  (1207)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)ab\Z/)), 're_tests 1004  (1208)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)ab\z/)), 're_tests 1005  (1209)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)ab$/)), 're_tests 1006  (1210)');
ok((not ("b\nac" ~~ rx:P5/(?m)ab\Z/)), 're_tests 1007  (1211)');
ok((not ("b\nac" ~~ rx:P5/(?m)ab\z/)), 're_tests 1008  (1212)');
ok((not ("b\nac" ~~ rx:P5/(?m)ab$/)), 're_tests 1009  (1213)');
ok((not ("ca\nb\n" ~~ rx:P5/ab\Z/)), 're_tests 1010  (1214)');
ok((not ("ca\nb\n" ~~ rx:P5/ab\z/)), 're_tests 1012  (1216)');
ok((not ("ca\nb\n" ~~ rx:P5/ab$/)), 're_tests 1014  (1218)');
ok((not ("b\nca\n" ~~ rx:P5/ab\Z/)), 're_tests 1015  (1219)');
ok((not ("b\nca\n" ~~ rx:P5/ab\z/)), 're_tests 1017  (1221)');
ok((not ("b\nca\n" ~~ rx:P5/ab$/)), 're_tests 1019  (1223)');
ok((not ("b\nca" ~~ rx:P5/ab\Z/)), 're_tests 1020  (1224)');
ok((not ("b\nca" ~~ rx:P5/ab\z/)), 're_tests 1022  (1226)');
ok((not ("b\nca" ~~ rx:P5/ab$/)), 're_tests 1024  (1228)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)ab\Z/)), 're_tests 1025  (1229)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)ab\z/)), 're_tests 1026  (1230)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)ab$/)), 're_tests 1027  (1231)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)ab\Z/)), 're_tests 1028  (1232)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)ab\z/)), 're_tests 1029  (1233)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)ab$/)), 're_tests 1030  (1234)');
ok((not ("b\nca" ~~ rx:P5/(?m)ab\Z/)), 're_tests 1031  (1235)');
ok((not ("b\nca" ~~ rx:P5/(?m)ab\z/)), 're_tests 1032  (1236)');
ok((not ("b\nca" ~~ rx:P5/(?m)ab$/)), 're_tests 1033  (1237)');
ok((not ("abb\nb\n" ~~ rx:P5/abb\Z/)), 're_tests 1034  (1238)');
ok((not ("abb\nb\n" ~~ rx:P5/abb\z/)), 're_tests 1036  (1240)');
ok((not ("abb\nb\n" ~~ rx:P5/abb$/)), 're_tests 1038  (1242)');
is(("b\nabb\n" ~~ rx:P5/abb\Z/ && $/.from), 2, 're_tests 1039/0 (1243)');
ok((not ("b\nabb\n" ~~ rx:P5/abb\z/)), 're_tests 1041  (1245)');
is(("b\nabb\n" ~~ rx:P5/abb$/ && $/.from), 2, 're_tests 1043/0 (1247)');
is(("b\nabb" ~~ rx:P5/abb\Z/ && $/.from), 2, 're_tests 1044/0 (1248)');
is(("b\nabb" ~~ rx:P5/abb\z/ && $/.from), 2, 're_tests 1046/0 (1250)');
is(("b\nabb" ~~ rx:P5/abb$/ && $/.from), 2, 're_tests 1048/0 (1252)');
ok((not ("abb\nb\n" ~~ rx:P5/(?m)abb\Z/)), 're_tests 1049  (1253)');
ok((not ("abb\nb\n" ~~ rx:P5/(?m)abb\z/)), 're_tests 1050  (1254)');
is(("abb\nb\n" ~~ rx:P5/(?m)abb$/ && $/.from), 0, 're_tests 1051/0 (1255)');
is(("b\nabb\n" ~~ rx:P5/(?m)abb\Z/ && $/.from), 2, 're_tests 1052/0 (1256)');
ok((not ("b\nabb\n" ~~ rx:P5/(?m)abb\z/)), 're_tests 1053  (1257)');
is(("b\nabb\n" ~~ rx:P5/(?m)abb$/ && $/.from), 2, 're_tests 1054/0 (1258)');
is(("b\nabb" ~~ rx:P5/(?m)abb\Z/ && $/.from), 2, 're_tests 1055/0 (1259)');
is(("b\nabb" ~~ rx:P5/(?m)abb\z/ && $/.from), 2, 're_tests 1056/0 (1260)');
is(("b\nabb" ~~ rx:P5/(?m)abb$/ && $/.from), 2, 're_tests 1057/0 (1261)');
ok((not ("ac\nb\n" ~~ rx:P5/abb\Z/)), 're_tests 1058  (1262)');
ok((not ("ac\nb\n" ~~ rx:P5/abb\z/)), 're_tests 1060  (1264)');
ok((not ("ac\nb\n" ~~ rx:P5/abb$/)), 're_tests 1062  (1266)');
ok((not ("b\nac\n" ~~ rx:P5/abb\Z/)), 're_tests 1063  (1267)');
ok((not ("b\nac\n" ~~ rx:P5/abb\z/)), 're_tests 1065  (1269)');
ok((not ("b\nac\n" ~~ rx:P5/abb$/)), 're_tests 1067  (1271)');
ok((not ("b\nac" ~~ rx:P5/abb\Z/)), 're_tests 1068  (1272)');
ok((not ("b\nac" ~~ rx:P5/abb\z/)), 're_tests 1070  (1274)');
ok((not ("b\nac" ~~ rx:P5/abb$/)), 're_tests 1072  (1276)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)abb\Z/)), 're_tests 1073  (1277)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)abb\z/)), 're_tests 1074  (1278)');
ok((not ("ac\nb\n" ~~ rx:P5/(?m)abb$/)), 're_tests 1075  (1279)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)abb\Z/)), 're_tests 1076  (1280)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)abb\z/)), 're_tests 1077  (1281)');
ok((not ("b\nac\n" ~~ rx:P5/(?m)abb$/)), 're_tests 1078  (1282)');
ok((not ("b\nac" ~~ rx:P5/(?m)abb\Z/)), 're_tests 1079  (1283)');
ok((not ("b\nac" ~~ rx:P5/(?m)abb\z/)), 're_tests 1080  (1284)');
ok((not ("b\nac" ~~ rx:P5/(?m)abb$/)), 're_tests 1081  (1285)');
ok((not ("ca\nb\n" ~~ rx:P5/abb\Z/)), 're_tests 1082  (1286)');
ok((not ("ca\nb\n" ~~ rx:P5/abb\z/)), 're_tests 1084  (1288)');
ok((not ("ca\nb\n" ~~ rx:P5/abb$/)), 're_tests 1086  (1290)');
ok((not ("b\nca\n" ~~ rx:P5/abb\Z/)), 're_tests 1087  (1291)');
ok((not ("b\nca\n" ~~ rx:P5/abb\z/)), 're_tests 1089  (1293)');
ok((not ("b\nca\n" ~~ rx:P5/abb$/)), 're_tests 1091  (1295)');
ok((not ("b\nca" ~~ rx:P5/abb\Z/)), 're_tests 1092  (1296)');
ok((not ("b\nca" ~~ rx:P5/abb\z/)), 're_tests 1094  (1298)');
ok((not ("b\nca" ~~ rx:P5/abb$/)), 're_tests 1096  (1300)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)abb\Z/)), 're_tests 1097  (1301)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)abb\z/)), 're_tests 1098  (1302)');
ok((not ("ca\nb\n" ~~ rx:P5/(?m)abb$/)), 're_tests 1099  (1303)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)abb\Z/)), 're_tests 1100  (1304)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)abb\z/)), 're_tests 1101  (1305)');
ok((not ("b\nca\n" ~~ rx:P5/(?m)abb$/)), 're_tests 1102  (1306)');
ok((not ("b\nca" ~~ rx:P5/(?m)abb\Z/)), 're_tests 1103  (1307)');
ok((not ("b\nca" ~~ rx:P5/(?m)abb\z/)), 're_tests 1104  (1308)');
ok((not ("b\nca" ~~ rx:P5/(?m)abb$/)), 're_tests 1105  (1309)');
is(("ca" ~~ rx:P5/(^|x)(c)/ && $1), "c", 're_tests 1106/2 (1310)');
ok((not ("x" ~~ rx:P5/a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz/)), 're_tests 1108  (1312)');
is(("_I(round(xs * sz),1)" ~~ rx:P5/round\(((?>[^()]+))\)/ && $0), "xs * sz", 're_tests 1110/1 (1314)');
ok(("foo.bart" ~~ rx:P5/foo.bart/), 're_tests 1112  (1316)');
ok(("abcd\ndxxx" ~~ rx:P5/(?m)^d[x][x][x]/), 're_tests 1114  (1318)');
ok(("bbbbXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+X/), 're_tests 1115  (1319)', :todo<bug>);
ok(("bbbbXcXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+XX/), 're_tests 1117  (1321)', :todo<bug>);
ok(("bbbbXXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.XX(.+)+X/), 're_tests 1119  (1323)', :todo<bug>);
ok((not ("bbbbXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+X/)), 're_tests 1121  (1325)');
ok((not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+XX/)), 're_tests 1123  (1327)');
ok((not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.XX(.+)+X/)), 're_tests 1125  (1329)');
ok(("bbbbXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+[X]/), 're_tests 1127  (1331)', :todo<bug>);
ok(("bbbbXcXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+[X][X]/), 're_tests 1129  (1333)', :todo<bug>);
ok(("bbbbXXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.XX(.+)+[X]/), 're_tests 1131  (1335)', :todo<bug>);
ok((not ("bbbbXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+[X]/)), 're_tests 1133  (1337)');
ok((not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.X(.+)+[X][X]/)), 're_tests 1135  (1339)');
ok((not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.XX(.+)+[X]/)), 're_tests 1137  (1341)');
ok(("bbbbXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.[X](.+)+[X]/), 're_tests 1139  (1343)', :todo<bug>);
ok(("bbbbXcXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.[X](.+)+[X][X]/), 're_tests 1141  (1345)', :todo<bug>);
ok(("bbbbXXcXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.[X][X](.+)+[X]/), 're_tests 1143  (1347)', :todo<bug>);
ok((not ("bbbbXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.[X](.+)+[X]/)), 're_tests 1145  (1349)');
ok((not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.[X](.+)+[X][X]/)), 're_tests 1147  (1351)');
ok((not ("bbbbXXXaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa" ~~ rx:P5/.[X][X](.+)+[X]/)), 're_tests 1149  (1353)');
ok(("xxxtt" ~~ rx:P5/tt+$/), 're_tests 1151  (1355)');
is(("za-9z" ~~ rx:P5/([a-\d]+)/ && $0), "a-9", 're_tests 1153/1 (1357)');
is(("a0-za" ~~ rx:P5/([\d-z]+)/ && $0), "0-z", 're_tests 1155/1 (1359)');
is(("a0- z" ~~ rx:P5/([\d-\s]+)/ && $0), "0- ", 're_tests 1157/1 (1361)');
#todo_is(("za-9z" ~~ rx:P5/([a-[:digit:]]+)/ && $0), "a-9", 're_tests 1159/1 (1363)');
#todo_is(("=0-z=" ~~ rx:P5/([[:digit:]-z]+)/ && $0), "0-z", 're_tests 1160/1 (1364)');
#todo_is(("=0-z=" ~~ rx:P5/([[:digit:]-[:alpha:]]+)/ && $0), "0-z", 're_tests 1161/1 (1365)');
ok((not ("aaaXbX" ~~ rx:P5/\GX.*X/)), 're_tests 1162  (1366)');
is(("3.1415926" ~~ rx:P5/(\d+\.\d+)/ && $0), "3.1415926", 're_tests 1163/1 (1367)');
is(("have a web browser" ~~ rx:P5/(\ba.{0,10}br)/ && $0), "a web br", 're_tests 1165/1 (1369)');
ok((not ("Changes" ~~ rx:P5/(?i)\.c(pp|xx|c)?$/)), 're_tests 1167  (1371)');
ok(("IO.c" ~~ rx:P5/(?i)\.c(pp|xx|c)?$/), 're_tests 1169  (1373)');
is(("IO.c" ~~ rx:P5/(?i)(\.c(pp|xx|c)?$)/ && $0), ".c", 're_tests 1171/1 (1375)');
ok((not ("C:/" ~~ rx:P5/^([a-z]:)/)), 're_tests 1173  (1377)');
ok(("\nx aa" ~~ rx:P5/(?m)^\S\s+aa$/), 're_tests 1175  (1379)');
ok(("ab" ~~ rx:P5/(^|a)b/), 're_tests 1176  (1380)');
ok((not ("abcab" ~~ rx:P5/(\w)?(abc)\1b/)), 're_tests 1178  (1382)');
ok(("a,b,c" ~~ rx:P5/^(?:.,){2}c/), 're_tests 1180  (1384)');
is(("a,b,c" ~~ rx:P5/^(.,){2}c/ && $0), "b,", 're_tests 1182/1 (1386)');
ok(("a,b,c" ~~ rx:P5/^(?:[^,]*,){2}c/), 're_tests 1184  (1388)');
is(("a,b,c" ~~ rx:P5/^([^,]*,){2}c/ && $0), "b,", 're_tests 1186/1 (1390)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]*,){3}d/ && $0), "c,", 're_tests 1188/1 (1392)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]*,){3,}d/ && $0), "c,", 're_tests 1190/1 (1394)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]*,){0,3}d/ && $0), "c,", 're_tests 1192/1 (1396)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{1,3},){3}d/ && $0), "c,", 're_tests 1194/1 (1398)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{1,3},){3,}d/ && $0), "c,", 're_tests 1196/1 (1400)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{1,3},){0,3}d/ && $0), "c,", 're_tests 1198/1 (1402)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{1,},){3}d/ && $0), "c,", 're_tests 1200/1 (1404)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{1,},){3,}d/ && $0), "c,", 're_tests 1202/1 (1406)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{1,},){0,3}d/ && $0), "c,", 're_tests 1204/1 (1408)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{0,3},){3}d/ && $0), "c,", 're_tests 1206/1 (1410)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{0,3},){3,}d/ && $0), "c,", 're_tests 1208/1 (1412)');
is(("aaa,b,c,d" ~~ rx:P5/^([^,]{0,3},){0,3}d/ && $0), "c,", 're_tests 1210/1 (1414)');
ok(("" ~~ rx:P5/(?i)/), 're_tests 1212  (1416)');
ok(("a\nxb\n" ~~ rx:P5/(?m)(?!\A)x/), 're_tests 1214  (1418)');
ok(("123\nabcabcabcabc\n" ~~ rx:P5/(?m)^.{9}abc.*\n/), 're_tests 1215  (1419)');
ok((not ("a" ~~ rx:P5/^(a)?(?(1)a|b)+$/)), 're_tests 1216  (1420)');
is(("aaaaaa" ~~ rx:P5/^(a\1?){4}$/ && $0), "aa", 're_tests 1218/1 (1422)');
ok(("x1" ~~ rx:P5/^(0+)?(?:x(1))?/), 're_tests 1220  (1424)');
ok(("012cxx0190" ~~ rx:P5/^([0-9a-fA-F]+)(?:x([0-9a-fA-F]+)?)(?:x([0-9a-fA-F]+))?/), 're_tests 1222  (1426)');
is(("bbbac" ~~ rx:P5/^(b+?|a){1,2}c/ && $0), "a", 're_tests 1224/1 (1428)');
is(("bbbbac" ~~ rx:P5/^(b+?|a){1,2}c/ && $0), "a", 're_tests 1226/1 (1430)');
ok(("aaaacccc" ~~ rx:P5/((?:aaaa|bbbb)cccc)?/), 're_tests 1228  (1432)');
ok(("bbbbcccc" ~~ rx:P5/((?:aaaa|bbbb)cccc)?/), 're_tests 1230  (1434)');
is(("a" ~~ rx:P5/(a)?(a)+/ && $0), "", 're_tests 1232/1 (1436)');
is(("a" ~~ rx:P5/(a)?(a)+/ && $1), "a", 're_tests 1232/2 (1437)');
is(("ab" ~~ rx:P5/(ab)?(ab)+/ && $0), "", 're_tests 1234/1 (1440)');
is(("ab" ~~ rx:P5/(ab)?(ab)+/ && $1), "ab", 're_tests 1234/2 (1441)');
is(("abc" ~~ rx:P5/(abc)?(abc)+/ && $0), "", 're_tests 1236/1 (1444)');
is(("abc" ~~ rx:P5/(abc)?(abc)+/ && $1), "abc", 're_tests 1236/2 (1445)');
ok((not ("a\nb\n" ~~ rx:P5/(?m)b\s^/)), 're_tests 1238  (1448)', :todo<bug>);
ok(("a" ~~ rx:P5/\ba/), 're_tests 1239  (1449)');
#todo_is(("ab" ~~ rx:P5/^(a(??{"(?!)"})|(a)(?{1}))b/ && $1), "a", 're_tests 1241/2 (1451)');
ok((not ("AbCd" ~~ rx:P5/ab(?i)cd/)), 're_tests 1242  (1452)');
ok(("abCd" ~~ rx:P5/ab(?i)cd/), 're_tests 1244  (1454)');
is(("CD" ~~ rx:P5/(A|B)*(?(1)(CD)|(CD))/ && $1), "", 're_tests 1246/2 (1456)');
is(("CD" ~~ rx:P5/(A|B)*(?(1)(CD)|(CD))/ && $2), "CD", 're_tests 1246/3 (1457)');
is(("ABCD" ~~ rx:P5/(A|B)*(?(1)(CD)|(CD))/ && $1), "CD", 're_tests 1248/2 (1460)');
is(("ABCD" ~~ rx:P5/(A|B)*(?(1)(CD)|(CD))/ && $2), "", 're_tests 1248/3 (1461)');
is(("CD" ~~ rx:P5/(A|B)*?(?(1)(CD)|(CD))/ && $1), "", 're_tests 1250/2 (1464)');
is(("CD" ~~ rx:P5/(A|B)*?(?(1)(CD)|(CD))/ && $2), "CD", 're_tests 1250/3 (1465)');
is(("ABCD" ~~ rx:P5/(A|B)*?(?(1)(CD)|(CD))/ && $1), "CD", 're_tests 1252/2 (1468)');
is(("ABCD" ~~ rx:P5/(A|B)*?(?(1)(CD)|(CD))/ && $2), "", 're_tests 1252/3 (1469)');
ok((not ("Oo" ~~ rx:P5/(?i)^(o)(?!.*\1)/)), 're_tests 1254  (1472)');
is(("abc12bc" ~~ rx:P5/(.*)\d+\1/ && $0), "bc", 're_tests 1256/1 (1474)');
is(("foo\n bar" ~~ rx:P5/(?m:(foo\s*$))/ && $0), "foo", 're_tests 1258/1 (1476)');
is(("abcd" ~~ rx:P5/(.*)c/ && $0), "ab", 're_tests 1259/1 (1477)');
is(("abcd" ~~ rx:P5/(.*)(?=c)/ && $0), "ab", 're_tests 1261/1 (1479)');
is(("abcd" ~~ rx:P5/(.*)(?=c)c/ && $0), "ab", 're_tests 1263/1 (1481)');
is(("abcd" ~~ rx:P5/(.*)(?=b|c)/ && $0), "ab", 're_tests 1265/1 (1483)');
is(("abcd" ~~ rx:P5/(.*)(?=b|c)c/ && $0), "ab", 're_tests 1267/1 (1485)');
is(("abcd" ~~ rx:P5/(.*)(?=c|b)/ && $0), "ab", 're_tests 1269/1 (1487)');
is(("abcd" ~~ rx:P5/(.*)(?=c|b)c/ && $0), "ab", 're_tests 1271/1 (1489)');
is(("abcd" ~~ rx:P5/(.*)(?=[bc])/ && $0), "ab", 're_tests 1273/1 (1491)');
is(("abcd" ~~ rx:P5/(.*)(?=[bc])c/ && $0), "ab", 're_tests 1275/1 (1493)');
is(("abcd" ~~ rx:P5/(.*)(?<=b)/ && $0), "ab", 're_tests 1277/1 (1495)');
is(("abcd" ~~ rx:P5/(.*)(?<=b)c/ && $0), "ab", 're_tests 1279/1 (1497)');
is(("abcd" ~~ rx:P5/(.*)(?<=b|c)/ && $0), "abc", 're_tests 1281/1 (1499)');
is(("abcd" ~~ rx:P5/(.*)(?<=b|c)c/ && $0), "ab", 're_tests 1283/1 (1501)');
is(("abcd" ~~ rx:P5/(.*)(?<=c|b)/ && $0), "abc", 're_tests 1285/1 (1503)');
is(("abcd" ~~ rx:P5/(.*)(?<=c|b)c/ && $0), "ab", 're_tests 1287/1 (1505)');
is(("abcd" ~~ rx:P5/(.*)(?<=[bc])/ && $0), "abc", 're_tests 1289/1 (1507)');
is(("abcd" ~~ rx:P5/(.*)(?<=[bc])c/ && $0), "ab", 're_tests 1291/1 (1509)');
is(("abcd" ~~ rx:P5/(.*?)c/ && $0), "ab", 're_tests 1293/1 (1511)');
is(("abcd" ~~ rx:P5/(.*?)(?=c)/ && $0), "ab", 're_tests 1295/1 (1513)');
is(("abcd" ~~ rx:P5/(.*?)(?=c)c/ && $0), "ab", 're_tests 1297/1 (1515)');
is(("abcd" ~~ rx:P5/(.*?)(?=b|c)/ && $0), "a", 're_tests 1299/1 (1517)');
is(("abcd" ~~ rx:P5/(.*?)(?=b|c)c/ && $0), "ab", 're_tests 1301/1 (1519)');
is(("abcd" ~~ rx:P5/(.*?)(?=c|b)/ && $0), "a", 're_tests 1303/1 (1521)');
is(("abcd" ~~ rx:P5/(.*?)(?=c|b)c/ && $0), "ab", 're_tests 1305/1 (1523)');
is(("abcd" ~~ rx:P5/(.*?)(?=[bc])/ && $0), "a", 're_tests 1307/1 (1525)');
is(("abcd" ~~ rx:P5/(.*?)(?=[bc])c/ && $0), "ab", 're_tests 1309/1 (1527)');
is(("abcd" ~~ rx:P5/(.*?)(?<=b)/ && $0), "ab", 're_tests 1311/1 (1529)');
is(("abcd" ~~ rx:P5/(.*?)(?<=b)c/ && $0), "ab", 're_tests 1313/1 (1531)');
is(("abcd" ~~ rx:P5/(.*?)(?<=b|c)/ && $0), "ab", 're_tests 1315/1 (1533)');
is(("abcd" ~~ rx:P5/(.*?)(?<=b|c)c/ && $0), "ab", 're_tests 1317/1 (1535)');
is(("abcd" ~~ rx:P5/(.*?)(?<=c|b)/ && $0), "ab", 're_tests 1319/1 (1537)');
is(("abcd" ~~ rx:P5/(.*?)(?<=c|b)c/ && $0), "ab", 're_tests 1321/1 (1539)');
is(("abcd" ~~ rx:P5/(.*?)(?<=[bc])/ && $0), "ab", 're_tests 1323/1 (1541)');
is(("abcd" ~~ rx:P5/(.*?)(?<=[bc])c/ && $0), "ab", 're_tests 1325/1 (1543)');
is(("2" ~~ rx:P5/2(]*)?$\1/ && $<>), "2", 're_tests 1327/0 (1545)');
#todo_ok(("x" ~~ rx:P5/(??{})/), 're_tests 1329  (1547)');
is(("foobarbar" ~~ rx:P5/^.{3,4}(.+)\1\z/ && $0), "bar", 're_tests 1330/1 (1548)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){3,4}(.+)\1\z/ && $0), "bar", 're_tests 1332/1 (1550)');
is(("foobarbar" ~~ rx:P5/^.{3,4}((?:b|a|r)+)\1\z/ && $0), "bar", 're_tests 1334/1 (1552)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){3,4}((?:b|a|r)+)\1\z/ && $0), "bar", 're_tests 1336/1 (1554)');
is(("foobarbar" ~~ rx:P5/^.{3,4}(.+?)\1\z/ && $0), "bar", 're_tests 1338/1 (1556)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){3,4}(.+?)\1\z/ && $0), "bar", 're_tests 1340/1 (1558)');
is(("foobarbar" ~~ rx:P5/^.{3,4}((?:b|a|r)+?)\1\z/ && $0), "bar", 're_tests 1342/1 (1560)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){3,4}((?:b|a|r)+?)\1\z/ && $0), "bar", 're_tests 1344/1 (1562)');
is(("foobarbar" ~~ rx:P5/^.{2,3}?(.+)\1\z/ && $0), "bar", 're_tests 1346/1 (1564)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){2,3}?(.+)\1\z/ && $0), "bar", 're_tests 1348/1 (1566)');
is(("foobarbar" ~~ rx:P5/^.{2,3}?((?:b|a|r)+)\1\z/ && $0), "bar", 're_tests 1350/1 (1568)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){2,3}?((?:b|a|r)+)\1\z/ && $0), "bar", 're_tests 1352/1 (1570)');
is(("foobarbar" ~~ rx:P5/^.{2,3}?(.+?)\1\z/ && $0), "bar", 're_tests 1354/1 (1572)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){2,3}?(.+?)\1\z/ && $0), "bar", 're_tests 1356/1 (1574)');
is(("foobarbar" ~~ rx:P5/^.{2,3}?((?:b|a|r)+?)\1\z/ && $0), "bar", 're_tests 1358/1 (1576)');
is(("foobarbar" ~~ rx:P5/^(?:f|o|b){2,3}?((?:b|a|r)+?)\1\z/ && $0), "bar", 're_tests 1360/1 (1578)');
ok((not ("......abef" ~~ rx:P5/.*a(?!(b|cd)*e).*f/)), 're_tests 1362  (1580)');
