/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.tika;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioInfoHeader;
import org.gagravarr.ogg.audio.OggAudioStatistics;
import org.gagravarr.ogg.audio.OggAudioStream;
import org.gagravarr.vorbis.VorbisStyleComments;
import org.xml.sax.SAXException;

public abstract class OggAudioParser
extends AbstractParser {
    private static final long serialVersionUID = 5168743829615945633L;
    private static final DecimalFormat DURATION_FORMAT = new DecimalFormat("0.0#");

    protected static void extractChannelInfo(Metadata metadata, OggAudioInfoHeader info) {
        OggAudioParser.extractChannelInfo(metadata, info.getNumChannels());
    }

    protected static void extractChannelInfo(Metadata metadata, int channelCount) {
        if (channelCount == 1) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Mono");
        } else if (channelCount == 2) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "Stereo");
        } else if (channelCount == 5) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "5.1");
        } else if (channelCount == 7) {
            metadata.set(XMPDM.AUDIO_CHANNEL_TYPE, "7.1");
        }
    }

    protected static void extractComments(Metadata metadata, XHTMLContentHandler xhtml, VorbisStyleComments comments) throws TikaException, SAXException {
        metadata.set(TikaCoreProperties.TITLE, comments.getTitle());
        metadata.set(TikaCoreProperties.CREATOR, comments.getArtist());
        metadata.set(XMPDM.ARTIST, comments.getArtist());
        metadata.set(XMPDM.ALBUM, comments.getAlbum());
        metadata.set(XMPDM.GENRE, comments.getGenre());
        metadata.set(XMPDM.RELEASE_DATE, comments.getDate());
        metadata.add(XMP.CREATOR_TOOL, comments.getVendor());
        metadata.add("vendor", comments.getVendor());
        for (String comment : comments.getComments("comment")) {
            metadata.add(XMPDM.LOG_COMMENT.getName(), comment);
        }
        List<String> done = Arrays.asList("title", "artist", "album", "genre", "date", "tracknumber", "vendor", "comment");
        for (String key : comments.getAllComments().keySet()) {
            if (done.contains(key)) continue;
            for (String value : comments.getAllComments().get(key)) {
                metadata.add(key, value);
            }
        }
        xhtml.element("h1", comments.getTitle());
        xhtml.element("p", comments.getArtist());
        if (comments.getTrackNumber() != null) {
            xhtml.element("p", comments.getAlbum() + ", track " + comments.getTrackNumber());
            metadata.set(XMPDM.TRACK_NUMBER, comments.getTrackNumber());
        } else {
            xhtml.element("p", comments.getAlbum());
        }
        xhtml.element("p", comments.getDate());
        for (String comment : comments.getComments("comment")) {
            xhtml.element("p", comment);
        }
        xhtml.element("p", comments.getGenre());
    }

    protected static void extractDuration(Metadata metadata, XHTMLContentHandler xhtml, OggAudioHeaders headers, OggAudioStream audio) throws IOException, SAXException {
        OggAudioStatistics stats = new OggAudioStatistics(headers, audio);
        stats.calculate();
        double duration = stats.getDurationSeconds();
        if (duration > 0.0) {
            metadata.add(XMPDM.DURATION, DURATION_FORMAT.format(duration));
            xhtml.element("p", stats.getDuration());
        }
    }
}

