/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Objects;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;

final class CRSPair {
    final CoordinateReferenceSystem sourceCRS;
    final CoordinateReferenceSystem targetCRS;

    CRSPair(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceCRS) * 31 + Objects.hashCode(this.targetCRS);
    }

    public boolean equals(Object object) {
        if (object instanceof CRSPair) {
            CRSPair cRSPair = (CRSPair)object;
            return Objects.equals(this.sourceCRS, cRSPair.sourceCRS) && Objects.equals(this.targetCRS, cRSPair.targetCRS);
        }
        return false;
    }

    static String label(IdentifiedObject identifiedObject) {
        Object object;
        String string;
        block10: {
            String string2;
            block9: {
                if (identifiedObject == null) {
                    return null;
                }
                Class<? extends IdentifiedObject> clazz = identifiedObject instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)identifiedObject).getInterface() : Classes.getLeafInterfaces(identifiedObject.getClass(), IdentifiedObject.class)[0];
                string = Classes.getShortName(clazz);
                string2 = "CRS";
                if (string.endsWith("CRS")) break block9;
                string2 = "CS";
                if (!string.endsWith("CS")) break block10;
            }
            object = identifiedObject;
            if (identifiedObject instanceof CoordinateReferenceSystem) {
                object = ((CoordinateReferenceSystem)identifiedObject).getCoordinateSystem();
            }
            if (object instanceof EllipsoidalCS) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.setLength(string.length() - string2.length());
                string = stringBuilder.append(((CoordinateSystem)object).getDimension()).append('D').toString();
            }
        }
        if ((object = IdentifiedObjects.getName(identifiedObject, null)) != null) {
            int n;
            if (((String)object).length() >= n) {
                int n2;
                for (n = 30; n > 15 && !Character.isSpaceChar(n2 = ((String)object).codePointBefore(n)); n -= Character.charCount(n2)) {
                }
                object = CharSequences.trimWhitespaces((CharSequence)object, 0, n).toString() + '\u2026';
            }
            string = string + "[\u201c" + (String)object + "\u201d]";
        }
        return string;
    }

    public String toString() {
        return CRSPair.label(this.sourceCRS) + " \u27f6 " + CRSPair.label(this.targetCRS);
    }
}

