#
# XFig Drawing Library
#
# Copyright (c) 2017 D Scott Guthridge <scott_guthridge@rompromity.net>
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the Artistic License as published by the Perl Foundation, either
# version 2.0 of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the Artistic License for more details.
# 
# You should have received a copy of the Artistic License along with this
# program.  If not, see <http://www.perlfoundation.org/artistic_license_2_0>.
#
package Graphics::Fig::FontSize;
our $VERSION = 'v1.0.8';

use strict;
use warnings;
use POSIX qw(floor ceil);
use Carp;

 #
 # @CharacterWidths500: widths of each (ASCII / Latin-1) character in
 # each PostScript font assuming a point size of 500.
 #
 my @CharacterWidths500 = (
    [  # Times Roman (default)
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 228, 279, 279, 465, 434, 101,
	186, 186, 279, 315, 140, 186, 140, 155,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 155, 155, 315, 315, 315, 248,
	514, 403, 372, 372, 403, 341, 310, 403,
	403, 186, 217, 403, 341, 496, 403, 403,
	310, 403, 372, 310, 341, 403, 403, 527,
	403, 403, 341, 186, 155, 186, 262, 279,
	186, 248, 279, 248, 279, 248, 186, 279,
	279, 155, 155, 279, 155, 434, 279, 279,
	279, 279, 186, 217, 155, 279, 279, 403,
	279, 279, 248, 268, 112, 268, 302,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 279, 279, 279, 279, 112, 279,
	186, 424, 154, 279, 315, 186, 424, 186,
	223, 315, 168, 168, 186, 279, 253, 140,
	186, 168, 173, 279, 419, 419, 419, 248,
	403, 403, 403, 403, 403, 403, 496, 372,
	341, 341, 341, 341, 186, 186, 186, 186,
	403, 403, 403, 403, 403, 403, 403, 315,
	403, 403, 403, 403, 403, 403, 310, 279,
	248, 248, 248, 248, 248, 248, 372, 248,
	248, 248, 248, 248, 155, 155, 155, 155,
	279, 279, 279, 279, 279, 279, 279, 315,
	279, 279, 279, 279, 279, 279, 279, 279
    ],
    [  # Times Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 235, 279, 279, 465, 434, 119,
	186, 186, 279, 377, 140, 186, 140, 155,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 186, 186, 377, 377, 377, 279,
	514, 341, 341, 372, 403, 341, 341, 403,
	403, 186, 248, 372, 310, 465, 372, 403,
	341, 403, 341, 279, 310, 403, 341, 465,
	341, 310, 310, 217, 155, 217, 236, 279,
	186, 279, 279, 248, 279, 248, 155, 279,
	279, 155, 155, 248, 155, 403, 279, 279,
	279, 279, 217, 217, 155, 279, 248, 372,
	248, 248, 217, 223, 154, 223, 302,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 217, 279, 279, 279, 279, 154, 279,
	186, 424, 154, 279, 377, 186, 424, 186,
	223, 377, 168, 168, 186, 279, 292, 140,
	186, 168, 173, 279, 419, 419, 419, 279,
	341, 341, 341, 341, 341, 341, 496, 372,
	341, 341, 341, 341, 186, 186, 186, 186,
	403, 372, 403, 403, 403, 403, 403, 377,
	403, 403, 403, 403, 403, 310, 341, 279,
	279, 279, 279, 279, 279, 279, 372, 248,
	248, 248, 248, 248, 155, 155, 155, 155,
	279, 279, 279, 279, 279, 279, 279, 377,
	279, 279, 279, 279, 279, 248, 279, 248
    ],
    [  # Times Bold
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 310, 279, 279, 558, 465, 155,
	186, 186, 279, 318, 140, 186, 140, 155,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 186, 186, 318, 318, 318, 279,
	519, 403, 372, 403, 403, 372, 341, 434,
	434, 217, 279, 434, 372, 527, 403, 434,
	341, 434, 403, 310, 372, 403, 403, 558,
	403, 403, 372, 186, 155, 186, 324, 279,
	186, 279, 310, 248, 310, 248, 186, 279,
	310, 155, 186, 310, 155, 465, 310, 279,
	310, 310, 248, 217, 186, 310, 279, 403,
	279, 279, 248, 220, 123, 220, 290,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 279, 279, 279, 279, 123, 279,
	186, 417, 168, 279, 318, 186, 417, 186,
	223, 318, 168, 168, 186, 310, 302, 140,
	186, 168, 184, 279, 419, 419, 419, 279,
	403, 403, 403, 403, 403, 403, 558, 403,
	372, 372, 372, 372, 217, 217, 217, 217,
	403, 403, 434, 434, 434, 434, 434, 318,
	434, 403, 403, 403, 403, 403, 341, 310,
	279, 279, 279, 279, 279, 279, 403, 248,
	248, 248, 248, 248, 155, 155, 155, 155,
	279, 310, 279, 279, 279, 279, 279, 318,
	279, 310, 310, 310, 310, 279, 310, 279
    ],
    [  # Times Bold Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 217, 310, 279, 279, 465, 434, 155,
	186, 186, 279, 318, 140, 186, 140, 155,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 186, 186, 318, 318, 318, 279,
	465, 372, 372, 372, 403, 372, 372, 403,
	434, 217, 279, 372, 341, 496, 403, 403,
	341, 403, 372, 310, 341, 403, 372, 496,
	372, 341, 341, 186, 155, 186, 318, 279,
	186, 279, 279, 248, 279, 248, 186, 279,
	310, 155, 155, 279, 155, 434, 310, 279,
	279, 279, 217, 217, 155, 310, 248, 372,
	279, 248, 217, 194, 123, 194, 318,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 217, 279, 279, 279, 279, 123, 279,
	186, 417, 149, 279, 338, 186, 417, 186,
	223, 318, 168, 168, 186, 322, 279, 140,
	186, 168, 168, 279, 419, 419, 419, 279,
	372, 372, 372, 372, 372, 372, 527, 372,
	372, 372, 372, 372, 217, 217, 217, 217,
	403, 403, 403, 403, 403, 403, 403, 318,
	403, 403, 403, 403, 403, 341, 341, 279,
	279, 279, 279, 279, 279, 279, 403, 248,
	248, 248, 248, 248, 155, 155, 155, 155,
	279, 310, 279, 279, 279, 279, 279, 318,
	279, 310, 310, 310, 310, 248, 279, 248
    ],
    [  # Avantgarde Book
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 165, 173, 309, 309, 433, 423, 111,
	206, 206, 237, 338, 155, 185, 155, 244,
	309, 309, 309, 309, 309, 309, 309, 309,
	309, 309, 155, 155, 338, 338, 338, 330,
	484, 413, 320, 454, 415, 299, 271, 487,
	381, 126, 269, 330, 258, 513, 413, 485,
	331, 486, 339, 278, 238, 366, 392, 536,
	340, 331, 268, 196, 338, 196, 338, 279,
	211, 381, 381, 361, 382, 363, 175, 376,
	341, 112, 113, 280, 112, 524, 341, 366,
	381, 381, 168, 217, 189, 339, 309, 464,
	268, 299, 237, 196, 375, 196, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 165, 309, 309, 309, 309, 375, 343,
	206, 417, 206, 237, 338, 185, 417, 271,
	223, 338, 185, 185, 209, 339, 315, 155,
	181, 185, 206, 237, 464, 464, 464, 330,
	413, 413, 413, 413, 413, 413, 554, 454,
	299, 299, 299, 299, 126, 126, 126, 126,
	441, 413, 485, 485, 485, 485, 485, 338,
	485, 366, 366, 366, 366, 331, 331, 309,
	381, 381, 381, 381, 381, 381, 646, 361,
	363, 363, 363, 363, 112, 112, 112, 112,
	366, 341, 366, 366, 366, 366, 366, 338,
	365, 339, 339, 339, 339, 299, 381, 299
    ],
    [  # Avantgarde Book Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 165, 173, 309, 309, 433, 423, 111,
	206, 206, 237, 338, 155, 185, 155, 244,
	309, 309, 309, 309, 309, 309, 309, 309,
	309, 309, 155, 155, 338, 338, 338, 330,
	484, 413, 320, 454, 415, 299, 271, 487,
	381, 126, 269, 330, 258, 513, 413, 485,
	331, 486, 339, 278, 238, 366, 392, 536,
	340, 331, 268, 196, 338, 196, 338, 279,
	211, 381, 381, 361, 382, 363, 175, 376,
	341, 112, 113, 280, 112, 524, 341, 366,
	381, 381, 168, 217, 189, 339, 309, 464,
	268, 299, 237, 196, 375, 196, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 165, 309, 309, 309, 309, 375, 343,
	206, 417, 206, 237, 338, 185, 417, 271,
	223, 338, 185, 185, 209, 339, 315, 155,
	181, 185, 206, 237, 464, 464, 464, 330,
	413, 413, 413, 413, 413, 413, 554, 454,
	299, 299, 299, 299, 126, 126, 126, 126,
	441, 413, 485, 485, 485, 485, 485, 338,
	485, 366, 366, 366, 366, 331, 331, 309,
	381, 381, 381, 381, 381, 381, 646, 361,
	363, 363, 363, 363, 112, 112, 112, 112,
	366, 341, 366, 366, 366, 366, 366, 338,
	365, 339, 339, 339, 339, 299, 381, 299
    ],
    [  # Avantgarde Demi
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	156, 156, 201, 313, 313, 480, 380, 123,
	212, 212, 246, 335, 156, 235, 156, 257,
	313, 313, 313, 313, 313, 313, 313, 313,
	313, 313, 156, 156, 335, 335, 335, 313,
	413, 413, 324, 436, 391, 290, 268, 469,
	380, 156, 268, 346, 246, 503, 413, 469,
	313, 469, 324, 290, 235, 357, 391, 503,
	380, 346, 279, 179, 357, 179, 335, 279,
	235, 369, 369, 357, 369, 357, 156, 369,
	335, 134, 145, 324, 134, 525, 335, 357,
	369, 369, 179, 246, 168, 335, 313, 447,
	313, 324, 257, 190, 335, 190, 335,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	156, 156, 313, 313, 313, 313, 335, 313,
	279, 413, 201, 257, 335, 235, 413, 235,
	223, 335, 188, 188, 235, 322, 335, 156,
	190, 188, 201, 257, 469, 469, 469, 313,
	413, 413, 413, 413, 413, 413, 503, 436,
	290, 290, 290, 290, 156, 156, 156, 156,
	414, 413, 469, 469, 469, 469, 469, 335,
	469, 357, 357, 357, 357, 346, 313, 335,
	369, 369, 369, 369, 369, 369, 603, 357,
	357, 357, 357, 357, 134, 134, 134, 134,
	357, 335, 357, 357, 357, 357, 357, 335,
	369, 335, 335, 335, 335, 324, 369, 324
    ],
    [  # Avantguard Demi Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	156, 156, 201, 313, 313, 480, 380, 123,
	212, 212, 246, 335, 156, 235, 156, 257,
	313, 313, 313, 313, 313, 313, 313, 313,
	313, 313, 156, 156, 335, 335, 335, 313,
	413, 413, 324, 436, 391, 290, 268, 469,
	380, 156, 268, 346, 246, 503, 413, 469,
	313, 469, 324, 290, 235, 357, 391, 503,
	380, 346, 279, 179, 357, 179, 335, 279,
	235, 369, 369, 357, 369, 357, 156, 369,
	335, 134, 145, 324, 134, 525, 335, 357,
	369, 369, 179, 246, 168, 335, 313, 447,
	313, 324, 257, 190, 335, 190, 335,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	156, 156, 313, 313, 313, 313, 335, 313,
	279, 413, 201, 257, 335, 235, 413, 235,
	223, 335, 188, 188, 235, 322, 335, 156,
	190, 188, 201, 257, 469, 469, 469, 313,
	413, 413, 413, 413, 413, 413, 503, 436,
	290, 290, 290, 290, 156, 156, 156, 156,
	414, 413, 469, 469, 469, 469, 469, 335,
	469, 357, 357, 357, 357, 346, 313, 335,
	369, 369, 369, 369, 369, 369, 603, 357,
	357, 357, 357, 357, 134, 134, 134, 134,
	357, 335, 357, 357, 357, 357, 357, 335,
	369, 335, 335, 335, 335, 324, 369, 324
    ],
    [  # Bookman Light
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	179, 168, 212, 346, 346, 503, 447, 123,
	168, 168, 246, 335, 179, 223, 179, 335,
	346, 346, 346, 346, 346, 346, 346, 346,
	346, 346, 179, 179, 335, 335, 335, 302,
	458, 380, 413, 413, 447, 402, 357, 447,
	447, 190, 335, 402, 335, 514, 413, 447,
	346, 458, 402, 369, 346, 436, 391, 536,
	402, 357, 357, 168, 335, 168, 335, 279,
	190, 324, 346, 290, 346, 290, 179, 302,
	369, 168, 168, 346, 168, 525, 369, 313,
	346, 324, 246, 290, 212, 380, 290, 436,
	313, 302, 268, 156, 335, 156, 335,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	179, 168, 346, 346, 346, 346, 335, 290,
	235, 413, 235, 201, 335, 223, 413, 246,
	223, 335, 208, 208, 190, 380, 335, 179,
	179, 208, 235, 201, 519, 519, 519, 302,
	380, 380, 380, 380, 380, 380, 704, 413,
	402, 402, 402, 402, 190, 190, 190, 190,
	447, 413, 447, 447, 447, 447, 447, 335,
	447, 436, 436, 436, 436, 357, 346, 369,
	324, 324, 324, 324, 324, 324, 480, 290,
	290, 290, 290, 290, 168, 168, 168, 168,
	313, 369, 313, 313, 313, 313, 313, 335,
	313, 380, 380, 380, 380, 302, 346, 302
    ],
    [  # Bookman Light Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	168, 179, 201, 346, 346, 447, 458, 112,
	156, 156, 246, 335, 168, 179, 168, 335,
	346, 346, 346, 346, 346, 346, 346, 346,
	346, 346, 168, 168, 335, 335, 335, 302,
	436, 391, 402, 402, 413, 380, 346, 424,
	447, 179, 313, 402, 324, 480, 402, 424,
	335, 436, 391, 357, 335, 402, 380, 536,
	391, 369, 324, 145, 335, 145, 335, 279,
	190, 346, 335, 268, 357, 302, 190, 313,
	346, 156, 156, 335, 156, 491, 346, 302,
	335, 313, 223, 302, 190, 346, 302, 491,
	302, 335, 290, 201, 335, 212, 335,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	168, 179, 346, 346, 346, 346, 335, 346,
	235, 413, 246, 168, 335, 179, 413, 246,
	223, 335, 208, 208, 179, 346, 346, 168,
	179, 208, 223, 168, 519, 519, 519, 302,
	391, 391, 391, 391, 391, 391, 681, 402,
	380, 380, 380, 380, 179, 179, 179, 179,
	413, 402, 424, 424, 424, 424, 424, 335,
	424, 402, 402, 402, 402, 369, 335, 346,
	346, 346, 346, 346, 346, 346, 491, 268,
	302, 302, 302, 302, 156, 156, 156, 156,
	302, 346, 302, 302, 302, 302, 302, 335,
	302, 346, 346, 346, 346, 335, 335, 335
    ],
    [  # Bookman Demi
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	190, 201, 235, 369, 369, 525, 447, 134,
	179, 179, 257, 335, 190, 201, 190, 335,
	369, 369, 369, 369, 369, 369, 369, 369,
	369, 369, 190, 190, 335, 335, 335, 369,
	458, 402, 402, 413, 436, 402, 380, 436,
	458, 223, 357, 447, 357, 525, 413, 447,
	369, 447, 436, 369, 391, 413, 402, 525,
	436, 391, 357, 168, 335, 168, 335, 279,
	223, 324, 335, 324, 357, 324, 212, 324,
	380, 201, 190, 369, 190, 558, 380, 346,
	357, 346, 257, 290, 257, 369, 335, 447,
	335, 346, 313, 179, 335, 179, 335,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	190, 201, 369, 369, 369, 369, 335, 335,
	279, 413, 223, 223, 335, 201, 413, 257,
	223, 335, 221, 221, 223, 369, 447, 190,
	201, 221, 223, 223, 553, 553, 553, 369,
	402, 402, 402, 402, 402, 402, 637, 413,
	402, 402, 402, 402, 223, 223, 223, 223,
	436, 413, 447, 447, 447, 447, 447, 335,
	447, 413, 413, 413, 413, 391, 369, 369,
	324, 324, 324, 324, 324, 324, 491, 324,
	324, 324, 324, 324, 201, 201, 201, 201,
	346, 380, 346, 346, 346, 346, 346, 335,
	346, 369, 369, 369, 369, 346, 357, 346
    ],
    [  # Bookman Demi Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	190, 179, 212, 380, 380, 491, 547, 101,
	145, 145, 257, 335, 190, 156, 190, 201,
	380, 380, 380, 380, 380, 380, 380, 380,
	380, 380, 190, 190, 346, 335, 346, 346,
	436, 402, 402, 391, 424, 402, 369, 424,
	447, 212, 346, 436, 357, 480, 413, 424,
	357, 424, 413, 391, 391, 413, 369, 558,
	413, 369, 380, 145, 324, 145, 346, 279,
	212, 380, 335, 313, 380, 313, 235, 346,
	391, 212, 179, 391, 212, 536, 380, 335,
	369, 346, 279, 302, 246, 380, 302, 480,
	346, 335, 313, 168, 346, 168, 346,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	190, 179, 380, 380, 380, 380, 346, 346,
	290, 436, 246, 212, 346, 156, 436, 268,
	223, 335, 228, 228, 190, 380, 380, 190,
	201, 228, 246, 212, 570, 570, 570, 346,
	402, 402, 402, 402, 402, 402, 637, 391,
	402, 402, 402, 402, 212, 212, 212, 212,
	424, 413, 424, 424, 424, 424, 424, 335,
	424, 413, 413, 413, 413, 369, 357, 369,
	380, 380, 380, 380, 380, 380, 491, 313,
	313, 313, 313, 313, 212, 212, 212, 212,
	335, 380, 335, 335, 335, 335, 335, 335,
	335, 380, 380, 380, 380, 335, 369, 335
    ],
    [  # Courier
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334
    ],
    [  # Courier Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334
    ],
    [  # Courier Bold
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334,
	334, 334, 334, 334, 334, 334, 334, 334
    ],
    [  # Courier Bold Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335,
	335, 335, 335, 335, 335, 335, 335, 335
    ],
    [  # Helvetica
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 155, 198, 310, 310, 496, 372, 107,
	186, 186, 217, 326, 155, 186, 155, 155,
	310, 310, 310, 310, 310, 310, 310, 310,
	310, 310, 155, 155, 326, 326, 326, 310,
	567, 372, 372, 403, 403, 372, 341, 434,
	403, 155, 279, 372, 310, 465, 403, 434,
	372, 434, 403, 372, 341, 403, 372, 527,
	372, 372, 341, 155, 155, 155, 262, 310,
	186, 310, 310, 279, 310, 310, 155, 310,
	310, 124, 124, 279, 124, 465, 310, 310,
	310, 310, 186, 279, 155, 310, 279, 403,
	279, 279, 279, 186, 145, 186, 326,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 310, 310, 310, 310, 145, 310,
	186, 411, 207, 310, 326, 186, 411, 186,
	338, 326, 196, 196, 186, 310, 300, 155,
	186, 196, 204, 310, 485, 485, 485, 341,
	372, 372, 372, 372, 372, 372, 558, 403,
	372, 372, 372, 372, 155, 155, 155, 155,
	403, 403, 434, 434, 434, 434, 434, 326,
	434, 403, 403, 403, 403, 372, 372, 341,
	310, 310, 310, 310, 310, 310, 496, 279,
	310, 310, 310, 310, 155, 155, 155, 155,
	310, 310, 310, 310, 310, 310, 310, 326,
	341, 310, 310, 310, 310, 279, 310, 279
    ],
    [  # Helvetica Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 155, 198, 310, 310, 496, 372, 107,
	186, 186, 217, 326, 155, 186, 155, 155,
	310, 310, 310, 310, 310, 310, 310, 310,
	310, 310, 155, 155, 326, 326, 326, 310,
	567, 372, 372, 403, 403, 372, 341, 434,
	403, 155, 279, 372, 310, 465, 403, 434,
	372, 434, 403, 372, 341, 403, 372, 527,
	372, 372, 341, 155, 155, 155, 262, 310,
	186, 310, 310, 279, 310, 310, 155, 310,
	310, 124, 124, 279, 124, 465, 310, 310,
	310, 310, 186, 279, 155, 310, 279, 403,
	279, 279, 279, 186, 145, 186, 326,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 310, 310, 310, 310, 145, 310,
	186, 411, 207, 310, 326, 186, 411, 186,
	338, 326, 218, 218, 186, 310, 300, 155,
	186, 218, 204, 310, 529, 529, 529, 341,
	372, 372, 372, 372, 372, 372, 558, 403,
	372, 372, 372, 372, 155, 155, 155, 155,
	403, 403, 434, 434, 434, 434, 434, 326,
	434, 403, 403, 403, 403, 372, 372, 341,
	310, 310, 310, 310, 310, 310, 496, 279,
	310, 310, 310, 310, 155, 155, 155, 155,
	310, 310, 310, 310, 310, 310, 310, 326,
	341, 310, 310, 310, 310, 279, 310, 279
    ],
    [  # Helvetica Bold
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 265, 310, 310, 496, 403, 133,
	186, 186, 217, 326, 155, 186, 155, 155,
	310, 310, 310, 310, 310, 310, 310, 310,
	310, 310, 186, 186, 326, 326, 326, 341,
	544, 403, 403, 403, 403, 372, 341, 434,
	403, 155, 310, 403, 341, 465, 403, 434,
	372, 434, 403, 372, 341, 403, 372, 527,
	372, 372, 341, 186, 155, 186, 326, 310,
	186, 310, 341, 310, 341, 310, 186, 341,
	341, 155, 155, 310, 155, 496, 341, 341,
	341, 341, 217, 310, 186, 341, 310, 434,
	310, 310, 279, 217, 156, 217, 326,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 310, 310, 310, 310, 156, 310,
	186, 411, 207, 310, 326, 186, 411, 186,
	338, 326, 196, 196, 186, 341, 310, 155,
	186, 196, 204, 310, 485, 485, 485, 341,
	403, 403, 403, 403, 403, 403, 558, 403,
	372, 372, 372, 372, 155, 155, 155, 155,
	403, 403, 434, 434, 434, 434, 434, 326,
	434, 403, 403, 403, 403, 372, 372, 341,
	310, 310, 310, 310, 310, 310, 496, 310,
	310, 310, 310, 310, 155, 155, 155, 155,
	341, 341, 341, 341, 341, 341, 341, 326,
	341, 341, 341, 341, 341, 310, 341, 310
    ],
    [  # Helvetica Bold Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 265, 310, 310, 496, 403, 133,
	186, 186, 217, 326, 155, 186, 155, 155,
	310, 310, 310, 310, 310, 310, 310, 310,
	310, 310, 186, 186, 326, 326, 326, 341,
	544, 403, 403, 403, 403, 372, 341, 434,
	403, 155, 310, 403, 341, 465, 403, 434,
	372, 434, 403, 372, 341, 403, 372, 527,
	372, 372, 341, 186, 155, 186, 326, 310,
	186, 310, 341, 310, 341, 310, 186, 341,
	341, 155, 155, 310, 155, 496, 341, 341,
	341, 341, 217, 310, 186, 341, 310, 434,
	310, 310, 279, 217, 156, 217, 326,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 310, 310, 310, 310, 156, 310,
	186, 411, 207, 310, 326, 186, 411, 186,
	338, 326, 248, 248, 186, 341, 310, 155,
	186, 248, 204, 310, 589, 589, 589, 341,
	403, 403, 403, 403, 403, 403, 558, 403,
	372, 372, 372, 372, 155, 155, 155, 155,
	403, 403, 434, 434, 434, 434, 434, 326,
	434, 403, 403, 403, 403, 372, 372, 341,
	310, 310, 310, 310, 310, 310, 496, 310,
	310, 310, 310, 310, 155, 155, 155, 155,
	341, 341, 341, 341, 341, 341, 341, 326,
	341, 341, 341, 341, 341, 310, 341, 310
    ],
    [  # Helvetica Narrow
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 127, 162, 255, 255, 407, 305,  88,
	152, 152, 178, 267, 127, 152, 127, 127,
	255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 127, 127, 267, 267, 267, 255,
	465, 305, 305, 331, 331, 305, 280, 356,
	331, 127, 229, 305, 255, 381, 331, 356,
	305, 356, 331, 305, 280, 331, 305, 432,
	305, 305, 280, 127, 127, 127, 215, 255,
	152, 255, 255, 229, 255, 255, 127, 255,
	255, 102, 102, 229, 102, 381, 255, 255,
	255, 255, 152, 229, 127, 255, 229, 331,
	229, 229, 229, 153, 119, 153, 267,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 152, 255, 255, 255, 255, 119, 255,
	152, 337, 169, 255, 267, 152, 337, 152,
	183, 267, 152, 152, 152, 255, 246, 127,
	152, 152, 167, 255, 382, 382, 382, 280,
	305, 305, 305, 305, 305, 305, 458, 331,
	305, 305, 305, 305, 127, 127, 127, 127,
	331, 331, 356, 356, 356, 356, 356, 267,
	356, 331, 331, 331, 331, 305, 305, 280,
	255, 255, 255, 255, 255, 255, 407, 229,
	255, 255, 255, 255, 127, 127, 127, 127,
	255, 255, 255, 255, 255, 255, 255, 267,
	280, 255, 255, 255, 255, 229, 255, 229
    ],
    [  # Helvetica Narrow Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 127, 162, 255, 255, 407, 305,  88,
	152, 152, 178, 267, 127, 152, 127, 127,
	255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 127, 127, 267, 267, 267, 255,
	465, 305, 305, 331, 331, 305, 280, 356,
	331, 127, 229, 305, 255, 381, 331, 356,
	305, 356, 331, 305, 280, 331, 305, 432,
	305, 305, 280, 127, 127, 127, 215, 255,
	152, 255, 255, 229, 255, 255, 127, 255,
	255, 102, 102, 229, 102, 381, 255, 255,
	255, 255, 152, 229, 127, 255, 229, 331,
	229, 229, 229, 153, 119, 153, 267,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 152, 255, 255, 255, 255, 119, 255,
	152, 337, 169, 255, 267, 152, 337, 152,
	183, 267, 152, 152, 152, 255, 246, 127,
	152, 152, 167, 255, 382, 382, 382, 280,
	305, 305, 305, 305, 305, 305, 458, 331,
	305, 305, 305, 305, 127, 127, 127, 127,
	331, 331, 356, 356, 356, 356, 356, 267,
	356, 331, 331, 331, 331, 305, 305, 280,
	255, 255, 255, 255, 255, 255, 407, 229,
	255, 255, 255, 255, 127, 127, 127, 127,
	255, 255, 255, 255, 255, 255, 255, 267,
	280, 255, 255, 255, 255, 229, 255, 229
    ],
    [  # Helvetica Narrow Bold
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 152, 217, 255, 255, 407, 331, 109,
	152, 152, 178, 267, 127, 152, 127, 127,
	255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 152, 152, 267, 267, 267, 280,
	447, 331, 331, 331, 331, 305, 280, 356,
	331, 127, 255, 331, 280, 381, 331, 356,
	305, 356, 331, 305, 280, 331, 305, 432,
	305, 305, 280, 152, 127, 152, 267, 255,
	152, 255, 280, 255, 280, 255, 152, 280,
	280, 127, 127, 255, 127, 407, 280, 280,
	280, 280, 178, 255, 152, 280, 255, 356,
	255, 255, 229, 178, 128, 178, 267,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 152, 255, 255, 255, 255, 128, 255,
	152, 337, 169, 255, 267, 152, 337, 152,
	183, 267, 152, 152, 152, 280, 255, 127,
	152, 152, 167, 255, 382, 382, 382, 280,
	331, 331, 331, 331, 331, 331, 458, 331,
	305, 305, 305, 305, 127, 127, 127, 127,
	331, 331, 356, 356, 356, 356, 356, 267,
	356, 331, 331, 331, 331, 305, 305, 280,
	255, 255, 255, 255, 255, 255, 407, 255,
	255, 255, 255, 255, 127, 127, 127, 127,
	280, 280, 280, 280, 280, 280, 280, 267,
	280, 280, 280, 280, 280, 255, 280, 255
    ],
    [  # Helvetica Narrow Bold Oblique
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 152, 217, 255, 255, 407, 331, 109,
	152, 152, 178, 267, 127, 152, 127, 127,
	255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 152, 152, 267, 267, 267, 280,
	447, 331, 331, 331, 331, 305, 280, 356,
	331, 127, 255, 331, 280, 381, 331, 356,
	305, 356, 331, 305, 280, 331, 305, 432,
	305, 305, 280, 152, 127, 152, 267, 255,
	152, 255, 280, 255, 280, 255, 152, 280,
	280, 127, 127, 255, 127, 407, 280, 280,
	280, 280, 178, 255, 152, 280, 255, 356,
	255, 255, 229, 178, 128, 178, 267,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	127, 152, 255, 255, 255, 255, 128, 255,
	152, 337, 169, 255, 267, 152, 337, 152,
	183, 267, 152, 152, 152, 280, 255, 127,
	152, 152, 167, 255, 382, 382, 382, 280,
	331, 331, 331, 331, 331, 331, 458, 331,
	305, 305, 305, 305, 127, 127, 127, 127,
	331, 331, 356, 356, 356, 356, 356, 267,
	356, 331, 331, 331, 331, 305, 305, 280,
	255, 255, 255, 255, 255, 255, 407, 255,
	255, 255, 255, 255, 127, 127, 127, 127,
	280, 280, 280, 280, 280, 280, 280, 267,
	280, 280, 280, 280, 280, 255, 280, 255
    ],
    [  # New Century Schoolbook Roman
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 165, 217, 310, 310, 465, 455, 114,
	186, 186, 279, 338, 155, 186, 155, 155,
	310, 310, 310, 310, 310, 310, 310, 310,
	310, 310, 155, 155, 338, 338, 338, 248,
	411, 403, 403, 403, 434, 403, 372, 434,
	465, 227, 310, 434, 372, 527, 455, 434,
	372, 434, 403, 352, 372, 455, 403, 548,
	393, 393, 341, 186, 338, 186, 338, 279,
	186, 310, 310, 248, 320, 279, 186, 300,
	341, 176, 165, 331, 176, 496, 341, 279,
	320, 310, 248, 259, 217, 341, 300, 434,
	300, 300, 269, 186, 338, 186, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 165, 310, 310, 310, 310, 338, 279,
	186, 411, 186, 238, 338, 186, 411, 186,
	223, 338, 186, 186, 186, 341, 338, 155,
	186, 186, 168, 238, 466, 466, 466, 248,
	403, 403, 403, 403, 403, 403, 558, 403,
	403, 403, 403, 403, 227, 227, 227, 227,
	434, 455, 434, 434, 434, 434, 434, 338,
	434, 455, 455, 455, 455, 393, 372, 320,
	310, 310, 310, 310, 310, 310, 444, 248,
	279, 279, 279, 279, 176, 176, 176, 176,
	279, 341, 279, 279, 279, 279, 279, 338,
	279, 341, 341, 341, 341, 300, 320, 300
    ],
    [  # New Century Schoolbook Roman Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 223, 310, 310, 465, 476, 155,
	186, 186, 279, 338, 155, 186, 155, 338,
	310, 310, 310, 310, 310, 310, 310, 310,
	310, 310, 155, 155, 338, 338, 338, 248,
	417, 393, 403, 403, 434, 403, 372, 434,
	465, 227, 341, 414, 372, 527, 455, 434,
	372, 434, 414, 372, 382, 455, 393, 517,
	393, 382, 372, 186, 338, 186, 338, 279,
	186, 320, 310, 248, 341, 248, 186, 300,
	341, 186, 176, 310, 186, 496, 341, 279,
	320, 310, 248, 248, 197, 341, 290, 434,
	279, 279, 259, 186, 338, 186, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 186, 310, 310, 310, 310, 338, 279,
	186, 417, 236, 238, 338, 186, 417, 186,
	223, 338, 186, 186, 186, 341, 363, 155,
	186, 186, 208, 238, 466, 466, 466, 248,
	393, 393, 393, 393, 393, 393, 486, 403,
	403, 403, 403, 403, 227, 227, 227, 227,
	434, 455, 434, 434, 434, 434, 434, 338,
	434, 455, 455, 455, 455, 382, 372, 310,
	320, 320, 320, 320, 320, 320, 403, 248,
	248, 248, 248, 248, 186, 186, 186, 186,
	279, 341, 279, 279, 279, 279, 279, 338,
	279, 341, 341, 341, 341, 279, 320, 279
    ],
    [  # New Century Schoolbook Roman Bold
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	160, 165, 186, 320, 320, 465, 476, 135,
	217, 217, 279, 338, 155, 186, 155, 155,
	320, 320, 320, 320, 320, 320, 320, 320,
	320, 320, 155, 155, 338, 338, 338, 279,
	417, 424, 434, 434, 465, 424, 403, 465,
	486, 248, 362, 455, 403, 548, 465, 465,
	424, 465, 455, 372, 403, 465, 424, 548,
	403, 403, 372, 217, 338, 217, 338, 279,
	186, 341, 362, 310, 372, 320, 217, 341,
	382, 207, 197, 372, 197, 538, 382, 341,
	372, 362, 290, 279, 238, 382, 341, 496,
	341, 341, 300, 217, 338, 217, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	160, 165, 320, 320, 320, 320, 338, 279,
	186, 417, 205, 279, 338, 186, 417, 186,
	223, 338, 192, 192, 186, 382, 417, 155,
	186, 192, 205, 279, 481, 481, 481, 279,
	424, 424, 424, 424, 424, 424, 548, 434,
	424, 424, 424, 424, 248, 248, 248, 248,
	465, 465, 465, 465, 465, 465, 465, 338,
	465, 465, 465, 465, 465, 403, 424, 341,
	341, 341, 341, 341, 341, 341, 486, 310,
	320, 320, 320, 320, 207, 207, 207, 207,
	341, 382, 341, 341, 341, 341, 341, 338,
	341, 382, 382, 382, 382, 341, 372, 341
    ],
    [  # New Century Schoolbook Roman Bold Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	160, 186, 223, 320, 320, 496, 496, 160,
	227, 227, 279, 338, 160, 186, 160, 155,
	320, 320, 320, 320, 320, 320, 320, 320,
	320, 320, 160, 160, 338, 338, 338, 269,
	417, 414, 424, 424, 465, 414, 393, 455,
	486, 248, 372, 434, 393, 527, 476, 465,
	414, 465, 444, 382, 403, 465, 414, 527,
	414, 393, 393, 227, 338, 227, 338, 279,
	186, 372, 341, 300, 372, 290, 217, 341,
	382, 217, 207, 362, 217, 527, 382, 320,
	362, 352, 290, 269, 227, 382, 310, 465,
	320, 290, 290, 227, 338, 227, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	160, 186, 320, 320, 320, 320, 338, 279,
	186, 417, 230, 269, 338, 186, 417, 186,
	223, 338, 192, 192, 186, 382, 363, 160,
	186, 192, 199, 269, 481, 481, 481, 269,
	414, 414, 414, 414, 414, 414, 496, 424,
	414, 414, 414, 414, 248, 248, 248, 248,
	465, 476, 465, 465, 465, 465, 465, 338,
	465, 465, 465, 465, 465, 393, 414, 320,
	372, 372, 372, 372, 372, 372, 455, 300,
	290, 290, 290, 290, 217, 217, 217, 217,
	320, 382, 320, 320, 320, 320, 320, 338,
	320, 382, 382, 382, 382, 290, 362, 290
    ],
    [  # Palatino Roman
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 155, 207, 279, 279, 469, 434, 116,
	186, 186, 217, 338, 140, 186, 140, 338,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 140, 140, 338, 338, 338, 248,
	417, 434, 341, 396, 432, 341, 310, 426,
	465, 188, 186, 405, 341, 528, 464, 439,
	337, 439, 373, 293, 342, 434, 403, 558,
	372, 372, 372, 186, 338, 186, 338, 279,
	186, 279, 309, 248, 341, 267, 186, 310,
	325, 162, 131, 310, 162, 493, 325, 305,
	336, 313, 221, 237, 182, 337, 315, 466,
	288, 310, 279, 186, 338, 186, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 155, 279, 279, 279, 279, 338, 279,
	186, 417, 186, 279, 338, 186, 417, 186,
	223, 338, 168, 168, 186, 337, 351, 140,
	186, 168, 186, 279, 419, 419, 419, 248,
	434, 434, 434, 434, 434, 434, 527, 396,
	341, 341, 341, 341, 188, 188, 188, 188,
	432, 464, 439, 439, 439, 439, 439, 338,
	465, 434, 434, 434, 434, 372, 337, 310,
	279, 279, 279, 279, 279, 279, 423, 248,
	267, 267, 267, 267, 160, 160, 160, 160,
	305, 325, 305, 305, 305, 305, 305, 338,
	310, 337, 337, 337, 337, 310, 336, 310
    ],
    [  # Palatino Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 279, 279, 279, 496, 434, 186,
	186, 186, 217, 338, 140, 186, 140, 165,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 140, 140, 338, 338, 338, 279,
	417, 403, 341, 372, 434, 341, 310, 403,
	434, 186, 186, 372, 310, 527, 434, 434,
	341, 434, 372, 310, 341, 434, 403, 527,
	403, 372, 372, 186, 338, 186, 338, 279,
	186, 248, 259, 227, 279, 217, 155, 279,
	279, 155, 155, 248, 155, 434, 310, 248,
	279, 259, 217, 217, 186, 310, 279, 403,
	279, 279, 248, 186, 338, 186, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 279, 279, 279, 279, 338, 279,
	186, 417, 186, 279, 338, 186, 417, 186,
	223, 338, 168, 168, 186, 310, 279, 140,
	186, 168, 186, 279, 419, 419, 419, 279,
	403, 403, 403, 403, 403, 403, 525, 372,
	341, 341, 341, 341, 186, 186, 186, 186,
	434, 434, 434, 434, 434, 434, 434, 338,
	434, 434, 434, 434, 434, 372, 341, 279,
	248, 248, 248, 248, 248, 248, 356, 227,
	217, 217, 217, 217, 155, 155, 155, 155,
	248, 310, 248, 248, 248, 248, 248, 338,
	248, 310, 310, 310, 310, 279, 279, 279
    ],
    [  # Palatino Bold
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 155, 224, 279, 279, 496, 465, 127,
	186, 186, 248, 338, 140, 186, 140, 165,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 140, 140, 338, 338, 338, 248,
	417, 434, 372, 403, 465, 341, 310, 465,
	465, 217, 217, 434, 341, 558, 465, 465,
	341, 465, 403, 341, 372, 434, 434, 558,
	372, 372, 372, 186, 338, 186, 338, 279,
	186, 279, 341, 248, 341, 279, 217, 310,
	341, 186, 186, 341, 186, 496, 341, 310,
	341, 341, 217, 248, 186, 341, 310, 465,
	279, 310, 279, 173, 338, 173, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 155, 279, 279, 279, 279, 338, 279,
	186, 417, 245, 279, 338, 186, 417, 186,
	223, 338, 168, 168, 186, 341, 358, 140,
	186, 168, 272, 279, 419, 419, 419, 248,
	434, 434, 434, 434, 434, 434, 558, 403,
	341, 341, 341, 341, 217, 217, 217, 217,
	465, 465, 465, 465, 465, 465, 465, 338,
	465, 434, 434, 434, 434, 372, 341, 341,
	279, 279, 279, 279, 279, 279, 434, 248,
	279, 279, 279, 279, 186, 186, 186, 186,
	310, 341, 310, 310, 310, 310, 310, 338,
	310, 341, 341, 341, 341, 310, 341, 310
    ],
    [  # Palatino Bold Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 279, 279, 279, 496, 465, 140,
	186, 186, 248, 338, 140, 217, 140, 176,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 140, 140, 338, 338, 338, 248,
	465, 403, 372, 382, 434, 341, 310, 434,
	434, 217, 217, 403, 341, 527, 434, 465,
	372, 465, 403, 310, 341, 434, 372, 558,
	403, 341, 372, 186, 338, 186, 338, 279,
	186, 310, 300, 248, 310, 248, 186, 279,
	310, 186, 186, 310, 186, 465, 310, 310,
	310, 300, 217, 248, 217, 310, 310, 465,
	279, 310, 279, 186, 338, 186, 338,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 279, 279, 279, 279, 338, 310,
	186, 417, 186, 279, 338, 217, 417, 186,
	223, 338, 168, 168, 186, 310, 310, 140,
	186, 168, 186, 279, 419, 419, 419, 248,
	403, 403, 403, 403, 403, 403, 527, 382,
	341, 341, 341, 341, 217, 217, 217, 217,
	434, 434, 465, 465, 465, 465, 465, 338,
	465, 434, 434, 434, 434, 341, 372, 310,
	310, 310, 310, 310, 310, 310, 412, 248,
	248, 248, 248, 248, 186, 186, 186, 186,
	310, 310, 310, 310, 310, 310, 310, 338,
	310, 310, 310, 310, 310, 310, 310, 310
    ],
    [  # Symbol
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	140, 186, 398, 279, 307, 465, 434, 245,
	186, 186, 279, 307, 140, 307, 140, 155,
	279, 279, 279, 279, 279, 279, 279, 279,
	279, 279, 155, 155, 307, 307, 307, 248,
	307, 403, 372, 403, 342, 341, 426, 337,
	403, 186, 352, 403, 383, 496, 403, 403,
	429, 414, 310, 331, 341, 385, 245, 429,
	360, 444, 341, 186, 482, 186, 367, 279,
	279, 352, 307, 307, 276, 245, 291, 229,
	337, 184, 337, 307, 307, 322, 291, 307,
	307, 291, 307, 337, 245, 322, 398, 383,
	275, 383, 276, 268, 112, 268, 307,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0, 346, 138, 307,  93, 398, 279, 420,
	420, 420, 420, 582, 551, 337, 551, 337,
	223, 307, 229, 307, 307, 398, 276, 257,
	307, 307, 307, 307, 558, 337, 558, 367,
	460, 383, 444, 551, 429, 429, 460, 429,
	429, 398, 398, 398, 398, 398, 398, 398,
	429, 398, 441, 441, 497, 460, 307, 140,
	398, 337, 337, 582, 551, 337, 551, 337,
	276, 184, 441, 441, 439, 398, 214, 214,
	214, 214, 214, 214, 276, 276, 276, 276,
	  0, 184, 153, 383, 383, 383, 214, 214,
	214, 214, 214, 214, 276, 276, 276,   0
    ],
    [  # Zapf Chancery Medium Italic
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	123, 156, 123, 246, 246, 380, 436,  89,
	145, 123, 235, 290, 123, 156, 123, 190,
	246, 246, 246, 246, 246, 246, 246, 246,
	246, 246, 145, 134, 290, 290, 290, 212,
	391, 346, 335, 290, 391, 346, 324, 346,
	380, 212, 223, 369, 324, 469, 391, 335,
	302, 335, 335, 257, 279, 413, 357, 491,
	313, 313, 346, 134, 268, 179, 290, 279,
	123, 235, 235, 190, 246, 190, 179, 223,
	246, 134, 123, 246, 134, 346, 257, 223,
	246, 223, 168, 179, 179, 257, 246, 380,
	235, 223, 246, 134, 290, 134, 290,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	123, 156, 246, 246, 246, 246, 290, 235,
	201, 413, 145, 190, 290, 156, 413, 246,
	223, 290, 147, 147, 168, 257, 279, 123,
	168, 147, 145, 212, 369, 369, 369, 223,
	346, 346, 346, 346, 346, 346, 413, 290,
	346, 346, 346, 346, 212, 212, 212, 212,
	391, 391, 335, 335, 335, 335, 335, 290,
	369, 413, 413, 413, 413, 313, 302, 235,
	235, 235, 235, 235, 235, 235, 302, 190,
	190, 190, 190, 190, 134, 134, 134, 134,
	223, 257, 223, 223, 223, 223, 223, 290,
	246, 257, 257, 257, 257, 223, 246, 223
    ],
    [  # Zapf Dinbats
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	155, 544, 537, 544, 547, 401, 441, 441,
	442, 385, 536, 524, 307, 477, 509, 521,
	509, 528, 544, 422, 472, 425, 425, 319,
	378, 426, 424, 424, 421, 276, 308, 300,
	322, 386, 439, 440, 440, 441, 443, 443,
	456, 460, 441, 470, 460, 465, 456, 464,
	515, 415, 404, 418, 441, 442, 388, 433,
	429, 442, 424, 395, 395, 381, 391, 461,
	455, 441, 441, 395, 384, 389, 385, 439,
	439, 398, 442, 438, 442, 487, 425, 425,
	425, 424, 424, 498, 498, 440, 438, 245,
	 77, 155, 232, 219, 219, 373, 373,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0,   0,   0,   0,   0,   0,   0,   0,
	  0, 409, 304, 304, 508, 372, 424, 424,
	433, 332, 387, 350, 440, 440, 440, 440,
	440, 440, 440, 440, 440, 440, 440, 440,
	440, 440, 440, 440, 440, 440, 440, 440,
	440, 440, 440, 440, 440, 440, 440, 440,
	440, 440, 440, 440, 440, 440, 440, 440,
	440, 440, 440, 440, 499, 468, 567, 256,
	418, 516, 418, 513, 518, 518, 518, 466,
	487, 462, 516, 516, 512, 519, 520, 259,
	493, 467, 467, 484, 484, 389, 389, 488,
	  0, 488, 424, 528, 430, 483, 430, 496,
	540, 496, 464, 487, 518, 542, 513,   0
    ],
);

#
# @FontScale: font scaling parameters for each PostScript font
#
#  The parameters scale linearly but with different slopes.  Also,
#  they have minimum or maximimum values.  Calculate from the point
#  size as follows:
#
#      minLeftBearing(pointSize) = MIN(leftBearingMax,
#          pointSize * leftBearingSlope + leftBearingIntercept);
#
#      maxRightBearing(pointSize) = MIN(rightBearingMax,
#          pointSize * rightBearingSlope + rightBearingIntercept);
#
#      maxWidth(pointSize) = MAX(widthMin,
#          pointSize * widthSlope + widthIntercept)
#
#      maxAscent(pointSize) = MAX(ascentMin,
#          pointSize * ascentSlope + ascentIntercept)
#
#      maxDescent(pointSize) = MAX(descentMin,
#          pointSize * descentSlope + descentIntercept)
#   
# To calculate per-character widths at a given point size, we use:
#
#      width = characterWidthAt500 * maxWidth(pointSize) /
#          (500 * widthSlope + widthIntercept)
#
my @FontScale = (
    # Times Roman                       
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.078,
	leftBearingIntercept    =>  -0.065,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.042,
	rightBearingIntercept   =>  -0.502,
	widthMin                =>   6.000,
	widthSlope              =>   1.056,
	widthIntercept          =>  -0.669,
	ascentMin               =>   6.000,
	ascentSlope             =>   1.022,
	ascentIntercept         =>  -0.266,
	descentMin              =>   2.000,
	descentSlope            =>   0.244,
	descentIntercept        =>   0.071
    },
    # Times Italic                      
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.188,
	leftBearingIntercept    =>   0.259,
	rightBearingMin         =>   5.000,
	rightBearingSlope       =>   1.018,
	rightBearingIntercept   =>  -0.211,
	widthMin                =>   6.000,
	widthSlope              =>   1.028,
	widthIntercept          =>  -0.336,
	ascentMin               =>   6.000,
	ascentSlope             =>   1.009,
	ascentIntercept         =>  -0.113,
	descentMin              =>   2.000,
	descentSlope            =>   0.243,
	descentIntercept        =>   0.089
    },
    # Times Bold                        
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.071,
	leftBearingIntercept    =>  -0.148,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.095,
	rightBearingIntercept   =>  -0.145,
	widthMin                =>   6.000,
	widthSlope              =>   1.117,
	widthIntercept          =>  -0.408,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.060,
	ascentIntercept         =>  -0.724,
	descentMin              =>   1.000,
	descentSlope            =>   0.243,
	descentIntercept        =>   0.083
    },
    # Times Bold Italic                 
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.222,
	leftBearingIntercept    =>  -0.332,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.051,
	rightBearingIntercept   =>  -0.612,
	widthMin                =>   6.000,
	widthSlope              =>   1.056,
	widthIntercept          =>  -0.669,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.063,
	ascentIntercept         =>  -0.752,
	descentMin              =>   1.000,
	descentSlope            =>   0.244,
	descentIntercept        =>   0.078
    },
    # Avantgarde Book                   
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.086,
	leftBearingIntercept    =>   0.033,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.248,
	rightBearingIntercept   =>   0.025,
	widthMin                =>   7.000,
	widthSlope              =>   1.293,
	widthIntercept          =>  -0.516,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.090,
	ascentIntercept         =>  -0.076,
	descentMin              =>   1.000,
	descentSlope            =>   0.269,
	descentIntercept        =>  -0.223
    },
    # Avantgarde Book Oblique           
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.091,
	leftBearingIntercept    =>   0.088,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.310,
	rightBearingIntercept   =>  -0.724,
	widthMin                =>   7.000,
	widthSlope              =>   1.293,
	widthIntercept          =>  -0.516,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.085,
	ascentIntercept         =>  -0.021,
	descentMin              =>   1.000,
	descentSlope            =>   0.254,
	descentIntercept        =>  -0.051
    },
    # Avantgarde Demi                   
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.085,
	leftBearingIntercept    =>   0.019,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.173,
	rightBearingIntercept   =>  -0.080,
	widthMin                =>   6.000,
	widthSlope              =>   1.207,
	widthIntercept          =>  -0.487,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.115,
	ascentIntercept         =>   0.621,
	descentMin              =>   2.000,
	descentSlope            =>   0.281,
	descentIntercept        =>  -0.376
    },
    # Avantgarde Demi Oblique           
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.030,
	leftBearingIntercept    =>   0.361,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.239,
	rightBearingIntercept   =>  -0.873,
	widthMin                =>   6.000,
	widthSlope              =>   1.207,
	widthIntercept          =>  -0.487,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.123,
	ascentIntercept         =>   0.524,
	descentMin              =>   2.000,
	descentSlope            =>   0.282,
	descentIntercept        =>  -0.383
    },
    # Bookman Light                     
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.123,
	leftBearingIntercept    =>   0.476,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.398,
	rightBearingIntercept   =>  -0.771,
	widthMin                =>   8.000,
	widthSlope              =>   1.409,
	widthIntercept          =>  -0.911,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.030,
	ascentIntercept         =>  -0.361,
	descentMin              =>   1.000,
	descentSlope            =>   0.270,
	descentIntercept        =>  -0.244
    },
    # Bookman Light Italic              
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.222,
	leftBearingIntercept    =>  -0.332,
	rightBearingMin         =>   8.000,
	rightBearingSlope       =>   1.417,
	rightBearingIntercept   =>   0.002,
	widthMin                =>   7.000,
	widthSlope              =>   1.363,
	widthIntercept          =>  -0.355,
	ascentMin               =>   6.000,
	ascentSlope             =>   0.979,
	ascentIntercept         =>   0.248,
	descentMin              =>   1.000,
	descentSlope            =>   0.247,
	descentIntercept        =>   0.037
    },
    # Bookman Demi                      
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.106,
	leftBearingIntercept    =>   0.268,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.284,
	rightBearingIntercept   =>  -0.405,
	widthMin                =>   7.000,
	widthSlope              =>   1.273,
	widthIntercept          =>  -0.280,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.029,
	ascentIntercept         =>   0.646,
	descentMin              =>   2.000,
	descentSlope            =>   0.278,
	descentIntercept        =>  -0.334
    },
    # Bookman Demi Italic               
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.258,
	leftBearingIntercept    =>   0.098,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.348,
	rightBearingIntercept   =>  -0.174,
	widthMin                =>   7.000,
	widthSlope              =>   1.273,
	widthIntercept          =>  -0.280,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.033,
	ascentIntercept         =>   0.605,
	descentMin              =>   2.000,
	descentSlope            =>   0.243,
	descentIntercept        =>   0.083
    },
    # Courier                           
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.014,
	leftBearingIntercept    =>   0.167,
	rightBearingMin         =>   4.000,
	rightBearingSlope       =>   0.684,
	rightBearingIntercept   =>  -0.205,
	widthMin                =>   4.000,
	widthSlope              =>   0.667,
	widthIntercept          =>  -0.007,
	ascentMin               =>   6.000,
	ascentSlope             =>   0.905,
	ascentIntercept         =>   0.141,
	descentMin              =>   1.000,
	descentSlope            =>   0.241,
	descentIntercept        =>   0.110
    },
    # Courier Oblique                   
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.068,
	leftBearingIntercept    =>  -0.190,
	rightBearingMin         =>   4.000,
	rightBearingSlope       =>   0.791,
	rightBearingIntercept   =>  -0.487,
	widthMin                =>   4.000,
	widthSlope              =>   0.667,
	widthIntercept          =>  -0.007,
	ascentMin               =>   6.000,
	ascentSlope             =>   0.905,
	ascentIntercept         =>   0.141,
	descentMin              =>   1.000,
	descentSlope            =>   0.241,
	descentIntercept        =>   0.111
    },
    # Courier Bold                      
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.047,
	leftBearingIntercept    =>  -0.440,
	rightBearingMin         =>   4.000,
	rightBearingSlope       =>   0.705,
	rightBearingIntercept   =>  -0.455,
	widthMin                =>   4.000,
	widthSlope              =>   0.667,
	widthIntercept          =>  -0.007,
	ascentMin               =>   6.000,
	ascentSlope             =>   0.971,
	ascentIntercept         =>   0.345,
	descentMin              =>   2.000,
	descentSlope            =>   0.256,
	descentIntercept        =>  -0.070
    },
    # Courier Bold Oblique              
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.068,
	leftBearingIntercept    =>  -0.190,
	rightBearingMin         =>   4.000,
	rightBearingSlope       =>   0.820,
	rightBearingIntercept   =>   0.160,
	widthMin                =>   4.000,
	widthSlope              =>   0.670,
	widthIntercept          =>  -0.040,
	ascentMin               =>   6.000,
	ascentSlope             =>   0.971,
	ascentIntercept         =>   0.345,
	descentMin              =>   2.000,
	descentSlope            =>   0.256,
	descentIntercept        =>  -0.070
    },
    # Helvetica                         
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.025,
	leftBearingIntercept    =>   0.306,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.064,
	rightBearingIntercept   =>  -0.766,
	widthMin                =>   6.000,
	widthSlope              =>   1.135,
	widthIntercept          =>  -0.618,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.063,
	ascentIntercept         =>   0.244,
	descentMin              =>   2.000,
	descentSlope            =>   0.245,
	descentIntercept        =>   0.054
    },
    # Helvetica Oblique                 
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.072,
	leftBearingIntercept    =>  -0.134,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.215,
	rightBearingIntercept   =>  -0.581,
	widthMin                =>   6.000,
	widthSlope              =>   1.135,
	widthIntercept          =>  -0.618,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.063,
	ascentIntercept         =>   0.244,
	descentMin              =>   2.000,
	descentSlope            =>   0.246,
	descentIntercept        =>   0.054
    },
    # Helvetica Bold                    
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.025,
	leftBearingIntercept    =>   0.306,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.078,
	rightBearingIntercept   =>   0.063,
	widthMin                =>   6.000,
	widthSlope              =>   1.117,
	widthIntercept          =>  -0.408,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.058,
	ascentIntercept         =>   0.299,
	descentMin              =>   2.000,
	descentSlope            =>   0.246,
	descentIntercept        =>   0.049
    },
    # Helvetica Bold Oblique            
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.072,
	leftBearingIntercept    =>  -0.134,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.235,
	rightBearingIntercept   =>  -0.816,
	widthMin                =>   6.000,
	widthSlope              =>   1.178,
	widthIntercept          =>  -0.137,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.063,
	ascentIntercept         =>   0.243,
	descentMin              =>   2.000,
	descentSlope            =>   0.246,
	descentIntercept        =>   0.048
    },
    # Helvetica Narrow                  
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.016,
	leftBearingIntercept    =>   0.195,
	rightBearingMin         =>   5.000,
	rightBearingSlope       =>   0.872,
	rightBearingIntercept   =>  -0.465,
	widthMin                =>   5.000,
	widthSlope              =>   0.929,
	widthIntercept          =>  -0.150,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.053,
	ascentIntercept         =>   0.368,
	descentMin              =>   1.000,
	descentSlope            =>   0.251,
	descentIntercept        =>  -0.014
    },
    # Helvetica Narrow Oblique          
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.054,
	leftBearingIntercept    =>  -0.356,
	rightBearingMin         =>   5.000,
	rightBearingSlope       =>   1.004,
	rightBearingIntercept   =>  -0.044,
	widthMin                =>   5.000,
	widthSlope              =>   0.929,
	widthIntercept          =>  -0.150,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.053,
	ascentIntercept         =>   0.368,
	descentMin              =>   1.000,
	descentSlope            =>   0.251,
	descentIntercept        =>  -0.014
    },
    # Helvetica Narrow Bold             
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.044,
	leftBearingIntercept    =>  -0.467,
	rightBearingMin         =>   5.000,
	rightBearingSlope       =>   0.874,
	rightBearingIntercept   =>  -0.493,
	widthMin                =>   5.000,
	widthSlope              =>   0.915,
	widthIntercept          =>   0.017,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.089,
	ascentIntercept         =>  -0.063,
	descentMin              =>   2.000,
	descentSlope            =>   0.255,
	descentIntercept        =>  -0.056
    },
    # Helvetica Narrow Bold Oblique     
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.040,
	leftBearingIntercept    =>   0.486,
	rightBearingMin         =>   5.000,
	rightBearingSlope       =>   1.007,
	rightBearingIntercept   =>  -0.085,
	widthMin                =>   5.000,
	widthSlope              =>   0.915,
	widthIntercept          =>   0.017,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.105,
	ascentIntercept         =>  -0.257,
	descentMin              =>   2.000,
	descentSlope            =>   0.255,
	descentIntercept        =>  -0.056
    },
    # New Century Schoolbook Roman      
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.092,
	leftBearingIntercept    =>   0.102,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.090,
	rightBearingIntercept   =>  -0.076,
	widthMin                =>   6.000,
	widthSlope              =>   1.117,
	widthIntercept          =>  -0.408,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.093,
	ascentIntercept         =>  -0.117,
	descentMin              =>   1.000,
	descentSlope            =>   0.244,
	descentIntercept        =>   0.069
    },
    # New Century Schoolbook Italic     
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.186,
	leftBearingIntercept    =>   0.233,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.086,
	rightBearingIntercept   =>  -0.035,
	widthMin                =>   6.000,
	widthSlope              =>   1.056,
	widthIntercept          =>  -0.669,
	ascentMin               =>   6.000,
	ascentSlope             =>   1.078,
	ascentIntercept         =>   0.063,
	descentMin              =>   2.000,
	descentSlope            =>   0.244,
	descentIntercept        =>   0.069
    },
    # New Century Schoolbook Bold       
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.092,
	leftBearingIntercept    =>   0.102,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.086,
	rightBearingIntercept   =>  -0.035,
	widthMin                =>   6.000,
	widthSlope              =>   1.095,
	widthIntercept          =>  -0.146,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.106,
	ascentIntercept         =>  -0.271,
	descentMin              =>   2.000,
	descentSlope            =>   0.250,
	descentIntercept        =>  -0.000
    },
    # New Century Schoolbook Bold Italic
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.191,
	leftBearingIntercept    =>   0.287,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.111,
	rightBearingIntercept   =>  -0.326,
	widthMin                =>   6.000,
	widthSlope              =>   1.056,
	widthIntercept          =>  -0.669,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.112,
	ascentIntercept         =>   0.656,
	descentMin              =>   1.000,
	descentSlope            =>   0.248,
	descentIntercept        =>   0.027
    },
    # Palatino Roman                    
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.043,
	leftBearingIntercept    =>  -0.481,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.099,
	rightBearingIntercept   =>  -0.188,
	widthMin                =>   6.000,
	widthSlope              =>   1.117,
	widthIntercept          =>  -0.408,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.055,
	ascentIntercept         =>  -0.655,
	descentMin              =>   2.000,
	descentSlope            =>   0.316,
	descentIntercept        =>   0.210
    },
    # Palatino Italic                   
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.181,
	leftBearingIntercept    =>   0.176,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.094,
	rightBearingIntercept   =>  -0.132,
	widthMin                =>   6.000,
	widthSlope              =>   1.056,
	widthIntercept          =>  -0.669,
	ascentMin               =>   6.000,
	ascentSlope             =>   1.048,
	ascentIntercept         =>  -0.572,
	descentMin              =>   2.000,
	descentSlope            =>   0.308,
	descentIntercept        =>   0.302
    },
    # Palatino Bold                     
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.013,
	leftBearingIntercept    =>   0.153,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.104,
	rightBearingIntercept   =>  -0.243,
	widthMin                =>   6.000,
	widthSlope              =>   1.117,
	widthIntercept          =>  -0.408,
	ascentMin               =>   7.000,
	ascentSlope             =>   1.044,
	ascentIntercept         =>  -0.529,
	descentMin              =>   2.000,
	descentSlope            =>   0.299,
	descentIntercept        =>  -0.590
    },
    # Palatino Bold Italic              
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.145,
	leftBearingIntercept    =>  -0.255,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.199,
	rightBearingIntercept   =>  -0.386,
	widthMin                =>   6.000,
	widthSlope              =>   1.117,
	widthIntercept          =>  -0.408,
	ascentMin               =>   6.000,
	ascentSlope             =>   1.045,
	ascentIntercept         =>  -0.544,
	descentMin              =>   2.000,
	descentSlope            =>   0.302,
	descentIntercept        =>   0.370
    },
    # Symbol                            
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.202,
	leftBearingIntercept    =>   0.427,
	rightBearingMin         =>   7.000,
	rightBearingSlope       =>   1.219,
	rightBearingIntercept   =>  -0.622,
	widthMin                =>   6.000,
	widthSlope              =>   1.163,
	widthIntercept          =>   0.044,
	ascentMin               =>   6.000,
	ascentSlope             =>   1.129,
	ascentIntercept         =>  -0.549,
	descentMin              =>   2.000,
	descentSlope            =>   0.327,
	descentIntercept        =>   0.078
    },
    # Zapf Chancery Medium Italic       
    {
	leftBearingMax          =>  -1.000,
	leftBearingSlope        =>  -0.148,
	leftBearingIntercept    =>  -0.226,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.155,
	rightBearingIntercept   =>   0.141,
	widthMin                =>   5.000,
	widthSlope              =>   0.982,
	widthIntercept          =>   0.220,
	ascentMin               =>   5.000,
	ascentSlope             =>   0.918,
	ascentIntercept         =>  -0.011,
	descentMin              =>   1.000,
	descentSlope            =>   0.299,
	descentIntercept        =>  -0.584
    },
    # Zapf Dingbats                     
    {
	leftBearingMax          =>   0.000,
	leftBearingSlope        =>  -0.002,
	leftBearingIntercept    =>   0.025,
	rightBearingMin         =>   6.000,
	rightBearingSlope       =>   1.095,
	rightBearingIntercept   =>  -0.145,
	widthMin                =>   6.000,
	widthSlope              =>   1.136,
	widthIntercept          =>  -0.632,
	ascentMin               =>   5.000,
	ascentSlope             =>   0.914,
	ascentIntercept         =>   0.031,
	descentMin              =>   1.000,
	descentSlope            =>   0.159,
	descentIntercept        =>   0.088
    }
);

#
# Graphics::Fig::FontSize::_getFontBounds
#   $fontIndex: integer 0..34
#   $fontSize:  number >= 0
#
sub _getFontBounds {
    my $fontIndex = shift;
    my $fontSize  = shift;

    die "bad font index: $fontIndex" if $fontIndex < 0 || $fontIndex > 34;
    die "bad font size: $fontSize" if $fontSize < 0;
    my $data = $FontScale[$fontIndex];

    #
    # Calculate leftmost reach of a character in this font (typically
    # negative) relative to the (left) reference point.
    #
    my $minLeftBearing = $fontSize * $data->{leftBearingSlope} +
	$data->{leftBearingIntercept};
    if ($minLeftBearing > $data->{leftBearingMax}) {
	$minLeftBearing = $data->{leftBearingMax};
    }

    #
    # Calculate rightmost reach of a character in this font relative to
    # the (left) reference point.
    #
    my $maxRightBearing = $fontSize * $data->{rightBearingSlope} +
	$data->{rightBearingIntercept};
    if ($maxRightBearing < $data->{rightBearingMin}) {
	$maxRightBearing = $data->{rightBearingMin};
    }

    #
    # Calculate the maximum width of a character in this font.
    #
    my $maxWidth = $fontSize * $data->{widthSlope} + $data->{widthIntercept};
    if ($maxWidth < $data->{widthMin}) {
	$maxWidth = $data->{widthMin};
    }

    #
    # Calculate uppermost reach of a character in this font relative to
    # the (left) reference point.
    #
    my $maxAscent = $fontSize * $data->{ascentSlope} + $data->{ascentIntercept};
    if ($maxAscent < $data->{ascentMin}) {
	$maxAscent = $data->{ascentMin};
    }

    #
    # Calculate the downward most reach of a character in this font
    # (positive down) relative to the (left) reference point.
    #
    my $maxDescent = $fontSize * $data->{descentSlope} +
	$data->{descentIntercept};
    if ($maxDescent > $data->{descentMin}) {
	$maxDescent = $data->{descentMin};
    }

    #
    # Calculate the maximum width of a character at point size 500.
    #
    my $maxWidth500 = 500 * $data->{widthSlope} + $data->{widthIntercept};

    return {
	minLeftBearing	=> $minLeftBearing,
	maxRightBearing	=> $maxRightBearing,
	maxWidth	=> $maxWidth,
	maxAscent	=> $maxAscent,
	maxDescent	=> $maxDescent,
	maxWidth500	=> $maxWidth500
    };
}

#
# Graphics::Fig::FontSize::getTextSize
#   $fontRef:  [ fontFlag, fontNumber ]
#   $fontSize: real
#   $text: a text string
#
sub getTextSize {
    my $fontRef  = shift;
    my $fontSize = shift;
    my $text     = shift;

    #
    # Find the PostScript font index.
    #
    my $fontIndex;
    if ($fontRef->[0] & 4) {
	#
	# Postscript font.  Map -1 (default) to Roman; otherwise,
	# take the index as-is.
	#
	if ($fontRef->[1] >= 0) {
	    $fontIndex = $fontRef->[1];
	} else {
	    $fontIndex = 0;
	}
    } else {
	#
	# Map LaTeX fonts to nearest PostScript font.
	#
	die "bad index" if $fontRef->[1] > 5;
	$fontIndex = (
	    0,	# default
	    0,	# roman
	    2,	# bold
	    1,	# italic
	    16, # sans serif
	    12	# typewriter
	)[$fontRef->[1]];
    }
    die if !defined($fontIndex);
    die if $fontIndex < 0 || $fontIndex > 34;

    #
    # Get the font size as integer.
    #
    $fontSize = ceil($fontSize - 0.0001);

    #
    # Get the maximum bounds for this pointsize.
    #
    my $fontBounds = &_getFontBounds($fontIndex, $fontSize);
    my $scale = $fontBounds->{maxWidth} / $fontBounds->{maxWidth500};

    #
    # Find the text width.
    #
    my $width = 0.0;
    for (my $i = 0; $i < length($text); ++$i) {
	my $n = ord(substr($text, $i, 1));

	die if $n > 255;
	$width += ceil($scale * $CharacterWidths500[$fontIndex][$n]);
    }

    #
    # Return the dimensions relative to the left-hand side reference
    # point in inches.  Signs are positive to the right and down.
    #
    #
    # Vertical dimensions are based on the maximum ascent and descent
    # values of the current font.  It would be more consistent with xfig
    # if we included the per-character ascent and descent values along
    # with the widths and made these bounds fit the actual text.  The left
    # bound should really come from floor($fontBounds->{minLeftBearing}),
    # since a few characters extend slightly left of the reference point.
    # But xfig doesn't include this, so we're more consistent by leaving
    # it out.
    #
    return {
	left	=>  0,
	right	=>  ceil($width)			/ 80.0,
	up	=> -ceil($fontBounds->{maxAscent})	/ 80.0,
	down	=>  ceil($fontBounds->{maxDescent})	/ 80.0
    };
}

1;
