# Copyrights 2011-2015 by [Mark Overmeer].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.01.
use warnings;
use strict;

package POSIX::1003::User;
use vars '$VERSION';
$VERSION = '0.99_03';

use base 'POSIX::1003::Module';

our @IN_CORE  = qw/
  getpwnam  getpwuid  getpwent
  getgrnam  getgrgid  getgrent
  getlogin
  /;

my @functions = qw/
  getuid    setuid
  geteuid   seteuid
            setreuid
  getresuid setresuid

  getgid    setgid
  getegid   setegid
            setregid
  getresgid setresgid
  getgroups setgroups
  /;

push @functions, @IN_CORE;

my @constants;

our %EXPORT_TAGS =
  ( constants => \@constants
  , functions => \@functions
  , tables    => [ '%user' ]
  );

my  $user;
our %user;

BEGIN {
    $user = user_table;
    push @constants, keys %$user;
    tie %user, 'POSIX::1003::ReadOnlyTable', $user;
}


#------------------

#------------------

#------------------


1;
