#include "bearoffgammon.h"

struct GroupInfo {
  struct GammonProbs    gDefault;
  unsigned char* info;
  unsigned int   base;
  unsigned int   size;
};

static struct GammonProbs all[] = {
{0,0,0,36},
{36,0,0,35},
{35,36,0,35},
{35,35,36,35},
{72,0,0,34},
{108,0,0,33},
{107,36,0,33},
{107,35,36,33},
{106,72,0,33},
{104,144,0,33},
{103,180,0,33},
{103,179,36,33},
{103,176,144,33},
{103,174,216,33},
{103,173,252,33},
{100,288,0,33},
{100,284,144,33},
{99,312,432,33},
{99,306,648,33},
{99,305,684,33},
{144,0,0,32},
{140,144,0,32},
{138,216,0,32},
{137,248,144,32},
{136,284,144,32},
{132,424,288,32},
{130,492,432,32},
{130,484,720,32},
{128,544,1152,32},
{128,536,1440,32},
{128,533,1548,32},
{128,532,1584,32},
{128,520,2016,32},
{128,516,2160,32},
{128,512,2304,32},
{180,0,0,31},
{176,144,0,31},
{175,180,0,31},
{175,174,216,31},
{175,173,252,31},
{172,288,0,31},
{171,324,0,31},
{171,312,432,31},
{171,311,468,31},
{216,0,0,30},
{212,144,0,30},
{208,288,0,30},
{200,568,288,30},
{196,704,576,30},
{196,688,1152,30},
{196,682,1368,30},
{196,658,2232,30},
{196,650,2520,30},
{192,812,1872,30},
{192,782,2952,30},
{192,774,3240,30},
{242,360,0,29},
{241,396,0,29},
{241,392,144,29},
{241,391,180,29},
{238,504,0,29},
{238,502,72,29},
{232,720,0,29},
{232,704,576,29},
{231,730,936,29},
{231,729,972,29},
{231,722,1224,29},
{231,714,1512,29},
{231,713,1548,29},
{230,784,288,29},
{226,916,720,29},
{226,912,864,29},
{220,1124,1008,29},
{221,1044,2592,29},
{221,1041,2700,29},
{220,1108,1584,29},
{221,1000,4176,29},
{221,989,4572,29},
{219,1104,3024,29},
{219,1102,3096,29},
{219,1086,3672,29},
{219,1085,3708,29},
{288,0,0,28},
{284,144,0,28},
{283,173,252,28},
{281,243,324,28},
{280,288,0,28},
{279,305,684,28},
{276,432,0,28},
{276,416,576,28},
{268,720,0,28},
{264,848,576,28},
{260,956,1872,28},
{260,950,2088,28},
{260,920,3168,28},
{260,912,3456,28},
{244,1528,2016,28},
{313,391,180,27},
{310,502,72,27},
{240,1552,6336,28},
{240,1480,8928,28},
{240,1472,9216,28},
{304,720,0,27},
{304,704,576,27},
{303,729,972,27},
{303,722,1224,27},
{303,714,1512,27},
{303,713,1548,27},
{360,0,0,26},
{287,1229,3708,27},
{356,144,0,26},
{348,432,0,26},
{400,1152,0,24},
{392,1440,0,24},
{390,1504,288,24},
{368,2248,2016,24},
{368,2212,3312,24},
{364,2236,7632,24},
{364,2224,8064,24},
{360,2480,4032,24},
{360,2472,4320,24},
{364,2152,10656,24},
{364,2144,10944,24},
{356,2444,10512,24},
{356,2442,10584,24},
{356,2360,13536,24},
{356,2352,13824,24},
};

static unsigned char x9[] = {
0,
4,
4,
5,
5,
9,
9,
10,
10,
13,
13,
14,
14,
14,
};


static unsigned char x10[] = {
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
3,
3,
};


static unsigned char x11[] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
3,
};


static unsigned char x17[] = {
0,
35,
35,
56,
58,
70,
71,
73,
74,
76,
76,
77,
77,
77,
};


static unsigned char x18[] = {
4,
20,
20,
45,
46,
47,
47,
49,
50,
51,
51,
52,
52,
52,
};


static unsigned char x19[] = {
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
4,
4,
21,
21,
25,
25,
0,
4,
4,
21,
21,
25,
25,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
32,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
32,
34,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
32,
34,
34,
};


static unsigned char x20[] = {
1,
5,
8,
22,
24,
26,
27,
29,
31,
33,
33,
34,
34,
34,
};


static unsigned char x21[] = {
0,
1,
5,
1,
5,
8,
1,
5,
8,
22,
1,
5,
8,
22,
23,
1,
5,
8,
22,
24,
26,
1,
5,
8,
22,
24,
26,
27,
1,
5,
8,
22,
24,
26,
27,
29,
1,
5,
8,
22,
24,
26,
27,
29,
30,
1,
5,
8,
22,
24,
26,
27,
29,
31,
33,
1,
5,
8,
22,
24,
26,
27,
29,
31,
33,
33,
1,
5,
8,
22,
24,
26,
27,
29,
31,
33,
33,
34,
1,
5,
8,
22,
24,
26,
27,
29,
31,
33,
33,
34,
34,
};


static unsigned char x22[] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
3,
};


static unsigned char x23[] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
};


static unsigned char x25[] = {
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
};


static unsigned char x26[] = {
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
};


static unsigned char x27[] = {
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
};


static unsigned char x33[] = {
4,
108,
110,
113,
114,
119,
120,
123,
124,
125,
125,
126,
126,
126,
};


static unsigned char x34[] = {
20,
108,
111,
112,
113,
115,
116,
117,
118,
121,
121,
122,
122,
122,
};


static unsigned char x35[] = {
0,
0,
44,
0,
44,
44,
0,
44,
44,
90,
0,
44,
44,
90,
90,
0,
44,
44,
90,
90,
96,
0,
44,
44,
90,
90,
96,
96,
0,
44,
44,
90,
90,
96,
96,
99,
0,
44,
44,
90,
90,
96,
96,
99,
99,
0,
44,
44,
90,
90,
96,
96,
99,
99,
100,
0,
44,
44,
90,
90,
96,
96,
99,
99,
100,
100,
0,
44,
44,
90,
90,
96,
96,
99,
99,
100,
100,
101,
0,
44,
44,
90,
90,
96,
96,
99,
99,
100,
100,
101,
101,
};


static unsigned char x36[] = {
4,
44,
44,
86,
88,
91,
91,
92,
93,
94,
94,
95,
95,
95,
};


static unsigned char x37[] = {
0,
0,
20,
0,
20,
20,
0,
20,
20,
46,
0,
20,
20,
46,
46,
0,
20,
20,
46,
46,
48,
0,
20,
20,
46,
46,
48,
48,
0,
20,
20,
46,
46,
48,
48,
53,
0,
20,
20,
46,
46,
48,
48,
53,
53,
0,
20,
20,
46,
46,
48,
48,
53,
53,
54,
0,
20,
20,
46,
46,
48,
48,
53,
53,
54,
54,
0,
20,
20,
46,
46,
48,
48,
53,
53,
54,
54,
55,
0,
20,
20,
46,
46,
48,
48,
53,
53,
54,
54,
55,
55,
};


static unsigned char x38[] = {
4,
4,
20,
4,
20,
20,
4,
20,
20,
45,
4,
20,
20,
45,
46,
4,
20,
20,
45,
46,
47,
4,
20,
20,
45,
46,
47,
47,
4,
20,
20,
45,
46,
47,
47,
49,
4,
20,
20,
45,
46,
47,
47,
49,
50,
4,
20,
20,
45,
46,
47,
47,
49,
50,
51,
4,
20,
20,
45,
46,
47,
47,
49,
50,
51,
51,
4,
20,
20,
45,
46,
47,
47,
49,
50,
51,
51,
52,
4,
20,
20,
45,
46,
47,
47,
49,
50,
51,
51,
52,
52,
};


static unsigned char x39[] = {
0,
0,
0,
4,
0,
0,
4,
0,
4,
4,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
4,
4,
21,
21,
25,
25,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
4,
4,
21,
21,
25,
25,
0,
4,
4,
21,
21,
25,
25,
28,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
4,
4,
21,
21,
25,
25,
0,
4,
4,
21,
21,
25,
25,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
4,
4,
21,
21,
25,
25,
0,
4,
4,
21,
21,
25,
25,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
4,
4,
21,
21,
25,
25,
0,
4,
4,
21,
21,
25,
25,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
32,
0,
0,
4,
0,
4,
4,
0,
4,
4,
21,
0,
4,
4,
21,
21,
0,
4,
4,
21,
21,
25,
0,
4,
4,
21,
21,
25,
25,
0,
4,
4,
21,
21,
25,
25,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
32,
0,
4,
4,
21,
21,
25,
25,
28,
28,
32,
32,
34,
};


static unsigned char x40[] = {
20,
82,
83,
97,
98,
102,
103,
104,
105,
106,
106,
107,
107,
109,
};


static unsigned char x41[] = {
4,
4,
44,
4,
44,
45,
4,
44,
45,
62,
4,
44,
45,
56,
69,
4,
44,
45,
56,
60,
72,
4,
44,
45,
57,
60,
62,
75,
4,
44,
45,
57,
60,
62,
63,
78,
4,
44,
45,
58,
61,
62,
63,
64,
79,
4,
44,
45,
58,
61,
62,
63,
64,
66,
80,
4,
44,
45,
59,
61,
62,
63,
65,
66,
67,
80,
4,
44,
45,
59,
61,
62,
63,
65,
66,
67,
67,
81,
4,
44,
45,
59,
61,
62,
63,
65,
66,
67,
67,
68,
81,
};


static unsigned char x42[] = {
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
4,
4,
6,
5,
9,
9,
0,
4,
4,
6,
5,
9,
9,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
13,
0,
4,
4,
7,
5,
9,
9,
11,
10,
13,
13,
0,
4,
4,
7,
5,
9,
9,
11,
10,
13,
13,
14,
0,
4,
4,
7,
5,
9,
9,
11,
10,
13,
13,
14,
14,
};


static unsigned char x43[] = {
0,
0,
0,
4,
0,
0,
4,
0,
4,
4,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
4,
4,
6,
5,
9,
9,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
4,
4,
6,
5,
9,
9,
0,
4,
4,
6,
5,
9,
9,
10,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
4,
4,
6,
5,
9,
9,
0,
4,
4,
6,
5,
9,
9,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
4,
4,
6,
5,
9,
9,
0,
4,
4,
6,
5,
9,
9,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
13,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
4,
4,
6,
5,
9,
9,
0,
4,
4,
6,
5,
9,
9,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
13,
0,
4,
4,
7,
5,
9,
9,
11,
10,
13,
13,
0,
0,
4,
0,
4,
4,
0,
4,
4,
5,
0,
4,
4,
5,
5,
0,
4,
4,
5,
5,
9,
0,
4,
4,
6,
5,
9,
9,
0,
4,
4,
6,
5,
9,
9,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
0,
4,
4,
6,
5,
9,
9,
10,
10,
13,
0,
4,
4,
7,
5,
9,
9,
11,
10,
13,
13,
0,
4,
4,
7,
5,
9,
9,
11,
10,
13,
13,
14,
};


static unsigned char x44[] = {
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
4,
4,
5,
8,
9,
16,
0,
4,
4,
5,
8,
9,
9,
17,
0,
4,
4,
5,
8,
9,
9,
10,
17,
0,
4,
4,
5,
8,
9,
9,
10,
12,
18,
0,
4,
4,
5,
8,
9,
9,
10,
12,
13,
18,
0,
4,
4,
5,
8,
9,
9,
10,
12,
13,
13,
19,
0,
4,
4,
5,
8,
9,
9,
10,
12,
13,
13,
14,
19,
};


static unsigned char x45[] = {
0,
0,
0,
4,
0,
0,
4,
0,
4,
4,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
4,
4,
5,
8,
9,
16,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
4,
4,
5,
8,
9,
16,
0,
4,
4,
5,
8,
9,
9,
17,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
4,
4,
5,
8,
9,
16,
0,
4,
4,
5,
8,
9,
9,
17,
0,
4,
4,
5,
8,
9,
9,
10,
17,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
4,
4,
5,
8,
9,
16,
0,
4,
4,
5,
8,
9,
9,
17,
0,
4,
4,
5,
8,
9,
9,
10,
17,
0,
4,
4,
5,
8,
9,
9,
10,
12,
18,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
4,
4,
5,
8,
9,
16,
0,
4,
4,
5,
8,
9,
9,
17,
0,
4,
4,
5,
8,
9,
9,
10,
17,
0,
4,
4,
5,
8,
9,
9,
10,
12,
18,
0,
4,
4,
5,
8,
9,
9,
10,
12,
13,
18,
0,
0,
4,
0,
4,
4,
0,
4,
4,
9,
0,
4,
4,
5,
9,
0,
4,
4,
5,
8,
15,
0,
4,
4,
5,
8,
9,
16,
0,
4,
4,
5,
8,
9,
9,
17,
0,
4,
4,
5,
8,
9,
9,
10,
17,
0,
4,
4,
5,
8,
9,
9,
10,
12,
18,
0,
4,
4,
5,
8,
9,
9,
10,
12,
13,
18,
0,
4,
4,
5,
8,
9,
9,
10,
12,
13,
13,
19,
};


static unsigned char x46[] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
};


static unsigned char x47[] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
1,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
};


static unsigned char x48[] = {
87,
84,
84,
84,
84,
84,
84,
84,
84,
84,
84,
84,
85,
89,
};


static unsigned char x49[] = {
4,
4,
4,
9,
5,
5,
9,
5,
5,
5,
15,
9,
9,
9,
9,
15,
9,
9,
9,
9,
9,
17,
10,
10,
10,
10,
10,
10,
17,
10,
10,
10,
10,
10,
10,
10,
18,
13,
13,
13,
13,
13,
13,
13,
13,
18,
13,
13,
13,
13,
13,
13,
13,
13,
13,
19,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
19,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
19,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
};


static unsigned char x50[] = {
20,
20,
20,
35,
35,
35,
35,
35,
35,
35,
36,
36,
36,
36,
40,
36,
36,
36,
36,
36,
40,
37,
37,
37,
37,
37,
37,
41,
37,
37,
37,
37,
37,
37,
37,
41,
38,
38,
38,
38,
38,
38,
38,
38,
42,
38,
38,
38,
38,
38,
38,
38,
38,
38,
42,
39,
39,
39,
39,
39,
39,
39,
39,
39,
39,
43,
39,
39,
39,
39,
39,
39,
39,
39,
39,
39,
39,
43,
39,
39,
39,
39,
39,
39,
39,
39,
39,
39,
39,
39,
43,
};


static unsigned char x51[] = {
4,
4,
4,
4,
4,
4,
4,
5,
5,
5,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
10,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
13,
13,
13,
13,
13,
13,
13,
13,
13,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
13,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
14,
};


static unsigned char x52[] = {
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
};


static unsigned char x53[] = {
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
};


static unsigned char x54[] = {
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
};


static unsigned char x55[] = {
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
};

struct GroupInfo info[63] = {
// 1 100000
{ {0,0,0,36}, 0, 0, 0}, 
// 2 010000
{ {0,0,0,36}, 0, 0, 0}, 
// 3 110000
{ {0,0,0,36}, 0, 0, 0}, 
// 4 001000
{ {0,0,0,36}, 0, 0, 0}, 
// 5 101000
{ {0,0,0,36}, 0, 0, 0}, 
// 6 011000
{ {0,0,0,36}, 0, 0, 0}, 
// 7 111000
{ {0,0,0,36}, 0, 0, 0}, 
// 8 000100
{ {175,173,252,31}, 0, 0, 0}, 
// 9 100100
{ {0, 0, 0, 0}, x9, 91, 14}, 
// 10 010100
{ {0, 0, 0, 0}, x10, 91, 14}, 
// 11 110100
{ {0, 0, 0, 0}, x11, 364, 91}, 
// 12 001100
{ {0,0,0,36}, 0, 0, 0}, 
// 13 101100
{ {0,0,0,36}, 0, 0, 0}, 
// 14 011100
{ {0,0,0,36}, 0, 0, 0}, 
// 15 111100
{ {0,0,0,36}, 0, 0, 0}, 
// 16 000010
{ {397,1127,4788,24}, 0, 0, 0}, 
// 17 100010
{ {0, 0, 0, 0}, x17, 91, 14}, 
// 18 010010
{ {0, 0, 0, 0}, x18, 91, 14}, 
// 19 110010
{ {0, 0, 0, 0}, x19, 364, 91}, 
// 20 001010
{ {0, 0, 0, 0}, x20, 91, 14}, 
// 21 101010
{ {0, 0, 0, 0}, x21, 364, 91}, 
// 22 011010
{ {0, 0, 0, 0}, x22, 364, 91}, 
// 23 111010
{ {0, 0, 0, 0}, x23, 1001, 364}, 
// 24 000110
{ {107,35,36,33}, 0, 0, 0}, 
// 25 100110
{ {0, 0, 0, 0}, x25, 364, 91}, 
// 26 010110
{ {0, 0, 0, 0}, x26, 364, 91}, 
// 27 110110
{ {0, 0, 0, 0}, x27, 1001, 364}, 
// 28 001110
{ {0,0,0,36}, 0, 0, 0}, 
// 29 101110
{ {0,0,0,36}, 0, 0, 0}, 
// 30 011110
{ {0,0,0,36}, 0, 0, 0}, 
// 31 111110
{ {0,0,0,36}, 0, 0, 0}, 
// 32 000001
{ {583,3203,15588,17}, 0, 0, 0}, 
// 33 100001
{ {0, 0, 0, 0}, x33, 91, 14}, 
// 34 010001
{ {0, 0, 0, 0}, x34, 91, 14}, 
// 35 110001
{ {0, 0, 0, 0}, x35, 364, 91}, 
// 36 001001
{ {0, 0, 0, 0}, x36, 91, 14}, 
// 37 101001
{ {0, 0, 0, 0}, x37, 364, 91}, 
// 38 011001
{ {0, 0, 0, 0}, x38, 364, 91}, 
// 39 111001
{ {0, 0, 0, 0}, x39, 1001, 364}, 
// 40 000101
{ {0, 0, 0, 0}, x40, 91, 14}, 
// 41 100101
{ {0, 0, 0, 0}, x41, 364, 91}, 
// 42 010101
{ {0, 0, 0, 0}, x42, 364, 91}, 
// 43 110101
{ {0, 0, 0, 0}, x43, 1001, 364}, 
// 44 001101
{ {0, 0, 0, 0}, x44, 364, 91}, 
// 45 101101
{ {0, 0, 0, 0}, x45, 1001, 364}, 
// 46 011101
{ {0, 0, 0, 0}, x46, 1001, 364}, 
// 47 111101
{ {0, 0, 0, 0}, x47, 2002, 1001}, 
// 48 000011
{ {0, 0, 0, 0}, x48, 91, 14}, 
// 49 100011
{ {0, 0, 0, 0}, x49, 364, 91}, 
// 50 010011
{ {0, 0, 0, 0}, x50, 364, 91}, 
// 51 110011
{ {0, 0, 0, 0}, x51, 1001, 364}, 
// 52 001011
{ {0, 0, 0, 0}, x52, 364, 91}, 
// 53 101011
{ {0, 0, 0, 0}, x53, 1001, 364}, 
// 54 011011
{ {0, 0, 0, 0}, x54, 1001, 364}, 
// 55 111011
{ {0, 0, 0, 0}, x55, 2002, 1001}, 
// 56 000111
{ {72,0,0,34}, 0, 0, 0}, 
// 57 100111
{ {0,0,0,36}, 0, 0, 0}, 
// 58 010111
{ {0,0,0,36}, 0, 0, 0}, 
// 59 110111
{ {0,0,0,36}, 0, 0, 0}, 
// 60 001111
{ {0,0,0,36}, 0, 0, 0}, 
// 61 101111
{ {0,0,0,36}, 0, 0, 0}, 
// 62 011111
{ {0,0,0,36}, 0, 0, 0}, 
// 63 111111
{ {0,0,0,36}, 0, 0, 0}, 
};
#include <assert.h>
#include "positionid.h"

extern struct GammonProbs*
getBearoffGammonProbs(int board[6])
{
  int group = 0;
  int i;
  struct GroupInfo* in;
  
  for(i = 5; i >= 0; --i) { 
    group += (0x1 << i) * !!board[i];
  }

  
  in = &info[group-1];
  if( ! in->info ) {
    return &in->gDefault;
  }

  {
    int grpSize = 0;
    int b1[6];
    unsigned int k;
    unsigned int index;
    
    for(k = 0; k < 6; ++k) {
      if( (group & (0x1 << k)) ) {
	{                                               assert( board[k] > 0 ); }
      
	b1[grpSize] = board[k] - 1;
	++grpSize;
      }
    }

    index = PositionIndex(grpSize, b1);

    {             assert( index >= in->base && index - in->base < in->size ); }
    {      assert( in->info[index - in->base] < sizeof(all)/sizeof(all[0]) ); }
  
    return &all[in->info[index - in->base]];
  }
}

/* race BG part */

static long y1[6][RBG_NPROBS] = { 
{36, 0, 0, 0, 0, },
{36, 0, 0, 0, 0, },
{6, 1080, 0, 0, 0, },
{6, 1080, 0, 0, 0, },
{0, 396, 32400, 0, 0, },
{0, 396, 32400, 0, 0, },
};

static long y2[6][RBG_NPROBS] = { 
{36, 0, 0, 0, 0, },
{26, 360, 0, 0, 0, },
{5, 1116, 0, 0, 0, },
{5, 596, 18720, 0, 0, },
{0, 335, 33596, 36000, 0, },
{0, 235, 17666, 739080, 0, },
};

static long y3[15][RBG_NPROBS] = { 
{36, 0, 0, 0, 0, },
{6, 1080, 0, 0, 0, },
{5, 1116, 0, 0, 0, },
{5, 1116, 0, 0, 0, },
{5, 1116, 0, 0, 0, },
{5, 1016, 3600, 0, 0, },
{0, 396, 32400, 0, 0, },
{0, 396, 32400, 0, 0, },
{0, 376, 33120, 0, 0, },
{0, 335, 34596, 0, 0, },
{0, 396, 32400, 0, 0, },
{0, 376, 33120, 0, 0, },
{0, 335, 34596, 0, 0, },
{0, 335, 33596, 36000, 0, },
{0, 335, 27296, 262800, 0, },
};

static long y4[6][RBG_NPROBS] = { 
{36, 0, 0, 0, 0, },
{17, 684, 0, 0, 0, },
{4, 999, 5508, 0, 0, },
{4, 297, 30082, 25128, 0, },
{0, 272, 24281, 450484, 90144, },
{0, 120, 11765, 983521, 4213260, },
};

static long y5[15][RBG_NPROBS] = { 
{34, 72, 0, 0, 0, },
{5, 1116, 0, 0, 0, },
{4, 1148, 144, 0, 0, },
{4, 1148, 144, 0, 0, },
{4, 1080, 2592, 0, 0, },
{4, 739, 14860, 288, 0, },
{0, 396, 32400, 0, 0, },
{0, 371, 33292, 288, 0, },
{0, 298, 35716, 7632, 0, },
{0, 272, 34033, 101900, 576, },
{0, 388, 32680, 288, 0, },
{0, 322, 34856, 7488, 0, },
{0, 272, 34794, 74504, 576, },
{0, 272, 27197, 346480, 55152, },
{0, 256, 15488, 772640, 634752, },
};

static long y6[15][RBG_NPROBS] = { 
{25, 396, 0, 0, 0, },
{5, 1112, 144, 0, 0, },
{4, 1112, 1440, 0, 0, },
{4, 631, 18756, 0, 0, },
{4, 615, 19324, 288, 0, },
{4, 523, 22528, 4176, 0, },
{0, 333, 33656, 36432, 0, },
{0, 322, 33854, 43560, 0, },
{0, 297, 33393, 92540, 576, },
{0, 272, 30181, 240284, 10944, },
{0, 233, 17737, 739100, 576, },
{0, 217, 18281, 739964, 10944, },
{0, 192, 18895, 747036, 127008, },
{0, 192, 17551, 782404, 595584, },
{0, 184, 14192, 886751, 1565604, },
};

static long y7[20][RBG_NPROBS] = { 
{5, 1116, 0, 0, 0, },
{4, 1148, 144, 0, 0, },
{4, 1048, 3744, 0, 0, },
{4, 999, 5508, 0, 0, },
{0, 392, 32544, 0, 0, },
{0, 375, 33156, 0, 0, },
{0, 355, 33868, 288, 0, },
{0, 335, 34588, 288, 0, },
{0, 331, 34624, 4176, 0, },
{0, 297, 35266, 25128, 0, },
{0, 371, 33292, 288, 0, },
{0, 331, 34732, 288, 0, },
{0, 298, 35716, 7632, 0, },
{0, 331, 33728, 36432, 0, },
{0, 297, 34754, 43560, 0, },
{0, 272, 34033, 101900, 576, },
{0, 330, 27470, 263016, 0, },
{0, 297, 28537, 267356, 576, },
{0, 272, 28421, 303644, 10944, },
{0, 272, 24281, 450484, 90144, },
};

static long y8[6][RBG_NPROBS] = { 
{34, 72, 0, 0, 0, },
{11, 880, 720, 0, 0, },
{3, 751, 15482, 9000, 0, },
{3, 163, 30547, 225808, 104400, },
{0, 195, 14249, 822591, 3288276, },
{0, 57, 8951, 767859, 18563364, },
};

static long y9[15][RBG_NPROBS] = { 
{29, 252, 0, 0, 0, },
{5, 1116, 0, 0, 0, },
{3, 1115, 2628, 0, 0, },
{3, 1146, 1512, 0, 0, },
{3, 899, 10284, 4320, 0, },
{3, 452, 25549, 34076, 576, },
{0, 392, 32544, 0, 0, },
{0, 333, 34408, 9360, 0, },
{0, 236, 35179, 106580, 26496, },
{0, 207, 27064, 426011, 397044, },
{0, 357, 33552, 9072, 0, },
{0, 249, 35142, 91080, 25920, },
{0, 207, 28985, 359990, 284184, },
{0, 207, 16674, 753203, 2083572, },
{0, 165, 8770, 941530, 7506936, },
};

static long y10[15][RBG_NPROBS] = { 
{23, 468, 0, 0, 0, },
{5, 1086, 1080, 0, 0, },
{3, 1043, 5212, 288, 0, },
{3, 659, 19036, 288, 0, },
{3, 583, 21510, 9720, 0, },
{3, 368, 27767, 62980, 4608, },
{0, 325, 33734, 43992, 0, },
{0, 289, 33359, 103644, 18144, },
{0, 235, 30691, 266808, 121392, },
{0, 207, 23831, 532351, 758772, },
{0, 223, 18071, 739532, 18720, },
{0, 175, 19349, 750336, 212976, },
{0, 147, 18301, 802935, 983988, },
{0, 147, 13709, 895395, 3606660, },
{0, 129, 9184, 920983, 9389700, },
};

static long y11[20][RBG_NPROBS] = { 
{5, 1112, 144, 0, 0, },
{3, 1144, 1584, 0, 0, },
{3, 1055, 4788, 0, 0, },
{3, 857, 11792, 4464, 0, },
{0, 385, 32796, 0, 0, },
{0, 371, 33292, 288, 0, },
{0, 321, 34738, 13032, 0, },
{0, 335, 34472, 4464, 0, },
{0, 308, 34657, 32780, 576, },
{0, 235, 34181, 143452, 39168, },
{0, 345, 33984, 9072, 0, },
{0, 309, 35268, 9504, 0, },
{0, 236, 35555, 93060, 25920, },
{0, 309, 34282, 45000, 0, },
{0, 235, 34783, 122124, 26784, },
{0, 207, 28547, 375536, 292176, },
{0, 307, 28169, 267628, 1152, },
{0, 235, 29373, 316128, 54000, },
{0, 207, 25276, 488623, 460260, },
{0, 207, 15791, 778381, 2321532, },
};

static long y12[15][RBG_NPROBS] = { 
{17, 680, 144, 0, 0, },
{4, 983, 6076, 288, 0, },
{3, 923, 9488, 1872, 0, },
{3, 333, 29949, 29900, 576, },
{3, 331, 29167, 60532, 4608, },
{3, 283, 29081, 125244, 25920, },
{0, 263, 24605, 449718, 117720, },
{0, 245, 24912, 457129, 292860, },
{0, 222, 23475, 526367, 735732, },
{0, 207, 19394, 669443, 1573812, },
{0, 120, 11720, 984849, 4223772, },
{0, 108, 11969, 985331, 4443588, },
{0, 93, 12122, 963477, 5731884, },
{0, 93, 11334, 906514, 8803800, },
{0, 93, 9540, 858470, 12858408, },
};

static long y13[20][RBG_NPROBS] = { 
{4, 1132, 720, 0, 0, },
{3, 1091, 3484, 288, 0, },
{3, 775, 14808, 2160, 0, },
{3, 715, 16754, 9864, 0, },
{0, 367, 33436, 288, 0, },
{0, 296, 35680, 11504, 576, },
{0, 284, 35649, 28172, 576, },
{0, 268, 34079, 105284, 5760, },
{0, 252, 33761, 136812, 29376, },
{0, 222, 32167, 230992, 104400, },
{0, 309, 35114, 15032, 576, },
{0, 259, 35139, 78796, 5472, },
{0, 223, 34893, 133328, 40752, },
{0, 258, 27701, 345954, 74088, },
{0, 222, 28523, 359568, 198288, },
{0, 207, 25658, 472035, 562356, },
{0, 246, 15840, 772067, 665748, },
{0, 210, 17074, 766333, 952524, },
{0, 195, 16968, 761467, 1964916, },
{0, 195, 13487, 839379, 3671460, },
};

static long y14[20][RBG_NPROBS] = { 
{4, 1089, 2268, 0, 0, },
{3, 647, 19404, 2592, 0, },
{3, 559, 22396, 8928, 0, },
{3, 527, 23025, 27740, 576, },
{0, 313, 34013, 49484, 576, },
{0, 293, 33443, 95796, 5184, },
{0, 277, 32921, 134556, 32832, },
{0, 267, 30329, 241000, 26640, },
{0, 252, 30183, 263560, 103536, },
{0, 222, 28408, 360893, 299628, },
{0, 211, 18473, 740252, 31680, },
{0, 186, 19069, 747694, 157752, },
{0, 162, 19534, 758017, 303228, },
{0, 185, 17752, 783317, 628812, },
{0, 162, 18254, 788219, 874836, },
{0, 147, 17470, 814155, 1657044, },
{0, 180, 14314, 886931, 1587636, },
{0, 155, 15088, 882887, 1896516, },
{0, 141, 14977, 868919, 3196404, },
{0, 141, 12630, 886913, 5590332, },
};

static long y15[15][RBG_NPROBS] = { 
{3, 1019, 6076, 288, 0, },
{0, 355, 33824, 1872, 0, },
{0, 331, 34492, 8928, 0, },
{0, 297, 35133, 29900, 576, },
{0, 284, 34771, 59668, 4608, },
{0, 285, 35948, 16112, 576, },
{0, 284, 35025, 50636, 576, },
{0, 259, 34403, 105284, 5760, },
{0, 222, 34305, 155740, 42624, },
{0, 283, 28939, 270876, 6048, },
{0, 258, 28885, 304624, 27504, },
{0, 222, 29275, 334920, 111024, },
{0, 258, 24785, 449718, 117720, },
{0, 221, 25756, 457849, 292860, },
{0, 207, 23447, 546031, 763956, },
};

static long y16[6][RBG_NPROBS] = { 
{31, 180, 0, 0, 0, },
{6, 975, 3772, 288, 0, },
{2, 466, 25089, 78660, 18144, },
{2, 84, 23554, 584297, 1627164, },
{0, 116, 6951, 880249, 14356620, },
{0, 18, 6042, 425561, 36475740, },
};

static long y17[15][RBG_NPROBS] = { 
{23, 468, 0, 0, 0, },
{4, 1148, 144, 0, 0, },
{2, 995, 8200, 1584, 0, },
{2, 1066, 5688, 0, 0, },
{2, 603, 22062, 10568, 576, },
{2, 205, 32081, 163840, 67248, },
{0, 383, 32860, 288, 0, },
{0, 254, 35419, 75284, 2304, },
{0, 154, 29734, 402111, 269892, },
{0, 140, 15913, 828583, 3482100, },
{0, 296, 34104, 68256, 0, },
{0, 164, 30562, 363296, 127584, },
{0, 136, 17946, 801264, 2017440, },
{0, 120, 7889, 1002899, 8538948, },
{0, 70, 5652, 775017, 21974652, },
};

static long y18[15][RBG_NPROBS] = { 
{19, 608, 144, 0, 0, },
{4, 1065, 3132, 0, 0, },
{2, 884, 12012, 8208, 0, },
{2, 655, 20336, 5328, 0, },
{2, 444, 26523, 55852, 7200, },
{2, 189, 30326, 243663, 214596, },
{0, 304, 33253, 88380, 5184, },
{0, 224, 30938, 271784, 135360, },
{0, 153, 24544, 564925, 1181484, },
{0, 140, 14007, 849405, 5202684, },
{0, 193, 18775, 748820, 171648, },
{0, 117, 18938, 811339, 1255572, },
{0, 100, 13699, 913601, 5157036, },
{0, 92, 7775, 917424, 13070160, },
{0, 62, 5739, 706619, 24697476, },
};

static long y19[20][RBG_NPROBS] = { 
{4, 1130, 792, 0, 0, },
{2, 1063, 5796, 0, 0, },
{2, 991, 8364, 864, 0, },
{2, 587, 22351, 20884, 1152, },
{0, 371, 33292, 288, 0, },
{0, 357, 33712, 3312, 0, },
{0, 246, 35383, 86828, 6624, },
{0, 327, 34262, 22392, 0, },
{0, 237, 34453, 131064, 39312, },
{0, 152, 28396, 445719, 527364, },
{0, 288, 34388, 68400, 0, },
{0, 260, 35352, 69984, 0, },
{0, 158, 30668, 367220, 128880, },
{0, 259, 34481, 102492, 5184, },
{0, 157, 30147, 385270, 200952, },
{0, 140, 17532, 803268, 2295216, },
{0, 257, 28879, 305844, 38016, },
{0, 155, 26546, 508717, 517068, },
{0, 140, 16334, 823115, 3133332, },
{0, 124, 7589, 978016, 9636912, },
};

static long y20[15][RBG_NPROBS] = { 
{14, 776, 576, 0, 0, },
{4, 913, 8552, 1872, 0, },
{2, 767, 15983, 16868, 576, },
{2, 360, 29605, 53820, 5184, },
{2, 300, 28857, 156860, 64512, },
{2, 176, 27944, 340841, 409788, },
{0, 243, 24528, 474225, 268380, },
{0, 198, 22633, 576764, 1132416, },
{0, 150, 18321, 737255, 3182580, },
{0, 140, 12063, 859951, 7342452, },
{0, 108, 11969, 977637, 4720572, },
{0, 76, 12092, 946693, 7168140, },
{0, 64, 10674, 863340, 12566448, },
{0, 64, 7844, 761133, 19913580, },
{0, 52, 6032, 616407, 28031940, },
};

static long y21[20][RBG_NPROBS] = { 
{4, 1099, 1908, 0, 0, },
{2, 1019, 7348, 1152, 0, },
{2, 751, 16778, 9000, 0, },
{2, 520, 23769, 56524, 6336, },
{0, 342, 34202, 5112, 0, },
{0, 292, 35133, 36292, 3744, },
{0, 225, 34874, 131282, 45720, },
{0, 268, 32812, 150088, 34848, },
{0, 220, 30222, 298601, 284508, },
{0, 150, 25691, 530366, 1079064, },
{0, 262, 35170, 73880, 2304, },
{0, 222, 34976, 132004, 27504, },
{0, 154, 30031, 392356, 236160, },
{0, 220, 28078, 378260, 195408, },
{0, 151, 25786, 529760, 931104, },
{0, 140, 16413, 821065, 3104748, },
{0, 210, 16875, 771659, 1018692, },
{0, 140, 17488, 793184, 2715264, },
{0, 132, 12957, 858233, 6618924, },
{0, 128, 6962, 908191, 12776580, },
};

static long y22[20][RBG_NPROBS] = { 
{4, 1035, 4204, 288, 0, },
{2, 642, 20738, 7704, 0, },
{2, 555, 23523, 20180, 576, },
{2, 410, 27049, 80676, 18144, },
{0, 290, 33665, 91628, 7488, },
{0, 275, 33057, 132372, 28512, },
{0, 212, 30778, 291535, 191556, },
{0, 253, 29938, 271332, 94608, },
{0, 208, 27684, 401077, 444492, },
{0, 151, 23054, 608233, 1646748, },
{0, 184, 19038, 750756, 181008, },
{0, 164, 19390, 761061, 286956, },
{0, 113, 18750, 820147, 1368756, },
{0, 164, 17961, 797571, 824580, },
{0, 111, 17708, 838828, 2139984, },
{0, 100, 13209, 915715, 5715972, },
{0, 158, 14796, 886873, 1991484, },
{0, 106, 15120, 886295, 4018500, },
{0, 96, 12026, 896601, 8123868, },
{0, 92, 7533, 877093, 14835708, },
};

static long y23[15][RBG_NPROBS] = { 
{2, 963, 9344, 1872, 0, },
{0, 331, 34550, 6840, 0, },
{0, 311, 34757, 25292, 576, },
{0, 292, 34669, 52956, 5184, },
{0, 225, 34049, 160400, 66672, },
{0, 242, 35841, 75644, 2304, },
{0, 242, 34959, 107252, 7488, },
{0, 222, 34300, 156216, 31968, },
{0, 153, 29610, 407273, 291420, },
{0, 240, 29401, 308924, 43776, },
{0, 220, 29234, 339556, 90576, },
{0, 151, 26258, 521963, 600084, },
{0, 220, 25312, 475809, 268380, },
{0, 149, 23843, 596484, 1140480, },
{0, 140, 15529, 836357, 3699900, },
};

static long y24[15][RBG_NPROBS] = { 
{10, 887, 1764, 0, 0, },
{3, 719, 16407, 17156, 576, },
{2, 641, 19951, 37220, 4032, },
{2, 194, 30182, 243319, 180324, },
{2, 185, 28264, 318235, 388980, },
{2, 143, 26206, 434497, 830268, },
{0, 183, 14564, 820763, 3505716, },
{0, 160, 14565, 819849, 4610412, },
{0, 136, 13405, 831119, 6827796, },
{0, 132, 10367, 861740, 9849312, },
{0, 55, 8811, 772043, 18687492, },
{0, 47, 8633, 762062, 19650744, },
{0, 40, 8204, 717461, 22138956, },
{0, 40, 7232, 643295, 26068644, },
{0, 36, 6082, 562587, 30651156, },
};

static long y25[20][RBG_NPROBS] = { 
{3, 1079, 3916, 288, 0, },
{2, 887, 11834, 10728, 0, },
{2, 476, 25507, 51044, 4032, },
{2, 402, 27073, 90180, 18144, },
{0, 318, 34810, 14312, 576, },
{0, 232, 34908, 121056, 43200, },
{0, 200, 34336, 181552, 99648, },
{0, 200, 26978, 434919, 514404, },
{0, 176, 26107, 485813, 930780, },
{0, 147, 23378, 600873, 1678428, },
{0, 221, 35079, 128568, 64368, },
{0, 182, 29423, 372592, 429264, },
{0, 148, 27194, 487861, 754668, },
{0, 176, 17571, 762085, 2047644, },
{0, 139, 17798, 786039, 2617380, },
{0, 132, 14067, 884661, 4228956, },
{0, 152, 9103, 939942, 7739064, },
{0, 113, 10135, 926300, 8712288, },
{0, 100, 9481, 906351, 10884564, },
{0, 100, 6941, 887101, 14869404, },
};

static long y26[20][RBG_NPROBS] = { 
{3, 985, 7264, 1584, 0, },
{2, 595, 21997, 23276, 576, },
{2, 395, 27547, 82204, 17568, },
{2, 340, 27770, 144132, 65232, },
{0, 269, 33277, 131568, 52272, },
{0, 226, 30426, 285363, 216756, },
{0, 195, 28399, 389959, 524628, },
{0, 196, 23900, 538799, 950436, },
{0, 173, 22617, 594924, 1665792, },
{0, 146, 19382, 710497, 2957436, },
{0, 159, 19533, 759847, 378612, },
{0, 133, 18457, 807913, 1255788, },
{0, 107, 17761, 834132, 2426976, },
{0, 133, 14018, 894693, 3884652, },
{0, 105, 14160, 885933, 5322348, },
{0, 100, 11603, 903632, 8232336, },
{0, 120, 9386, 919460, 9602640, },
{0, 92, 9959, 897073, 10972332, },
{0, 88, 9081, 845101, 14167836, },
{0, 88, 6944, 797786, 18640728, },
};

static long y27[15][RBG_NPROBS] = { 
{2, 850, 13146, 11448, 0, },
{0, 310, 34855, 23044, 1152, },
{0, 296, 34455, 55420, 7200, },
{0, 232, 33661, 164996, 77472, },
{0, 200, 32377, 248703, 221076, },
{0, 209, 35429, 131512, 64656, },
{0, 208, 34703, 158780, 70560, },
{0, 182, 29012, 387017, 442620, },
{0, 147, 26918, 497879, 798372, },
{0, 207, 29618, 341130, 142776, },
{0, 181, 25868, 495979, 641268, },
{0, 146, 24254, 583029, 1232172, },
{0, 180, 16617, 776622, 2574072, },
{0, 142, 16946, 792561, 3346812, },
{0, 136, 13415, 872781, 5315004, },
};

static long y28[20][RBG_NPROBS] = { 
{3, 876, 11070, 5832, 0, },
{2, 355, 29081, 78820, 17568, },
{2, 312, 28766, 144712, 59904, },
{2, 268, 28254, 217343, 161604, },
{0, 227, 24896, 477159, 432324, },
{0, 209, 23554, 535275, 919188, },
{0, 185, 22006, 601857, 1648188, },
{0, 194, 19630, 671532, 1799280, },
{0, 172, 18904, 699721, 2751804, },
{0, 145, 16482, 774441, 4460508, },
{0, 100, 12078, 980097, 4863996, },
{0, 87, 12104, 965251, 5971284, },
{0, 71, 11891, 942537, 7811532, },
{0, 87, 11301, 910749, 8974044, },
{0, 70, 11128, 900933, 10344780, },
{0, 64, 10008, 845763, 14062356, },
{0, 87, 9602, 858987, 13039380, },
{0, 70, 9669, 843115, 14317092, },
{0, 64, 8948, 788345, 17503164, },
{0, 64, 7347, 721049, 22000716, },
};

static long y29[15][RBG_NPROBS] = { 
{2, 711, 17893, 20684, 576, },
{0, 277, 35301, 49644, 5184, },
{0, 250, 32889, 169600, 72432, },
{0, 216, 31766, 251079, 180900, },
{0, 191, 29823, 346777, 420300, },
{0, 196, 34817, 169610, 92808, },
{0, 195, 28619, 387703, 320724, },
{0, 180, 26178, 483327, 741636, },
{0, 147, 24325, 575456, 1366128, },
{0, 185, 17665, 769685, 1232316, },
{0, 172, 17499, 767034, 2149416, },
{0, 137, 17091, 792659, 3388644, },
{0, 172, 14184, 836845, 3932460, },
{0, 137, 14526, 834307, 5213556, },
{0, 132, 11813, 863857, 7899084, },
};

static long y30[15][RBG_NPROBS] = { 
{2, 537, 23595, 40820, 4032, },
{0, 260, 32786, 160172, 78768, },
{0, 239, 29984, 285233, 187740, },
{0, 215, 28156, 375495, 427140, },
{0, 191, 26442, 456345, 857628, },
{0, 147, 19675, 767435, 481284, },
{0, 147, 18377, 798257, 1053900, },
{0, 133, 17615, 821824, 1846224, },
{0, 106, 17096, 842747, 3025332, },
{0, 141, 15264, 885864, 2214432, },
{0, 128, 15090, 876847, 3371076, },
{0, 101, 14852, 877549, 4913964, },
{0, 128, 12865, 889903, 5784660, },
{0, 100, 13053, 881311, 7156692, },
{0, 96, 11075, 873594, 10184616, },
};

static long y31[6][RBG_NPROBS] = { 
{0, 278, 34449, 78676, 17568, },
{0, 196, 34220, 190904, 99936, },
{0, 195, 29493, 359469, 204444, },
{0, 195, 25955, 480507, 432324, },
{0, 180, 24042, 554123, 961236, },
{0, 146, 22638, 628265, 1698012, },
};

typedef long T[RBG_NPROBS];

static T* y[] = {
  y1, y2, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12, y13, y14, y15, y16,
  y17, y18, y19, y20, y21, y22, y23, y24, y25, y26, y27, y28, y29, y30, y31, 
};


CONST long*
getRaceBGprobs(int board[6])
{
  unsigned int tot = 0;
  int group = 0;
  int i;
  {                                                 assert( board[5] == 0 ); }
  
  for(i = 4; i >= 0; --i) { 
    group += (0x1 << i) * !!board[i];
    tot += board[i];
  }

  if( tot > 6 ) {
    return 0;
  }

  {
    int grpSize = 0;
    int b1[6];
    unsigned int k;

    for(k = 0; k < 5; ++k) {
      if( (group & (0x1 << k)) ) {
	{                                            assert( board[k] > 0 ); }
      
	b1[grpSize] = board[k] - 1;
	++grpSize;
      }
    }

    {
      unsigned int const index = PositionIndex(grpSize, b1);

      return y[group-1][index];
    }
  }
}
