package JIRA::API::IssueLinkType 0.01;
# DO NOT EDIT! This is an autogenerated file.
use 5.020;
use Moo 2;
use experimental 'signatures';
use Types::Standard qw(Str Bool Num Int Object ArrayRef);
use MooX::TypeTiny;

=head1 NAME

JIRA::API::IssueLinkType -

=head1 SYNOPSIS

  my $obj = JIRA::API::IssueLinkType->new();
  ...

=cut

sub as_hash( $self ) {
    return { $self->%* }
}

=head1 PROPERTIES

=head2 C<< id >>

The ID of the issue link type and is used as follows:

 *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is the type of issue link. Required on create when `name` isn't provided. Otherwise, read only.
 *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is read only.

=cut

has 'id' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< inward >>

The description of the issue link type inward link and is used as follows:

 *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is read only.
 *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.

=cut

has 'inward' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< name >>

The name of the issue link type and is used as follows:

 *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is the type of issue link. Required on create when `id` isn't provided. Otherwise, read only.
 *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.

=cut

has 'name' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< outward >>

The description of the issue link type outward link and is used as follows:

 *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is read only.
 *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.

=cut

has 'outward' => (
    is       => 'ro',
    isa      => Str,
);

=head2 C<< self >>

The URL of the issue link type. Read only.

=cut

has 'self' => (
    is       => 'ro',
    isa      => Str,
);


1;
