# Generated by default/object.tt
package Paws::Transcribe::InputDataConfig;
  use Moose;
  has DataAccessRoleArn => (is => 'ro', isa => 'Str', required => 1);
  has S3Uri => (is => 'ro', isa => 'Str', required => 1);
  has TuningDataS3Uri => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transcribe::InputDataConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transcribe::InputDataConfig object:

  $service_obj->Method(Att1 => { DataAccessRoleArn => $value, ..., TuningDataS3Uri => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transcribe::InputDataConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->DataAccessRoleArn

=head1 DESCRIPTION

The object that contains the Amazon S3 object location and access role
required to train and tune your custom language model.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DataAccessRoleArn => Str

The Amazon Resource Name (ARN) that uniquely identifies the permissions
you've given Amazon Transcribe to access your Amazon S3 buckets
containing your media files or text data.


=head2 B<REQUIRED> S3Uri => Str

The Amazon S3 prefix you specify to access the plain text files that
you use to train your custom language model.


=head2 TuningDataS3Uri => Str

The Amazon S3 prefix you specify to access the plain text files that
you use to tune your custom language model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transcribe>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

