######################################################################
#
# 2153_jipse_by_utf8jp.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xF3\xB0\x80\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x00"],
        ["\xF3\xB0\x80\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x01"],
        ["\xF3\xB0\x80\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x02"],
        ["\xF3\xB0\x80\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x03"],
        ["\xF3\xB0\x80\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x37"],
        ["\xF3\xB0\x80\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2D"],
        ["\xF3\xB0\x80\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2E"],
        ["\xF3\xB0\x80\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2F"],
        ["\xF3\xB0\x80\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x16"],
        ["\xF3\xB0\x80\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x05"],
        ["\xF3\xB0\x80\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x15"],
        ["\xF3\xB0\x80\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0B"],
        ["\xF3\xB0\x80\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0C"],
        ["\xF3\xB0\x80\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0D"],
        ["\xF3\xB0\x80\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0E"],
        ["\xF3\xB0\x80\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0F"],
        ["\xF3\xB0\x80\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x10"],
        ["\xF3\xB0\x80\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x11"],
        ["\xF3\xB0\x80\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x12"],
        ["\xF3\xB0\x80\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x13"],
        ["\xF3\xB0\x80\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3C"],
        ["\xF3\xB0\x80\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3D"],
        ["\xF3\xB0\x80\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x32"],
        ["\xF3\xB0\x80\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x26"],
        ["\xF3\xB0\x80\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x18"],
        ["\xF3\xB0\x80\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x19"],
        ["\xF3\xB0\x80\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3F"],
        ["\xF3\xB0\x80\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x27"],
        ["\xF3\xB0\x80\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1C"],
        ["\xF3\xB0\x80\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1D"],
        ["\xF3\xB0\x80\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1E"],
        ["\xF3\xB0\x80\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1F"],
        ["\xF3\xB0\x80\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x40"],
        ["\xF3\xB0\x80\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F"],
        ["\xF3\xB0\x80\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F"],
        ["\xF3\xB0\x80\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B"],
        ["\xF3\xB0\x80\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0"],
        ["\xF3\xB0\x80\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C"],
        ["\xF3\xB0\x80\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50"],
        ["\xF3\xB0\x80\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D"],
        ["\xF3\xB0\x80\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4D"],
        ["\xF3\xB0\x80\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5D"],
        ["\xF3\xB0\x80\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5C"],
        ["\xF3\xB0\x80\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4E"],
        ["\xF3\xB0\x80\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B"],
        ["\xF3\xB0\x80\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60"],
        ["\xF3\xB0\x80\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4B"],
        ["\xF3\xB0\x80\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x61"],
        ["\xF3\xB0\x80\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0"],
        ["\xF3\xB0\x80\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1"],
        ["\xF3\xB0\x80\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2"],
        ["\xF3\xB0\x80\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3"],
        ["\xF3\xB0\x80\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4"],
        ["\xF3\xB0\x80\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5"],
        ["\xF3\xB0\x80\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6"],
        ["\xF3\xB0\x80\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7"],
        ["\xF3\xB0\x80\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8"],
        ["\xF3\xB0\x80\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9"],
        ["\xF3\xB0\x80\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A"],
        ["\xF3\xB0\x80\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E"],
        ["\xF3\xB0\x80\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C"],
        ["\xF3\xB0\x80\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E"],
        ["\xF3\xB0\x80\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E"],
        ["\xF3\xB0\x80\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F"],
        ["\xF3\xB0\x81\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C"],
        ["\xF3\xB0\x81\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1"],
        ["\xF3\xB0\x81\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2"],
        ["\xF3\xB0\x81\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3"],
        ["\xF3\xB0\x81\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4"],
        ["\xF3\xB0\x81\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5"],
        ["\xF3\xB0\x81\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6"],
        ["\xF3\xB0\x81\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7"],
        ["\xF3\xB0\x81\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8"],
        ["\xF3\xB0\x81\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9"],
        ["\xF3\xB0\x81\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1"],
        ["\xF3\xB0\x81\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2"],
        ["\xF3\xB0\x81\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3"],
        ["\xF3\xB0\x81\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4"],
        ["\xF3\xB0\x81\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5"],
        ["\xF3\xB0\x81\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6"],
        ["\xF3\xB0\x81\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7"],
        ["\xF3\xB0\x81\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8"],
        ["\xF3\xB0\x81\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9"],
        ["\xF3\xB0\x81\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2"],
        ["\xF3\xB0\x81\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3"],
        ["\xF3\xB0\x81\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4"],
        ["\xF3\xB0\x81\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5"],
        ["\xF3\xB0\x81\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6"],
        ["\xF3\xB0\x81\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7"],
        ["\xF3\xB0\x81\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8"],
        ["\xF3\xB0\x81\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9"],
        ["\xF3\xB0\x81\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A"],
        ["\xF3\xB0\x81\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B"],
        ["\xF3\xB0\x81\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A"],
        ["\xF3\xB0\x81\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F"],
        ["\xF3\xB0\x81\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D"],
        ["\xF3\xB0\x81\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79"],
        ["\xF3\xB0\x81\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57"],
        ["\xF3\xB0\x81\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59"],
        ["\xF3\xB0\x81\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62"],
        ["\xF3\xB0\x81\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63"],
        ["\xF3\xB0\x81\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64"],
        ["\xF3\xB0\x81\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65"],
        ["\xF3\xB0\x81\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66"],
        ["\xF3\xB0\x81\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67"],
        ["\xF3\xB0\x81\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68"],
        ["\xF3\xB0\x81\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69"],
        ["\xF3\xB0\x81\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70"],
        ["\xF3\xB0\x81\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71"],
        ["\xF3\xB0\x81\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72"],
        ["\xF3\xB0\x81\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73"],
        ["\xF3\xB0\x81\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74"],
        ["\xF3\xB0\x81\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75"],
        ["\xF3\xB0\x81\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76"],
        ["\xF3\xB0\x81\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77"],
        ["\xF3\xB0\x81\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78"],
        ["\xF3\xB0\x81\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x80"],
        ["\xF3\xB0\x81\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8B"],
        ["\xF3\xB0\x81\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9B"],
        ["\xF3\xB0\x81\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9C"],
        ["\xF3\xB0\x81\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA0"],
        ["\xF3\xB0\x81\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAB"],
        ["\xF3\xB0\x81\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB0"],
        ["\xF3\xB0\x81\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC0"],
        ["\xF3\xB0\x81\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6A"],
        ["\xF3\xB0\x81\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD0"],
        ["\xF3\xB0\x81\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA1"],
        ["\xF3\xB0\x81\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x07"],
        ["\xF3\xB0\x82\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x20"],
        ["\xF3\xB0\x82\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x21"],
        ["\xF3\xB0\x82\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x22"],
        ["\xF3\xB0\x82\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x23"],
        ["\xF3\xB0\x82\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x24"],
        ["\xF3\xB0\x82\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x25"],
        ["\xF3\xB0\x82\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x06"],
        ["\xF3\xB0\x82\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x17"],
        ["\xF3\xB0\x82\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x28"],
        ["\xF3\xB0\x82\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x29"],
        ["\xF3\xB0\x82\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2A"],
        ["\xF3\xB0\x82\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2B"],
        ["\xF3\xB0\x82\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x2C"],
        ["\xF3\xB0\x82\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x09"],
        ["\xF3\xB0\x82\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x0A"],
        ["\xF3\xB0\x82\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1B"],
        ["\xF3\xB0\x82\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x30"],
        ["\xF3\xB0\x82\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x31"],
        ["\xF3\xB0\x82\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x1A"],
        ["\xF3\xB0\x82\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x33"],
        ["\xF3\xB0\x82\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x34"],
        ["\xF3\xB0\x82\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x35"],
        ["\xF3\xB0\x82\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x36"],
        ["\xF3\xB0\x82\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x08"],
        ["\xF3\xB0\x82\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x38"],
        ["\xF3\xB0\x82\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x39"],
        ["\xF3\xB0\x82\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3A"],
        ["\xF3\xB0\x82\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3B"],
        ["\xF3\xB0\x82\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x04"],
        ["\xF3\xB0\x82\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x14"],
        ["\xF3\xB0\x82\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x3E"],
        ["\xF3\xB0\x82\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE1"],
        ["\xF3\xB0\x82\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB1"],
        ["\xF3\xB0\x82\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\xF3\xB0\x82\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\xF3\xB0\x82\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\xF3\xB0\x82\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\xF3\xB0\x82\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\xF3\xB0\x82\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\xF3\xB0\x82\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\xF3\xB0\x82\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\xF3\xB0\x82\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\xF3\xB0\x82\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\xF3\xB0\x82\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\xF3\xB0\x82\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\xF3\xB0\x82\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\xF3\xB0\x82\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\xF3\xB0\x82\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\xF3\xB0\x82\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\xF3\xB0\x82\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x81"],
        ["\xF3\xB0\x82\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82"],
        ["\xF3\xB0\x82\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83"],
        ["\xF3\xB0\x82\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84"],
        ["\xF3\xB0\x82\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85"],
        ["\xF3\xB0\x82\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86"],
        ["\xF3\xB0\x82\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87"],
        ["\xF3\xB0\x82\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88"],
        ["\xF3\xB0\x82\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89"],
        ["\xF3\xB0\x82\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A"],
        ["\xF3\xB0\x82\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C"],
        ["\xF3\xB0\x82\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D"],
        ["\xF3\xB0\x82\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E"],
        ["\xF3\xB0\x82\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F"],
        ["\xF3\xB0\x82\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90"],
        ["\xF3\xB0\x83\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91"],
        ["\xF3\xB0\x83\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92"],
        ["\xF3\xB0\x83\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93"],
        ["\xF3\xB0\x83\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94"],
        ["\xF3\xB0\x83\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95"],
        ["\xF3\xB0\x83\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96"],
        ["\xF3\xB0\x83\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97"],
        ["\xF3\xB0\x83\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98"],
        ["\xF3\xB0\x83\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99"],
        ["\xF3\xB0\x83\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A"],
        ["\xF3\xB0\x83\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D"],
        ["\xF3\xB0\x83\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E"],
        ["\xF3\xB0\x83\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F"],
        ["\xF3\xB0\x83\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2"],
        ["\xF3\xB0\x83\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3"],
        ["\xF3\xB0\x83\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4"],
        ["\xF3\xB0\x83\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5"],
        ["\xF3\xB0\x83\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6"],
        ["\xF3\xB0\x83\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7"],
        ["\xF3\xB0\x83\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8"],
        ["\xF3\xB0\x83\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9"],
        ["\xF3\xB0\x83\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA"],
        ["\xF3\xB0\x83\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAC"],
        ["\xF3\xB0\x83\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAD"],
        ["\xF3\xB0\x83\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAE"],
        ["\xF3\xB0\x83\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAF"],
        ["\xF3\xB0\x83\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBA"],
        ["\xF3\xB0\x83\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBB"],
        ["\xF3\xB0\x83\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBC"],
        ["\xF3\xB0\x83\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBD"],
        ["\xF3\xB0\x83\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBE"],
        ["\xF3\xB0\x83\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xBF"],
        ["\xF3\xB0\x83\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB2"],
        ["\xF3\xB0\x83\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB3"],
        ["\xF3\xB0\x83\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB4"],
        ["\xF3\xB0\x83\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB5"],
        ["\xF3\xB0\x83\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB6"],
        ["\xF3\xB0\x83\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB7"],
        ["\xF3\xB0\x83\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB8"],
        ["\xF3\xB0\x83\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xB9"],
        ["\xF3\xB0\x83\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCA"],
        ["\xF3\xB0\x83\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCB"],
        ["\xF3\xB0\x83\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCC"],
        ["\xF3\xB0\x83\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCD"],
        ["\xF3\xB0\x83\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCE"],
        ["\xF3\xB0\x83\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xCF"],
        ["\xF3\xB0\x83\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDA"],
        ["\xF3\xB0\x83\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDB"],
        ["\xF3\xB0\x83\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDC"],
        ["\xF3\xB0\x83\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDD"],
        ["\xF3\xB0\x83\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDE"],
        ["\xF3\xB0\x83\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xDF"],
        ["\xF3\xB0\x83\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEA"],
        ["\xF3\xB0\x83\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEB"],
        ["\xF3\xB0\x83\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEC"],
        ["\xF3\xB0\x83\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xED"],
        ["\xF3\xB0\x83\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEE"],
        ["\xF3\xB0\x83\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xEF"],
        ["\xF3\xB0\x83\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFA"],
        ["\xF3\xB0\x83\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFB"],
        ["\xF3\xB0\x83\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFC"],
        ["\xF3\xB0\x83\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFD"],
        ["\xF3\xB0\x83\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFE"],
        ["\xF3\xB0\x83\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xFF"],
        ["\xF3\xB0\x84\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\xF3\xB0\x84\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x7F"],
        ["\xF3\xB0\x84\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x7B"],
        ["\xF3\xB0\x84\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE0"],
        ["\xF3\xB0\x84\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x6C"],
        ["\xF3\xB0\x84\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\xF3\xB0\x84\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x7D"],
        ["\xF3\xB0\x84\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\xF3\xB0\x84\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x5D"],
        ["\xF3\xB0\x84\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x5C"],
        ["\xF3\xB0\x84\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\xF3\xB0\x84\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x6B"],
        ["\xF3\xB0\x84\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x60"],
        ["\xF3\xB0\x84\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\xF3\xB0\x84\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x61"],
        ["\xF3\xB0\x84\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF0"],
        ["\xF3\xB0\x84\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF1"],
        ["\xF3\xB0\x84\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF2"],
        ["\xF3\xB0\x84\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],
        ["\xF3\xB0\x84\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF4"],
        ["\xF3\xB0\x84\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF5"],
        ["\xF3\xB0\x84\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF6"],
        ["\xF3\xB0\x84\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF7"],
        ["\xF3\xB0\x84\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],
        ["\xF3\xB0\x84\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xF9"],
        ["\xF3\xB0\x84\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x7A"],
        ["\xF3\xB0\x84\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x5E"],
        ["\xF3\xB0\x84\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\xF3\xB0\x84\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x7E"],
        ["\xF3\xB0\x84\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x6E"],
        ["\xF3\xB0\x84\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x6F"],
        ["\xF3\xB0\x84\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x7C"],
        ["\xF3\xB0\x84\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],
        ["\xF3\xB0\x84\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC2"],
        ["\xF3\xB0\x84\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC3"],
        ["\xF3\xB0\x84\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],
        ["\xF3\xB0\x84\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],
        ["\xF3\xB0\x84\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC6"],
        ["\xF3\xB0\x84\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC7"],
        ["\xF3\xB0\x84\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC8"],
        ["\xF3\xB0\x84\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],
        ["\xF3\xB0\x84\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD1"],
        ["\xF3\xB0\x84\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD2"],
        ["\xF3\xB0\x84\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD3"],
        ["\xF3\xB0\x84\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD4"],
        ["\xF3\xB0\x84\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD5"],
        ["\xF3\xB0\x84\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],
        ["\xF3\xB0\x84\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD7"],
        ["\xF3\xB0\x84\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD8"],
        ["\xF3\xB0\x84\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD9"],
        ["\xF3\xB0\x84\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE2"],
        ["\xF3\xB0\x84\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE3"],
        ["\xF3\xB0\x84\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE4"],
        ["\xF3\xB0\x84\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE5"],
        ["\xF3\xB0\x84\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE6"],
        ["\xF3\xB0\x84\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],
        ["\xF3\xB0\x84\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],
        ["\xF3\xB0\x84\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xE9"],
        ["\xF3\xB0\x84\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\xF3\xB0\x84\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x5B"],
        ["\xF3\xB0\x84\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x5A"],
        ["\xF3\xB0\x84\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x5F"],
        ["\xF3\xB0\x84\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x6D"],
        ["\xF3\xB0\x84\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x79"],
        ["\xF3\xB0\x85\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x57"],
        ["\xF3\xB0\x85\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x59"],
        ["\xF3\xB0\x85\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x62"],
        ["\xF3\xB0\x85\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x63"],
        ["\xF3\xB0\x85\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x64"],
        ["\xF3\xB0\x85\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x65"],
        ["\xF3\xB0\x85\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x66"],
        ["\xF3\xB0\x85\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x67"],
        ["\xF3\xB0\x85\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x68"],
        ["\xF3\xB0\x85\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x69"],
        ["\xF3\xB0\x85\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x70"],
        ["\xF3\xB0\x85\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x71"],
        ["\xF3\xB0\x85\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x72"],
        ["\xF3\xB0\x85\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x73"],
        ["\xF3\xB0\x85\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x74"],
        ["\xF3\xB0\x85\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x75"],
        ["\xF3\xB0\x85\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x76"],
        ["\xF3\xB0\x85\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x77"],
        ["\xF3\xB0\x85\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x78"],
        ["\xF3\xB0\x85\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x80"],
        ["\xF3\xB0\x85\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x8B"],
        ["\xF3\xB0\x85\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x9B"],
        ["\xF3\xB0\x85\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x9C"],
        ["\xF3\xB0\x85\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA0"],
        ["\xF3\xB0\x85\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],
        ["\xF3\xB0\x85\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xB0"],
        ["\xF3\xB0\x85\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],
        ["\xF3\xB0\x85\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\x6A"],
        ["\xF3\xB0\x85\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xD0"],
        ["\xF3\xB0\x85\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4F\xA1"],
        ["\xF3\xB0\x85\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x4F"],
        ["\xF3\xB0\x85\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x7F"],
        ["\xF3\xB0\x85\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x7B"],
        ["\xF3\xB0\x85\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\xE0"],
        ["\xF3\xB0\x85\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x6C"],
        ["\xF3\xB0\x85\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x50"],
        ["\xF3\xB0\x85\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x7D"],
        ["\xF3\xB0\x85\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x4D"],
        ["\xF3\xB0\x85\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x5D"],
        ["\xF3\xB0\x85\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x5C"],
        ["\xF3\xB0\x85\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x4E"],
        ["\xF3\xB0\x85\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x6B"],
        ["\xF3\xB0\x85\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x60"],
        ["\xF3\xB0\x85\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7F\x4B"],
        ["\xF3\xB0\x85\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA9"],
        ["\xF3\xB0\x85\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xAA"],
        ["\xF3\xB0\x85\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xEA"],
        ["\xF3\xB0\x85\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xEB"],
        ["\xF3\xB0\x85\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA7"],
        ["\xF3\xB0\x85\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\xF3\xB0\x85\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\xF3\xB0\x85\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\xF3\xB0\x86\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA5"],
        ["\xF3\xB0\x86\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],
        ["\xF3\xB0\x86\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xEC"],
        ["\xF3\xB0\x86\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],
        ["\xF3\xB0\x86\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB9"],
        ["\xF3\xB0\x86\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xCA"],
        ["\xF3\xB0\x86\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x9C"],
        ["\xF3\xB0\x86\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x9B"],
        ["\xF3\xB0\x86\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xEE"],
        ["\xF3\xB0\x86\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x9D"],
        ["\xF3\xB0\x86\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],
        ["\xF3\xB0\x86\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\xF3\xB0\x86\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\xF3\xB0\x86\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\xF3\xB0\x86\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB4"],
        ["\xF3\xB0\x86\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x8B"],
        ["\xF3\xB0\x86\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xBD"],
        ["\xF3\xB0\x86\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xBC"],
        ["\xF3\xB0\x86\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],
        ["\xF3\xB0\x86\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\xF3\xB0\x86\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],
        ["\xF3\xB0\x86\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xBF"],
        ["\xF3\xB0\x86\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xFE"],
        ["\xF3\xB0\x86\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],
        ["\xF3\xB0\x86\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xFC"],
        ["\xF3\xB0\x86\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xFD"],
        ["\xF3\xB0\x86\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xDA"],
        ["\xF3\xB0\x86\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\xF3\xB0\x86\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xDC"],
        ["\xF3\xB0\x86\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x46\xFE"],
        ["\xF3\xB0\x87\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF0"],
        ["\xF3\xB0\x87\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF1"],
        ["\xF3\xB0\x87\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF2"],
        ["\xF3\xB0\x87\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF3"],
        ["\xF3\xB0\x87\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF4"],
        ["\xF3\xB0\x87\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF5"],
        ["\xF3\xB0\x87\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF6"],
        ["\xF3\xB0\x87\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF7"],
        ["\xF3\xB0\x87\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF8"],
        ["\xF3\xB0\x87\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xF9"],
        ["\xF3\xB0\x87\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC1"],
        ["\xF3\xB0\x87\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC2"],
        ["\xF3\xB0\x87\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC3"],
        ["\xF3\xB0\x87\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC4"],
        ["\xF3\xB0\x87\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC5"],
        ["\xF3\xB0\x87\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC6"],
        ["\xF3\xB0\x87\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC7"],
        ["\xF3\xB0\x87\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC8"],
        ["\xF3\xB0\x87\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xC9"],
        ["\xF3\xB0\x87\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD1"],
        ["\xF3\xB0\x87\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD2"],
        ["\xF3\xB0\x87\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD3"],
        ["\xF3\xB0\x87\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD4"],
        ["\xF3\xB0\x87\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD5"],
        ["\xF3\xB0\x87\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD6"],
        ["\xF3\xB0\x87\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD7"],
        ["\xF3\xB0\x87\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD8"],
        ["\xF3\xB0\x87\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xD9"],
        ["\xF3\xB0\x87\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE2"],
        ["\xF3\xB0\x87\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE3"],
        ["\xF3\xB0\x87\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE4"],
        ["\xF3\xB0\x87\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE5"],
        ["\xF3\xB0\x87\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE6"],
        ["\xF3\xB0\x87\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE7"],
        ["\xF3\xB0\x87\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE8"],
        ["\xF3\xB0\x87\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xE9"],
        ["\xF3\xB0\x87\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x57"],
        ["\xF3\xB0\x87\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x59"],
        ["\xF3\xB0\x87\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x62"],
        ["\xF3\xB0\x87\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x63"],
        ["\xF3\xB0\x88\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x64"],
        ["\xF3\xB0\x88\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x65"],
        ["\xF3\xB0\x88\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x66"],
        ["\xF3\xB0\x88\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x67"],
        ["\xF3\xB0\x88\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x68"],
        ["\xF3\xB0\x88\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x69"],
        ["\xF3\xB0\x88\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x70"],
        ["\xF3\xB0\x88\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x71"],
        ["\xF3\xB0\x88\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x72"],
        ["\xF3\xB0\x88\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x73"],
        ["\xF3\xB0\x88\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x74"],
        ["\xF3\xB0\x88\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x75"],
        ["\xF3\xB0\x88\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x76"],
        ["\xF3\xB0\x88\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x77"],
        ["\xF3\xB0\x88\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x78"],
        ["\xF3\xB0\x88\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x80"],
        ["\xF3\xB0\x88\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x8B"],
        ["\xF3\xB0\x88\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x9B"],
        ["\xF3\xB0\x88\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\x9C"],
        ["\xF3\xB0\x88\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xA0"],
        ["\xF3\xB0\x88\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xAB"],
        ["\xF3\xB0\x88\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7B\xB0"],
        ["\xF3\xB0\x88\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xF3\xB0\x88\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7F"],
        ["\xF3\xB0\x88\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xF3\xB0\x88\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xF3\xB0\x88\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xF3\xB0\x88\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xF3\xB0\x88\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xF3\xB0\x88\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xF3\xB0\x88\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xF3\xB0\x88\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xF3\xB0\x88\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xF3\xB0\x88\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xF3\xB0\x88\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xF3\xB0\x88\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xF3\xB0\x88\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xF3\xB0\x88\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xF3\xB0\x88\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xF3\xB0\x88\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xF3\xB0\x88\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xF3\xB0\x88\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xF3\xB0\x88\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xF3\xB0\x88\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xF3\xB0\x88\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xF3\xB0\x88\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xF3\xB0\x88\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xF3\xB0\x88\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xF3\xB0\x88\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xF3\xB0\x88\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xF3\xB0\x88\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xF3\xB0\x88\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xF3\xB0\x88\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xF3\xB0\x88\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xF3\xB0\x88\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xF3\xB0\x88\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xF3\xB0\x88\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xF3\xB0\x88\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xF3\xB0\x88\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xF3\xB0\x88\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xF3\xB0\x89\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xF3\xB0\x89\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xF3\xB0\x89\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xF3\xB0\x89\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xF3\xB0\x89\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xF3\xB0\x89\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xF3\xB0\x89\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xF3\xB0\x89\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xF3\xB0\x89\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xF3\xB0\x89\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xF3\xB0\x89\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xF3\xB0\x89\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xF3\xB0\x89\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xF3\xB0\x89\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xF3\xB0\x89\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xF3\xB0\x89\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xF3\xB0\x89\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xF3\xB0\x89\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xF3\xB0\x89\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xF3\xB0\x89\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xF3\xB0\x89\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xF3\xB0\x89\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xF3\xB0\x89\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xF3\xB0\x89\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xF3\xB0\x89\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xF3\xB0\x89\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xF3\xB0\x89\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xF3\xB0\x89\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xF3\xB0\x89\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xF3\xB0\x89\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xF3\xB0\x89\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xF3\xB0\x89\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xF3\xB0\x89\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xF3\xB0\x89\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xF3\xB0\x89\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xF3\xB0\x89\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xF3\xB0\x89\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xF3\xB0\x89\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xF3\xB0\x89\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xF3\xB0\x89\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xF3\xB0\x89\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xF3\xB0\x89\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xF3\xB0\x89\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xF3\xB0\x89\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xF3\xB0\x89\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xF3\xB0\x89\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4F"],
        ["\xF3\xB0\x89\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7F"],
        ["\xF3\xB0\x89\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7B"],
        ["\xF3\xB0\x89\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE0"],
        ["\xF3\xB0\x89\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6C"],
        ["\xF3\xB0\x89\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x50"],
        ["\xF3\xB0\x89\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7D"],
        ["\xF3\xB0\x89\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4D"],
        ["\xF3\xB0\x8A\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5D"],
        ["\xF3\xB0\x8A\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5C"],
        ["\xF3\xB0\x8A\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4E"],
        ["\xF3\xB0\x8A\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6B"],
        ["\xF3\xB0\x8A\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x60"],
        ["\xF3\xB0\x8A\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4B"],
        ["\xF3\xB0\x8A\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x61"],
        ["\xF3\xB0\x8A\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF0"],
        ["\xF3\xB0\x8A\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF1"],
        ["\xF3\xB0\x8A\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF2"],
        ["\xF3\xB0\x8A\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF3"],
        ["\xF3\xB0\x8A\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF4"],
        ["\xF3\xB0\x8A\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF5"],
        ["\xF3\xB0\x8A\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF6"],
        ["\xF3\xB0\x8A\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF7"],
        ["\xF3\xB0\x8A\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF8"],
        ["\xF3\xB0\x8A\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xF9"],
        ["\xF3\xB0\x8A\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7A"],
        ["\xF3\xB0\x8A\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5E"],
        ["\xF3\xB0\x8A\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4C"],
        ["\xF3\xB0\x8A\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7E"],
        ["\xF3\xB0\x8A\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6E"],
        ["\xF3\xB0\x8A\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6F"],
        ["\xF3\xB0\x8A\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x7C"],
        ["\xF3\xB0\x8A\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC1"],
        ["\xF3\xB0\x8A\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC2"],
        ["\xF3\xB0\x8A\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC3"],
        ["\xF3\xB0\x8A\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC4"],
        ["\xF3\xB0\x8A\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC5"],
        ["\xF3\xB0\x8A\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC6"],
        ["\xF3\xB0\x8A\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC7"],
        ["\xF3\xB0\x8A\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC8"],
        ["\xF3\xB0\x8A\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xC9"],
        ["\xF3\xB0\x8A\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD1"],
        ["\xF3\xB0\x8A\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD2"],
        ["\xF3\xB0\x8A\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD3"],
        ["\xF3\xB0\x8A\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD4"],
        ["\xF3\xB0\x8A\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD5"],
        ["\xF3\xB0\x8A\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD6"],
        ["\xF3\xB0\x8A\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD7"],
        ["\xF3\xB0\x8A\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD8"],
        ["\xF3\xB0\x8A\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xD9"],
        ["\xF3\xB0\x8A\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE2"],
        ["\xF3\xB0\x8A\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE3"],
        ["\xF3\xB0\x8A\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE4"],
        ["\xF3\xB0\x8A\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE5"],
        ["\xF3\xB0\x8A\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE6"],
        ["\xF3\xB0\x8A\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE7"],
        ["\xF3\xB0\x8A\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE8"],
        ["\xF3\xB0\x8A\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\xE9"],
        ["\xF3\xB0\x8A\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x4A"],
        ["\xF3\xB0\x8A\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5B"],
        ["\xF3\xB0\x8A\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5A"],
        ["\xF3\xB0\x8A\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x5F"],
        ["\xF3\xB0\x8A\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x6D"],
        ["\xF3\xB0\x8A\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x79"],
        ["\xF3\xB0\x8A\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x57"],
        ["\xF3\xB0\x8A\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x59"],
        ["\xF3\xB0\x8A\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x62"],
        ["\xF3\xB0\x8A\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x63"],
        ["\xF3\xB0\x8A\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x64"],
        ["\xF3\xB0\x8A\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x65"],
        ["\xF3\xB0\x8A\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x66"],
        ["\xF3\xB0\x8A\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x67"],
        ["\xF3\xB0\x8B\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x68"],
        ["\xF3\xB0\x8B\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x69"],
        ["\xF3\xB0\x8B\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x70"],
        ["\xF3\xB0\x8B\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x71"],
        ["\xF3\xB0\x8B\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x72"],
        ["\xF3\xB0\x8B\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x73"],
        ["\xF3\xB0\x8B\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x74"],
        ["\xF3\xB0\x8B\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x75"],
        ["\xF3\xB0\x8B\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x76"],
        ["\xF3\xB0\x8B\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x77"],
        ["\xF3\xB0\x8B\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x78"],
        ["\xF3\xB0\x8B\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x80"],
        ["\xF3\xB0\x8B\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x8B"],
        ["\xF3\xB0\x8B\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6C\x9B"],
        ["\xF3\xB0\x8B\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\xF3\xB0\x8B\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7F"],
        ["\xF3\xB0\x8B\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\xF3\xB0\x8B\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xE0"],
        ["\xF3\xB0\x8B\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\xF3\xB0\x8B\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\xF3\xB0\x8B\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\xF3\xB0\x8B\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\xF3\xB0\x8B\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\xF3\xB0\x8B\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\xF3\xB0\x8B\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\xF3\xB0\x8B\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\xF3\xB0\x8B\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\xF3\xB0\x8B\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\xF3\xB0\x8B\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\xF3\xB0\x8B\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF0"],
        ["\xF3\xB0\x8B\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF1"],
        ["\xF3\xB0\x8B\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF2"],
        ["\xF3\xB0\x8B\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF3"],
        ["\xF3\xB0\x8B\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF4"],
        ["\xF3\xB0\x8B\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF5"],
        ["\xF3\xB0\x8B\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF6"],
        ["\xF3\xB0\x8B\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF7"],
        ["\xF3\xB0\x8B\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xF8"],
        ["\xF3\xB0\x8B\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC1"],
        ["\xF3\xB0\x8B\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC2"],
        ["\xF3\xB0\x8B\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC3"],
        ["\xF3\xB0\x8B\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],
        ["\xF3\xB0\x8B\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC5"],
        ["\xF3\xB0\x8B\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC6"],
        ["\xF3\xB0\x8B\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC7"],
        ["\xF3\xB0\x8B\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC8"],
        ["\xF3\xB0\x8B\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\xF3\xB0\x8B\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD1"],
        ["\xF3\xB0\x8C\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD2"],
        ["\xF3\xB0\x8C\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD3"],
        ["\xF3\xB0\x8C\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD4"],
        ["\xF3\xB0\x8C\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD5"],
        ["\xF3\xB0\x8C\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD6"],
        ["\xF3\xB0\x8C\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],
        ["\xF3\xB0\x8C\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD8"],
        ["\xF3\xB0\x8C\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xD9"],
        ["\xF3\xB0\x8C\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xE2"],
        ["\xF3\xB0\x8C\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xE3"],
        ["\xF3\xB0\x8C\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xE4"],
        ["\xF3\xB0\x8C\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xE5"],
        ["\xF3\xB0\x8C\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xE6"],
        ["\xF3\xB0\x8C\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x50\xE7"],
        ["\xF3\xB0\x8C\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x4F"],
        ["\xF3\xB0\x8C\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x7F"],
        ["\xF3\xB0\x8C\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x7B"],
        ["\xF3\xB0\x8C\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE0"],
        ["\xF3\xB0\x8C\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x6C"],
        ["\xF3\xB0\x8C\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x50"],
        ["\xF3\xB0\x8C\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x7D"],
        ["\xF3\xB0\x8C\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x4D"],
        ["\xF3\xB0\x8C\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x5D"],
        ["\xF3\xB0\x8C\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x5C"],
        ["\xF3\xB0\x8C\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x4E"],
        ["\xF3\xB0\x8C\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x6B"],
        ["\xF3\xB0\x8D\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x60"],
        ["\xF3\xB0\x8D\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x4B"],
        ["\xF3\xB0\x8D\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x61"],
        ["\xF3\xB0\x8D\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF0"],
        ["\xF3\xB0\x8D\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF1"],
        ["\xF3\xB0\x8D\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF2"],
        ["\xF3\xB0\x8D\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF3"],
        ["\xF3\xB0\x8D\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF4"],
        ["\xF3\xB0\x8D\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF5"],
        ["\xF3\xB0\x8D\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF6"],
        ["\xF3\xB0\x8D\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF7"],
        ["\xF3\xB0\x8D\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF8"],
        ["\xF3\xB0\x8D\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xF9"],
        ["\xF3\xB0\x8D\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x7A"],
        ["\xF3\xB0\x8D\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x5E"],
        ["\xF3\xB0\x8D\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x4C"],
        ["\xF3\xB0\x8D\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x7E"],
        ["\xF3\xB0\x8D\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x6E"],
        ["\xF3\xB0\x8D\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x6F"],
        ["\xF3\xB0\x8D\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x7C"],
        ["\xF3\xB0\x8D\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xC1"],
        ["\xF3\xB0\x8D\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xD8"],
        ["\xF3\xB0\x8D\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xD9"],
        ["\xF3\xB0\x8D\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE2"],
        ["\xF3\xB0\x8D\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE3"],
        ["\xF3\xB0\x8D\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE4"],
        ["\xF3\xB0\x8D\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE5"],
        ["\xF3\xB0\x8D\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE6"],
        ["\xF3\xB0\x8D\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE7"],
        ["\xF3\xB0\x8D\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE8"],
        ["\xF3\xB0\x8D\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\xE9"],
        ["\xF3\xB0\x8D\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x4A"],
        ["\xF3\xB0\x8D\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x5B"],
        ["\xF3\xB0\x8D\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x5A"],
        ["\xF3\xB0\x8D\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x5F"],
        ["\xF3\xB0\x8D\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x6D"],
        ["\xF3\xB0\x8D\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x79"],
        ["\xF3\xB0\x8D\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x57"],
        ["\xF3\xB0\x8D\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x59"],
        ["\xF3\xB0\x8D\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x62"],
        ["\xF3\xB0\x8D\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x63"],
        ["\xF3\xB0\x8D\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x64"],
        ["\xF3\xB0\x8D\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x65"],
        ["\xF3\xB0\x8D\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x66"],
        ["\xF3\xB0\x8D\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x67"],
        ["\xF3\xB0\x8D\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x68"],
        ["\xF3\xB0\x8D\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x69"],
        ["\xF3\xB0\x8D\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x70"],
        ["\xF3\xB0\x8D\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x71"],
        ["\xF3\xB0\x8E\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x72"],
        ["\xF3\xB0\x8E\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x73"],
        ["\xF3\xB0\x8E\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x74"],
        ["\xF3\xB0\x8E\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x75"],
        ["\xF3\xB0\x8E\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7D\x76"],
        ["\xF3\xB0\x8E\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE0"],
        ["\xF3\xB0\x8E\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x50"],
        ["\xF3\xB0\x8E\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xF0"],
        ["\xF3\xB0\x8E\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xF4"],
        ["\xF3\xB0\x8E\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4C"],
        ["\xF3\xB0\x8E\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xF8"],
        ["\xF3\xB0\x8E\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x7C"],
        ["\xF3\xB0\x8E\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xD7"],
        ["\xF3\xB0\x8E\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC8"],
        ["\xF3\xB0\x8E\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE7"],
        ["\xF3\xB0\x8E\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x79"],
        ["\xF3\xB0\x8E\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6C"],
        ["\xF3\xB0\x8E\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x7D"],
        ["\xF3\xB0\x8E\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xF3"],
        ["\xF3\xB0\x8E\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xF7"],
        ["\xF3\xB0\x8E\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6F"],
        ["\xF3\xB0\x8E\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5E"],
        ["\xF3\xB0\x8E\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC7"],
        ["\xF3\xB0\x8E\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE6"],
        ["\xF3\xB0\x8E\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xD6"],
        ["\xF3\xB0\x8E\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x6D"],
        ["\xF3\xB0\x8E\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x74"],
        ["\xF3\xB0\x8E\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC4"],
        ["\xF3\xB0\x8E\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE2"],
        ["\xF3\xB0\x8E\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xD3"],
        ["\xF3\xB0\x8E\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x4A"],
        ["\xF3\xB0\x8E\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x62"],
        ["\xF3\xB0\x8E\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC1"],
        ["\xF3\xB0\x8E\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xE3"],
        ["\xF3\xB0\x8E\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\xC9"],
        ["\xF3\xB0\x8E\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x5B"],
        ["\xF3\xB0\x8E\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6B\x65"],
        ["\xF3\xB0\x95\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],
        ["\xF3\xB0\x95\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7F"],
        ["\xF3\xB0\x95\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\xF3\xB0\x95\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\xF3\xB0\x95\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\xF3\xB0\x95\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\xF3\xB0\x95\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\xF3\xB0\x95\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\xF3\xB0\x95\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\xF3\xB0\x95\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\xF3\xB0\x95\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\xF3\xB0\x95\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\xF3\xB0\x95\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\xF3\xB0\x95\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\xF3\xB0\x95\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\xF3\xB0\x95\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],
        ["\xF3\xB0\x95\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\xF3\xB0\x95\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\xF3\xB0\x95\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],
        ["\xF3\xB0\x95\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],
        ["\xF3\xB0\x95\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF5"],
        ["\xF3\xB0\x95\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF6"],
        ["\xF3\xB0\x95\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF7"],
        ["\xF3\xB0\x95\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\xF3\xB0\x96\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xF9"],
        ["\xF3\xB0\x96\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\xF3\xB0\x96\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\xF3\xB0\x96\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\xF3\xB0\x96\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\xF3\xB0\x96\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\xF3\xB0\x96\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\xF3\xB0\x96\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],
        ["\xF3\xB0\x96\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],
        ["\xF3\xB0\x96\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC3"],
        ["\xF3\xB0\x96\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"],
        ["\xF3\xB0\x96\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],
        ["\xF3\xB0\x96\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC6"],
        ["\xF3\xB0\x96\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\xF3\xB0\x96\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC8"],
        ["\xF3\xB0\x96\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],
        ["\xF3\xB0\x96\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\xF3\xB0\x96\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],
        ["\xF3\xB0\x96\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\xF3\xB0\x96\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD4"],
        ["\xF3\xB0\x96\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD5"],
        ["\xF3\xB0\x96\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\xF3\xB0\x96\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\xF3\xB0\x96\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],
        ["\xF3\xB0\x96\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xD9"],
        ["\xF3\xB0\x96\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],
        ["\xF3\xB0\x96\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\xF3\xB0\x96\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],
        ["\xF3\xB0\x96\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xE5"],
        ["\xF3\xB0\x96\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\xF3\xB0\x96\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\xF3\xB0\x96\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\xF3\xB0\x96\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],
        ["\xF3\xB0\x96\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\xF3\xB0\x96\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\xF3\xB0\x96\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\xF3\xB0\x96\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\xF3\xB0\x96\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\xF3\xB0\x96\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\xF3\xB0\x96\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\xF3\xB0\x96\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\xF3\xB0\x96\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\xF3\xB0\x96\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\xF3\xB0\x96\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\xF3\xB0\x96\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\xF3\xB0\x96\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\xF3\xB0\x96\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\xF3\xB0\x96\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\x80"],
        ["\xF3\xB0\x96\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xA0"],
        ["\xF3\xB0\x97\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],
        ["\xF3\xB0\x9A\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4F"],
        ["\xF3\xB0\x9A\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7F"],
        ["\xF3\xB0\x9A\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7B"],
        ["\xF3\xB0\x9A\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],
        ["\xF3\xB0\x9A\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6C"],
        ["\xF3\xB0\x9A\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x50"],
        ["\xF3\xB0\x9A\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7D"],
        ["\xF3\xB0\x9A\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4D"],
        ["\xF3\xB0\x9A\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5D"],
        ["\xF3\xB0\x9A\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5C"],
        ["\xF3\xB0\x9A\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4E"],
        ["\xF3\xB0\x9A\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6B"],
        ["\xF3\xB0\x9A\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x60"],
        ["\xF3\xB0\x9A\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4B"],
        ["\xF3\xB0\x9A\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x61"],
        ["\xF3\xB0\x9A\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],
        ["\xF3\xB0\x9A\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],
        ["\xF3\xB0\x9A\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],
        ["\xF3\xB0\x9A\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"],
        ["\xF3\xB0\x9A\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],
        ["\xF3\xB0\x9A\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],
        ["\xF3\xB0\x9A\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],
        ["\xF3\xB0\x9A\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],
        ["\xF3\xB0\x9A\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],
        ["\xF3\xB0\x9A\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],
        ["\xF3\xB0\x9A\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7A"],
        ["\xF3\xB0\x9A\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5E"],
        ["\xF3\xB0\x9A\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4C"],
        ["\xF3\xB0\x9A\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7E"],
        ["\xF3\xB0\x9A\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6E"],
        ["\xF3\xB0\x9A\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6F"],
        ["\xF3\xB0\x9A\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x7C"],
        ["\xF3\xB0\x9A\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],
        ["\xF3\xB0\x9A\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],
        ["\xF3\xB0\x9A\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],
        ["\xF3\xB0\x9A\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],
        ["\xF3\xB0\x9A\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],
        ["\xF3\xB0\x9A\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],
        ["\xF3\xB0\x9A\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],
        ["\xF3\xB0\x9A\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],
        ["\xF3\xB0\x9A\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],
        ["\xF3\xB0\x9A\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],
        ["\xF3\xB0\x9A\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],
        ["\xF3\xB0\x9A\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],
        ["\xF3\xB0\x9A\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],
        ["\xF3\xB0\x9A\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],
        ["\xF3\xB0\x9A\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],
        ["\xF3\xB0\x9A\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],
        ["\xF3\xB0\x9A\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],
        ["\xF3\xB0\x9A\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],
        ["\xF3\xB0\x9A\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],
        ["\xF3\xB0\x9A\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],
        ["\xF3\xB0\x9A\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],
        ["\xF3\xB0\x9A\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],
        ["\xF3\xB0\x9A\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],
        ["\xF3\xB0\x9A\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],
        ["\xF3\xB0\x9A\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],
        ["\xF3\xB0\x9A\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],
        ["\xF3\xB0\x9A\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x4A"],
        ["\xF3\xB0\x9A\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5B"],
        ["\xF3\xB0\x9A\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5A"],
        ["\xF3\xB0\x9A\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x5F"],
        ["\xF3\xB0\x9B\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6D"],
        ["\xF3\xB0\x9B\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x79"],
        ["\xF3\xB0\x9B\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x57"],
        ["\xF3\xB0\x9B\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x59"],
        ["\xF3\xB0\x9B\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x62"],
        ["\xF3\xB0\x9B\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x63"],
        ["\xF3\xB0\x9B\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x64"],
        ["\xF3\xB0\x9B\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x65"],
        ["\xF3\xB0\x9B\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x66"],
        ["\xF3\xB0\x9B\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x67"],
        ["\xF3\xB0\x9B\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x68"],
        ["\xF3\xB0\x9B\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x69"],
        ["\xF3\xB0\x9B\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x70"],
        ["\xF3\xB0\x9B\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x71"],
        ["\xF3\xB0\x9B\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x72"],
        ["\xF3\xB0\x9B\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x73"],
        ["\xF3\xB0\x9B\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x74"],
        ["\xF3\xB0\x9B\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x75"],
        ["\xF3\xB0\x9B\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x76"],
        ["\xF3\xB0\x9B\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x77"],
        ["\xF3\xB0\x9B\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x78"],
        ["\xF3\xB0\x9B\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x80"],
        ["\xF3\xB0\x9B\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x8B"],
        ["\xF3\xB0\x9B\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9B"],
        ["\xF3\xB0\x9B\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x9C"],
        ["\xF3\xB0\x9B\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA0"],
        ["\xF3\xB0\x9B\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],
        ["\xF3\xB0\x9B\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],
        ["\xF3\xB0\x9B\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],
        ["\xF3\xB0\x9B\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\x6A"],
        ["\xF3\xB0\x9B\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],
        ["\xF3\xB0\x9B\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],
        ["\xF3\xB0\x9B\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4F"],
        ["\xF3\xB0\x9B\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7F"],
        ["\xF3\xB0\x9B\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7B"],
        ["\xF3\xB0\x9B\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],
        ["\xF3\xB0\x9B\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6C"],
        ["\xF3\xB0\x9B\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x50"],
        ["\xF3\xB0\x9B\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7D"],
        ["\xF3\xB0\x9B\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4D"],
        ["\xF3\xB0\x9B\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5D"],
        ["\xF3\xB0\x9B\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5C"],
        ["\xF3\xB0\x9B\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4E"],
        ["\xF3\xB0\x9B\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6B"],
        ["\xF3\xB0\x9B\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x60"],
        ["\xF3\xB0\x9B\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4B"],
        ["\xF3\xB0\x9B\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x61"],
        ["\xF3\xB0\x9B\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],
        ["\xF3\xB0\x9B\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],
        ["\xF3\xB0\x9B\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],
        ["\xF3\xB0\x9B\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],
        ["\xF3\xB0\x9B\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],
        ["\xF3\xB0\x9B\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],
        ["\xF3\xB0\x9B\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],
        ["\xF3\xB0\x9B\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],
        ["\xF3\xB0\x9B\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],
        ["\xF3\xB0\x9B\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],
        ["\xF3\xB0\x9B\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7A"],
        ["\xF3\xB0\x9B\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5E"],
        ["\xF3\xB0\x9B\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4C"],
        ["\xF3\xB0\x9B\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7E"],
        ["\xF3\xB0\x9B\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6E"],
        ["\xF3\xB0\x9B\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6F"],
        ["\xF3\xB0\x9B\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x7C"],
        ["\xF3\xB0\x9C\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],
        ["\xF3\xB0\x9C\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],
        ["\xF3\xB0\x9C\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],
        ["\xF3\xB0\x9C\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],
        ["\xF3\xB0\x9C\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],
        ["\xF3\xB0\x9C\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],
        ["\xF3\xB0\x9C\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],
        ["\xF3\xB0\x9C\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],
        ["\xF3\xB0\x9C\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],
        ["\xF3\xB0\x9C\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],
        ["\xF3\xB0\x9C\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],
        ["\xF3\xB0\x9C\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],
        ["\xF3\xB0\x9C\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],
        ["\xF3\xB0\x9C\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],
        ["\xF3\xB0\x9C\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],
        ["\xF3\xB0\x9C\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],
        ["\xF3\xB0\x9C\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],
        ["\xF3\xB0\x9C\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],
        ["\xF3\xB0\x9C\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],
        ["\xF3\xB0\x9C\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],
        ["\xF3\xB0\x9C\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],
        ["\xF3\xB0\x9C\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],
        ["\xF3\xB0\x9C\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],
        ["\xF3\xB0\x9C\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],
        ["\xF3\xB0\x9C\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],
        ["\xF3\xB0\x9C\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],
        ["\xF3\xB0\x9C\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x4A"],
        ["\xF3\xB0\x9C\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5B"],
        ["\xF3\xB0\x9C\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5A"],
        ["\xF3\xB0\x9C\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x5F"],
        ["\xF3\xB0\x9C\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6D"],
        ["\xF3\xB0\x9C\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x79"],
        ["\xF3\xB0\x9C\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x57"],
        ["\xF3\xB0\x9C\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x59"],
        ["\xF3\xB0\x9C\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x62"],
        ["\xF3\xB0\x9C\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x63"],
        ["\xF3\xB0\x9C\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x64"],
        ["\xF3\xB0\x9C\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x65"],
        ["\xF3\xB0\x9C\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x66"],
        ["\xF3\xB0\x9C\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x67"],
        ["\xF3\xB0\x9C\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x68"],
        ["\xF3\xB0\x9C\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x69"],
        ["\xF3\xB0\x9C\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x70"],
        ["\xF3\xB0\x9C\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x71"],
        ["\xF3\xB0\x9C\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x72"],
        ["\xF3\xB0\x9C\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x73"],
        ["\xF3\xB0\x9C\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x74"],
        ["\xF3\xB0\x9C\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x75"],
        ["\xF3\xB0\x9C\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x76"],
        ["\xF3\xB0\x9C\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x77"],
        ["\xF3\xB0\x9C\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x78"],
        ["\xF3\xB0\x9C\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x80"],
        ["\xF3\xB0\x9C\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x8B"],
        ["\xF3\xB0\x9C\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9B"],
        ["\xF3\xB0\x9C\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x9C"],
        ["\xF3\xB0\x9C\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA0"],
        ["\xF3\xB0\x9C\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],
        ["\xF3\xB0\x9C\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],
        ["\xF3\xB0\x9C\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],
        ["\xF3\xB0\x9C\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\x6A"],
        ["\xF3\xB0\x9C\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],
        ["\xF3\xB0\x9C\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],
        ["\xF3\xB0\x9C\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4F"],
        ["\xF3\xB0\x9C\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7F"],
        ["\xF3\xB0\x9D\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7B"],
        ["\xF3\xB0\x9D\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],
        ["\xF3\xB0\x9D\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6C"],
        ["\xF3\xB0\x9D\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x50"],
        ["\xF3\xB0\x9D\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7D"],
        ["\xF3\xB0\x9D\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4D"],
        ["\xF3\xB0\x9D\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x80"],
        ["\xF3\xB0\x9D\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5C"],
        ["\xF3\xB0\x9D\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4E"],
        ["\xF3\xB0\x9D\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6B"],
        ["\xF3\xB0\x9D\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x60"],
        ["\xF3\xB0\x9D\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4B"],
        ["\xF3\xB0\x9D\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x61"],
        ["\xF3\xB0\x9D\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],
        ["\xF3\xB0\x9D\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],
        ["\xF3\xB0\x9D\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],
        ["\xF3\xB0\x9D\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],
        ["\xF3\xB0\x9D\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],
        ["\xF3\xB0\x9D\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],
        ["\xF3\xB0\x9D\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],
        ["\xF3\xB0\x9D\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],
        ["\xF3\xB0\x9D\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],
        ["\xF3\xB0\x9D\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],
        ["\xF3\xB0\x9D\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7A"],
        ["\xF3\xB0\x9D\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5E"],
        ["\xF3\xB0\x9D\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4C"],
        ["\xF3\xB0\x9D\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7E"],
        ["\xF3\xB0\x9D\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6E"],
        ["\xF3\xB0\x9D\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6F"],
        ["\xF3\xB0\x9D\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x7C"],
        ["\xF3\xB0\x9D\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],
        ["\xF3\xB0\x9D\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],
        ["\xF3\xB0\x9D\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],
        ["\xF3\xB0\x9D\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],
        ["\xF3\xB0\x9D\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],
        ["\xF3\xB0\x9D\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],
        ["\xF3\xB0\x9D\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],
        ["\xF3\xB0\x9D\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],
        ["\xF3\xB0\x9D\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],
        ["\xF3\xB0\x9D\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],
        ["\xF3\xB0\x9D\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],
        ["\xF3\xB0\x9D\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],
        ["\xF3\xB0\x9D\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],
        ["\xF3\xB0\x9D\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],
        ["\xF3\xB0\x9D\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],
        ["\xF3\xB0\x9D\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],
        ["\xF3\xB0\x9D\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],
        ["\xF3\xB0\x9D\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],
        ["\xF3\xB0\x9D\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],
        ["\xF3\xB0\x9D\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],
        ["\xF3\xB0\x9D\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],
        ["\xF3\xB0\x9D\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],
        ["\xF3\xB0\x9D\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],
        ["\xF3\xB0\x9D\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],
        ["\xF3\xB0\x9D\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],
        ["\xF3\xB0\x9D\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],
        ["\xF3\xB0\x9D\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x4A"],
        ["\xF3\xB0\x9D\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5B"],
        ["\xF3\xB0\x9D\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5A"],
        ["\xF3\xB0\x9D\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5F"],
        ["\xF3\xB0\x9D\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6D"],
        ["\xF3\xB0\x9D\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x79"],
        ["\xF3\xB0\x9D\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x57"],
        ["\xF3\xB0\x9D\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x59"],
        ["\xF3\xB0\x9E\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x62"],
        ["\xF3\xB0\x9E\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x63"],
        ["\xF3\xB0\x9E\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x64"],
        ["\xF3\xB0\x9E\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x65"],
        ["\xF3\xB0\x9E\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x66"],
        ["\xF3\xB0\x9E\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x67"],
        ["\xF3\xB0\x9E\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x68"],
        ["\xF3\xB0\x9E\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x69"],
        ["\xF3\xB0\x9E\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x70"],
        ["\xF3\xB0\x9E\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x71"],
        ["\xF3\xB0\x9E\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x72"],
        ["\xF3\xB0\x9E\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x73"],
        ["\xF3\xB0\x9E\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x74"],
        ["\xF3\xB0\x9E\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x75"],
        ["\xF3\xB0\x9E\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x76"],
        ["\xF3\xB0\x9E\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x77"],
        ["\xF3\xB0\x9E\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x78"],
        ["\xF3\xB0\x9E\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x80"],
        ["\xF3\xB0\x9E\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x8B"],
        ["\xF3\xB0\x9E\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9B"],
        ["\xF3\xB0\x9E\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x9C"],
        ["\xF3\xB0\x9E\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA0"],
        ["\xF3\xB0\x9E\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],
        ["\xF3\xB0\x9E\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],
        ["\xF3\xB0\x9E\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],
        ["\xF3\xB0\x9E\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x6A"],
        ["\xF3\xB0\x9E\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],
        ["\xF3\xB0\x9E\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],
        ["\xF3\xB0\x9E\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4F"],
        ["\xF3\xB0\x9E\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7F"],
        ["\xF3\xB0\x9E\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7B"],
        ["\xF3\xB0\x9E\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE0"],
        ["\xF3\xB0\x9E\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6C"],
        ["\xF3\xB0\x9E\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x50"],
        ["\xF3\xB0\x9E\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7D"],
        ["\xF3\xB0\x9E\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4D"],
        ["\xF3\xB0\x9E\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5D"],
        ["\xF3\xB0\x9E\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5C"],
        ["\xF3\xB0\x9E\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4E"],
        ["\xF3\xB0\x9E\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6B"],
        ["\xF3\xB0\x9E\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x60"],
        ["\xF3\xB0\x9E\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4B"],
        ["\xF3\xB0\x9E\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x61"],
        ["\xF3\xB0\x9E\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF0"],
        ["\xF3\xB0\x9E\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF1"],
        ["\xF3\xB0\x9E\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF2"],
        ["\xF3\xB0\x9E\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF3"],
        ["\xF3\xB0\x9E\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF4"],
        ["\xF3\xB0\x9E\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF5"],
        ["\xF3\xB0\x9E\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF6"],
        ["\xF3\xB0\x9E\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF7"],
        ["\xF3\xB0\x9E\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF8"],
        ["\xF3\xB0\x9E\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xF9"],
        ["\xF3\xB0\x9E\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7A"],
        ["\xF3\xB0\x9E\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5E"],
        ["\xF3\xB0\x9E\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4C"],
        ["\xF3\xB0\x9E\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7E"],
        ["\xF3\xB0\x9E\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6E"],
        ["\xF3\xB0\x9E\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6F"],
        ["\xF3\xB0\x9E\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x7C"],
        ["\xF3\xB0\x9E\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],
        ["\xF3\xB0\x9E\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE9"],
        ["\xF3\xB0\x9E\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],
        ["\xF3\xB0\x9E\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],
        ["\xF3\xB0\x9F\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],
        ["\xF3\xB0\x9F\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],
        ["\xF3\xB0\x9F\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],
        ["\xF3\xB0\x9F\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],
        ["\xF3\xB0\x9F\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xF3\xB0\x9F\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD1"],
        ["\xF3\xB0\x9F\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD2"],
        ["\xF3\xB0\x9F\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD3"],
        ["\xF3\xB0\x9F\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD4"],
        ["\xF3\xB0\x9F\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD5"],
        ["\xF3\xB0\x9F\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD6"],
        ["\xF3\xB0\x9F\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD7"],
        ["\xF3\xB0\x9F\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD8"],
        ["\xF3\xB0\x9F\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD9"],
        ["\xF3\xB0\x9F\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE2"],
        ["\xF3\xB0\x9F\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE3"],
        ["\xF3\xB0\x9F\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE4"],
        ["\xF3\xB0\x9F\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE5"],
        ["\xF3\xB0\x9F\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE6"],
        ["\xF3\xB0\x9F\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE7"],
        ["\xF3\xB0\x9F\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE8"],
        ["\xF3\xB0\x9F\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xE9"],
        ["\xF3\xB0\x9F\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x4A"],
        ["\xF3\xB0\x9F\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5B"],
        ["\xF3\xB0\x9F\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5A"],
        ["\xF3\xB0\x9F\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x5F"],
        ["\xF3\xB0\x9F\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6D"],
        ["\xF3\xB0\x9F\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x79"],
        ["\xF3\xB0\x9F\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x57"],
        ["\xF3\xB0\x9F\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x59"],
        ["\xF3\xB0\x9F\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x62"],
        ["\xF3\xB0\x9F\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x63"],
        ["\xF3\xB0\x9F\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x64"],
        ["\xF3\xB0\x9F\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x65"],
        ["\xF3\xB0\x9F\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x66"],
        ["\xF3\xB0\x9F\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x67"],
        ["\xF3\xB0\x9F\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x68"],
        ["\xF3\xB0\x9F\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x69"],
        ["\xF3\xB0\x9F\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x70"],
        ["\xF3\xB0\x9F\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x71"],
        ["\xF3\xB0\x9F\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x72"],
        ["\xF3\xB0\x9F\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x73"],
        ["\xF3\xB0\x9F\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x74"],
        ["\xF3\xB0\x9F\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x75"],
        ["\xF3\xB0\x9F\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x76"],
        ["\xF3\xB0\x9F\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x77"],
        ["\xF3\xB0\x9F\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x78"],
        ["\xF3\xB0\x9F\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x80"],
        ["\xF3\xB0\x9F\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x8B"],
        ["\xF3\xB0\x9F\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\xF3\xB0\x9F\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9C"],
        ["\xF3\xB0\x9F\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA0"],
        ["\xF3\xB0\x9F\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],
        ["\xF3\xB0\x9F\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],
        ["\xF3\xB0\x9F\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],
        ["\xF3\xB0\x9F\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x6A"],
        ["\xF3\xB0\x9F\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],
        ["\xF3\xB0\x9F\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],
        ["\xF3\xB0\x9F\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4F"],
        ["\xF3\xB0\x9F\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7F"],
        ["\xF3\xB0\x9F\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7B"],
        ["\xF3\xB0\x9F\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE0"],
        ["\xF3\xB0\x9F\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6C"],
        ["\xF3\xB0\x9F\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x50"],
        ["\xF3\xB0\xA0\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7D"],
        ["\xF3\xB0\xA0\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4D"],
        ["\xF3\xB0\xA0\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5D"],
        ["\xF3\xB0\xA0\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5C"],
        ["\xF3\xB0\xA0\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4E"],
        ["\xF3\xB0\xA0\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6B"],
        ["\xF3\xB0\xA0\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x60"],
        ["\xF3\xB0\xA0\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4B"],
        ["\xF3\xB0\xA0\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x61"],
        ["\xF3\xB0\xA0\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF0"],
        ["\xF3\xB0\xA0\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF1"],
        ["\xF3\xB0\xA0\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF2"],
        ["\xF3\xB0\xA0\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF3"],
        ["\xF3\xB0\xA0\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF4"],
        ["\xF3\xB0\xA0\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF5"],
        ["\xF3\xB0\xA0\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF6"],
        ["\xF3\xB0\xA0\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF7"],
        ["\xF3\xB0\xA0\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF8"],
        ["\xF3\xB0\xA0\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xF9"],
        ["\xF3\xB0\xA0\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7A"],
        ["\xF3\xB0\xA0\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5E"],
        ["\xF3\xB0\xA0\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4C"],
        ["\xF3\xB0\xA0\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7E"],
        ["\xF3\xB0\xA0\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6E"],
        ["\xF3\xB0\xA0\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6F"],
        ["\xF3\xB0\xA0\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x7C"],
        ["\xF3\xB0\xA0\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC1"],
        ["\xF3\xB0\xA0\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC2"],
        ["\xF3\xB0\xA0\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x8B"],
        ["\xF3\xB0\xA0\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC4"],
        ["\xF3\xB0\xA0\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC5"],
        ["\xF3\xB0\xA0\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC6"],
        ["\xF3\xB0\xA0\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC7"],
        ["\xF3\xB0\xA0\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC8"],
        ["\xF3\xB0\xA0\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC9"],
        ["\xF3\xB0\xA0\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD1"],
        ["\xF3\xB0\xA0\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD2"],
        ["\xF3\xB0\xA0\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD3"],
        ["\xF3\xB0\xA0\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD4"],
        ["\xF3\xB0\xA0\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD5"],
        ["\xF3\xB0\xA0\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD6"],
        ["\xF3\xB0\xA0\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD7"],
        ["\xF3\xB0\xA0\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD8"],
        ["\xF3\xB0\xA0\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5A"],
        ["\xF3\xB0\xA0\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE2"],
        ["\xF3\xB0\xA0\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE3"],
        ["\xF3\xB0\xA0\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE4"],
        ["\xF3\xB0\xA0\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE5"],
        ["\xF3\xB0\xA0\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE6"],
        ["\xF3\xB0\xA0\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE7"],
        ["\xF3\xB0\xA0\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE8"],
        ["\xF3\xB0\xA0\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xE9"],
        ["\xF3\xB0\xA0\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x4A"],
        ["\xF3\xB0\xA0\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5B"],
        ["\xF3\xB0\xA0\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5A"],
        ["\xF3\xB0\xA0\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x5F"],
        ["\xF3\xB0\xA0\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6D"],
        ["\xF3\xB0\xA0\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x79"],
        ["\xF3\xB0\xA0\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x57"],
        ["\xF3\xB0\xA0\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x59"],
        ["\xF3\xB0\xA0\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x62"],
        ["\xF3\xB0\xA0\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x63"],
        ["\xF3\xB0\xA0\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x64"],
        ["\xF3\xB0\xA0\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x65"],
        ["\xF3\xB0\xA1\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x66"],
        ["\xF3\xB0\xA1\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x67"],
        ["\xF3\xB0\xA1\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x68"],
        ["\xF3\xB0\xA1\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x69"],
        ["\xF3\xB0\xA1\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x70"],
        ["\xF3\xB0\xA1\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x71"],
        ["\xF3\xB0\xA1\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x72"],
        ["\xF3\xB0\xA1\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x73"],
        ["\xF3\xB0\xA1\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x74"],
        ["\xF3\xB0\xA1\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x75"],
        ["\xF3\xB0\xA1\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x76"],
        ["\xF3\xB0\xA1\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x77"],
        ["\xF3\xB0\xA1\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x78"],
        ["\xF3\xB0\xA1\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x80"],
        ["\xF3\xB0\xA1\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x8B"],
        ["\xF3\xB0\xA1\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9B"],
        ["\xF3\xB0\xA1\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x9C"],
        ["\xF3\xB0\xA1\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA0"],
        ["\xF3\xB0\xA1\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xAB"],
        ["\xF3\xB0\xA1\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xB0"],
        ["\xF3\xB0\xA1\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC0"],
        ["\xF3\xB0\xA1\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\x6A"],
        ["\xF3\xB0\xA1\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD0"],
        ["\xF3\xB0\xA1\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xA1"],
        ["\xF3\xB0\xA1\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4F"],
        ["\xF3\xB0\xA1\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7F"],
        ["\xF3\xB0\xA1\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7B"],
        ["\xF3\xB0\xA1\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE0"],
        ["\xF3\xB0\xA1\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6C"],
        ["\xF3\xB0\xA1\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x50"],
        ["\xF3\xB0\xA1\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7D"],
        ["\xF3\xB0\xA1\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4D"],
        ["\xF3\xB0\xA1\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5D"],
        ["\xF3\xB0\xA1\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5C"],
        ["\xF3\xB0\xA1\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4E"],
        ["\xF3\xB0\xA1\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6B"],
        ["\xF3\xB0\xA1\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x60"],
        ["\xF3\xB0\xA1\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4B"],
        ["\xF3\xB0\xA1\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x61"],
        ["\xF3\xB0\xA1\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF0"],
        ["\xF3\xB0\xA1\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF1"],
        ["\xF3\xB0\xA1\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF2"],
        ["\xF3\xB0\xA1\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF3"],
        ["\xF3\xB0\xA1\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF4"],
        ["\xF3\xB0\xA1\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF5"],
        ["\xF3\xB0\xA1\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF6"],
        ["\xF3\xB0\xA1\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF7"],
        ["\xF3\xB0\xA1\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF8"],
        ["\xF3\xB0\xA1\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xF9"],
        ["\xF3\xB0\xA1\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7A"],
        ["\xF3\xB0\xA1\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5E"],
        ["\xF3\xB0\xA1\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4C"],
        ["\xF3\xB0\xA1\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7E"],
        ["\xF3\xB0\xA1\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6E"],
        ["\xF3\xB0\xA1\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6F"],
        ["\xF3\xB0\xA1\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x7C"],
        ["\xF3\xB0\xA1\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC1"],
        ["\xF3\xB0\xA1\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC2"],
        ["\xF3\xB0\xA1\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC3"],
        ["\xF3\xB0\xA1\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC4"],
        ["\xF3\xB0\xA1\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC5"],
        ["\xF3\xB0\xA1\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC6"],
        ["\xF3\xB0\xA1\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC7"],
        ["\xF3\xB0\xA1\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC8"],
        ["\xF3\xB0\xA2\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC9"],
        ["\xF3\xB0\xA2\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD1"],
        ["\xF3\xB0\xA2\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD2"],
        ["\xF3\xB0\xA2\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD3"],
        ["\xF3\xB0\xA2\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD4"],
        ["\xF3\xB0\xA2\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD5"],
        ["\xF3\xB0\xA2\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD6"],
        ["\xF3\xB0\xA2\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD7"],
        ["\xF3\xB0\xA2\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD8"],
        ["\xF3\xB0\xA2\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD9"],
        ["\xF3\xB0\xA2\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE2"],
        ["\xF3\xB0\xA2\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE3"],
        ["\xF3\xB0\xA2\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE4"],
        ["\xF3\xB0\xA2\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE5"],
        ["\xF3\xB0\xA2\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE6"],
        ["\xF3\xB0\xA2\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE7"],
        ["\xF3\xB0\xA2\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE8"],
        ["\xF3\xB0\xA2\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xE9"],
        ["\xF3\xB0\xA2\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x4A"],
        ["\xF3\xB0\xA2\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5B"],
        ["\xF3\xB0\xA2\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5A"],
        ["\xF3\xB0\xA2\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x5F"],
        ["\xF3\xB0\xA2\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6D"],
        ["\xF3\xB0\xA2\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x79"],
        ["\xF3\xB0\xA2\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x57"],
        ["\xF3\xB0\xA2\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x59"],
        ["\xF3\xB0\xA2\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x62"],
        ["\xF3\xB0\xA2\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x63"],
        ["\xF3\xB0\xA2\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x64"],
        ["\xF3\xB0\xA2\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x65"],
        ["\xF3\xB0\xA2\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x66"],
        ["\xF3\xB0\xA2\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x67"],
        ["\xF3\xB0\xA2\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x68"],
        ["\xF3\xB0\xA2\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x69"],
        ["\xF3\xB0\xA2\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x70"],
        ["\xF3\xB0\xA2\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x71"],
        ["\xF3\xB0\xA2\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x72"],
        ["\xF3\xB0\xA2\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x73"],
        ["\xF3\xB0\xA2\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x74"],
        ["\xF3\xB0\xA2\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x75"],
        ["\xF3\xB0\xA2\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x76"],
        ["\xF3\xB0\xA2\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x77"],
        ["\xF3\xB0\xA2\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x78"],
        ["\xF3\xB0\xA2\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x80"],
        ["\xF3\xB0\xA2\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x8B"],
        ["\xF3\xB0\xA2\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9B"],
        ["\xF3\xB0\xA2\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x9C"],
        ["\xF3\xB0\xA2\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA0"],
        ["\xF3\xB0\xA2\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xAB"],
        ["\xF3\xB0\xA2\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xB0"],
        ["\xF3\xB0\xA2\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xC0"],
        ["\xF3\xB0\xA2\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\x6A"],
        ["\xF3\xB0\xA2\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xD0"],
        ["\xF3\xB0\xA2\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF5\xA1"],
        ["\xF3\xB0\xA2\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4F"],
        ["\xF3\xB0\xA2\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7F"],
        ["\xF3\xB0\xA2\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7B"],
        ["\xF3\xB0\xA2\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE0"],
        ["\xF3\xB0\xA2\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6C"],
        ["\xF3\xB0\xA2\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x50"],
        ["\xF3\xB0\xA2\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7D"],
        ["\xF3\xB0\xA2\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4D"],
        ["\xF3\xB0\xA2\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5D"],
        ["\xF3\xB0\xA2\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5C"],
        ["\xF3\xB0\xA3\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4E"],
        ["\xF3\xB0\xA3\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6B"],
        ["\xF3\xB0\xA3\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x60"],
        ["\xF3\xB0\xA3\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4B"],
        ["\xF3\xB0\xA3\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x61"],
        ["\xF3\xB0\xA3\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF0"],
        ["\xF3\xB0\xA3\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF1"],
        ["\xF3\xB0\xA3\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF2"],
        ["\xF3\xB0\xA3\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF3"],
        ["\xF3\xB0\xA3\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF4"],
        ["\xF3\xB0\xA3\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF5"],
        ["\xF3\xB0\xA3\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF6"],
        ["\xF3\xB0\xA3\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF7"],
        ["\xF3\xB0\xA3\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF8"],
        ["\xF3\xB0\xA3\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xF9"],
        ["\xF3\xB0\xA3\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7A"],
        ["\xF3\xB0\xA3\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5E"],
        ["\xF3\xB0\xA3\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4C"],
        ["\xF3\xB0\xA3\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7E"],
        ["\xF3\xB0\xA3\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6E"],
        ["\xF3\xB0\xA3\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6F"],
        ["\xF3\xB0\xA3\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x7C"],
        ["\xF3\xB0\xA3\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC1"],
        ["\xF3\xB0\xA3\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC2"],
        ["\xF3\xB0\xA3\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC3"],
        ["\xF3\xB0\xA3\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC4"],
        ["\xF3\xB0\xA3\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC5"],
        ["\xF3\xB0\xA3\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBA"],
        ["\xF3\xB0\xA3\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC7"],
        ["\xF3\xB0\xA3\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC8"],
        ["\xF3\xB0\xA3\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC9"],
        ["\xF3\xB0\xA3\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD1"],
        ["\xF3\xB0\xA3\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD2"],
        ["\xF3\xB0\xA3\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD3"],
        ["\xF3\xB0\xA3\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD4"],
        ["\xF3\xB0\xA3\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD5"],
        ["\xF3\xB0\xA3\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD6"],
        ["\xF3\xB0\xA3\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD7"],
        ["\xF3\xB0\xA3\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD8"],
        ["\xF3\xB0\xA3\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD9"],
        ["\xF3\xB0\xA3\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE2"],
        ["\xF3\xB0\xA3\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE3"],
        ["\xF3\xB0\xA3\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE4"],
        ["\xF3\xB0\xA3\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE5"],
        ["\xF3\xB0\xA3\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE6"],
        ["\xF3\xB0\xA3\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE7"],
        ["\xF3\xB0\xA3\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE8"],
        ["\xF3\xB0\xA3\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xE9"],
        ["\xF3\xB0\xA3\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x4A"],
        ["\xF3\xB0\xA3\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5B"],
        ["\xF3\xB0\xA3\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5A"],
        ["\xF3\xB0\xA3\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x5F"],
        ["\xF3\xB0\xA3\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6D"],
        ["\xF3\xB0\xA3\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x79"],
        ["\xF3\xB0\xA3\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x57"],
        ["\xF3\xB0\xA3\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x59"],
        ["\xF3\xB0\xA3\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x62"],
        ["\xF3\xB0\xA3\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x63"],
        ["\xF3\xB0\xA3\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x64"],
        ["\xF3\xB0\xA3\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x65"],
        ["\xF3\xB0\xA3\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x66"],
        ["\xF3\xB0\xA3\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x67"],
        ["\xF3\xB0\xA3\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x68"],
        ["\xF3\xB0\xA3\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x69"],
        ["\xF3\xB0\xA4\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x70"],
        ["\xF3\xB0\xA4\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x71"],
        ["\xF3\xB0\xA4\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x72"],
        ["\xF3\xB0\xA4\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x73"],
        ["\xF3\xB0\xA4\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x74"],
        ["\xF3\xB0\xA4\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x75"],
        ["\xF3\xB0\xA4\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x76"],
        ["\xF3\xB0\xA4\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x77"],
        ["\xF3\xB0\xA4\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x78"],
        ["\xF3\xB0\xA4\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x80"],
        ["\xF3\xB0\xA4\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x8B"],
        ["\xF3\xB0\xA4\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9B"],
        ["\xF3\xB0\xA4\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x9C"],
        ["\xF3\xB0\xA4\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA0"],
        ["\xF3\xB0\xA4\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xAB"],
        ["\xF3\xB0\xA4\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xB0"],
        ["\xF3\xB0\xA4\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC0"],
        ["\xF3\xB0\xA4\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\x6A"],
        ["\xF3\xB0\xA4\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xD0"],
        ["\xF3\xB0\xA4\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xA1"],
        ["\xF3\xB0\xA4\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4F"],
        ["\xF3\xB0\xA4\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7F"],
        ["\xF3\xB0\xA4\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7B"],
        ["\xF3\xB0\xA4\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE0"],
        ["\xF3\xB0\xA4\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6C"],
        ["\xF3\xB0\xA4\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x50"],
        ["\xF3\xB0\xA4\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7D"],
        ["\xF3\xB0\xA4\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4D"],
        ["\xF3\xB0\xA4\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5D"],
        ["\xF3\xB0\xA4\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5C"],
        ["\xF3\xB0\xA4\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4E"],
        ["\xF3\xB0\xA4\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6B"],
        ["\xF3\xB0\xA4\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x60"],
        ["\xF3\xB0\xA4\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4B"],
        ["\xF3\xB0\xA4\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x61"],
        ["\xF3\xB0\xA4\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF0"],
        ["\xF3\xB0\xA4\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF1"],
        ["\xF3\xB0\xA4\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF2"],
        ["\xF3\xB0\xA4\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF3"],
        ["\xF3\xB0\xA4\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF4"],
        ["\xF3\xB0\xA4\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF5"],
        ["\xF3\xB0\xA4\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF6"],
        ["\xF3\xB0\xA4\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF7"],
        ["\xF3\xB0\xA4\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF8"],
        ["\xF3\xB0\xA4\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xF9"],
        ["\xF3\xB0\xA4\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7A"],
        ["\xF3\xB0\xA4\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5E"],
        ["\xF3\xB0\xA4\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4C"],
        ["\xF3\xB0\xA4\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7E"],
        ["\xF3\xB0\xA4\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6E"],
        ["\xF3\xB0\xA4\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6F"],
        ["\xF3\xB0\xA4\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x7C"],
        ["\xF3\xB0\xA4\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC1"],
        ["\xF3\xB0\xA4\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC2"],
        ["\xF3\xB0\xA4\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC3"],
        ["\xF3\xB0\xA4\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC4"],
        ["\xF3\xB0\xA4\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC5"],
        ["\xF3\xB0\xA4\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC6"],
        ["\xF3\xB0\xA4\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC7"],
        ["\xF3\xB0\xA4\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC8"],
        ["\xF3\xB0\xA4\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC9"],
        ["\xF3\xB0\xA4\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD1"],
        ["\xF3\xB0\xA4\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD2"],
        ["\xF3\xB0\xA4\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD3"],
        ["\xF3\xB0\xA5\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD4"],
        ["\xF3\xB0\xA5\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD5"],
        ["\xF3\xB0\xA5\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD6"],
        ["\xF3\xB0\xA5\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD7"],
        ["\xF3\xB0\xA5\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD8"],
        ["\xF3\xB0\xA5\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD9"],
        ["\xF3\xB0\xA5\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE2"],
        ["\xF3\xB0\xA5\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE3"],
        ["\xF3\xB0\xA5\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE4"],
        ["\xF3\xB0\xA5\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE5"],
        ["\xF3\xB0\xA5\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE6"],
        ["\xF3\xB0\xA5\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE7"],
        ["\xF3\xB0\xA5\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE8"],
        ["\xF3\xB0\xA5\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xE9"],
        ["\xF3\xB0\xA5\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x80"],
        ["\xF3\xB0\xA5\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5B"],
        ["\xF3\xB0\xA5\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5A"],
        ["\xF3\xB0\xA5\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x5F"],
        ["\xF3\xB0\xA5\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6D"],
        ["\xF3\xB0\xA5\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x79"],
        ["\xF3\xB0\xA5\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x57"],
        ["\xF3\xB0\xA5\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x59"],
        ["\xF3\xB0\xA5\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x62"],
        ["\xF3\xB0\xA5\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x63"],
        ["\xF3\xB0\xA5\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x64"],
        ["\xF3\xB0\xA5\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x65"],
        ["\xF3\xB0\xA5\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x66"],
        ["\xF3\xB0\xA5\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x67"],
        ["\xF3\xB0\xA5\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x68"],
        ["\xF3\xB0\xA5\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x69"],
        ["\xF3\xB0\xA5\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x70"],
        ["\xF3\xB0\xA5\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x71"],
        ["\xF3\xB0\xA5\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x72"],
        ["\xF3\xB0\xA5\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x73"],
        ["\xF3\xB0\xA5\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x74"],
        ["\xF3\xB0\xA5\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x75"],
        ["\xF3\xB0\xA5\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x76"],
        ["\xF3\xB0\xA5\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x77"],
        ["\xF3\xB0\xA5\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x78"],
        ["\xF3\xB0\xA5\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x80"],
        ["\xF3\xB0\xA5\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x8B"],
        ["\xF3\xB0\xA5\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9B"],
        ["\xF3\xB0\xA5\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x9C"],
        ["\xF3\xB0\xA5\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA0"],
        ["\xF3\xB0\xA5\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xAB"],
        ["\xF3\xB0\xA5\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xB0"],
        ["\xF3\xB0\xA5\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xC0"],
        ["\xF3\xB0\xA5\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x6A"],
        ["\xF3\xB0\xA5\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xD0"],
        ["\xF3\xB0\xA5\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\xA1"],
        ["\xF3\xB0\xA5\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4F"],
        ["\xF3\xB0\xA5\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7F"],
        ["\xF3\xB0\xA5\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7B"],
        ["\xF3\xB0\xA5\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE0"],
        ["\xF3\xB0\xA5\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6C"],
        ["\xF3\xB0\xA5\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x50"],
        ["\xF3\xB0\xA5\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7D"],
        ["\xF3\xB0\xA5\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4D"],
        ["\xF3\xB0\xA5\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5D"],
        ["\xF3\xB0\xA5\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5C"],
        ["\xF3\xB0\xA5\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4E"],
        ["\xF3\xB0\xA5\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6B"],
        ["\xF3\xB0\xA5\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x60"],
        ["\xF3\xB0\xA5\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4B"],
        ["\xF3\xB0\xA6\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x61"],
        ["\xF3\xB0\xA6\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF0"],
        ["\xF3\xB0\xA6\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF1"],
        ["\xF3\xB0\xA6\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF2"],
        ["\xF3\xB0\xA6\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF3"],
        ["\xF3\xB0\xA6\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF4"],
        ["\xF3\xB0\xA6\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF5"],
        ["\xF3\xB0\xA6\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF6"],
        ["\xF3\xB0\xA6\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF7"],
        ["\xF3\xB0\xA6\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF8"],
        ["\xF3\xB0\xA6\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xF9"],
        ["\xF3\xB0\xA6\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7A"],
        ["\xF3\xB0\xA6\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5E"],
        ["\xF3\xB0\xA6\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4C"],
        ["\xF3\xB0\xA6\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7E"],
        ["\xF3\xB0\xA6\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6E"],
        ["\xF3\xB0\xA6\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6F"],
        ["\xF3\xB0\xA6\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x7C"],
        ["\xF3\xB0\xA6\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC1"],
        ["\xF3\xB0\xA6\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC2"],
        ["\xF3\xB0\xA6\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC3"],
        ["\xF3\xB0\xA6\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC4"],
        ["\xF3\xB0\xA6\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC5"],
        ["\xF3\xB0\xA6\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC6"],
        ["\xF3\xB0\xA6\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC7"],
        ["\xF3\xB0\xA6\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC8"],
        ["\xF3\xB0\xA6\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC9"],
        ["\xF3\xB0\xA6\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD1"],
        ["\xF3\xB0\xA6\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD2"],
        ["\xF3\xB0\xA6\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD3"],
        ["\xF3\xB0\xA6\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD4"],
        ["\xF3\xB0\xA6\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD5"],
        ["\xF3\xB0\xA6\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD6"],
        ["\xF3\xB0\xA6\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD7"],
        ["\xF3\xB0\xA6\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD8"],
        ["\xF3\xB0\xA6\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD9"],
        ["\xF3\xB0\xA6\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE2"],
        ["\xF3\xB0\xA6\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE3"],
        ["\xF3\xB0\xA6\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE4"],
        ["\xF3\xB0\xA6\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE5"],
        ["\xF3\xB0\xA6\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE6"],
        ["\xF3\xB0\xA6\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE7"],
        ["\xF3\xB0\xA6\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE8"],
        ["\xF3\xB0\xA6\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xE9"],
        ["\xF3\xB0\xA6\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x4A"],
        ["\xF3\xB0\xA6\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5B"],
        ["\xF3\xB0\xA6\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5A"],
        ["\xF3\xB0\xA6\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x5F"],
        ["\xF3\xB0\xA6\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6D"],
        ["\xF3\xB0\xA6\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x79"],
        ["\xF3\xB0\xA6\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x57"],
        ["\xF3\xB0\xA6\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x59"],
        ["\xF3\xB0\xA6\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x62"],
        ["\xF3\xB0\xA6\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x63"],
        ["\xF3\xB0\xA6\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x64"],
        ["\xF3\xB0\xA6\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x65"],
        ["\xF3\xB0\xA6\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x66"],
        ["\xF3\xB0\xA6\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x67"],
        ["\xF3\xB0\xA6\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x68"],
        ["\xF3\xB0\xA6\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x69"],
        ["\xF3\xB0\xA6\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x70"],
        ["\xF3\xB0\xA6\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x71"],
        ["\xF3\xB0\xA6\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x72"],
        ["\xF3\xB0\xA6\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x73"],
        ["\xF3\xB0\xA7\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x74"],
        ["\xF3\xB0\xA7\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x75"],
        ["\xF3\xB0\xA7\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x76"],
        ["\xF3\xB0\xA7\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x77"],
        ["\xF3\xB0\xA7\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x78"],
        ["\xF3\xB0\xA7\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x80"],
        ["\xF3\xB0\xA7\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x8B"],
        ["\xF3\xB0\xA7\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9B"],
        ["\xF3\xB0\xA7\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x9C"],
        ["\xF3\xB0\xA7\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA0"],
        ["\xF3\xB0\xA7\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xAB"],
        ["\xF3\xB0\xA7\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xB0"],
        ["\xF3\xB0\xA7\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xC0"],
        ["\xF3\xB0\xA7\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\x6A"],
        ["\xF3\xB0\xA7\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xD0"],
        ["\xF3\xB0\xA7\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF8\xA1"],
        ["\xF3\xB0\xA7\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4F"],
        ["\xF3\xB0\xA7\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7F"],
        ["\xF3\xB0\xA7\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7B"],
        ["\xF3\xB0\xA7\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE0"],
        ["\xF3\xB0\xA7\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6C"],
        ["\xF3\xB0\xA7\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x50"],
        ["\xF3\xB0\xA7\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7D"],
        ["\xF3\xB0\xA7\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4D"],
        ["\xF3\xB0\xA7\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5D"],
        ["\xF3\xB0\xA7\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5C"],
        ["\xF3\xB0\xA7\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4E"],
        ["\xF3\xB0\xA7\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6B"],
        ["\xF3\xB0\xA7\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x60"],
        ["\xF3\xB0\xA7\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4B"],
        ["\xF3\xB0\xA7\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x61"],
        ["\xF3\xB0\xA7\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF0"],
        ["\xF3\xB0\xA7\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF1"],
        ["\xF3\xB0\xA7\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF2"],
        ["\xF3\xB0\xA7\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF3"],
        ["\xF3\xB0\xA7\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF4"],
        ["\xF3\xB0\xA7\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF5"],
        ["\xF3\xB0\xA7\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF6"],
        ["\xF3\xB0\xA7\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\xF3\xB0\xA7\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF8"],
        ["\xF3\xB0\xA7\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF9"],
        ["\xF3\xB0\xA7\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7A"],
        ["\xF3\xB0\xA7\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5E"],
        ["\xF3\xB0\xA7\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4C"],
        ["\xF3\xB0\xA7\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7E"],
        ["\xF3\xB0\xA7\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6E"],
        ["\xF3\xB0\xA7\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6F"],
        ["\xF3\xB0\xA7\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x7C"],
        ["\xF3\xB0\xA7\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC1"],
        ["\xF3\xB0\xA7\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC2"],
        ["\xF3\xB0\xA7\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC3"],
        ["\xF3\xB0\xA7\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC4"],
        ["\xF3\xB0\xA7\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC5"],
        ["\xF3\xB0\xA7\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC6"],
        ["\xF3\xB0\xA7\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC7"],
        ["\xF3\xB0\xA7\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC8"],
        ["\xF3\xB0\xA7\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC9"],
        ["\xF3\xB0\xA7\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD1"],
        ["\xF3\xB0\xA7\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD2"],
        ["\xF3\xB0\xA7\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD3"],
        ["\xF3\xB0\xA7\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD4"],
        ["\xF3\xB0\xA7\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD5"],
        ["\xF3\xB0\xA7\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD6"],
        ["\xF3\xB0\xA7\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD7"],
        ["\xF3\xB0\xA8\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD8"],
        ["\xF3\xB0\xA8\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD9"],
        ["\xF3\xB0\xA8\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE2"],
        ["\xF3\xB0\xA8\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE3"],
        ["\xF3\xB0\xA8\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE4"],
        ["\xF3\xB0\xA8\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE5"],
        ["\xF3\xB0\xA8\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE6"],
        ["\xF3\xB0\xA8\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE7"],
        ["\xF3\xB0\xA8\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE8"],
        ["\xF3\xB0\xA8\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xE9"],
        ["\xF3\xB0\xA8\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x4A"],
        ["\xF3\xB0\xA8\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],
        ["\xF3\xB0\xA8\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5A"],
        ["\xF3\xB0\xA8\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5F"],
        ["\xF3\xB0\xA8\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6D"],
        ["\xF3\xB0\xA8\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x79"],
        ["\xF3\xB0\xA8\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x57"],
        ["\xF3\xB0\xA8\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x59"],
        ["\xF3\xB0\xA8\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x62"],
        ["\xF3\xB0\xA8\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x63"],
        ["\xF3\xB0\xA8\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x64"],
        ["\xF3\xB0\xA8\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x65"],
        ["\xF3\xB0\xA8\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x66"],
        ["\xF3\xB0\xA8\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x67"],
        ["\xF3\xB0\xA8\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x68"],
        ["\xF3\xB0\xA8\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x69"],
        ["\xF3\xB0\xA8\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x70"],
        ["\xF3\xB0\xA8\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x71"],
        ["\xF3\xB0\xA8\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAC\x8C"],
        ["\xF3\xB0\xA8\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x73"],
        ["\xF3\xB0\xA8\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x74"],
        ["\xF3\xB0\xA8\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x75"],
        ["\xF3\xB0\xA8\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x76"],
        ["\xF3\xB0\xA8\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x77"],
        ["\xF3\xB0\xA8\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x78"],
        ["\xF3\xB0\xA8\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x80"],
        ["\xF3\xB0\xA8\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x8B"],
        ["\xF3\xB0\xA8\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9B"],
        ["\xF3\xB0\xA8\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x9C"],
        ["\xF3\xB0\xA8\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA0"],
        ["\xF3\xB0\xA8\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xAB"],
        ["\xF3\xB0\xA8\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xB0"],
        ["\xF3\xB0\xA8\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xC0"],
        ["\xF3\xB0\xA8\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x6A"],
        ["\xF3\xB0\xA8\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xD0"],
        ["\xF3\xB0\xA8\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xA1"],
        ["\xF3\xB0\xA8\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x4F"],
        ["\xF3\xB0\xA8\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x7F"],
        ["\xF3\xB0\xA8\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x7B"],
        ["\xF3\xB0\xA8\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE0"],
        ["\xF3\xB0\xA8\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x6C"],
        ["\xF3\xB0\xA8\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x50"],
        ["\xF3\xB0\xA8\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x7D"],
        ["\xF3\xB0\xA8\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x4D"],
        ["\xF3\xB0\xA8\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x5D"],
        ["\xF3\xB0\xA8\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x5C"],
        ["\xF3\xB0\xA8\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x4E"],
        ["\xF3\xB0\xA8\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x6B"],
        ["\xF3\xB0\xA8\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x60"],
        ["\xF3\xB0\xA8\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x4B"],
        ["\xF3\xB0\xA8\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x61"],
        ["\xF3\xB0\xA8\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF0"],
        ["\xF3\xB0\xA8\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF1"],
        ["\xF3\xB0\xA8\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF2"],
        ["\xF3\xB0\xA9\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF3"],
        ["\xF3\xB0\xA9\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF4"],
        ["\xF3\xB0\xA9\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF5"],
        ["\xF3\xB0\xA9\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF6"],
        ["\xF3\xB0\xA9\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF7"],
        ["\xF3\xB0\xA9\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF8"],
        ["\xF3\xB0\xA9\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xF9"],
        ["\xF3\xB0\xA9\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x7A"],
        ["\xF3\xB0\xA9\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x5E"],
        ["\xF3\xB0\xA9\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x4C"],
        ["\xF3\xB0\xA9\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x7E"],
        ["\xF3\xB0\xA9\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x6E"],
        ["\xF3\xB0\xA9\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x6F"],
        ["\xF3\xB0\xA9\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x7C"],
        ["\xF3\xB0\xA9\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC1"],
        ["\xF3\xB0\xA9\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC2"],
        ["\xF3\xB0\xA9\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC3"],
        ["\xF3\xB0\xA9\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC4"],
        ["\xF3\xB0\xA9\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC5"],
        ["\xF3\xB0\xA9\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC6"],
        ["\xF3\xB0\xA9\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC7"],
        ["\xF3\xB0\xA9\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC8"],
        ["\xF3\xB0\xA9\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC9"],
        ["\xF3\xB0\xA9\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD1"],
        ["\xF3\xB0\xA9\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD2"],
        ["\xF3\xB0\xA9\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD3"],
        ["\xF3\xB0\xA9\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD4"],
        ["\xF3\xB0\xA9\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD5"],
        ["\xF3\xB0\xA9\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD6"],
        ["\xF3\xB0\xA9\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD7"],
        ["\xF3\xB0\xA9\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD8"],
        ["\xF3\xB0\xA9\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD9"],
        ["\xF3\xB0\xA9\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE2"],
        ["\xF3\xB0\xA9\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE3"],
        ["\xF3\xB0\xA9\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE4"],
        ["\xF3\xB0\xA9\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE5"],
        ["\xF3\xB0\xA9\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE6"],
        ["\xF3\xB0\xA9\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE7"],
        ["\xF3\xB0\xA9\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE8"],
        ["\xF3\xB0\xA9\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xE9"],
        ["\xF3\xB0\xA9\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x4A"],
        ["\xF3\xB0\xA9\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x5B"],
        ["\xF3\xB0\xA9\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x5A"],
        ["\xF3\xB0\xA9\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x5F"],
        ["\xF3\xB0\xA9\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x6D"],
        ["\xF3\xB0\xA9\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x79"],
        ["\xF3\xB0\xA9\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x57"],
        ["\xF3\xB0\xA9\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x59"],
        ["\xF3\xB0\xA9\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x62"],
        ["\xF3\xB0\xA9\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x63"],
        ["\xF3\xB0\xA9\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x64"],
        ["\xF3\xB0\xA9\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x65"],
        ["\xF3\xB0\xA9\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x66"],
        ["\xF3\xB0\xA9\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x67"],
        ["\xF3\xB0\xA9\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x68"],
        ["\xF3\xB0\xA9\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x69"],
        ["\xF3\xB0\xA9\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x70"],
        ["\xF3\xB0\xA9\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x71"],
        ["\xF3\xB0\xA9\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x72"],
        ["\xF3\xB0\xA9\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x73"],
        ["\xF3\xB0\xA9\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x74"],
        ["\xF3\xB0\xA9\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x75"],
        ["\xF3\xB0\xA9\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x76"],
        ["\xF3\xB0\xA9\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x77"],
        ["\xF3\xB0\xAA\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x78"],
        ["\xF3\xB0\xAA\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x80"],
        ["\xF3\xB0\xAA\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x8B"],
        ["\xF3\xB0\xAA\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x9B"],
        ["\xF3\xB0\xAA\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x9C"],
        ["\xF3\xB0\xAA\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xA0"],
        ["\xF3\xB0\xAA\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xAB"],
        ["\xF3\xB0\xAA\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xB0"],
        ["\xF3\xB0\xAA\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xC0"],
        ["\xF3\xB0\xAA\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\x6A"],
        ["\xF3\xB0\xAA\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xD0"],
        ["\xF3\xB0\xAA\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7A\xA1"],
        ["\xF3\xB0\xAA\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\xF3\xB0\xAA\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7F"],
        ["\xF3\xB0\xAA\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\xF3\xB0\xAA\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],
        ["\xF3\xB0\xAA\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\xF3\xB0\xAA\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\xF3\xB0\xAA\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\xF3\xB0\xAA\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\xF3\xB0\xAA\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\xF3\xB0\xAA\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\xF3\xB0\xAA\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\xF3\xB0\xAA\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\xF3\xB0\xAA\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\xF3\xB0\xAA\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],
        ["\xF3\xB0\xAA\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\xF3\xB0\xAA\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\xF3\xB0\xAA\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],
        ["\xF3\xB0\xAA\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF2"],
        ["\xF3\xB0\xAA\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF3"],
        ["\xF3\xB0\xAA\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\xF3\xB0\xAA\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],
        ["\xF3\xB0\xAA\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\xF3\xB0\xAA\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],
        ["\xF3\xB0\xAA\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\xF3\xB0\xAA\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\xF3\xB0\xAA\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\xF3\xB0\xAA\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\xF3\xB0\xAA\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\xF3\xB0\xAA\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\xF3\xB0\xAA\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\xF3\xB0\xAA\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\xF3\xB0\xAA\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\xF3\xB0\xAA\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC1"],
        ["\xF3\xB0\xAA\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],
        ["\xF3\xB0\xAA\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],
        ["\xF3\xB0\xAA\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC4"],
        ["\xF3\xB0\xAA\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC5"],
        ["\xF3\xB0\xAA\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC6"],
        ["\xF3\xB0\xAA\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],
        ["\xF3\xB0\xAA\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC8"],
        ["\xF3\xB0\xAA\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC9"],
        ["\xF3\xB0\xAA\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],
        ["\xF3\xB0\xAA\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\xF3\xB0\xAA\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\xF3\xB0\xAA\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],
        ["\xF3\xB0\xAA\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD5"],
        ["\xF3\xB0\xAA\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],
        ["\xF3\xB0\xAA\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD7"],
        ["\xF3\xB0\xAA\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\xF3\xB0\xAA\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],
        ["\xF3\xB0\xAA\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],
        ["\xF3\xB0\xAA\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\xF3\xB0\xAB\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],
        ["\xF3\xB0\xAB\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],
        ["\xF3\xB0\xAB\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\xF3\xB0\xAB\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE7"],
        ["\xF3\xB0\xAB\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\xF3\xB0\xAB\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\xF3\xB0\xAB\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\xF3\xB0\xAB\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\xF3\xB0\xAB\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],
        ["\xF3\xB0\xAB\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\xF3\xB0\xAB\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\xF3\xB0\xAB\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\xF3\xB0\xAB\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\xF3\xB0\xAB\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\xF3\xB0\xAB\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\xF3\xB0\xAB\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\xF3\xB0\xAB\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\xF3\xB0\xAB\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\xF3\xB0\xAB\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\xF3\xB0\xAB\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\xF3\xB0\xAB\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\xF3\xB0\xAB\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\xF3\xB0\xAB\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\xF3\xB0\xAB\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\xF3\xB0\xAB\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\xF3\xB0\xAB\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],
        ["\xF3\xB0\xAB\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\xF3\xB0\xAB\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],
        ["\xF3\xB0\xAB\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\xF3\xB0\xAB\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\xF3\xB0\xAB\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\xF3\xB0\xAB\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x80"],
        ["\xF3\xB0\xAB\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x8B"],
        ["\xF3\xB0\xAB\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x9B"],
        ["\xF3\xB0\xAB\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x9C"],
        ["\xF3\xB0\xAB\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xA0"],
        ["\xF3\xB0\xAB\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xAB"],
        ["\xF3\xB0\xAB\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],
        ["\xF3\xB0\xAB\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xC0"],
        ["\xF3\xB0\xAB\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\xF3\xB0\xAB\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],
        ["\xF3\xB0\xAB\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5E\xA1"],
        ["\xF3\xB0\xAB\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\xF3\xB0\xAB\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7F"],
        ["\xF3\xB0\xAB\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\xF3\xB0\xAB\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE0"],
        ["\xF3\xB0\xAB\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\xF3\xB0\xAB\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\xF3\xB0\xAB\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\xF3\xB0\xAB\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\xF3\xB0\xAB\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\xF3\xB0\xAB\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\xF3\xB0\xAB\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\xF3\xB0\xAB\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\xF3\xB0\xAB\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\xF3\xB0\xAB\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\xF3\xB0\xAB\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\xF3\xB0\xAB\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF0"],
        ["\xF3\xB0\xAB\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF1"],
        ["\xF3\xB0\xAB\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],
        ["\xF3\xB0\xAB\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF3"],
        ["\xF3\xB0\xAB\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF4"],
        ["\xF3\xB0\xAB\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF5"],
        ["\xF3\xB0\xAB\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\xF3\xB0\xAC\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF7"],
        ["\xF3\xB0\xAC\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF8"],
        ["\xF3\xB0\xAC\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xF9"],
        ["\xF3\xB0\xAC\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\xF3\xB0\xAC\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\xF3\xB0\xAC\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\xF3\xB0\xAC\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\xF3\xB0\xAC\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\xF3\xB0\xAC\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\xF3\xB0\xAC\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\xF3\xB0\xAC\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC1"],
        ["\xF3\xB0\xAC\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC2"],
        ["\xF3\xB0\xAC\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC3"],
        ["\xF3\xB0\xAC\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC4"],
        ["\xF3\xB0\xAC\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC5"],
        ["\xF3\xB0\xAC\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC6"],
        ["\xF3\xB0\xAC\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],
        ["\xF3\xB0\xAC\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC8"],
        ["\xF3\xB0\xAC\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7F"],
        ["\xF3\xB0\xAC\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD1"],
        ["\xF3\xB0\xAC\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD2"],
        ["\xF3\xB0\xAC\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD3"],
        ["\xF3\xB0\xAC\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD4"],
        ["\xF3\xB0\xAC\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD5"],
        ["\xF3\xB0\xAC\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD6"],
        ["\xF3\xB0\xAC\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD7"],
        ["\xF3\xB0\xAC\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD8"],
        ["\xF3\xB0\xAC\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD9"],
        ["\xF3\xB0\xAC\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE2"],
        ["\xF3\xB0\xAC\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE3"],
        ["\xF3\xB0\xAC\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE4"],
        ["\xF3\xB0\xAC\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE5"],
        ["\xF3\xB0\xAC\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE6"],
        ["\xF3\xB0\xAC\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],
        ["\xF3\xB0\xAC\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE8"],
        ["\xF3\xB0\xAC\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],
        ["\xF3\xB0\xAC\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\xF3\xB0\xAC\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\xF3\xB0\xAC\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\xF3\xB0\xAC\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\xF3\xB0\xAC\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\xF3\xB0\xAC\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\xF3\xB0\xAC\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\xF3\xB0\xAC\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\xF3\xB0\xAC\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\xF3\xB0\xAC\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\xF3\xB0\xAC\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\xF3\xB0\xAC\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\xF3\xB0\xAC\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\xF3\xB0\xAC\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\xF3\xB0\xAC\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\xF3\xB0\xAC\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\xF3\xB0\xAC\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\xF3\xB0\xAC\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\xF3\xB0\xAC\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\xF3\xB0\xAC\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\xF3\xB0\xAC\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\xF3\xB0\xAC\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\xF3\xB0\xAC\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\xF3\xB0\xAC\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\xF3\xB0\xAC\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\xF3\xB0\xAC\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x80"],
        ["\xF3\xB0\xAC\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x8B"],
        ["\xF3\xB0\xAC\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x9B"],
        ["\xF3\xB0\xAD\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x9C"],
        ["\xF3\xB0\xAD\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xA0"],
        ["\xF3\xB0\xAD\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],
        ["\xF3\xB0\xAD\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xB0"],
        ["\xF3\xB0\xAD\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],
        ["\xF3\xB0\xAD\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\xF3\xB0\xAD\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xD0"],
        ["\xF3\xB0\xAD\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xA1"],
        ["\xF3\xB0\xAD\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x4F"],
        ["\xF3\xB0\xAD\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x7F"],
        ["\xF3\xB0\xAD\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x7B"],
        ["\xF3\xB0\xAD\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE0"],
        ["\xF3\xB0\xAD\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x6C"],
        ["\xF3\xB0\xAD\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x50"],
        ["\xF3\xB0\xAD\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x7D"],
        ["\xF3\xB0\xAD\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x4D"],
        ["\xF3\xB0\xAD\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x5D"],
        ["\xF3\xB0\xAD\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x5C"],
        ["\xF3\xB0\xAD\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x4E"],
        ["\xF3\xB0\xAD\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x6B"],
        ["\xF3\xB0\xAD\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x60"],
        ["\xF3\xB0\xAD\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x4B"],
        ["\xF3\xB0\xAD\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x61"],
        ["\xF3\xB0\xAD\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF0"],
        ["\xF3\xB0\xAD\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF1"],
        ["\xF3\xB0\xAD\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF2"],
        ["\xF3\xB0\xAD\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF3"],
        ["\xF3\xB0\xAD\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF4"],
        ["\xF3\xB0\xAD\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF5"],
        ["\xF3\xB0\xAD\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF6"],
        ["\xF3\xB0\xAD\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF7"],
        ["\xF3\xB0\xAD\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF8"],
        ["\xF3\xB0\xAD\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xF9"],
        ["\xF3\xB0\xAD\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x7A"],
        ["\xF3\xB0\xAD\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x5E"],
        ["\xF3\xB0\xAD\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x4C"],
        ["\xF3\xB0\xAD\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x7E"],
        ["\xF3\xB0\xAD\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x6E"],
        ["\xF3\xB0\xAD\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x6F"],
        ["\xF3\xB0\xAD\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x7C"],
        ["\xF3\xB0\xAD\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC1"],
        ["\xF3\xB0\xAD\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC2"],
        ["\xF3\xB0\xAD\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC3"],
        ["\xF3\xB0\xAD\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC4"],
        ["\xF3\xB0\xAD\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC5"],
        ["\xF3\xB0\xAD\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC6"],
        ["\xF3\xB0\xAD\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC7"],
        ["\xF3\xB0\xAD\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC8"],
        ["\xF3\xB0\xAD\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC9"],
        ["\xF3\xB0\xAD\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD1"],
        ["\xF3\xB0\xAD\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD2"],
        ["\xF3\xB0\xAD\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD3"],
        ["\xF3\xB0\xAD\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD4"],
        ["\xF3\xB0\xAD\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD5"],
        ["\xF3\xB0\xAD\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD6"],
        ["\xF3\xB0\xAD\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD7"],
        ["\xF3\xB0\xAD\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD8"],
        ["\xF3\xB0\xAD\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD9"],
        ["\xF3\xB0\xAD\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE2"],
        ["\xF3\xB0\xAD\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE3"],
        ["\xF3\xB0\xAD\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE4"],
        ["\xF3\xB0\xAD\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE5"],
        ["\xF3\xB0\xAD\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE6"],
        ["\xF3\xB0\xAD\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE7"],
        ["\xF3\xB0\xAE\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE8"],
        ["\xF3\xB0\xAE\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xE9"],
        ["\xF3\xB0\xAE\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x4A"],
        ["\xF3\xB0\xAE\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x5B"],
        ["\xF3\xB0\xAE\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x5A"],
        ["\xF3\xB0\xAE\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x5F"],
        ["\xF3\xB0\xAE\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x6D"],
        ["\xF3\xB0\xAE\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x79"],
        ["\xF3\xB0\xAE\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x57"],
        ["\xF3\xB0\xAE\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x59"],
        ["\xF3\xB0\xAE\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x62"],
        ["\xF3\xB0\xAE\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x63"],
        ["\xF3\xB0\xAE\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x64"],
        ["\xF3\xB0\xAE\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x65"],
        ["\xF3\xB0\xAE\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x66"],
        ["\xF3\xB0\xAE\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x67"],
        ["\xF3\xB0\xAE\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x68"],
        ["\xF3\xB0\xAE\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x69"],
        ["\xF3\xB0\xAE\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x70"],
        ["\xF3\xB0\xAE\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x71"],
        ["\xF3\xB0\xAE\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x72"],
        ["\xF3\xB0\xAE\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x73"],
        ["\xF3\xB0\xAE\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x74"],
        ["\xF3\xB0\xAE\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x75"],
        ["\xF3\xB0\xAE\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x76"],
        ["\xF3\xB0\xAE\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x77"],
        ["\xF3\xB0\xAE\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x78"],
        ["\xF3\xB0\xAE\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x80"],
        ["\xF3\xB0\xAE\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x8B"],
        ["\xF3\xB0\xAE\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x9B"],
        ["\xF3\xB0\xAE\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x9C"],
        ["\xF3\xB0\xAE\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xA0"],
        ["\xF3\xB0\xAE\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xAB"],
        ["\xF3\xB0\xAE\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xB0"],
        ["\xF3\xB0\xAE\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xC0"],
        ["\xF3\xB0\xAE\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\x6A"],
        ["\xF3\xB0\xAE\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xD0"],
        ["\xF3\xB0\xAE\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7E\xA1"],
        ["\xF3\xB0\xAE\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4F"],
        ["\xF3\xB0\xAE\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7F"],
        ["\xF3\xB0\xAE\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7B"],
        ["\xF3\xB0\xAE\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE0"],
        ["\xF3\xB0\xAE\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6C"],
        ["\xF3\xB0\xAE\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x50"],
        ["\xF3\xB0\xAE\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7D"],
        ["\xF3\xB0\xAE\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4D"],
        ["\xF3\xB0\xAE\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5D"],
        ["\xF3\xB0\xAE\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5C"],
        ["\xF3\xB0\xAE\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4E"],
        ["\xF3\xB0\xAE\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6B"],
        ["\xF3\xB0\xAE\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x60"],
        ["\xF3\xB0\xAE\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4B"],
        ["\xF3\xB0\xAE\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x61"],
        ["\xF3\xB0\xAE\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF0"],
        ["\xF3\xB0\xAE\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF1"],
        ["\xF3\xB0\xAE\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF2"],
        ["\xF3\xB0\xAE\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF3"],
        ["\xF3\xB0\xAE\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF4"],
        ["\xF3\xB0\xAE\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF5"],
        ["\xF3\xB0\xAE\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF6"],
        ["\xF3\xB0\xAE\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF7"],
        ["\xF3\xB0\xAE\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF8"],
        ["\xF3\xB0\xAE\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xF9"],
        ["\xF3\xB0\xAE\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7A"],
        ["\xF3\xB0\xAF\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5E"],
        ["\xF3\xB0\xAF\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4C"],
        ["\xF3\xB0\xAF\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7E"],
        ["\xF3\xB0\xAF\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6E"],
        ["\xF3\xB0\xAF\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6F"],
        ["\xF3\xB0\xAF\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x7C"],
        ["\xF3\xB0\xAF\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC1"],
        ["\xF3\xB0\xAF\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC2"],
        ["\xF3\xB0\xAF\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC3"],
        ["\xF3\xB0\xAF\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC4"],
        ["\xF3\xB0\xAF\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC5"],
        ["\xF3\xB0\xAF\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC6"],
        ["\xF3\xB0\xAF\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC7"],
        ["\xF3\xB0\xAF\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC8"],
        ["\xF3\xB0\xAF\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC9"],
        ["\xF3\xB0\xAF\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD1"],
        ["\xF3\xB0\xAF\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD2"],
        ["\xF3\xB0\xAF\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD3"],
        ["\xF3\xB0\xAF\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD4"],
        ["\xF3\xB0\xAF\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD5"],
        ["\xF3\xB0\xAF\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD6"],
        ["\xF3\xB0\xAF\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD7"],
        ["\xF3\xB0\xAF\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD8"],
        ["\xF3\xB0\xAF\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD9"],
        ["\xF3\xB0\xAF\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE2"],
        ["\xF3\xB0\xAF\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE3"],
        ["\xF3\xB0\xAF\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE4"],
        ["\xF3\xB0\xAF\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE5"],
        ["\xF3\xB0\xAF\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE6"],
        ["\xF3\xB0\xAF\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE7"],
        ["\xF3\xB0\xAF\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE8"],
        ["\xF3\xB0\xAF\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xE9"],
        ["\xF3\xB0\xAF\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x4A"],
        ["\xF3\xB0\xAF\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5B"],
        ["\xF3\xB0\xAF\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5A"],
        ["\xF3\xB0\xAF\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x5F"],
        ["\xF3\xB0\xAF\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6D"],
        ["\xF3\xB0\xAF\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x79"],
        ["\xF3\xB0\xAF\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x57"],
        ["\xF3\xB0\xAF\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x59"],
        ["\xF3\xB0\xAF\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x62"],
        ["\xF3\xB0\xAF\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x63"],
        ["\xF3\xB0\xAF\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x64"],
        ["\xF3\xB0\xAF\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x65"],
        ["\xF3\xB0\xAF\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x66"],
        ["\xF3\xB0\xAF\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x67"],
        ["\xF3\xB0\xAF\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x68"],
        ["\xF3\xB0\xAF\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x69"],
        ["\xF3\xB0\xAF\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x70"],
        ["\xF3\xB0\xAF\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x71"],
        ["\xF3\xB0\xAF\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x72"],
        ["\xF3\xB0\xAF\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x73"],
        ["\xF3\xB0\xAF\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x74"],
        ["\xF3\xB0\xAF\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x75"],
        ["\xF3\xB0\xAF\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x76"],
        ["\xF3\xB0\xAF\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x77"],
        ["\xF3\xB0\xAF\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x78"],
        ["\xF3\xB0\xAF\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x80"],
        ["\xF3\xB0\xAF\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x8B"],
        ["\xF3\xB0\xAF\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x9B"],
        ["\xF3\xB0\xAF\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x9C"],
        ["\xF3\xB0\xAF\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xA0"],
        ["\xF3\xB0\xAF\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xAB"],
        ["\xF3\xB0\xAF\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xB0"],
        ["\xF3\xB0\xB0\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xC0"],
        ["\xF3\xB0\xB0\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\x6A"],
        ["\xF3\xB0\xB0\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xD0"],
        ["\xF3\xB0\xB0\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6E\xA1"],
        ["\xF3\xB0\xB0\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4F"],
        ["\xF3\xB0\xB0\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7F"],
        ["\xF3\xB0\xB0\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7B"],
        ["\xF3\xB0\xB0\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE0"],
        ["\xF3\xB0\xB0\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6C"],
        ["\xF3\xB0\xB0\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x50"],
        ["\xF3\xB0\xB0\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7D"],
        ["\xF3\xB0\xB0\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4D"],
        ["\xF3\xB0\xB0\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5D"],
        ["\xF3\xB0\xB0\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5C"],
        ["\xF3\xB0\xB0\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4E"],
        ["\xF3\xB0\xB0\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6B"],
        ["\xF3\xB0\xB0\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x60"],
        ["\xF3\xB0\xB0\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4B"],
        ["\xF3\xB0\xB0\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x61"],
        ["\xF3\xB0\xB0\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF0"],
        ["\xF3\xB0\xB0\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF1"],
        ["\xF3\xB0\xB0\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF2"],
        ["\xF3\xB0\xB0\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF3"],
        ["\xF3\xB0\xB0\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF4"],
        ["\xF3\xB0\xB0\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF5"],
        ["\xF3\xB0\xB0\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF6"],
        ["\xF3\xB0\xB0\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF7"],
        ["\xF3\xB0\xB0\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF8"],
        ["\xF3\xB0\xB0\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xF9"],
        ["\xF3\xB0\xB0\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7A"],
        ["\xF3\xB0\xB0\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5E"],
        ["\xF3\xB0\xB0\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4C"],
        ["\xF3\xB0\xB0\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7E"],
        ["\xF3\xB0\xB0\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6E"],
        ["\xF3\xB0\xB0\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6F"],
        ["\xF3\xB0\xB0\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x7C"],
        ["\xF3\xB0\xB0\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC1"],
        ["\xF3\xB0\xB0\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC2"],
        ["\xF3\xB0\xB0\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC3"],
        ["\xF3\xB0\xB0\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC4"],
        ["\xF3\xB0\xB0\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC5"],
        ["\xF3\xB0\xB0\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC6"],
        ["\xF3\xB0\xB0\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC7"],
        ["\xF3\xB0\xB0\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC8"],
        ["\xF3\xB0\xB0\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC9"],
        ["\xF3\xB0\xB0\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD1"],
        ["\xF3\xB0\xB0\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD2"],
        ["\xF3\xB0\xB0\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD3"],
        ["\xF3\xB0\xB0\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD4"],
        ["\xF3\xB0\xB0\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD5"],
        ["\xF3\xB0\xB0\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD6"],
        ["\xF3\xB0\xB0\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD7"],
        ["\xF3\xB0\xB0\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD8"],
        ["\xF3\xB0\xB0\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD9"],
        ["\xF3\xB0\xB0\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE2"],
        ["\xF3\xB0\xB0\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE3"],
        ["\xF3\xB0\xB0\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE4"],
        ["\xF3\xB0\xB0\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE5"],
        ["\xF3\xB0\xB0\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE6"],
        ["\xF3\xB0\xB0\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE7"],
        ["\xF3\xB0\xB0\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE6"],
        ["\xF3\xB0\xB0\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE9"],
        ["\xF3\xB0\xB0\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x4A"],
        ["\xF3\xB0\xB0\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5B"],
        ["\xF3\xB0\xB1\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5A"],
        ["\xF3\xB0\xB1\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x5F"],
        ["\xF3\xB0\xB1\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6D"],
        ["\xF3\xB0\xB1\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x79"],
        ["\xF3\xB0\xB1\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x57"],
        ["\xF3\xB0\xB1\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x59"],
        ["\xF3\xB0\xB1\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x62"],
        ["\xF3\xB0\xB1\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x63"],
        ["\xF3\xB0\xB1\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x64"],
        ["\xF3\xB0\xB1\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x65"],
        ["\xF3\xB0\xB1\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x66"],
        ["\xF3\xB0\xB1\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x67"],
        ["\xF3\xB0\xB1\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x68"],
        ["\xF3\xB0\xB1\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x69"],
        ["\xF3\xB0\xB1\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x70"],
        ["\xF3\xB0\xB1\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x71"],
        ["\xF3\xB0\xB1\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x72"],
        ["\xF3\xB0\xB1\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x73"],
        ["\xF3\xB0\xB1\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x74"],
        ["\xF3\xB0\xB1\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x75"],
        ["\xF3\xB0\xB1\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x76"],
        ["\xF3\xB0\xB1\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x77"],
        ["\xF3\xB0\xB1\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x78"],
        ["\xF3\xB0\xB1\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x80"],
        ["\xF3\xB0\xB1\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x8B"],
        ["\xF3\xB0\xB1\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x9B"],
        ["\xF3\xB0\xB1\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x9C"],
        ["\xF3\xB0\xB1\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xA0"],
        ["\xF3\xB0\xB1\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xAB"],
        ["\xF3\xB0\xB1\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xB0"],
        ["\xF3\xB0\xB1\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xC0"],
        ["\xF3\xB0\xB1\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\x6A"],
        ["\xF3\xB0\xB1\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xD0"],
        ["\xF3\xB0\xB1\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xA1"],
        ["\xF3\xB0\xB1\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x4F"],
        ["\xF3\xB0\xB1\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x7F"],
        ["\xF3\xB0\xB1\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x7B"],
        ["\xF3\xB0\xB1\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE0"],
        ["\xF3\xB0\xB1\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x6C"],
        ["\xF3\xB0\xB1\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x50"],
        ["\xF3\xB0\xB1\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x7D"],
        ["\xF3\xB0\xB1\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x4D"],
        ["\xF3\xB0\xB1\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x5D"],
        ["\xF3\xB0\xB1\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x5C"],
        ["\xF3\xB0\xB1\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x4E"],
        ["\xF3\xB0\xB1\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x6B"],
        ["\xF3\xB0\xB1\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x60"],
        ["\xF3\xB0\xB1\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x4B"],
        ["\xF3\xB0\xB1\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x61"],
        ["\xF3\xB0\xB1\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF0"],
        ["\xF3\xB0\xB1\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF1"],
        ["\xF3\xB0\xB1\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF2"],
        ["\xF3\xB0\xB1\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF3"],
        ["\xF3\xB0\xB1\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF4"],
        ["\xF3\xB0\xB1\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF5"],
        ["\xF3\xB0\xB1\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF6"],
        ["\xF3\xB0\xB1\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF7"],
        ["\xF3\xB0\xB1\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF8"],
        ["\xF3\xB0\xB1\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xF9"],
        ["\xF3\xB0\xB1\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x7A"],
        ["\xF3\xB0\xB1\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x5E"],
        ["\xF3\xB0\xB1\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x4C"],
        ["\xF3\xB0\xB1\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x7E"],
        ["\xF3\xB0\xB1\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x6E"],
        ["\xF3\xB0\xB2\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x6F"],
        ["\xF3\xB0\xB2\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x7C"],
        ["\xF3\xB0\xB2\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC1"],
        ["\xF3\xB0\xB2\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC2"],
        ["\xF3\xB0\xB2\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC3"],
        ["\xF3\xB0\xB2\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC4"],
        ["\xF3\xB0\xB2\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC5"],
        ["\xF3\xB0\xB2\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC6"],
        ["\xF3\xB0\xB2\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC7"],
        ["\xF3\xB0\xB2\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC8"],
        ["\xF3\xB0\xB2\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC9"],
        ["\xF3\xB0\xB2\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD1"],
        ["\xF3\xB0\xB2\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD2"],
        ["\xF3\xB0\xB2\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD3"],
        ["\xF3\xB0\xB2\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD4"],
        ["\xF3\xB0\xB2\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD5"],
        ["\xF3\xB0\xB2\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD6"],
        ["\xF3\xB0\xB2\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD7"],
        ["\xF3\xB0\xB2\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD8"],
        ["\xF3\xB0\xB2\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD9"],
        ["\xF3\xB0\xB2\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE2"],
        ["\xF3\xB0\xB2\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE3"],
        ["\xF3\xB0\xB2\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE4"],
        ["\xF3\xB0\xB2\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE5"],
        ["\xF3\xB0\xB2\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE6"],
        ["\xF3\xB0\xB2\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE7"],
        ["\xF3\xB0\xB2\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE8"],
        ["\xF3\xB0\xB2\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xE9"],
        ["\xF3\xB0\xB2\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x4A"],
        ["\xF3\xB0\xB2\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x5B"],
        ["\xF3\xB0\xB2\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x5A"],
        ["\xF3\xB0\xB2\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x5F"],
        ["\xF3\xB0\xB2\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x6D"],
        ["\xF3\xB0\xB2\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x79"],
        ["\xF3\xB0\xB2\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x57"],
        ["\xF3\xB0\xB2\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x59"],
        ["\xF3\xB0\xB2\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x62"],
        ["\xF3\xB0\xB2\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x63"],
        ["\xF3\xB0\xB2\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x64"],
        ["\xF3\xB0\xB2\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x65"],
        ["\xF3\xB0\xB2\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x66"],
        ["\xF3\xB0\xB2\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x67"],
        ["\xF3\xB0\xB2\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x68"],
        ["\xF3\xB0\xB2\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x69"],
        ["\xF3\xB0\xB2\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x70"],
        ["\xF3\xB0\xB2\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x71"],
        ["\xF3\xB0\xB2\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x72"],
        ["\xF3\xB0\xB2\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x73"],
        ["\xF3\xB0\xB2\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x74"],
        ["\xF3\xB0\xB2\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x75"],
        ["\xF3\xB0\xB2\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x76"],
        ["\xF3\xB0\xB2\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x77"],
        ["\xF3\xB0\xB2\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x78"],
        ["\xF3\xB0\xB2\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x80"],
        ["\xF3\xB0\xB2\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x8B"],
        ["\xF3\xB0\xB2\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x9B"],
        ["\xF3\xB0\xB2\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x9C"],
        ["\xF3\xB0\xB2\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xA0"],
        ["\xF3\xB0\xB2\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xAB"],
        ["\xF3\xB0\xB2\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xB0"],
        ["\xF3\xB0\xB2\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xC0"],
        ["\xF3\xB0\xB2\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\x6A"],
        ["\xF3\xB0\xB2\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xD0"],
        ["\xF3\xB0\xB2\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x7C\xA1"],
        ["\xF3\xB0\xB3\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x4F"],
        ["\xF3\xB0\xB3\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x7F"],
        ["\xF3\xB0\xB3\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x7B"],
        ["\xF3\xB0\xB3\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],
        ["\xF3\xB0\xB3\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x6C"],
        ["\xF3\xB0\xB3\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x50"],
        ["\xF3\xB0\xB3\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x7D"],
        ["\xF3\xB0\xB3\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD4"],
        ["\xF3\xB0\xB3\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x5D"],
        ["\xF3\xB0\xB3\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x5C"],
        ["\xF3\xB0\xB3\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x4E"],
        ["\xF3\xB0\xB3\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x6B"],
        ["\xF3\xB0\xB3\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x60"],
        ["\xF3\xB0\xB3\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x4B"],
        ["\xF3\xB0\xB3\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x61"],
        ["\xF3\xB0\xB3\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xF3\xB0\xB3\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xF3\xB0\xB3\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xF3\xB0\xB3\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],
        ["\xF3\xB0\xB3\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xF3\xB0\xB3\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xF3\xB0\xB3\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xF3\xB0\xB3\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xF3\xB0\xB3\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xF3\xB0\xB3\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],
        ["\xF3\xB0\xB3\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x7A"],
        ["\xF3\xB0\xB3\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x5E"],
        ["\xF3\xB0\xB3\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x4C"],
        ["\xF3\xB0\xB3\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x7E"],
        ["\xF3\xB0\xB3\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x6E"],
        ["\xF3\xB0\xB3\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x6F"],
        ["\xF3\xB0\xB3\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x7C"],
        ["\xF3\xB0\xB3\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],
        ["\xF3\xB0\xB3\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],
        ["\xF3\xB0\xB3\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xF3\xB0\xB3\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xF3\xB0\xB3\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],
        ["\xF3\xB0\xB3\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],
        ["\xF3\xB0\xB3\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xF3\xB0\xB3\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xF3\xB0\xB3\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],
        ["\xF3\xB0\xB3\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xF3\xB0\xB3\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xF3\xB0\xB3\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xF3\xB0\xB3\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xF3\xB0\xB3\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],
        ["\xF3\xB0\xB3\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],
        ["\xF3\xB0\xB3\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],
        ["\xF3\xB0\xB3\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xF3\xB0\xB3\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xF3\xB0\xB3\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xF3\xB0\xB3\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],
        ["\xF3\xB0\xB3\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xF3\xB0\xB3\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],
        ["\xF3\xB0\xB3\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xF3\xB0\xB3\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xF3\xB0\xB3\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xF3\xB0\xB3\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],
        ["\xF3\xB0\xB3\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x4A"],
        ["\xF3\xB0\xB3\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x5B"],
        ["\xF3\xB0\xB3\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x5A"],
        ["\xF3\xB0\xB3\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x5F"],
        ["\xF3\xB0\xB3\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x6D"],
        ["\xF3\xB0\xB3\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x79"],
        ["\xF3\xB0\xB4\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x57"],
        ["\xF3\xB0\xB4\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x59"],
        ["\xF3\xB0\xB4\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x62"],
        ["\xF3\xB0\xB4\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x63"],
        ["\xF3\xB0\xB4\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x64"],
        ["\xF3\xB0\xB4\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x65"],
        ["\xF3\xB0\xB4\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x66"],
        ["\xF3\xB0\xB4\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x67"],
        ["\xF3\xB0\xB4\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x68"],
        ["\xF3\xB0\xB4\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x69"],
        ["\xF3\xB0\xB4\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x70"],
        ["\xF3\xB0\xB4\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x71"],
        ["\xF3\xB0\xB4\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x72"],
        ["\xF3\xB0\xB4\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x73"],
        ["\xF3\xB0\xB4\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x74"],
        ["\xF3\xB0\xB4\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x75"],
        ["\xF3\xB0\xB4\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x76"],
        ["\xF3\xB0\xB4\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x77"],
        ["\xF3\xB0\xB4\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x78"],
        ["\xF3\xB0\xB4\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x80"],
        ["\xF3\xB0\xB4\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x8B"],
        ["\xF3\xB0\xB4\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x9B"],
        ["\xF3\xB0\xB4\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x9C"],
        ["\xF3\xB0\xB4\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA0"],
        ["\xF3\xB0\xB4\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xF3\xB0\xB4\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],
        ["\xF3\xB0\xB4\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xF3\xB0\xB4\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x6A"],
        ["\xF3\xB0\xB4\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xF3\xB0\xB4\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],
        ["\xF3\xB0\xB4\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x4F"],
        ["\xF3\xB0\xB4\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x7F"],
        ["\xF3\xB0\xB4\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x7B"],
        ["\xF3\xB0\xB4\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xF3\xB0\xB4\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x6C"],
        ["\xF3\xB0\xB4\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x50"],
        ["\xF3\xB0\xB4\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x7D"],
        ["\xF3\xB0\xB4\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x4D"],
        ["\xF3\xB0\xB4\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x5D"],
        ["\xF3\xB0\xB4\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x5C"],
        ["\xF3\xB0\xB4\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x4E"],
        ["\xF3\xB0\xB4\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x6B"],
        ["\xF3\xB0\xB4\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x60"],
        ["\xF3\xB0\xB4\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x4B"],
        ["\xF3\xB0\xB4\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x61"],
        ["\xF3\xB0\xB4\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xF3\xB0\xB4\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xF3\xB0\xB4\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],
        ["\xF3\xB0\xB4\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xF3\xB0\xB4\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],
        ["\xF3\xB0\xB4\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xF3\xB0\xB4\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xF3\xB0\xB4\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xF3\xB0\xB4\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],
        ["\xF3\xB0\xB4\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],
        ["\xF3\xB0\xB4\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x7A"],
        ["\xF3\xB0\xB4\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x5E"],
        ["\xF3\xB0\xB4\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x4C"],
        ["\xF3\xB0\xB4\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x7E"],
        ["\xF3\xB0\xB4\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x6E"],
        ["\xF3\xB0\xB4\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x6F"],
        ["\xF3\xB0\xB4\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x7C"],
        ["\xF3\xB0\xB4\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xF3\xB0\xB4\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],
        ["\xF3\xB0\xB5\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],
        ["\xF3\xB0\xB5\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],
        ["\xF3\xB0\xB5\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],
        ["\xF3\xB0\xB5\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xF3\xB0\xB5\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xF3\xB0\xB5\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],
        ["\xF3\xB0\xB5\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],
        ["\xF3\xB0\xB5\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],
        ["\xF3\xB0\xB5\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xF3\xB0\xB5\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xF3\xB0\xB5\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xF3\xB0\xB5\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xF3\xB0\xB5\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],
        ["\xF3\xB0\xB5\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],
        ["\xF3\xB0\xB5\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],
        ["\xF3\xB0\xB5\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xF3\xB0\xB5\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xF3\xB0\xB5\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xF3\xB0\xB5\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xF3\xB0\xB5\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xF3\xB0\xB5\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xF3\xB0\xB5\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xF3\xB0\xB5\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],
        ["\xF3\xB0\xB5\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xF3\xB0\xB5\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x4A"],
        ["\xF3\xB0\xB5\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x5B"],
        ["\xF3\xB0\xB5\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x5A"],
        ["\xF3\xB0\xB5\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x5F"],
        ["\xF3\xB0\xB5\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x6D"],
        ["\xF3\xB0\xB5\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x79"],
        ["\xF3\xB0\xB5\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x57"],
        ["\xF3\xB0\xB5\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x59"],
        ["\xF3\xB0\xB5\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x62"],
        ["\xF3\xB0\xB5\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x63"],
        ["\xF3\xB0\xB5\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x64"],
        ["\xF3\xB0\xB5\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x65"],
        ["\xF3\xB0\xB5\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x66"],
        ["\xF3\xB0\xB5\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x67"],
        ["\xF3\xB0\xB5\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x68"],
        ["\xF3\xB0\xB5\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x69"],
        ["\xF3\xB0\xB5\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x70"],
        ["\xF3\xB0\xB5\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x71"],
        ["\xF3\xB0\xB5\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x72"],
        ["\xF3\xB0\xB5\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x73"],
        ["\xF3\xB0\xB5\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x74"],
        ["\xF3\xB0\xB5\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x75"],
        ["\xF3\xB0\xB5\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x76"],
        ["\xF3\xB0\xB5\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x77"],
        ["\xF3\xB0\xB5\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x78"],
        ["\xF3\xB0\xB5\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x80"],
        ["\xF3\xB0\xB5\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x8B"],
        ["\xF3\xB0\xB5\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x9B"],
        ["\xF3\xB0\xB5\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x9C"],
        ["\xF3\xB0\xB5\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA0"],
        ["\xF3\xB0\xB5\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],
        ["\xF3\xB0\xB5\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xF3\xB0\xB5\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xF3\xB0\xB5\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\x6A"],
        ["\xF3\xB0\xB5\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xF3\xB0\xB5\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],
        ["\xF3\xB0\xB5\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x4F"],
        ["\xF3\xB0\xB5\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x7F"],
        ["\xF3\xB0\xB5\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x7B"],
        ["\xF3\xB0\xB5\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xF3\xB0\xB6\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x6C"],
        ["\xF3\xB0\xB6\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x50"],
        ["\xF3\xB0\xB6\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x7D"],
        ["\xF3\xB0\xB6\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x4D"],
        ["\xF3\xB0\xB6\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x5D"],
        ["\xF3\xB0\xB6\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x5C"],
        ["\xF3\xB0\xB6\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x4E"],
        ["\xF3\xB0\xB6\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x6B"],
        ["\xF3\xB0\xB6\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x60"],
        ["\xF3\xB0\xB6\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x4B"],
        ["\xF3\xB0\xB6\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x61"],
        ["\xF3\xB0\xB6\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xF3\xB0\xB6\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xF3\xB0\xB6\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xF3\xB0\xB6\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],
        ["\xF3\xB0\xB6\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],
        ["\xF3\xB0\xB6\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xF3\xB0\xB6\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xF3\xB0\xB6\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xF3\xB0\xB6\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],
        ["\xF3\xB0\xB6\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xF3\xB0\xB6\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x7A"],
        ["\xF3\xB0\xB6\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x5E"],
        ["\xF3\xB0\xB6\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x4C"],
        ["\xF3\xB0\xB6\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x7E"],
        ["\xF3\xB0\xB6\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x6E"],
        ["\xF3\xB0\xB6\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x6F"],
        ["\xF3\xB0\xB6\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x7C"],
        ["\xF3\xB0\xB6\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xF3\xB0\xB6\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xF3\xB0\xB6\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xF3\xB0\xB6\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],
        ["\xF3\xB0\xB6\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xF3\xB0\xB6\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xF3\xB0\xB6\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],
        ["\xF3\xB0\xB6\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],
        ["\xF3\xB0\xB6\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],
        ["\xF3\xB0\xB6\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],
        ["\xF3\xB0\xB6\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],
        ["\xF3\xB0\xB6\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],
        ["\xF3\xB0\xB6\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xF3\xB0\xB6\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xF3\xB0\xB6\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xF3\xB0\xB6\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xF3\xB0\xB6\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],
        ["\xF3\xB0\xB6\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xF3\xB0\xB6\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xF3\xB0\xB6\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xF3\xB0\xB6\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],
        ["\xF3\xB0\xB6\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xF3\xB0\xB6\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],
        ["\xF3\xB0\xB6\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xF3\xB0\xB6\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],
        ["\xF3\xB0\xB6\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],
        ["\xF3\xB0\xB6\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x4A"],
        ["\xF3\xB0\xB6\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x5B"],
        ["\xF3\xB0\xB6\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x5A"],
        ["\xF3\xB0\xB6\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x5F"],
        ["\xF3\xB0\xB6\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x6D"],
        ["\xF3\xB0\xB6\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x79"],
        ["\xF3\xB0\xB6\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x57"],
        ["\xF3\xB0\xB6\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x59"],
        ["\xF3\xB0\xB6\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x62"],
        ["\xF3\xB0\xB6\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x63"],
        ["\xF3\xB0\xB7\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x64"],
        ["\xF3\xB0\xB7\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x65"],
        ["\xF3\xB0\xB7\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x66"],
        ["\xF3\xB0\xB7\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x67"],
        ["\xF3\xB0\xB7\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x68"],
        ["\xF3\xB0\xB7\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x69"],
        ["\xF3\xB0\xB7\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x70"],
        ["\xF3\xB0\xB7\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x71"],
        ["\xF3\xB0\xB7\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x72"],
        ["\xF3\xB0\xB7\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x73"],
        ["\xF3\xB0\xB7\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x74"],
        ["\xF3\xB0\xB7\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x75"],
        ["\xF3\xB0\xB7\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x76"],
        ["\xF3\xB0\xB7\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x77"],
        ["\xF3\xB0\xB7\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x78"],
        ["\xF3\xB0\xB7\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x80"],
        ["\xF3\xB0\xB7\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x8B"],
        ["\xF3\xB0\xB7\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9B"],
        ["\xF3\xB0\xB7\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],
        ["\xF3\xB0\xB7\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA0"],
        ["\xF3\xB0\xB7\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xF3\xB0\xB7\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xF3\xB0\xB7\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xF3\xB0\xB7\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\x6A"],
        ["\xF3\xB0\xB7\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xF3\xB0\xB7\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xF3\xB0\xB7\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x4F"],
        ["\xF3\xB0\xB7\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x7F"],
        ["\xF3\xB0\xB7\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x7B"],
        ["\xF3\xB0\xB7\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],
        ["\xF3\xB0\xB7\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x6C"],
        ["\xF3\xB0\xB7\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x50"],
        ["\xF3\xB0\xB7\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x7D"],
        ["\xF3\xB0\xB7\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x4D"],
        ["\xF3\xB0\xB7\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x5D"],
        ["\xF3\xB0\xB7\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x5C"],
        ["\xF3\xB0\xB7\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x4E"],
        ["\xF3\xB0\xB7\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x6B"],
        ["\xF3\xB0\xB7\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x60"],
        ["\xF3\xB0\xB7\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x4B"],
        ["\xF3\xB0\xB7\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x61"],
        ["\xF3\xB0\xB7\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xF3\xB0\xB7\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xF3\xB0\xB7\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],
        ["\xF3\xB0\xB7\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xF3\xB0\xB7\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],
        ["\xF3\xB0\xB7\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xF3\xB0\xB7\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],
        ["\xF3\xB0\xB7\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xF3\xB0\xB7\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],
        ["\xF3\xB0\xB7\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xF3\xB0\xB7\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x7A"],
        ["\xF3\xB0\xB7\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x5E"],
        ["\xF3\xB0\xB7\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x4C"],
        ["\xF3\xB0\xB7\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x7E"],
        ["\xF3\xB0\xB7\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x6E"],
        ["\xF3\xB0\xB7\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x6F"],
        ["\xF3\xB0\xB7\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x7C"],
        ["\xF3\xB0\xB7\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],
        ["\xF3\xB0\xB7\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xF3\xB0\xB7\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],
        ["\xF3\xB0\xB7\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],
        ["\xF3\xB0\xB7\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xF3\xB0\xB7\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xF3\xB0\xB8\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],
        ["\xF3\xB0\xB8\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],
        ["\xF3\xB0\xB8\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],
        ["\xF3\xB0\xB8\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xF3\xB0\xB8\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xF3\xB0\xB8\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xF3\xB0\xB8\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEB"],
        ["\xF3\xB0\xB8\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],
        ["\xF3\xB0\xB8\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xF3\xB0\xB8\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],
        ["\xF3\xB0\xB8\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xF3\xB0\xB8\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],
        ["\xF3\xB0\xB8\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xF3\xB0\xB8\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xF3\xB0\xB8\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xF3\xB0\xB8\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xF3\xB0\xB8\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xF3\xB0\xB8\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xF3\xB0\xB8\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xF3\xB0\xB8\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],
        ["\xF3\xB0\xB8\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xF3\xB0\xB8\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x5B"],
        ["\xF3\xB0\xB8\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x5A"],
        ["\xF3\xB0\xB8\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x5F"],
        ["\xF3\xB0\xB8\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x6D"],
        ["\xF3\xB0\xB8\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x79"],
        ["\xF3\xB0\xB8\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x57"],
        ["\xF3\xB0\xB8\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x59"],
        ["\xF3\xB0\xB8\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x62"],
        ["\xF3\xB0\xB8\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x63"],
        ["\xF3\xB0\xB8\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x64"],
        ["\xF3\xB0\xB8\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x65"],
        ["\xF3\xB0\xB8\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x66"],
        ["\xF3\xB0\xB8\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x67"],
        ["\xF3\xB0\xB8\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x68"],
        ["\xF3\xB0\xB8\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x69"],
        ["\xF3\xB0\xB8\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x70"],
        ["\xF3\xB0\xB8\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x71"],
        ["\xF3\xB0\xB8\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x72"],
        ["\xF3\xB0\xB8\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x73"],
        ["\xF3\xB0\xB8\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x74"],
        ["\xF3\xB0\xB8\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x75"],
        ["\xF3\xB0\xB8\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x76"],
        ["\xF3\xB0\xB8\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x77"],
        ["\xF3\xB0\xB8\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x78"],
        ["\xF3\xB0\xB8\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x80"],
        ["\xF3\xB0\xB8\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x8B"],
        ["\xF3\xB0\xB8\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x9B"],
        ["\xF3\xB0\xB8\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x9C"],
        ["\xF3\xB0\xB8\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA0"],
        ["\xF3\xB0\xB8\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xF3\xB0\xB8\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],
        ["\xF3\xB0\xB8\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],
        ["\xF3\xB0\xB8\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x6A"],
        ["\xF3\xB0\xB8\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xF3\xB0\xB8\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],
        ["\xF3\xB0\xB8\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x4F"],
        ["\xF3\xB0\xB8\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x7F"],
        ["\xF3\xB0\xB8\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x7B"],
        ["\xF3\xB0\xB8\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xF3\xB0\xB8\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x6C"],
        ["\xF3\xB0\xB8\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x50"],
        ["\xF3\xB0\xB8\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x7D"],
        ["\xF3\xB0\xB8\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x4D"],
        ["\xF3\xB0\xB9\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x5D"],
        ["\xF3\xB0\xB9\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x5C"],
        ["\xF3\xB0\xB9\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x4E"],
        ["\xF3\xB0\xB9\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x6B"],
        ["\xF3\xB0\xB9\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x60"],
        ["\xF3\xB0\xB9\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x4B"],
        ["\xF3\xB0\xB9\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x61"],
        ["\xF3\xB0\xB9\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],
        ["\xF3\xB0\xB9\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xF3\xB0\xB9\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],
        ["\xF3\xB0\xB9\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xF3\xB0\xB9\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xF3\xB0\xB9\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],
        ["\xF3\xB0\xB9\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAC\xB8"],
        ["\xF3\xB0\xB9\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],
        ["\xF3\xB0\xB9\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xF3\xB0\xB9\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],
        ["\xF3\xB0\xB9\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x7A"],
        ["\xF3\xB0\xB9\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x5E"],
        ["\xF3\xB0\xB9\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x4C"],
        ["\xF3\xB0\xB9\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x7E"],
        ["\xF3\xB0\xB9\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x6E"],
        ["\xF3\xB0\xB9\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x43"],
        ["\xF3\xB0\xB9\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x7C"],
        ["\xF3\xB0\xB9\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],
        ["\xF3\xB0\xB9\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],
        ["\xF3\xB0\xB9\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xF3\xB0\xB9\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],
        ["\xF3\xB0\xB9\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],
        ["\xF3\xB0\xB9\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],
        ["\xF3\xB0\xB9\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xF3\xB0\xB9\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xF3\xB0\xB9\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],
        ["\xF3\xB0\xB9\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xF3\xB0\xB9\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xF3\xB0\xB9\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],
        ["\xF3\xB0\xB9\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xF3\xB0\xB9\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xF3\xB0\xB9\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xF3\xB0\xB9\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xF3\xB0\xB9\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],
        ["\xF3\xB0\xB9\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xF3\xB0\xB9\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],
        ["\xF3\xB0\xB9\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xF3\xB0\xB9\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],
        ["\xF3\xB0\xB9\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xF3\xB0\xB9\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\xF3\xB0\xB9\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xF3\xB0\xB9\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xF3\xB0\xB9\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xF3\xB0\xB9\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x4A"],
        ["\xF3\xB0\xB9\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x5B"],
        ["\xF3\xB0\xB9\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x5A"],
        ["\xF3\xB0\xB9\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x5F"],
        ["\xF3\xB0\xB9\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x6D"],
        ["\xF3\xB0\xB9\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x79"],
        ["\xF3\xB0\xB9\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x57"],
        ["\xF3\xB0\xB9\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x59"],
        ["\xF3\xB0\xB9\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x62"],
        ["\xF3\xB0\xB9\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x63"],
        ["\xF3\xB0\xB9\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x64"],
        ["\xF3\xB0\xB9\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x65"],
        ["\xF3\xB0\xB9\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x66"],
        ["\xF3\xB0\xB9\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x67"],
        ["\xF3\xB0\xBA\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x68"],
        ["\xF3\xB0\xBA\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x69"],
        ["\xF3\xB0\xBA\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x70"],
        ["\xF3\xB0\xBA\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x71"],
        ["\xF3\xB0\xBA\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x72"],
        ["\xF3\xB0\xBA\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\xF3\xB0\xBA\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x74"],
        ["\xF3\xB0\xBA\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x75"],
        ["\xF3\xB0\xBA\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x76"],
        ["\xF3\xB0\xBA\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x77"],
        ["\xF3\xB0\xBA\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF9"],
        ["\xF3\xB0\xBA\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x80"],
        ["\xF3\xB0\xBA\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x8B"],
        ["\xF3\xB0\xBA\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9B"],
        ["\xF3\xB0\xBA\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x9C"],
        ["\xF3\xB0\xBA\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA0"],
        ["\xF3\xB0\xBA\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],
        ["\xF3\xB0\xBA\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],
        ["\xF3\xB0\xBA\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],
        ["\xF3\xB0\xBA\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x6A"],
        ["\xF3\xB0\xBA\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],
        ["\xF3\xB0\xBA\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],
        ["\xF3\xB0\xBA\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x4F"],
        ["\xF3\xB0\xBA\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x7F"],
        ["\xF3\xB0\xBA\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x7B"],
        ["\xF3\xB0\xBA\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],
        ["\xF3\xB0\xBA\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x6C"],
        ["\xF3\xB0\xBA\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x50"],
        ["\xF3\xB0\xBA\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x7D"],
        ["\xF3\xB0\xBA\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x4D"],
        ["\xF3\xB0\xBA\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x5D"],
        ["\xF3\xB0\xBA\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x5C"],
        ["\xF3\xB0\xBA\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x4E"],
        ["\xF3\xB0\xBA\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x6B"],
        ["\xF3\xB0\xBA\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x60"],
        ["\xF3\xB0\xBA\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x4B"],
        ["\xF3\xB0\xBA\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x61"],
        ["\xF3\xB0\xBA\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],
        ["\xF3\xB0\xBA\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xF3\xB0\xBA\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],
        ["\xF3\xB0\xBA\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xF3\xB0\xBA\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xF3\xB0\xBA\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],
        ["\xF3\xB0\xBA\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],
        ["\xF3\xB0\xBA\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xF3\xB0\xBA\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],
        ["\xF3\xB0\xBA\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],
        ["\xF3\xB0\xBA\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x7A"],
        ["\xF3\xB0\xBA\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x5E"],
        ["\xF3\xB0\xBA\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x4C"],
        ["\xF3\xB0\xBA\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x7E"],
        ["\xF3\xB0\xBA\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x6E"],
        ["\xF3\xB0\xBA\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x6F"],
        ["\xF3\xB0\xBA\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x7C"],
        ["\xF3\xB0\xBA\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xF3\xB0\xBA\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xF3\xB0\xBA\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xF3\xB0\xBA\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],
        ["\xF3\xB0\xBA\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],
        ["\xF3\xB0\xBA\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],
        ["\xF3\xB0\xBA\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],
        ["\xF3\xB0\xBA\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],
        ["\xF3\xB0\xBA\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xF3\xB0\xBA\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],
        ["\xF3\xB0\xBB\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],
        ["\xF3\xB0\xBB\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],
        ["\xF3\xB0\xBB\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],
        ["\xF3\xB0\xBB\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],
        ["\xF3\xB0\xBB\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],
        ["\xF3\xB0\xBB\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],
        ["\xF3\xB0\xBB\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],
        ["\xF3\xB0\xBB\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xF3\xB0\xBB\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xF3\xB0\xBB\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xF3\xB0\xBB\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],
        ["\xF3\xB0\xBB\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xF3\xB0\xBB\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],
        ["\xF3\xB0\xBB\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],
        ["\xF3\xB0\xBB\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xF3\xB0\xBB\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xF3\xB0\xBB\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x4A"],
        ["\xF3\xB0\xBB\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x5B"],
        ["\xF3\xB0\xBB\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x5A"],
        ["\xF3\xB0\xBB\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x5F"],
        ["\xF3\xB0\xBB\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x6D"],
        ["\xF3\xB0\xBB\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x79"],
        ["\xF3\xB0\xBB\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x57"],
        ["\xF3\xB0\xBB\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x59"],
        ["\xF3\xB0\xBB\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x62"],
        ["\xF3\xB0\xBB\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x63"],
        ["\xF3\xB0\xBB\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x64"],
        ["\xF3\xB0\xBB\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x65"],
        ["\xF3\xB0\xBB\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x66"],
        ["\xF3\xB0\xBB\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x67"],
        ["\xF3\xB0\xBB\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x68"],
        ["\xF3\xB0\xBB\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x69"],
        ["\xF3\xB0\xBB\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x70"],
        ["\xF3\xB0\xBB\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x71"],
        ["\xF3\xB0\xBB\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x72"],
        ["\xF3\xB0\xBB\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x73"],
        ["\xF3\xB0\xBB\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x74"],
        ["\xF3\xB0\xBB\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x75"],
        ["\xF3\xB0\xBB\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x76"],
        ["\xF3\xB0\xBB\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x77"],
        ["\xF3\xB0\xBB\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x78"],
        ["\xF3\xB0\xBB\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x80"],
        ["\xF3\xB0\xBB\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x8B"],
        ["\xF3\xB0\xBB\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x73"],
        ["\xF3\xB0\xBB\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x9C"],
        ["\xF3\xB0\xBB\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA0"],
        ["\xF3\xB0\xBB\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],
        ["\xF3\xB0\xBB\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],
        ["\xF3\xB0\xBB\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xF3\xB0\xBB\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x6A"],
        ["\xF3\xB0\xBB\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xF3\xB0\xBB\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xF3\xB0\xBB\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x4F"],
        ["\xF3\xB0\xBB\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x7F"],
        ["\xF3\xB0\xBB\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x7B"],
        ["\xF3\xB0\xBB\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],
        ["\xF3\xB0\xBB\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x6C"],
        ["\xF3\xB0\xBB\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x50"],
        ["\xF3\xB0\xBB\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x7D"],
        ["\xF3\xB0\xBB\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x4D"],
        ["\xF3\xB0\xBB\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x5D"],
        ["\xF3\xB0\xBB\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x5C"],
        ["\xF3\xB0\xBB\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x4E"],
        ["\xF3\xB0\xBB\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x6B"],
        ["\xF3\xB0\xBC\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x60"],
        ["\xF3\xB0\xBC\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x4B"],
        ["\xF3\xB0\xBC\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x61"],
        ["\xF3\xB0\xBC\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xF3\xB0\xBC\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xF3\xB0\xBC\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xF3\xB0\xBC\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xF3\xB0\xBC\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],
        ["\xF3\xB0\xBC\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xF3\xB0\xBC\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xF3\xB0\xBC\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xF3\xB0\xBC\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xF3\xB0\xBC\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],
        ["\xF3\xB0\xBC\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x7A"],
        ["\xF3\xB0\xBC\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x5E"],
        ["\xF3\xB0\xBC\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x4C"],
        ["\xF3\xB0\xBC\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x7E"],
        ["\xF3\xB0\xBC\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x6E"],
        ["\xF3\xB0\xBC\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x6F"],
        ["\xF3\xB0\xBC\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x7C"],
        ["\xF3\xB0\xBC\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],
        ["\xF3\xB0\xBC\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xF3\xB0\xBC\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],
        ["\xF3\xB0\xBC\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],
        ["\xF3\xB0\xBC\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],
        ["\xF3\xB0\xBC\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xF3\xB0\xBC\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xF3\xB0\xBC\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xF3\xB0\xBC\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xF3\xB0\xBC\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xF3\xB0\xBC\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],
        ["\xF3\xB0\xBC\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xF3\xB0\xBC\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],
        ["\xF3\xB0\xBC\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],
        ["\xF3\xB0\xBC\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],
        ["\xF3\xB0\xBC\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xF3\xB0\xBC\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],
        ["\xF3\xB0\xBC\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xF3\xB0\xBC\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],
        ["\xF3\xB0\xBC\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xF3\xB0\xBC\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xF3\xB0\xBC\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xF3\xB0\xBC\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],
        ["\xF3\xB0\xBC\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xF3\xB0\xBC\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],
        ["\xF3\xB0\xBC\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xF3\xB0\xBC\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x4A"],
        ["\xF3\xB0\xBC\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x5B"],
        ["\xF3\xB0\xBC\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x5A"],
        ["\xF3\xB0\xBC\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x5F"],
        ["\xF3\xB0\xBC\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x6D"],
        ["\xF3\xB0\xBC\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x79"],
        ["\xF3\xB0\xBC\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x57"],
        ["\xF3\xB0\xBC\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x59"],
        ["\xF3\xB0\xBC\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x62"],
        ["\xF3\xB0\xBC\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x63"],
        ["\xF3\xB0\xBC\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x64"],
        ["\xF3\xB0\xBC\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x65"],
        ["\xF3\xB0\xBC\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x66"],
        ["\xF3\xB0\xBC\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE0"],
        ["\xF3\xB0\xBC\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x68"],
        ["\xF3\xB0\xBC\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x69"],
        ["\xF3\xB0\xBC\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x70"],
        ["\xF3\xB0\xBC\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x71"],
        ["\xF3\xB0\xBD\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x72"],
        ["\xF3\xB0\xBD\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x73"],
        ["\xF3\xB0\xBD\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x74"],
        ["\xF3\xB0\xBD\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x75"],
        ["\xF3\xB0\xBD\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x76"],
        ["\xF3\xB0\xBD\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x77"],
        ["\xF3\xB0\xBD\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x78"],
        ["\xF3\xB0\xBD\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x80"],
        ["\xF3\xB0\xBD\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x8B"],
        ["\xF3\xB0\xBD\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x9B"],
        ["\xF3\xB0\xBD\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x9C"],
        ["\xF3\xB0\xBD\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA0"],
        ["\xF3\xB0\xBD\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xF3\xB0\xBD\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xF3\xB0\xBD\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xF3\xB0\xBD\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x6A"],
        ["\xF3\xB0\xBD\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xF3\xB0\xBD\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xF3\xB0\xBD\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x4F"],
        ["\xF3\xB0\xBD\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x7F"],
        ["\xF3\xB0\xBD\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x7B"],
        ["\xF3\xB0\xBD\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xF3\xB0\xBD\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x6C"],
        ["\xF3\xB0\xBD\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x50"],
        ["\xF3\xB0\xBD\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x7D"],
        ["\xF3\xB0\xBD\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x4D"],
        ["\xF3\xB0\xBD\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x5D"],
        ["\xF3\xB0\xBD\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x5C"],
        ["\xF3\xB0\xBD\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x4E"],
        ["\xF3\xB0\xBD\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x6B"],
        ["\xF3\xB0\xBD\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x60"],
        ["\xF3\xB0\xBD\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x4B"],
        ["\xF3\xB0\xBD\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x61"],
        ["\xF3\xB0\xBD\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],
        ["\xF3\xB0\xBD\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xF3\xB0\xBD\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xF3\xB0\xBD\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],
        ["\xF3\xB0\xBD\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],
        ["\xF3\xB0\xBD\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xF3\xB0\xBD\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],
        ["\xF3\xB0\xBD\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],
        ["\xF3\xB0\xBD\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],
        ["\xF3\xB0\xBD\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xF3\xB0\xBD\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x7A"],
        ["\xF3\xB0\xBD\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x5E"],
        ["\xF3\xB0\xBD\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x4C"],
        ["\xF3\xB0\xBD\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x7E"],
        ["\xF3\xB0\xBD\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x6E"],
        ["\xF3\xB0\xBD\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x6F"],
        ["\xF3\xB0\xBD\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x7C"],
        ["\xF3\xB0\xBD\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xF3\xB0\xBD\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xF3\xB0\xBD\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xF3\xB0\xBD\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xF3\xB0\xBD\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xF3\xB0\xBD\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],
        ["\xF3\xB0\xBD\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],
        ["\xF3\xB0\xBD\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xF3\xB0\xBD\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],
        ["\xF3\xB0\xBD\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],
        ["\xF3\xB0\xBD\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xF3\xB0\xBD\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],
        ["\xF3\xB0\xBD\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xF3\xB0\xBD\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],
        ["\xF3\xB0\xBE\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],
        ["\xF3\xB0\xBE\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xF3\xB0\xBE\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],
        ["\xF3\xB0\xBE\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xF3\xB0\xBE\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],
        ["\xF3\xB0\xBE\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xF3\xB0\xBE\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xF3\xB0\xBE\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xF3\xB0\xBE\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],
        ["\xF3\xB0\xBE\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xF3\xB0\xBE\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],
        ["\xF3\xB0\xBE\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xF3\xB0\xBE\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x4A"],
        ["\xF3\xB0\xBE\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x5B"],
        ["\xF3\xB0\xBE\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x5A"],
        ["\xF3\xB0\xBE\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x5F"],
        ["\xF3\xB0\xBE\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x6D"],
        ["\xF3\xB0\xBE\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x79"],
        ["\xF3\xB0\xBE\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x57"],
        ["\xF3\xB0\xBE\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x59"],
        ["\xF3\xB0\xBE\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x62"],
        ["\xF3\xB0\xBE\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x63"],
        ["\xF3\xB0\xBE\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x64"],
        ["\xF3\xB0\xBE\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x65"],
        ["\xF3\xB0\xBE\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x66"],
        ["\xF3\xB0\xBE\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x67"],
        ["\xF3\xB0\xBE\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x68"],
        ["\xF3\xB0\xBE\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x69"],
        ["\xF3\xB0\xBE\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x70"],
        ["\xF3\xB0\xBE\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x71"],
        ["\xF3\xB0\xBE\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x72"],
        ["\xF3\xB0\xBE\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x73"],
        ["\xF3\xB0\xBE\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x74"],
        ["\xF3\xB0\xBE\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x75"],
        ["\xF3\xB0\xBE\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x76"],
        ["\xF3\xB0\xBE\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x77"],
        ["\xF3\xB0\xBE\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x78"],
        ["\xF3\xB0\xBE\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x80"],
        ["\xF3\xB0\xBE\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x8B"],
        ["\xF3\xB0\xBE\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x9B"],
        ["\xF3\xB0\xBE\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x9C"],
        ["\xF3\xB0\xBE\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA0"],
        ["\xF3\xB0\xBE\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xF3\xB0\xBE\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xF3\xB0\xBE\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],
        ["\xF3\xB0\xBE\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\x6A"],
        ["\xF3\xB0\xBE\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xF3\xB0\xBE\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xF3\xB0\xBE\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x4F"],
        ["\xF3\xB0\xBE\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x7F"],
        ["\xF3\xB0\xBE\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x7B"],
        ["\xF3\xB0\xBE\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],
        ["\xF3\xB0\xBE\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x6C"],
        ["\xF3\xB0\xBE\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x50"],
        ["\xF3\xB0\xBE\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x7D"],
        ["\xF3\xB0\xBE\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x4D"],
        ["\xF3\xB0\xBE\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x5D"],
        ["\xF3\xB0\xBE\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x5C"],
        ["\xF3\xB0\xBE\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x4E"],
        ["\xF3\xB0\xBE\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x6B"],
        ["\xF3\xB0\xBE\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x60"],
        ["\xF3\xB0\xBE\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x4B"],
        ["\xF3\xB0\xBE\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x61"],
        ["\xF3\xB0\xBE\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE7"],
        ["\xF3\xB0\xBF\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],
        ["\xF3\xB0\xBF\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],
        ["\xF3\xB0\xBF\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xF3\xB0\xBF\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],
        ["\xF3\xB0\xBF\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],
        ["\xF3\xB0\xBF\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],
        ["\xF3\xB0\xBF\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xF3\xB0\xBF\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],
        ["\xF3\xB0\xBF\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xF3\xB0\xBF\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x7A"],
        ["\xF3\xB0\xBF\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x5E"],
        ["\xF3\xB0\xBF\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x4C"],
        ["\xF3\xB0\xBF\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x7E"],
        ["\xF3\xB0\xBF\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x6E"],
        ["\xF3\xB0\xBF\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x6F"],
        ["\xF3\xB0\xBF\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x7C"],
        ["\xF3\xB0\xBF\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],
        ["\xF3\xB0\xBF\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xF3\xB0\xBF\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],
        ["\xF3\xB0\xBF\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xF3\xB0\xBF\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xF3\xB0\xBF\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],
        ["\xF3\xB0\xBF\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],
        ["\xF3\xB0\xBF\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],
        ["\xF3\xB0\xBF\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xF3\xB0\xBF\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],
        ["\xF3\xB0\xBF\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],
        ["\xF3\xB0\xBF\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],
        ["\xF3\xB0\xBF\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],
        ["\xF3\xB0\xBF\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xF3\xB0\xBF\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xF3\xB0\xBF\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xF3\xB0\xBF\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xF3\xB0\xBF\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],
        ["\xF3\xB0\xBF\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],
        ["\xF3\xB0\xBF\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],
        ["\xF3\xB0\xBF\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xF3\xB0\xBF\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],
        ["\xF3\xB0\xBF\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xF3\xB0\xBF\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],
        ["\xF3\xB0\xBF\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xF3\xB0\xBF\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],
        ["\xF3\xB0\xBF\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x4A"],
        ["\xF3\xB0\xBF\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x5B"],
        ["\xF3\xB0\xBF\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x5A"],
        ["\xF3\xB0\xBF\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x5F"],
        ["\xF3\xB0\xBF\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x6D"],
        ["\xF3\xB0\xBF\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x79"],
        ["\xF3\xB0\xBF\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x57"],
        ["\xF3\xB0\xBF\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x59"],
        ["\xF3\xB0\xBF\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x62"],
        ["\xF3\xB0\xBF\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x63"],
        ["\xF3\xB0\xBF\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x64"],
        ["\xF3\xB0\xBF\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x65"],
        ["\xF3\xB0\xBF\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x66"],
        ["\xF3\xB0\xBF\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x67"],
        ["\xF3\xB0\xBF\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x68"],
        ["\xF3\xB0\xBF\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x69"],
        ["\xF3\xB0\xBF\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x70"],
        ["\xF3\xB0\xBF\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x71"],
        ["\xF3\xB0\xBF\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x72"],
        ["\xF3\xB0\xBF\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x73"],
        ["\xF3\xB0\xBF\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x74"],
        ["\xF3\xB0\xBF\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x75"],
        ["\xF3\xB1\x80\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x76"],
        ["\xF3\xB1\x80\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x77"],
        ["\xF3\xB1\x80\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x78"],
        ["\xF3\xB1\x80\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x80"],
        ["\xF3\xB1\x80\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x8B"],
        ["\xF3\xB1\x80\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9B"],
        ["\xF3\xB1\x80\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x9C"],
        ["\xF3\xB1\x80\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA0"],
        ["\xF3\xB1\x80\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],
        ["\xF3\xB1\x80\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],
        ["\xF3\xB1\x80\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],
        ["\xF3\xB1\x80\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\x6A"],
        ["\xF3\xB1\x80\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],
        ["\xF3\xB1\x80\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],
        ["\xF3\xB1\x80\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x4F"],
        ["\xF3\xB1\x80\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x7F"],
        ["\xF3\xB1\x80\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x7B"],
        ["\xF3\xB1\x80\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],
        ["\xF3\xB1\x80\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x6C"],
        ["\xF3\xB1\x80\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x50"],
        ["\xF3\xB1\x80\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x7D"],
        ["\xF3\xB1\x80\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x4D"],
        ["\xF3\xB1\x80\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x5D"],
        ["\xF3\xB1\x80\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x5C"],
        ["\xF3\xB1\x80\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x4E"],
        ["\xF3\xB1\x80\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x6B"],
        ["\xF3\xB1\x80\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x60"],
        ["\xF3\xB1\x80\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x4B"],
        ["\xF3\xB1\x80\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x61"],
        ["\xF3\xB1\x80\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],
        ["\xF3\xB1\x80\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],
        ["\xF3\xB1\x80\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],
        ["\xF3\xB1\x80\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xF3\xB1\x80\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xF3\xB1\x80\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xF3\xB1\x80\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],
        ["\xF3\xB1\x80\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],
        ["\xF3\xB1\x80\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],
        ["\xF3\xB1\x80\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],
        ["\xF3\xB1\x80\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x7A"],
        ["\xF3\xB1\x80\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x5E"],
        ["\xF3\xB1\x80\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x4C"],
        ["\xF3\xB1\x80\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x7E"],
        ["\xF3\xB1\x80\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x6E"],
        ["\xF3\xB1\x80\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x6F"],
        ["\xF3\xB1\x80\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x7C"],
        ["\xF3\xB1\x80\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],
        ["\xF3\xB1\x80\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],
        ["\xF3\xB1\x80\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],
        ["\xF3\xB1\x80\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xF3\xB1\x80\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],
        ["\xF3\xB1\x80\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xF3\xB1\x80\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],
        ["\xF3\xB1\x80\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],
        ["\xF3\xB1\x80\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],
        ["\xF3\xB1\x80\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],
        ["\xF3\xB1\x80\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],
        ["\xF3\xB1\x80\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],
        ["\xF3\xB1\x80\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xF3\xB1\x80\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xF3\xB1\x80\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],
        ["\xF3\xB1\x80\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],
        ["\xF3\xB1\x80\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xF3\xB1\x80\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],
        ["\xF3\xB1\x81\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],
        ["\xF3\xB1\x81\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],
        ["\xF3\xB1\x81\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],
        ["\xF3\xB1\x81\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],
        ["\xF3\xB1\x81\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],
        ["\xF3\xB1\x81\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],
        ["\xF3\xB1\x81\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],
        ["\xF3\xB1\x81\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],
        ["\xF3\xB1\x81\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x4A"],
        ["\xF3\xB1\x81\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x5B"],
        ["\xF3\xB1\x81\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x5A"],
        ["\xF3\xB1\x81\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x5F"],
        ["\xF3\xB1\x81\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x6D"],
        ["\xF3\xB1\x81\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x79"],
        ["\xF3\xB1\x81\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x57"],
        ["\xF3\xB1\x81\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x59"],
        ["\xF3\xB1\x81\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x62"],
        ["\xF3\xB1\x81\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x63"],
        ["\xF3\xB1\x81\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x64"],
        ["\xF3\xB1\x81\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x65"],
        ["\xF3\xB1\x81\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x66"],
        ["\xF3\xB1\x81\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x67"],
        ["\xF3\xB1\x81\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x68"],
        ["\xF3\xB1\x81\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x69"],
        ["\xF3\xB1\x81\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x70"],
        ["\xF3\xB1\x81\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x71"],
        ["\xF3\xB1\x81\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x72"],
        ["\xF3\xB1\x81\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x73"],
        ["\xF3\xB1\x81\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x74"],
        ["\xF3\xB1\x81\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x75"],
        ["\xF3\xB1\x81\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x76"],
        ["\xF3\xB1\x81\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x77"],
        ["\xF3\xB1\x81\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x78"],
        ["\xF3\xB1\x81\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],
        ["\xF3\xB1\x81\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],
        ["\xF3\xB1\x81\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x9B"],
        ["\xF3\xB1\x81\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x9C"],
        ["\xF3\xB1\x81\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA0"],
        ["\xF3\xB1\x81\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],
        ["\xF3\xB1\x81\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],
        ["\xF3\xB1\x81\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],
        ["\xF3\xB1\x81\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\x6A"],
        ["\xF3\xB1\x81\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],
        ["\xF3\xB1\x81\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],
        ["\xF3\xB1\x81\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x4F"],
        ["\xF3\xB1\x81\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x7F"],
        ["\xF3\xB1\x81\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x7B"],
        ["\xF3\xB1\x81\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],
        ["\xF3\xB1\x81\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x6C"],
        ["\xF3\xB1\x81\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x50"],
        ["\xF3\xB1\x81\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x7D"],
        ["\xF3\xB1\x81\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x4D"],
        ["\xF3\xB1\x81\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x5D"],
        ["\xF3\xB1\x81\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x5C"],
        ["\xF3\xB1\x81\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x4E"],
        ["\xF3\xB1\x81\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x6B"],
        ["\xF3\xB1\x81\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x60"],
        ["\xF3\xB1\x81\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x4B"],
        ["\xF3\xB1\x81\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x61"],
        ["\xF3\xB1\x81\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],
        ["\xF3\xB1\x81\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],
        ["\xF3\xB1\x81\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xF3\xB1\x81\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],
        ["\xF3\xB1\x81\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],
        ["\xF3\xB1\x82\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xF3\xB1\x82\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],
        ["\xF3\xB1\x82\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],
        ["\xF3\xB1\x82\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xF3\xB1\x82\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],
        ["\xF3\xB1\x82\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x7A"],
        ["\xF3\xB1\x82\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x5E"],
        ["\xF3\xB1\x82\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x4C"],
        ["\xF3\xB1\x82\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x7E"],
        ["\xF3\xB1\x82\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x6E"],
        ["\xF3\xB1\x82\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x6F"],
        ["\xF3\xB1\x82\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x7C"],
        ["\xF3\xB1\x82\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],
        ["\xF3\xB1\x82\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],
        ["\xF3\xB1\x82\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],
        ["\xF3\xB1\x82\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],
        ["\xF3\xB1\x82\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],
        ["\xF3\xB1\x82\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],
        ["\xF3\xB1\x82\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xF3\xB1\x82\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],
        ["\xF3\xB1\x82\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],
        ["\xF3\xB1\x82\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],
        ["\xF3\xB1\x82\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],
        ["\xF3\xB1\x82\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],
        ["\xF3\xB1\x82\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],
        ["\xF3\xB1\x82\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],
        ["\xF3\xB1\x82\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],
        ["\xF3\xB1\x82\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],
        ["\xF3\xB1\x82\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],
        ["\xF3\xB1\x82\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],
        ["\xF3\xB1\x82\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],
        ["\xF3\xB1\x82\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],
        ["\xF3\xB1\x82\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],
        ["\xF3\xB1\x82\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],
        ["\xF3\xB1\x82\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],
        ["\xF3\xB1\x82\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],
        ["\xF3\xB1\x82\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],
        ["\xF3\xB1\x82\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xF3\xB1\x82\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x4A"],
        ["\xF3\xB1\x82\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x5B"],
        ["\xF3\xB1\x82\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x5A"],
        ["\xF3\xB1\x82\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x5F"],
        ["\xF3\xB1\x82\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x6D"],
        ["\xF3\xB1\x82\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x79"],
        ["\xF3\xB1\x82\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x57"],
        ["\xF3\xB1\x82\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x59"],
        ["\xF3\xB1\x82\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x62"],
        ["\xF3\xB1\x82\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x63"],
        ["\xF3\xB1\x82\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x64"],
        ["\xF3\xB1\x82\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x65"],
        ["\xF3\xB1\x82\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x66"],
        ["\xF3\xB1\x82\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x67"],
        ["\xF3\xB1\x82\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x68"],
        ["\xF3\xB1\x82\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\xF3\xB1\x82\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x70"],
        ["\xF3\xB1\x82\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x71"],
        ["\xF3\xB1\x82\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x72"],
        ["\xF3\xB1\x82\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x73"],
        ["\xF3\xB1\x82\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x74"],
        ["\xF3\xB1\x82\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x75"],
        ["\xF3\xB1\x82\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x76"],
        ["\xF3\xB1\x82\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x77"],
        ["\xF3\xB1\x82\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x78"],
        ["\xF3\xB1\x82\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x80"],
        ["\xF3\xB1\x83\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x8B"],
        ["\xF3\xB1\x83\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x9B"],
        ["\xF3\xB1\x83\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x9C"],
        ["\xF3\xB1\x83\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA0"],
        ["\xF3\xB1\x83\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],
        ["\xF3\xB1\x83\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],
        ["\xF3\xB1\x83\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],
        ["\xF3\xB1\x83\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x6A"],
        ["\xF3\xB1\x83\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],
        ["\xF3\xB1\x83\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],
        ["\xF3\xB1\x83\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x4F"],
        ["\xF3\xB1\x83\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x7F"],
        ["\xF3\xB1\x83\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x7B"],
        ["\xF3\xB1\x83\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],
        ["\xF3\xB1\x83\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x6C"],
        ["\xF3\xB1\x83\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x50"],
        ["\xF3\xB1\x83\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x7D"],
        ["\xF3\xB1\x83\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x4D"],
        ["\xF3\xB1\x83\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x5D"],
        ["\xF3\xB1\x83\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x5C"],
        ["\xF3\xB1\x83\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x4E"],
        ["\xF3\xB1\x83\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x6B"],
        ["\xF3\xB1\x83\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x60"],
        ["\xF3\xB1\x83\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x4B"],
        ["\xF3\xB1\x83\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x61"],
        ["\xF3\xB1\x83\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xF3\xB1\x83\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xF3\xB1\x83\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xF3\xB1\x83\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],
        ["\xF3\xB1\x83\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xF3\xB1\x83\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xF3\xB1\x83\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xF3\xB1\x83\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xF3\xB1\x83\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],
        ["\xF3\xB1\x83\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xF3\xB1\x83\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x7A"],
        ["\xF3\xB1\x83\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x5E"],
        ["\xF3\xB1\x83\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x4C"],
        ["\xF3\xB1\x83\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x7E"],
        ["\xF3\xB1\x83\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x6E"],
        ["\xF3\xB1\x83\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x6F"],
        ["\xF3\xB1\x83\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x7C"],
        ["\xF3\xB1\x83\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],
        ["\xF3\xB1\x83\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],
        ["\xF3\xB1\x83\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xF3\xB1\x83\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xF3\xB1\x83\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],
        ["\xF3\xB1\x83\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xF3\xB1\x83\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xF3\xB1\x83\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xF3\xB1\x83\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xF3\xB1\x83\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],
        ["\xF3\xB1\x83\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],
        ["\xF3\xB1\x83\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],
        ["\xF3\xB1\x83\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],
        ["\xF3\xB1\x83\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],
        ["\xF3\xB1\x83\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xF3\xB1\x83\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xF3\xB1\x83\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xF3\xB1\x83\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xF3\xB1\x83\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xF3\xB1\x83\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xF3\xB1\x83\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],
        ["\xF3\xB1\x83\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xF3\xB1\x84\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xF3\xB1\x84\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],
        ["\xF3\xB1\x84\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xF3\xB1\x84\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],
        ["\xF3\xB1\x84\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x4A"],
        ["\xF3\xB1\x84\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x5B"],
        ["\xF3\xB1\x84\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x5A"],
        ["\xF3\xB1\x84\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x5F"],
        ["\xF3\xB1\x84\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x6D"],
        ["\xF3\xB1\x84\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x79"],
        ["\xF3\xB1\x84\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x57"],
        ["\xF3\xB1\x84\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x59"],
        ["\xF3\xB1\x84\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x62"],
        ["\xF3\xB1\x84\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x63"],
        ["\xF3\xB1\x84\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x64"],
        ["\xF3\xB1\x84\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x65"],
        ["\xF3\xB1\x84\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x66"],
        ["\xF3\xB1\x84\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x67"],
        ["\xF3\xB1\x84\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x68"],
        ["\xF3\xB1\x84\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x69"],
        ["\xF3\xB1\x84\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x70"],
        ["\xF3\xB1\x84\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x71"],
        ["\xF3\xB1\x84\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x72"],
        ["\xF3\xB1\x84\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x73"],
        ["\xF3\xB1\x84\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x74"],
        ["\xF3\xB1\x84\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x75"],
        ["\xF3\xB1\x84\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x76"],
        ["\xF3\xB1\x84\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x77"],
        ["\xF3\xB1\x84\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x78"],
        ["\xF3\xB1\x84\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x80"],
        ["\xF3\xB1\x84\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x8B"],
        ["\xF3\xB1\x84\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x9B"],
        ["\xF3\xB1\x84\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x9C"],
        ["\xF3\xB1\x84\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA0"],
        ["\xF3\xB1\x84\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],
        ["\xF3\xB1\x84\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],
        ["\xF3\xB1\x84\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xF3\xB1\x84\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\x6A"],
        ["\xF3\xB1\x84\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xF3\xB1\x84\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],
        ["\xF3\xB1\x84\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x4F"],
        ["\xF3\xB1\x84\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x7F"],
        ["\xF3\xB1\x84\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x7B"],
        ["\xF3\xB1\x84\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xF3\xB1\x84\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x6C"],
        ["\xF3\xB1\x84\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x50"],
        ["\xF3\xB1\x84\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x7D"],
        ["\xF3\xB1\x84\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x4D"],
        ["\xF3\xB1\x84\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x5D"],
        ["\xF3\xB1\x84\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x5C"],
        ["\xF3\xB1\x84\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x4E"],
        ["\xF3\xB1\x84\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x6B"],
        ["\xF3\xB1\x84\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x60"],
        ["\xF3\xB1\x84\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x4B"],
        ["\xF3\xB1\x84\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x61"],
        ["\xF3\xB1\x84\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xF3\xB1\x84\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],
        ["\xF3\xB1\x84\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xF3\xB1\x84\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],
        ["\xF3\xB1\x84\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],
        ["\xF3\xB1\x84\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xF3\xB1\x84\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xF3\xB1\x84\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],
        ["\xF3\xB1\x84\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],
        ["\xF3\xB1\x85\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xF3\xB1\x85\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x7A"],
        ["\xF3\xB1\x85\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x5E"],
        ["\xF3\xB1\x85\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x4C"],
        ["\xF3\xB1\x85\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x7E"],
        ["\xF3\xB1\x85\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x6E"],
        ["\xF3\xB1\x85\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x6F"],
        ["\xF3\xB1\x85\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x7C"],
        ["\xF3\xB1\x85\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],
        ["\xF3\xB1\x85\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],
        ["\xF3\xB1\x85\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xF3\xB1\x85\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],
        ["\xF3\xB1\x85\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],
        ["\xF3\xB1\x85\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],
        ["\xF3\xB1\x85\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],
        ["\xF3\xB1\x85\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],
        ["\xF3\xB1\x85\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xF3\xB1\x85\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],
        ["\xF3\xB1\x85\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],
        ["\xF3\xB1\x85\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xF3\xB1\x85\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xF3\xB1\x85\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],
        ["\xF3\xB1\x85\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],
        ["\xF3\xB1\x85\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],
        ["\xF3\xB1\x85\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],
        ["\xF3\xB1\x85\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],
        ["\xF3\xB1\x85\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xF3\xB1\x85\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],
        ["\xF3\xB1\x85\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xF3\xB1\x85\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],
        ["\xF3\xB1\x85\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xF3\xB1\x85\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],
        ["\xF3\xB1\x85\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],
        ["\xF3\xB1\x85\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\x95"],
        ["\xF3\xB1\x85\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x4A"],
        ["\xF3\xB1\x85\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x5B"],
        ["\xF3\xB1\x85\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x5A"],
        ["\xF3\xB1\x85\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x5F"],
        ["\xF3\xB1\x85\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x6D"],
        ["\xF3\xB1\x85\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x79"],
        ["\xF3\xB1\x85\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x57"],
        ["\xF3\xB1\x85\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x59"],
        ["\xF3\xB1\x85\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x62"],
        ["\xF3\xB1\x85\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],
        ["\xF3\xB1\x85\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x64"],
        ["\xF3\xB1\x85\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x65"],
        ["\xF3\xB1\x85\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x66"],
        ["\xF3\xB1\x85\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x67"],
        ["\xF3\xB1\x85\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x68"],
        ["\xF3\xB1\x85\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x69"],
        ["\xF3\xB1\x85\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x70"],
        ["\xF3\xB1\x85\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x71"],
        ["\xF3\xB1\x85\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x72"],
        ["\xF3\xB1\x85\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x73"],
        ["\xF3\xB1\x85\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x74"],
        ["\xF3\xB1\x85\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x75"],
        ["\xF3\xB1\x85\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x76"],
        ["\xF3\xB1\x85\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x77"],
        ["\xF3\xB1\x85\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x78"],
        ["\xF3\xB1\x85\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x80"],
        ["\xF3\xB1\x85\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x8B"],
        ["\xF3\xB1\x85\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x9B"],
        ["\xF3\xB1\x85\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x9C"],
        ["\xF3\xB1\x85\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA0"],
        ["\xF3\xB1\x86\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],
        ["\xF3\xB1\x86\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xF3\xB1\x86\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xF3\xB1\x86\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\x6A"],
        ["\xF3\xB1\x86\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],
        ["\xF3\xB1\x86\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xF3\xB1\x86\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x4F"],
        ["\xF3\xB1\x86\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x7F"],
        ["\xF3\xB1\x86\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x7B"],
        ["\xF3\xB1\x86\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],
        ["\xF3\xB1\x86\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x6C"],
        ["\xF3\xB1\x86\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x50"],
        ["\xF3\xB1\x86\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x7D"],
        ["\xF3\xB1\x86\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x4D"],
        ["\xF3\xB1\x86\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x5D"],
        ["\xF3\xB1\x86\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x5C"],
        ["\xF3\xB1\x86\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x4E"],
        ["\xF3\xB1\x86\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x6B"],
        ["\xF3\xB1\x86\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x60"],
        ["\xF3\xB1\x86\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x4B"],
        ["\xF3\xB1\x86\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x61"],
        ["\xF3\xB1\x86\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],
        ["\xF3\xB1\x86\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],
        ["\xF3\xB1\x86\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],
        ["\xF3\xB1\x86\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],
        ["\xF3\xB1\x86\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],
        ["\xF3\xB1\x86\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],
        ["\xF3\xB1\x86\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],
        ["\xF3\xB1\x86\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],
        ["\xF3\xB1\x86\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],
        ["\xF3\xB1\x86\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],
        ["\xF3\xB1\x86\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x7A"],
        ["\xF3\xB1\x86\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x5E"],
        ["\xF3\xB1\x86\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x4C"],
        ["\xF3\xB1\x86\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x7E"],
        ["\xF3\xB1\x86\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x6E"],
        ["\xF3\xB1\x86\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x6F"],
        ["\xF3\xB1\x86\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x7C"],
        ["\xF3\xB1\x86\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],
        ["\xF3\xB1\x86\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],
        ["\xF3\xB1\x86\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],
        ["\xF3\xB1\x86\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],
        ["\xF3\xB1\x86\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],
        ["\xF3\xB1\x86\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],
        ["\xF3\xB1\x86\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],
        ["\xF3\xB1\x86\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],
        ["\xF3\xB1\x86\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],
        ["\xF3\xB1\x86\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],
        ["\xF3\xB1\x86\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],
        ["\xF3\xB1\x86\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],
        ["\xF3\xB1\x86\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],
        ["\xF3\xB1\x86\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],
        ["\xF3\xB1\x86\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],
        ["\xF3\xB1\x86\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],
        ["\xF3\xB1\x86\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],
        ["\xF3\xB1\x86\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],
        ["\xF3\xB1\x86\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],
        ["\xF3\xB1\x86\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],
        ["\xF3\xB1\x86\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],
        ["\xF3\xB1\x86\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],
        ["\xF3\xB1\x86\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],
        ["\xF3\xB1\x86\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],
        ["\xF3\xB1\x86\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],
        ["\xF3\xB1\x86\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],
        ["\xF3\xB1\x87\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x4A"],
        ["\xF3\xB1\x87\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x5B"],
        ["\xF3\xB1\x87\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x5A"],
        ["\xF3\xB1\x87\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x5F"],
        ["\xF3\xB1\x87\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x6D"],
        ["\xF3\xB1\x87\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x79"],
        ["\xF3\xB1\x87\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x57"],
        ["\xF3\xB1\x87\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x59"],
        ["\xF3\xB1\x87\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x62"],
        ["\xF3\xB1\x87\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x63"],
        ["\xF3\xB1\x87\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x64"],
        ["\xF3\xB1\x87\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x65"],
        ["\xF3\xB1\x87\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x66"],
        ["\xF3\xB1\x87\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x67"],
        ["\xF3\xB1\x87\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x68"],
        ["\xF3\xB1\x87\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x69"],
        ["\xF3\xB1\x87\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x70"],
        ["\xF3\xB1\x87\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x71"],
        ["\xF3\xB1\x87\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x72"],
        ["\xF3\xB1\x87\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x73"],
        ["\xF3\xB1\x87\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x74"],
        ["\xF3\xB1\x87\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x75"],
        ["\xF3\xB1\x87\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x76"],
        ["\xF3\xB1\x87\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x77"],
        ["\xF3\xB1\x87\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x78"],
        ["\xF3\xB1\x87\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x80"],
        ["\xF3\xB1\x87\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x8B"],
        ["\xF3\xB1\x87\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x9B"],
        ["\xF3\xB1\x87\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x9C"],
        ["\xF3\xB1\x87\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA0"],
        ["\xF3\xB1\x87\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],
        ["\xF3\xB1\x87\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],
        ["\xF3\xB1\x87\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],
        ["\xF3\xB1\x87\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\x6A"],
        ["\xF3\xB1\x87\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],
        ["\xF3\xB1\x87\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],
        ["\xF3\xB1\x87\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x4F"],
        ["\xF3\xB1\x87\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x7F"],
        ["\xF3\xB1\x87\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x7B"],
        ["\xF3\xB1\x87\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],
        ["\xF3\xB1\x87\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x6C"],
        ["\xF3\xB1\x87\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x50"],
        ["\xF3\xB1\x87\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x7D"],
        ["\xF3\xB1\x87\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x4D"],
        ["\xF3\xB1\x87\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x5D"],
        ["\xF3\xB1\x87\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x5C"],
        ["\xF3\xB1\x87\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x4E"],
        ["\xF3\xB1\x87\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x6B"],
        ["\xF3\xB1\x87\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x60"],
        ["\xF3\xB1\x87\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x4B"],
        ["\xF3\xB1\x87\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x61"],
        ["\xF3\xB1\x87\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],
        ["\xF3\xB1\x87\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\xF3\xB1\x87\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\xF3\xB1\x87\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],
        ["\xF3\xB1\x87\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],
        ["\xF3\xB1\x87\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\xF3\xB1\x87\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC6"],
        ["\xF3\xB1\x87\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],
        ["\xF3\xB1\x87\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],
        ["\xF3\xB1\x87\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\xF3\xB1\x87\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x7A"],
        ["\xF3\xB1\x87\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x5E"],
        ["\xF3\xB1\x87\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x4C"],
        ["\xF3\xB1\x88\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x7E"],
        ["\xF3\xB1\x88\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x6E"],
        ["\xF3\xB1\x88\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x6F"],
        ["\xF3\xB1\x88\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\x7C"],
        ["\xF3\xB1\x88\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\xF3\xB1\x88\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],
        ["\xF3\xB1\x88\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],
        ["\xF3\xB1\x88\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\xF3\xB1\x88\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\xF3\xB1\x88\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\xF3\xB1\x88\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\xF3\xB1\x88\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],
        ["\xF3\xB1\x88\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\xF3\xB1\x88\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\xF3\xB1\x88\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\xF3\xB1\x88\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\xF3\xB1\x88\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\xF3\xB1\x88\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\xF3\xB1\x88\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],
        ["\xF3\xB1\x88\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],
        ["\xF3\xB1\x88\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],
        ["\xF3\xB1\x88\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],
        ["\xF3\xB1\x88\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\xF3\xB1\x89\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x4F"],
        ["\xF3\xB1\x89\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x7F"],
        ["\xF3\xB1\x89\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x7B"],
        ["\xF3\xB1\x89\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],
        ["\xF3\xB1\x89\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x6C"],
        ["\xF3\xB1\x89\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x50"],
        ["\xF3\xB1\x89\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x7D"],
        ["\xF3\xB1\x89\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x4D"],
        ["\xF3\xB1\x89\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x5D"],
        ["\xF3\xB1\x89\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x5C"],
        ["\xF3\xB1\x89\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x4E"],
        ["\xF3\xB1\x89\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x6B"],
        ["\xF3\xB1\x89\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x60"],
        ["\xF3\xB1\x89\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x4B"],
        ["\xF3\xB1\x89\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x61"],
        ["\xF3\xB1\x89\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],
        ["\xF3\xB1\x89\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],
        ["\xF3\xB1\x89\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],
        ["\xF3\xB1\x89\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],
        ["\xF3\xB1\x89\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],
        ["\xF3\xB1\x89\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],
        ["\xF3\xB1\x89\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],
        ["\xF3\xB1\x89\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],
        ["\xF3\xB1\x89\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],
        ["\xF3\xB1\x89\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],
        ["\xF3\xB1\x89\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x7A"],
        ["\xF3\xB1\x89\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x5E"],
        ["\xF3\xB1\x89\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x4C"],
        ["\xF3\xB1\x89\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x7E"],
        ["\xF3\xB1\x89\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x6E"],
        ["\xF3\xB1\x89\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x6F"],
        ["\xF3\xB1\x89\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x7C"],
        ["\xF3\xB1\x89\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],
        ["\xF3\xB1\x89\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],
        ["\xF3\xB1\x89\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],
        ["\xF3\xB1\x89\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],
        ["\xF3\xB1\x89\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],
        ["\xF3\xB1\x89\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],
        ["\xF3\xB1\x89\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],
        ["\xF3\xB1\x89\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],
        ["\xF3\xB1\x89\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],
        ["\xF3\xB1\x89\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],
        ["\xF3\xB1\x89\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],
        ["\xF3\xB1\x89\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],
        ["\xF3\xB1\x89\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],
        ["\xF3\xB1\x89\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],
        ["\xF3\xB1\x89\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],
        ["\xF3\xB1\x89\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],
        ["\xF3\xB1\x89\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],
        ["\xF3\xB1\x89\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],
        ["\xF3\xB1\x89\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],
        ["\xF3\xB1\x89\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],
        ["\xF3\xB1\x89\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],
        ["\xF3\xB1\x89\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],
        ["\xF3\xB1\x89\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],
        ["\xF3\xB1\x89\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],
        ["\xF3\xB1\x89\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],
        ["\xF3\xB1\x89\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],
        ["\xF3\xB1\x89\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x4A"],
        ["\xF3\xB1\x89\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x5B"],
        ["\xF3\xB1\x89\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x5A"],
        ["\xF3\xB1\x89\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x5F"],
        ["\xF3\xB1\x8A\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x6D"],
        ["\xF3\xB1\x8A\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x79"],
        ["\xF3\xB1\x8A\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x57"],
        ["\xF3\xB1\x8A\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x59"],
        ["\xF3\xB1\x8A\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x62"],
        ["\xF3\xB1\x8A\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x63"],
        ["\xF3\xB1\x8A\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x64"],
        ["\xF3\xB1\x8A\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x65"],
        ["\xF3\xB1\x8A\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x66"],
        ["\xF3\xB1\x8A\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x67"],
        ["\xF3\xB1\x8A\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x68"],
        ["\xF3\xB1\x8A\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x69"],
        ["\xF3\xB1\x8A\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x70"],
        ["\xF3\xB1\x8A\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x71"],
        ["\xF3\xB1\x8A\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x72"],
        ["\xF3\xB1\x8A\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x73"],
        ["\xF3\xB1\x8A\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x74"],
        ["\xF3\xB1\x8A\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x75"],
        ["\xF3\xB1\x8A\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x76"],
        ["\xF3\xB1\x8A\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x77"],
        ["\xF3\xB1\x8A\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x78"],
        ["\xF3\xB1\x8A\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x80"],
        ["\xF3\xB1\x8A\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x8B"],
        ["\xF3\xB1\x8A\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x9B"],
        ["\xF3\xB1\x8A\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x9C"],
        ["\xF3\xB1\x8A\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA0"],
        ["\xF3\xB1\x8A\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],
        ["\xF3\xB1\x8A\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],
        ["\xF3\xB1\x8A\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],
        ["\xF3\xB1\x8A\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\x6A"],
        ["\xF3\xB1\x8A\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],
        ["\xF3\xB1\x8A\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],
        ["\xF3\xB1\x8A\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x4F"],
        ["\xF3\xB1\x8A\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x7F"],
        ["\xF3\xB1\x8A\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x7B"],
        ["\xF3\xB1\x8A\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],
        ["\xF3\xB1\x8A\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x6C"],
        ["\xF3\xB1\x8A\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x50"],
        ["\xF3\xB1\x8A\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x7D"],
        ["\xF3\xB1\x8A\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x4D"],
        ["\xF3\xB1\x8A\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x5D"],
        ["\xF3\xB1\x8A\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x5C"],
        ["\xF3\xB1\x8A\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x4E"],
        ["\xF3\xB1\x8A\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x6B"],
        ["\xF3\xB1\x8A\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x60"],
        ["\xF3\xB1\x8A\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x4B"],
        ["\xF3\xB1\x8A\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x61"],
        ["\xF3\xB1\x8A\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\xF3\xB1\x8A\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],
        ["\xF3\xB1\x8A\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\xF3\xB1\x8A\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\xF3\xB1\x8A\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],
        ["\xF3\xB1\x8A\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],
        ["\xF3\xB1\x8A\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],
        ["\xF3\xB1\x8A\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],
        ["\xF3\xB1\x8A\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],
        ["\xF3\xB1\x8A\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\xF3\xB1\x8A\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x7A"],
        ["\xF3\xB1\x8A\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x5E"],
        ["\xF3\xB1\x8A\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x4C"],
        ["\xF3\xB1\x8A\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x7E"],
        ["\xF3\xB1\x8A\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x6E"],
        ["\xF3\xB1\x8A\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x6F"],
        ["\xF3\xB1\x8A\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x7C"],
        ["\xF3\xB1\x8B\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],
        ["\xF3\xB1\x8B\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],
        ["\xF3\xB1\x8B\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],
        ["\xF3\xB1\x8B\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\xF3\xB1\x8B\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\xF3\xB1\x8B\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\xF3\xB1\x8B\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\xF3\xB1\x8B\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\xF3\xB1\x8B\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\xF3\xB1\x8B\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\xF3\xB1\x8B\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],
        ["\xF3\xB1\x8B\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],
        ["\xF3\xB1\x8B\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\xF3\xB1\x8B\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],
        ["\xF3\xB1\x8B\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],
        ["\xF3\xB1\x8B\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],
        ["\xF3\xB1\x8B\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],
        ["\xF3\xB1\x8B\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\xF3\xB1\x8B\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],
        ["\xF3\xB1\x8B\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],
        ["\xF3\xB1\x8B\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],
        ["\xF3\xB1\x8B\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],
        ["\xF3\xB1\x8B\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],
        ["\xF3\xB1\x8B\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],
        ["\xF3\xB1\x8B\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],
        ["\xF3\xB1\x8B\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],
        ["\xF3\xB1\x8B\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x4A"],
        ["\xF3\xB1\x8B\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x5B"],
        ["\xF3\xB1\x8B\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x5A"],
        ["\xF3\xB1\x8B\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x5F"],
        ["\xF3\xB1\x8B\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x6D"],
        ["\xF3\xB1\x8B\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x79"],
        ["\xF3\xB1\x8B\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x57"],
        ["\xF3\xB1\x8B\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x59"],
        ["\xF3\xB1\x8B\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x62"],
        ["\xF3\xB1\x8B\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x63"],
        ["\xF3\xB1\x8B\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x64"],
        ["\xF3\xB1\x8B\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x65"],
        ["\xF3\xB1\x8B\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x66"],
        ["\xF3\xB1\x8B\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x67"],
        ["\xF3\xB1\x8B\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x68"],
        ["\xF3\xB1\x8B\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x69"],
        ["\xF3\xB1\x8B\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x70"],
        ["\xF3\xB1\x8B\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x71"],
        ["\xF3\xB1\x8B\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x72"],
        ["\xF3\xB1\x8B\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x73"],
        ["\xF3\xB1\x8B\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x74"],
        ["\xF3\xB1\x8B\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x75"],
        ["\xF3\xB1\x8B\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x76"],
        ["\xF3\xB1\x8B\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x77"],
        ["\xF3\xB1\x8B\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x78"],
        ["\xF3\xB1\x8B\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x80"],
        ["\xF3\xB1\x8B\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x8B"],
        ["\xF3\xB1\x8B\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x9B"],
        ["\xF3\xB1\x8B\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x9C"],
        ["\xF3\xB1\x8B\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA0"],
        ["\xF3\xB1\x8B\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\xF3\xB1\x8B\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],
        ["\xF3\xB1\x8B\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\xF3\xB1\x8B\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\x6A"],
        ["\xF3\xB1\x8B\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\xF3\xB1\x8B\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\xF3\xB1\x8B\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x4F"],
        ["\xF3\xB1\x8B\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x7F"],
        ["\xF3\xB1\x8C\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x7B"],
        ["\xF3\xB1\x8C\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],
        ["\xF3\xB1\x8C\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x6C"],
        ["\xF3\xB1\x8C\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x50"],
        ["\xF3\xB1\x8C\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x7D"],
        ["\xF3\xB1\x8C\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x4D"],
        ["\xF3\xB1\x8C\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x5D"],
        ["\xF3\xB1\x8C\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x5C"],
        ["\xF3\xB1\x8C\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x4E"],
        ["\xF3\xB1\x8C\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x6B"],
        ["\xF3\xB1\x8C\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x60"],
        ["\xF3\xB1\x8C\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x4B"],
        ["\xF3\xB1\x8C\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x61"],
        ["\xF3\xB1\x8C\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],
        ["\xF3\xB1\x8C\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],
        ["\xF3\xB1\x8C\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],
        ["\xF3\xB1\x8C\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],
        ["\xF3\xB1\x8C\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],
        ["\xF3\xB1\x8C\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],
        ["\xF3\xB1\x8C\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],
        ["\xF3\xB1\x8C\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],
        ["\xF3\xB1\x8C\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],
        ["\xF3\xB1\x8C\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],
        ["\xF3\xB1\x8C\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x7A"],
        ["\xF3\xB1\x8C\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x5E"],
        ["\xF3\xB1\x8C\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x4C"],
        ["\xF3\xB1\x8C\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x7E"],
        ["\xF3\xB1\x8C\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x6E"],
        ["\xF3\xB1\x8C\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x6F"],
        ["\xF3\xB1\x8C\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x7C"],
        ["\xF3\xB1\x8C\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],
        ["\xF3\xB1\x8C\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],
        ["\xF3\xB1\x8C\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],
        ["\xF3\xB1\x8C\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],
        ["\xF3\xB1\x8C\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],
        ["\xF3\xB1\x8C\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],
        ["\xF3\xB1\x8C\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],
        ["\xF3\xB1\x8C\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],
        ["\xF3\xB1\x8C\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],
        ["\xF3\xB1\x8C\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],
        ["\xF3\xB1\x8C\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],
        ["\xF3\xB1\x8C\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],
        ["\xF3\xB1\x8C\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],
        ["\xF3\xB1\x8C\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],
        ["\xF3\xB1\x8C\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],
        ["\xF3\xB1\x8C\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],
        ["\xF3\xB1\x8C\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],
        ["\xF3\xB1\x8C\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],
        ["\xF3\xB1\x8C\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],
        ["\xF3\xB1\x8C\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],
        ["\xF3\xB1\x8C\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],
        ["\xF3\xB1\x8C\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],
        ["\xF3\xB1\x8C\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],
        ["\xF3\xB1\x8C\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],
        ["\xF3\xB1\x8C\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],
        ["\xF3\xB1\x8C\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],
        ["\xF3\xB1\x8C\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x4A"],
        ["\xF3\xB1\x8C\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x5B"],
        ["\xF3\xB1\x8C\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x5A"],
        ["\xF3\xB1\x8C\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x5F"],
        ["\xF3\xB1\x8C\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x6D"],
        ["\xF3\xB1\x8C\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x79"],
        ["\xF3\xB1\x8C\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x57"],
        ["\xF3\xB1\x8C\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x59"],
        ["\xF3\xB1\x8D\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x62"],
        ["\xF3\xB1\x8D\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x63"],
        ["\xF3\xB1\x8D\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x64"],
        ["\xF3\xB1\x8D\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x65"],
        ["\xF3\xB1\x8D\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x66"],
        ["\xF3\xB1\x8D\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x67"],
        ["\xF3\xB1\x8D\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x68"],
        ["\xF3\xB1\x8D\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x69"],
        ["\xF3\xB1\x8D\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x70"],
        ["\xF3\xB1\x8D\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x71"],
        ["\xF3\xB1\x8D\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x72"],
        ["\xF3\xB1\x8D\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x73"],
        ["\xF3\xB1\x8D\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x74"],
        ["\xF3\xB1\x8D\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x75"],
        ["\xF3\xB1\x8D\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x76"],
        ["\xF3\xB1\x8D\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x77"],
        ["\xF3\xB1\x8D\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x78"],
        ["\xF3\xB1\x8D\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x80"],
        ["\xF3\xB1\x8D\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x8B"],
        ["\xF3\xB1\x8D\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x9B"],
        ["\xF3\xB1\x8D\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x9C"],
        ["\xF3\xB1\x8D\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA0"],
        ["\xF3\xB1\x8D\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],
        ["\xF3\xB1\x8D\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],
        ["\xF3\xB1\x8D\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],
        ["\xF3\xB1\x8D\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\x6A"],
        ["\xF3\xB1\x8D\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],
        ["\xF3\xB1\x8D\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],
        ["\xF3\xB1\x8D\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xF3\xB1\x8D\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7F"],
        ["\xF3\xB1\x8D\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xF3\xB1\x8D\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xF3\xB1\x8D\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xF3\xB1\x8D\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xF3\xB1\x8D\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xF3\xB1\x8D\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xF3\xB1\x8D\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xF3\xB1\x8D\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xF3\xB1\x8D\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xF3\xB1\x8D\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xF3\xB1\x8D\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xF3\xB1\x8D\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xF3\xB1\x8D\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xF3\xB1\x8D\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xF3\xB1\x8D\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xF3\xB1\x8D\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xF3\xB1\x8D\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xF3\xB1\x8D\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xF3\xB1\x8D\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xF3\xB1\x8D\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xF3\xB1\x8D\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xF3\xB1\x8D\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xF3\xB1\x8D\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xF3\xB1\x8D\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xF3\xB1\x8D\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xF3\xB1\x8D\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xF3\xB1\x8D\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xF3\xB1\x8D\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xF3\xB1\x8D\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xF3\xB1\x8D\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xF3\xB1\x8D\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xF3\xB1\x8D\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xF3\xB1\x8D\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xF3\xB1\x8D\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xF3\xB1\x8E\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xF3\xB1\x8E\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xF3\xB1\x8E\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xF3\xB1\x8E\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xF3\xB1\x8E\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xF3\xB1\x8E\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xF3\xB1\x8E\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xF3\xB1\x8E\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xF3\xB1\x8E\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xF3\xB1\x8E\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xF3\xB1\x8E\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xF3\xB1\x8E\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xF3\xB1\x8E\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xF3\xB1\x8E\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xF3\xB1\x8E\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xF3\xB1\x8E\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xF3\xB1\x8E\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xF3\xB1\x8E\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xF3\xB1\x8E\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xF3\xB1\x8E\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xF3\xB1\x8E\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xF3\xB1\x8E\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xF3\xB1\x8E\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xF3\xB1\x8E\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xF3\xB1\x8E\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xF3\xB1\x8E\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xF3\xB1\x8E\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xF3\xB1\x8E\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xF3\xB1\x8E\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xF3\xB1\x8E\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xF3\xB1\x8E\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xF3\xB1\x8E\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xF3\xB1\x8E\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xF3\xB1\x8E\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xF3\xB1\x8E\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xF3\xB1\x8E\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xF3\xB1\x8E\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xF3\xB1\x8E\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xF3\xB1\x8E\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xF3\xB1\x8E\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xF3\xB1\x8E\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xF3\xB1\x8E\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xF3\xB1\x8E\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xF3\xB1\x8E\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xF3\xB1\x8E\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xF3\xB1\x8E\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xF3\xB1\x8E\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xF3\xB1\x8E\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xF3\xB1\x8E\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xF3\xB1\x8E\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xF3\xB1\x8E\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xF3\xB1\x8E\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xF3\xB1\x8E\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xF3\xB1\x8E\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xF3\xB1\x8E\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xF3\xB1\x8E\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xF3\xB1\x8E\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xF3\xB1\x8E\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xF3\xB1\x8E\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xF3\xB1\x8E\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7F"],
        ["\xF3\xB1\x8E\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xF3\xB1\x8E\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xF3\xB1\x8E\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xF3\xB1\x8E\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xF3\xB1\x8F\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xF3\xB1\x8F\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xF3\xB1\x8F\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xF3\xB1\x8F\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xF3\xB1\x8F\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xF3\xB1\x8F\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xF3\xB1\x8F\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xF3\xB1\x8F\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xF3\xB1\x8F\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xF3\xB1\x8F\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xF3\xB1\x8F\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xF3\xB1\x8F\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xF3\xB1\x8F\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xF3\xB1\x8F\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xF3\xB1\x8F\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xF3\xB1\x8F\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xF3\xB1\x8F\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xF3\xB1\x8F\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xF3\xB1\x8F\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xF3\xB1\x8F\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xF3\xB1\x8F\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xF3\xB1\x8F\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xF3\xB1\x8F\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xF3\xB1\x8F\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xF3\xB1\x8F\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xF3\xB1\x8F\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xF3\xB1\x8F\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xF3\xB1\x8F\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xF3\xB1\x8F\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xF3\xB1\x8F\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xF3\xB1\x8F\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xF3\xB1\x8F\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xF3\xB1\x8F\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xF3\xB1\x8F\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xF3\xB1\x8F\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xF3\xB1\x8F\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xF3\xB1\x8F\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xF3\xB1\x8F\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xF3\xB1\x8F\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xF3\xB1\x8F\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xF3\xB1\x8F\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xF3\xB1\x8F\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xF3\xB1\x8F\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xF3\xB1\x8F\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xF3\xB1\x8F\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xF3\xB1\x8F\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xF3\xB1\x8F\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xF3\xB1\x8F\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xF3\xB1\x8F\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xF3\xB1\x8F\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xF3\xB1\x8F\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xF3\xB1\x8F\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xF3\xB1\x8F\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xF3\xB1\x8F\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xF3\xB1\x8F\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xF3\xB1\x8F\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xF3\xB1\x8F\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xF3\xB1\x8F\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xF3\xB1\x8F\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xF3\xB1\x8F\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xF3\xB1\x8F\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xF3\xB1\x8F\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\x4A"],
        ["\xF3\xB1\x8F\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xF3\xB1\x8F\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xF3\xB1\x90\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xF3\xB1\x90\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xF3\xB1\x90\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xF3\xB1\x90\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xF3\xB1\x90\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xF3\xB1\x90\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xF3\xB1\x90\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xF3\xB1\x90\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xF3\xB1\x90\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xF3\xB1\x90\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xF3\xB1\x90\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xF3\xB1\x90\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xF3\xB1\x90\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xF3\xB1\x90\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xF3\xB1\x90\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xF3\xB1\x90\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xF3\xB1\x90\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xF3\xB1\x90\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xF3\xB1\x90\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xF3\xB1\x90\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xF3\xB1\x90\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xF3\xB1\x90\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xF3\xB1\x90\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xF3\xB1\x90\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xF3\xB1\x90\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xF3\xB1\x90\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7F"],
        ["\xF3\xB1\x90\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xF3\xB1\x90\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xF3\xB1\x90\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xF3\xB1\x90\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xF3\xB1\x90\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xF3\xB1\x90\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xF3\xB1\x90\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xF3\xB1\x90\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xF3\xB1\x90\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xF3\xB1\x90\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xF3\xB1\x90\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xF3\xB1\x90\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xF3\xB1\x90\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xF3\xB1\x90\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xF3\xB1\x90\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xF3\xB1\x90\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xF3\xB1\x90\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xF3\xB1\x90\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xF3\xB1\x90\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xF3\xB1\x90\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xF3\xB1\x90\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xF3\xB1\x90\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xF3\xB1\x90\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xF3\xB1\x90\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xF3\xB1\x90\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xF3\xB1\x90\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xF3\xB1\x90\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xF3\xB1\x90\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xF3\xB1\x90\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xF3\xB1\x90\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xF3\xB1\x90\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xF3\xB1\x90\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xF3\xB1\x90\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xF3\xB1\x90\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xF3\xB1\x90\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xF3\xB1\x90\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xF3\xB1\x90\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xF3\xB1\x90\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xF3\xB1\x91\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xF3\xB1\x91\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xF3\xB1\x91\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xF3\xB1\x91\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xF3\xB1\x91\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xF3\xB1\x91\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xF3\xB1\x91\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xF3\xB1\x91\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xF3\xB1\x91\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xF3\xB1\x91\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xF3\xB1\x91\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xF3\xB1\x91\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xF3\xB1\x91\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xF3\xB1\x91\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xF3\xB1\x91\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xF3\xB1\x91\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xF3\xB1\x91\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xF3\xB1\x91\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xF3\xB1\x91\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xF3\xB1\x91\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xF3\xB1\x91\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xF3\xB1\x91\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xF3\xB1\x91\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xF3\xB1\x91\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xF3\xB1\x91\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xF3\xB1\x91\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xF3\xB1\x91\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xF3\xB1\x91\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xF3\xB1\x91\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xF3\xB1\x91\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xF3\xB1\x91\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xF3\xB1\x91\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xF3\xB1\x91\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xF3\xB1\x91\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xF3\xB1\x91\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xF3\xB1\x91\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xF3\xB1\x91\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xF3\xB1\x91\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xF3\xB1\x91\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xF3\xB1\x91\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xF3\xB1\x91\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xF3\xB1\x91\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xF3\xB1\x91\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xF3\xB1\x91\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xF3\xB1\x91\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xF3\xB1\x91\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xF3\xB1\x91\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xF3\xB1\x91\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xF3\xB1\x91\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xF3\xB1\x91\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xF3\xB1\x91\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xF3\xB1\x91\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xF3\xB1\x91\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xF3\xB1\x91\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xF3\xB1\x91\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xF3\xB1\x91\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7F"],
        ["\xF3\xB1\x91\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xF3\xB1\x91\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xF3\xB1\x91\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xF3\xB1\x91\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xF3\xB1\x91\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xF3\xB1\x91\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xF3\xB1\x91\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xF3\xB1\x91\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xF3\xB1\x92\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xF3\xB1\x92\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xF3\xB1\x92\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xF3\xB1\x92\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xF3\xB1\x92\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xF3\xB1\x92\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xF3\xB1\x92\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xF3\xB1\x92\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xF3\xB1\x92\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xF3\xB1\x92\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xF3\xB1\x92\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xF3\xB1\x92\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xF3\xB1\x92\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xF3\xB1\x92\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xF3\xB1\x92\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xF3\xB1\x92\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xF3\xB1\x92\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xF3\xB1\x92\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xF3\xB1\x92\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xF3\xB1\x92\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xF3\xB1\x92\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xF3\xB1\x92\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xF3\xB1\x92\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xF3\xB1\x92\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xF3\xB1\x92\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xF3\xB1\x92\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xF3\xB1\x92\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xF3\xB1\x92\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xF3\xB1\x92\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xF3\xB1\x92\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xF3\xB1\x92\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xF3\xB1\x92\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xF3\xB1\x92\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xF3\xB1\x92\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xF3\xB1\x92\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xF3\xB1\x92\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xF3\xB1\x92\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xF3\xB1\x92\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xF3\xB1\x92\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xF3\xB1\x92\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xF3\xB1\x92\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xF3\xB1\x92\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xF3\xB1\x92\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xF3\xB1\x92\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xF3\xB1\x92\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xF3\xB1\x92\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xF3\xB1\x92\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xF3\xB1\x92\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xF3\xB1\x92\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xF3\xB1\x92\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xF3\xB1\x92\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xF3\xB1\x92\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xF3\xB1\x92\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xF3\xB1\x92\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xF3\xB1\x92\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xF3\xB1\x92\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xF3\xB1\x92\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xF3\xB1\x92\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xF3\xB1\x92\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xF3\xB1\x92\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xF3\xB1\x92\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xF3\xB1\x92\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xF3\xB1\x92\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xF3\xB1\x92\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xF3\xB1\x93\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xF3\xB1\x93\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xF3\xB1\x93\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xF3\xB1\x93\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xF3\xB1\x93\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xF3\xB1\x93\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xF3\xB1\x93\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xF3\xB1\x93\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xF3\xB1\x93\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xF3\xB1\x93\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xF3\xB1\x93\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xF3\xB1\x93\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xF3\xB1\x93\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xF3\xB1\x93\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xF3\xB1\x93\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xF3\xB1\x93\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xF3\xB1\x93\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xF3\xB1\x93\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xF3\xB1\x93\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xF3\xB1\x93\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xF3\xB1\x93\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xF3\xB1\x93\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7F"],
        ["\xF3\xB1\x93\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xF3\xB1\x93\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xF3\xB1\x93\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xF3\xB1\x93\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xF3\xB1\x93\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xF3\xB1\x93\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xF3\xB1\x93\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xF3\xB1\x93\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xF3\xB1\x93\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xF3\xB1\x93\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xF3\xB1\x93\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xF3\xB1\x93\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xF3\xB1\x93\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xF3\xB1\x93\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xF3\xB1\x93\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xF3\xB1\x93\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xF3\xB1\x93\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xF3\xB1\x93\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xF3\xB1\x93\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xF3\xB1\x93\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xF3\xB1\x93\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xF3\xB1\x93\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xF3\xB1\x93\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xF3\xB1\x93\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xF3\xB1\x93\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xF3\xB1\x93\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xF3\xB1\x93\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xF3\xB1\x93\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xF3\xB1\x93\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xF3\xB1\x93\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xF3\xB1\x93\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xF3\xB1\x93\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xF3\xB1\x93\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xF3\xB1\x93\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xF3\xB1\x93\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xF3\xB1\x93\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xF3\xB1\x93\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xF3\xB1\x93\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xF3\xB1\x93\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xF3\xB1\x93\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xF3\xB1\x93\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xF3\xB1\x94\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xF3\xB1\x94\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xF3\xB1\x94\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xF3\xB1\x94\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xF3\xB1\x94\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xF3\xB1\x94\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xF3\xB1\x94\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xF3\xB1\x94\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xF3\xB1\x94\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xF3\xB1\x94\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xF3\xB1\x94\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xF3\xB1\x94\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xF3\xB1\x94\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xF3\xB1\x94\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xF3\xB1\x94\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xF3\xB1\x94\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xF3\xB1\x94\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xF3\xB1\x94\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xF3\xB1\x94\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xF3\xB1\x94\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xF3\xB1\x94\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xF3\xB1\x94\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xF3\xB1\x94\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xF3\xB1\x94\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xF3\xB1\x94\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xF3\xB1\x94\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xF3\xB1\x94\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xF3\xB1\x94\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xF3\xB1\x94\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xF3\xB1\x94\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xF3\xB1\x94\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xF3\xB1\x94\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xF3\xB1\x94\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xF3\xB1\x94\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xF3\xB1\x94\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xF3\xB1\x94\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xF3\xB1\x94\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xF3\xB1\x94\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xF3\xB1\x94\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xF3\xB1\x94\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xF3\xB1\x94\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xF3\xB1\x94\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xF3\xB1\x94\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xF3\xB1\x94\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xF3\xB1\x94\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xF3\xB1\x94\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xF3\xB1\x94\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xF3\xB1\x94\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xF3\xB1\x94\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xF3\xB1\x94\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xF3\xB1\x94\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xF3\xB1\x94\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7F"],
        ["\xF3\xB1\x94\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xF3\xB1\x94\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xF3\xB1\x94\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xF3\xB1\x94\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xF3\xB1\x94\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xF3\xB1\x94\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xF3\xB1\x94\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xF3\xB1\x94\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xF3\xB1\x94\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xF3\xB1\x94\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xF3\xB1\x94\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xF3\xB1\x94\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xF3\xB1\x95\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xF3\xB1\x95\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xF3\xB1\x95\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xF3\xB1\x95\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xF3\xB1\x95\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xF3\xB1\x95\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xF3\xB1\x95\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xF3\xB1\x95\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xF3\xB1\x95\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xF3\xB1\x95\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xF3\xB1\x95\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xF3\xB1\x95\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xF3\xB1\x95\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xF3\xB1\x95\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xF3\xB1\x95\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xF3\xB1\x95\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xF3\xB1\x95\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xF3\xB1\x95\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xF3\xB1\x95\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xF3\xB1\x95\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xF3\xB1\x95\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xF3\xB1\x95\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xF3\xB1\x95\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xF3\xB1\x95\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xF3\xB1\x95\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xF3\xB1\x95\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xF3\xB1\x95\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xF3\xB1\x95\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xF3\xB1\x95\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xF3\xB1\x95\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xF3\xB1\x95\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xF3\xB1\x95\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xF3\xB1\x95\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xF3\xB1\x95\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xF3\xB1\x95\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xF3\xB1\x95\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xF3\xB1\x95\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xF3\xB1\x95\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xF3\xB1\x95\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xF3\xB1\x95\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xF3\xB1\x95\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xF3\xB1\x95\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xF3\xB1\x95\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xF3\xB1\x95\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xF3\xB1\x95\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xF3\xB1\x95\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xF3\xB1\x95\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xF3\xB1\x95\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xF3\xB1\x95\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xF3\xB1\x95\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xF3\xB1\x95\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xF3\xB1\x95\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xF3\xB1\x95\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xF3\xB1\x95\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xF3\xB1\x95\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xF3\xB1\x95\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xF3\xB1\x95\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xF3\xB1\x95\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xF3\xB1\x95\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xF3\xB1\x95\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xF3\xB1\x95\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xF3\xB1\x95\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xF3\xB1\x95\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xF3\xB1\x95\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xF3\xB1\x96\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xF3\xB1\x96\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xF3\xB1\x96\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xF3\xB1\x96\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xF3\xB1\x96\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xF3\xB1\x96\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xF3\xB1\x96\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xF3\xB1\x96\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xF3\xB1\x96\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xF3\xB1\x96\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xF3\xB1\x96\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xF3\xB1\x96\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xF3\xB1\x96\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xF3\xB1\x96\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xF3\xB1\x96\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xF3\xB1\x96\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xF3\xB1\x96\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xF3\xB1\x96\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7F"],
        ["\xF3\xB1\x96\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xF3\xB1\x96\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xF3\xB1\x96\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xF3\xB1\x96\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xF3\xB1\x96\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xF3\xB1\x96\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xF3\xB1\x96\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xF3\xB1\x96\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xF3\xB1\x96\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xF3\xB1\x96\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xF3\xB1\x96\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xF3\xB1\x96\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xF3\xB1\x96\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xF3\xB1\x96\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xF3\xB1\x96\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xF3\xB1\x96\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xF3\xB1\x96\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xF3\xB1\x96\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xF3\xB1\x96\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xF3\xB1\x96\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xF3\xB1\x96\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xF3\xB1\x96\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xF3\xB1\x96\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xF3\xB1\x96\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xF3\xB1\x96\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xF3\xB1\x96\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xF3\xB1\x96\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xF3\xB1\x96\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xF3\xB1\x96\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xF3\xB1\x96\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xF3\xB1\x96\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xF3\xB1\x96\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xF3\xB1\x96\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xF3\xB1\x96\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xF3\xB1\x96\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xF3\xB1\x96\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xF3\xB1\x96\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xF3\xB1\x96\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xF3\xB1\x96\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xF3\xB1\x96\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xF3\xB1\x96\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xF3\xB1\x96\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xF3\xB1\x96\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xF3\xB1\x96\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xF3\xB1\x96\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xF3\xB1\x96\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xF3\xB1\x97\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xF3\xB1\x97\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xF3\xB1\x97\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xF3\xB1\x97\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xF3\xB1\x97\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xF3\xB1\x97\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xF3\xB1\x97\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xF3\xB1\x97\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xF3\xB1\x97\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xF3\xB1\x97\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xF3\xB1\x97\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xF3\xB1\x97\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xF3\xB1\x97\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xF3\xB1\x97\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xF3\xB1\x97\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xF3\xB1\x97\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xF3\xB1\x97\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xF3\xB1\x97\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xF3\xB1\x97\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xF3\xB1\x97\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xF3\xB1\x97\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xF3\xB1\x97\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xF3\xB1\x97\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xF3\xB1\x97\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xF3\xB1\x97\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xF3\xB1\x97\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xF3\xB1\x97\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xF3\xB1\x97\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xF3\xB1\x97\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xF3\xB1\x97\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xF3\xB1\x97\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xF3\xB1\x97\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xF3\xB1\x97\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xF3\xB1\x97\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xF3\xB1\x97\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xF3\xB1\x97\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xF3\xB1\x97\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xF3\xB1\x97\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xF3\xB1\x97\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xF3\xB1\x97\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],
        ["\xF3\xB1\x97\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xF3\xB1\x97\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xF3\xB1\x97\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xF3\xB1\x97\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xF3\xB1\x97\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xF3\xB1\x97\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xF3\xB1\x97\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xF3\xB1\x97\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7F"],
        ["\xF3\xB1\x97\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xF3\xB1\x97\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xF3\xB1\x97\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xF3\xB1\x97\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xF3\xB1\x97\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xF3\xB1\x97\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xF3\xB1\x97\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xF3\xB1\x97\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xF3\xB1\x97\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xF3\xB1\x97\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xF3\xB1\x97\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xF3\xB1\x97\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xF3\xB1\x97\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xF3\xB1\x97\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xF3\xB1\x97\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xF3\xB1\x97\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xF3\xB1\x98\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xF3\xB1\x98\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xF3\xB1\x98\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xF3\xB1\x98\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xF3\xB1\x98\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xF3\xB1\x98\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xF3\xB1\x98\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xF3\xB1\x98\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xF3\xB1\x98\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xF3\xB1\x98\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xF3\xB1\x98\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xF3\xB1\x98\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xF3\xB1\x98\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xF3\xB1\x98\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xF3\xB1\x98\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xF3\xB1\x98\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xF3\xB1\x98\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xF3\xB1\x98\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xF3\xB1\x98\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xF3\xB1\x98\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xF3\xB1\x98\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xF3\xB1\x98\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xF3\xB1\x98\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xF3\xB1\x98\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xF3\xB1\x98\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xF3\xB1\x98\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xF3\xB1\x98\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xF3\xB1\x98\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xF3\xB1\x98\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xF3\xB1\x98\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xF3\xB1\x98\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xF3\xB1\x98\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xF3\xB1\x98\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xF3\xB1\x98\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xF3\xB1\x98\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xF3\xB1\x98\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xF3\xB1\x98\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xF3\xB1\x98\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xF3\xB1\x98\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xF3\xB1\x98\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xF3\xB1\x98\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xF3\xB1\x98\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xF3\xB1\x98\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xF3\xB1\x98\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xF3\xB1\x98\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xF3\xB1\x98\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xF3\xB1\x98\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xF3\xB1\x98\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xF3\xB1\x98\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xF3\xB1\x98\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xF3\xB1\x98\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xF3\xB1\x98\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xF3\xB1\x98\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xF3\xB1\x98\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xF3\xB1\x98\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xF3\xB1\x98\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xF3\xB1\x98\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xF3\xB1\x98\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xF3\xB1\x98\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xF3\xB1\x98\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xF3\xB1\x98\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xF3\xB1\x98\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xF3\xB1\x98\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xF3\xB1\x98\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xF3\xB1\x99\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xF3\xB1\x99\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xF3\xB1\x99\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xF3\xB1\x99\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xF3\xB1\x99\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xF3\xB1\x99\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xF3\xB1\x99\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xF3\xB1\x99\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xF3\xB1\x99\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xF3\xB1\x99\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xF3\xB1\x99\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xF3\xB1\x99\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xF3\xB1\x99\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\xF3\xB1\x99\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7F"],
        ["\xF3\xB1\x99\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\xF3\xB1\x99\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],
        ["\xF3\xB1\x99\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\xF3\xB1\x99\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\xF3\xB1\x99\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\xF3\xB1\x99\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\xF3\xB1\x99\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\xF3\xB1\x99\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\xF3\xB1\x99\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\xF3\xB1\x99\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\xF3\xB1\x99\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\xF3\xB1\x99\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\xF3\xB1\x99\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\xF3\xB1\x99\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF0"],
        ["\xF3\xB1\x99\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\xF3\xB1\x99\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF2"],
        ["\xF3\xB1\x99\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\xF3\xB1\x99\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF4"],
        ["\xF3\xB1\x99\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],
        ["\xF3\xB1\x99\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF6"],
        ["\xF3\xB1\x99\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF7"],
        ["\xF3\xB1\x99\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],
        ["\xF3\xB1\x99\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xF9"],
        ["\xF3\xB1\x99\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\xF3\xB1\x99\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\xF3\xB1\x99\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\xF3\xB1\x99\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\xF3\xB1\x99\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\xF3\xB1\x99\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\xF3\xB1\x99\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\xF3\xB1\x99\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC1"],
        ["\xF3\xB1\x99\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC2"],
        ["\xF3\xB1\x99\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC3"],
        ["\xF3\xB1\x99\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC4"],
        ["\xF3\xB1\x99\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC5"],
        ["\xF3\xB1\x99\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\xF3\xB1\x99\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC7"],
        ["\xF3\xB1\x99\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC8"],
        ["\xF3\xB1\x99\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\xF3\xB1\x99\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD1"],
        ["\xF3\xB1\x99\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD2"],
        ["\xF3\xB1\x99\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD3"],
        ["\xF3\xB1\x99\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\xF3\xB1\x99\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD5"],
        ["\xF3\xB1\x99\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD6"],
        ["\xF3\xB1\x99\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD7"],
        ["\xF3\xB1\x99\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD8"],
        ["\xF3\xB1\x99\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD9"],
        ["\xF3\xB1\x99\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],
        ["\xF3\xB1\x99\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE3"],
        ["\xF3\xB1\x9A\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE4"],
        ["\xF3\xB1\x9A\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE5"],
        ["\xF3\xB1\x9A\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE6"],
        ["\xF3\xB1\x9A\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],
        ["\xF3\xB1\x9A\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE8"],
        ["\xF3\xB1\x9A\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xE9"],
        ["\xF3\xB1\x9A\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\xF3\xB1\x9A\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\xF3\xB1\x9A\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\xF3\xB1\x9A\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\xF3\xB1\x9A\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\xF3\xB1\x9A\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\xF3\xB1\x9A\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\xF3\xB1\x9A\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\xF3\xB1\x9A\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\xF3\xB1\x9A\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\xF3\xB1\x9A\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\xF3\xB1\x9A\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\xF3\xB1\x9A\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\xF3\xB1\x9A\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\xF3\xB1\x9A\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\xF3\xB1\x9A\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\xF3\xB1\x9A\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\xF3\xB1\x9A\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\xF3\xB1\x9A\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x73"],
        ["\xF3\xB1\x9A\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\xF3\xB1\x9A\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\xF3\xB1\x9A\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\xF3\xB1\x9A\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\xF3\xB1\x9A\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\xF3\xB1\x9A\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\xF3\xB1\x9A\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x80"],
        ["\xF3\xB1\x9A\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x8B"],
        ["\xF3\xB1\x9A\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x9B"],
        ["\xF3\xB1\x9A\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x9C"],
        ["\xF3\xB1\x9A\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xA0"],
        ["\xF3\xB1\x9A\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xAB"],
        ["\xF3\xB1\x9A\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xB0"],
        ["\xF3\xB1\x9A\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\xF3\xB1\x9A\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\xF3\xB1\x9A\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xD0"],
        ["\xF3\xB1\x9A\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],
        ["\xF3\xB1\x9A\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\xF3\xB1\x9A\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7F"],
        ["\xF3\xB1\x9A\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\xF3\xB1\x9A\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\xF3\xB1\x9A\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\xF3\xB1\x9A\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],
        ["\xF3\xB1\x9A\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\xF3\xB1\x9A\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\xF3\xB1\x9A\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\xF3\xB1\x9A\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\xF3\xB1\x9A\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\xF3\xB1\x9A\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\xF3\xB1\x9A\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\xF3\xB1\x9A\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\xF3\xB1\x9A\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\xF3\xB1\x9A\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF0"],
        ["\xF3\xB1\x9A\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],
        ["\xF3\xB1\x9A\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],
        ["\xF3\xB1\x9A\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF3"],
        ["\xF3\xB1\x9A\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF4"],
        ["\xF3\xB1\x9A\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],
        ["\xF3\xB1\x9A\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],
        ["\xF3\xB1\x9B\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF7"],
        ["\xF3\xB1\x9B\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],
        ["\xF3\xB1\x9B\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xF9"],
        ["\xF3\xB1\x9B\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\xF3\xB1\x9B\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\xF3\xB1\x9B\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\xF3\xB1\x9B\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],
        ["\xF3\xB1\x9B\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\xF3\xB1\x9B\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\xF3\xB1\x9B\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\xF3\xB1\x9B\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC1"],
        ["\xF3\xB1\x9B\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC2"],
        ["\xF3\xB1\x9B\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],
        ["\xF3\xB1\x9B\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\xF3\xB1\x9B\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC5"],
        ["\xF3\xB1\x9B\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],
        ["\xF3\xB1\x9B\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC7"],
        ["\xF3\xB1\x9B\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC8"],
        ["\xF3\xB1\x9B\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],
        ["\xF3\xB1\x9B\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD1"],
        ["\xF3\xB1\x9B\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],
        ["\xF3\xB1\x9B\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\xF3\xB1\x9B\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],
        ["\xF3\xB1\x9B\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\xF3\xB1\x9B\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD6"],
        ["\xF3\xB1\x9B\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\xF3\xB1\x9B\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD8"],
        ["\xF3\xB1\x9B\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD9"],
        ["\xF3\xB1\x9B\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE2"],
        ["\xF3\xB1\x9B\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"],
        ["\xF3\xB1\x9B\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE4"],
        ["\xF3\xB1\x9B\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],
        ["\xF3\xB1\x9B\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE6"],
        ["\xF3\xB1\x9B\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\xF3\xB1\x9B\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],
        ["\xF3\xB1\x9B\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],
        ["\xF3\xB1\x9B\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\xF3\xB1\x9B\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\xF3\xB1\x9B\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\xF3\xB1\x9B\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\xF3\xB1\x9B\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\xF3\xB1\x9B\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\xF3\xB1\x9B\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\xF3\xB1\x9B\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\xF3\xB1\x9B\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\xF3\xB1\x9B\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\xF3\xB1\x9B\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\xF3\xB1\x9B\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\xF3\xB1\x9B\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\xF3\xB1\x9B\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\xF3\xB1\x9B\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\xF3\xB1\x9B\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\xF3\xB1\x9B\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\xF3\xB1\x9B\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\xF3\xB1\x9B\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\xF3\xB1\x9B\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\xF3\xB1\x9B\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\xF3\xB1\x9B\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\xF3\xB1\x9B\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\xF3\xB1\x9B\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\xF3\xB1\x9B\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\xF3\xB1\x9B\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x80"],
        ["\xF3\xB1\x9B\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x8B"],
        ["\xF3\xB1\x9B\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x9B"],
        ["\xF3\xB1\x9C\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x9C"],
        ["\xF3\xB1\x9C\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xA0"],
        ["\xF3\xB1\x9C\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"],
        ["\xF3\xB1\x9C\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xB0"],
        ["\xF3\xB1\x9C\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],
        ["\xF3\xB1\x9C\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\xF3\xB1\x9C\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\xF3\xB1\x9C\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"],
        ["\xF3\xB1\x9C\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\xF3\xB1\x9C\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7F"],
        ["\xF3\xB1\x9C\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\xF3\xB1\x9C\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE0"],
        ["\xF3\xB1\x9C\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\xF3\xB1\x9C\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\xF3\xB1\x9C\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\xF3\xB1\x9C\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\xF3\xB1\x9C\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\xF3\xB1\x9C\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\xF3\xB1\x9C\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\xF3\xB1\x9C\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\xF3\xB1\x9C\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\xF3\xB1\x9C\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\xF3\xB1\x9C\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\xF3\xB1\x9C\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\xF3\xB1\x9C\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\xF3\xB1\x9C\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\xF3\xB1\x9C\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],
        ["\xF3\xB1\x9C\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF4"],
        ["\xF3\xB1\x9C\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF5"],
        ["\xF3\xB1\x9C\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF6"],
        ["\xF3\xB1\x9C\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\xF3\xB1\x9C\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],
        ["\xF3\xB1\x9C\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],
        ["\xF3\xB1\x9C\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\xF3\xB1\x9C\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\xF3\xB1\x9C\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\xF3\xB1\x9C\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],
        ["\xF3\xB1\x9C\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\xF3\xB1\x9C\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\xF3\xB1\x9C\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\xF3\xB1\x9C\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\xF3\xB1\x9C\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC2"],
        ["\xF3\xB1\x9C\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC3"],
        ["\xF3\xB1\x9C\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC4"],
        ["\xF3\xB1\x9C\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC5"],
        ["\xF3\xB1\x9C\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC6"],
        ["\xF3\xB1\x9C\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],
        ["\xF3\xB1\x9C\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],
        ["\xF3\xB1\x9C\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],
        ["\xF3\xB1\x9C\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD1"],
        ["\xF3\xB1\x9C\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],
        ["\xF3\xB1\x9C\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\xF3\xB1\x9C\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],
        ["\xF3\xB1\x9C\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD5"],
        ["\xF3\xB1\x9C\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],
        ["\xF3\xB1\x9C\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD7"],
        ["\xF3\xB1\x9C\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD8"],
        ["\xF3\xB1\x9C\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD9"],
        ["\xF3\xB1\x9C\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],
        ["\xF3\xB1\x9C\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],
        ["\xF3\xB1\x9C\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\xF3\xB1\x9C\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE5"],
        ["\xF3\xB1\x9C\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\xF3\xB1\x9C\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE7"],
        ["\xF3\xB1\x9D\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],
        ["\xF3\xB1\x9D\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],
        ["\xF3\xB1\x9D\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\xF3\xB1\x9D\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\xF3\xB1\x9D\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\xF3\xB1\x9D\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],
        ["\xF3\xB1\x9D\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\xF3\xB1\x9D\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],
        ["\xF3\xB1\x9D\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],
        ["\xF3\xB1\x9D\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\xF3\xB1\x9D\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\xF3\xB1\x9D\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\xF3\xB1\x9D\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\xF3\xB1\x9D\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],
        ["\xF3\xB1\x9D\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\xF3\xB1\x9D\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],
        ["\xF3\xB1\x9D\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],
        ["\xF3\xB1\x9D\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\xF3\xB1\x9D\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\xF3\xB1\x9D\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\xF3\xB1\x9D\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\xF3\xB1\x9D\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\xF3\xB1\x9D\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\xF3\xB1\x9D\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\xF3\xB1\x9D\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],
        ["\xF3\xB1\x9D\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\xF3\xB1\x9D\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\xF3\xB1\x9D\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x80"],
        ["\xF3\xB1\x9D\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x8B"],
        ["\xF3\xB1\x9D\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x9B"],
        ["\xF3\xB1\x9D\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x9C"],
        ["\xF3\xB1\x9D\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA0"],
        ["\xF3\xB1\x9D\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xAB"],
        ["\xF3\xB1\x9D\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\xF3\xB1\x9D\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xC0"],
        ["\xF3\xB1\x9D\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\xF3\xB1\x9D\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\xF3\xB1\x9D\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\xF3\xB1\x9D\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\xF3\xB1\x9D\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7F"],
        ["\xF3\xB1\x9D\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\xF3\xB1\x9D\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE0"],
        ["\xF3\xB1\x9D\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\xF3\xB1\x9D\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\xF3\xB1\x9D\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\xF3\xB1\x9D\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\xF3\xB1\x9D\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\xF3\xB1\x9D\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\xF3\xB1\x9D\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\xF3\xB1\x9D\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\xF3\xB1\x9D\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\xF3\xB1\x9D\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\xF3\xB1\x9D\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\xF3\xB1\x9D\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],
        ["\xF3\xB1\x9D\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF1"],
        ["\xF3\xB1\x9D\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\xF3\xB1\x9D\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\xF3\xB1\x9D\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF4"],
        ["\xF3\xB1\x9D\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF5"],
        ["\xF3\xB1\x9D\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],
        ["\xF3\xB1\x9D\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\xF3\xB1\x9D\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\xF3\xB1\x9D\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x78"],
        ["\xF3\xB1\x9D\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],
        ["\xF3\xB1\x9E\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\xF3\xB1\x9E\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\xF3\xB1\x9E\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\xF3\xB1\x9E\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\xF3\xB1\x9E\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\xF3\xB1\x9E\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\xF3\xB1\x9E\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],
        ["\xF3\xB1\x9E\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\xF3\xB1\x9E\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\xF3\xB1\x9E\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\xF3\xB1\x9E\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],
        ["\xF3\xB1\x9E\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC6"],
        ["\xF3\xB1\x9E\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\xF3\xB1\x9E\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],
        ["\xF3\xB1\x9E\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC9"],
        ["\xF3\xB1\x9E\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD1"],
        ["\xF3\xB1\x9E\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD2"],
        ["\xF3\xB1\x9E\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],
        ["\xF3\xB1\x9E\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD4"],
        ["\xF3\xB1\x9E\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD5"],
        ["\xF3\xB1\x9E\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\xF3\xB1\x9E\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD7"],
        ["\xF3\xB1\x9E\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD8"],
        ["\xF3\xB1\x9E\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD9"],
        ["\xF3\xB1\x9E\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\xF3\xB1\x9E\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE3"],
        ["\xF3\xB1\x9E\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],
        ["\xF3\xB1\x9E\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],
        ["\xF3\xB1\x9E\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],
        ["\xF3\xB1\x9E\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\xF3\xB1\x9E\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],
        ["\xF3\xB1\x9E\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],
        ["\xF3\xB1\x9E\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\xF3\xB1\x9E\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\xF3\xB1\x9E\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\xF3\xB1\x9E\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\xF3\xB1\x9E\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\xF3\xB1\x9E\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\xF3\xB1\x9E\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\xF3\xB1\x9E\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\xF3\xB1\x9E\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\xF3\xB1\x9E\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\xF3\xB1\x9E\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\xF3\xB1\x9E\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\xF3\xB1\x9E\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\xF3\xB1\x9E\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\xF3\xB1\x9E\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\xF3\xB1\x9E\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],
        ["\xF3\xB1\x9E\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],
        ["\xF3\xB1\x9E\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],
        ["\xF3\xB1\x9E\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],
        ["\xF3\xB1\x9E\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],
        ["\xF3\xB1\x9E\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\xF3\xB1\x9E\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\xF3\xB1\x9E\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\xF3\xB1\x9E\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\xF3\xB1\x9E\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\xF3\xB1\x9E\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x80"],
        ["\xF3\xB1\x9E\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xC3"],
        ["\xF3\xB1\x9E\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x9B"],
        ["\xF3\xB1\x9E\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x9C"],
        ["\xF3\xB1\x9E\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xA0"],
        ["\xF3\xB1\x9E\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\xF3\xB1\x9E\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xB0"],
        ["\xF3\xB1\x9F\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xC0"],
        ["\xF3\xB1\x9F\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\xF3\xB1\x9F\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xD0"],
        ["\xF3\xB1\x9F\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x5F\xA1"],
        ["\xF3\xB1\x9F\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4F"],
        ["\xF3\xB1\x9F\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7F"],
        ["\xF3\xB1\x9F\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7B"],
        ["\xF3\xB1\x9F\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE0"],
        ["\xF3\xB1\x9F\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6C"],
        ["\xF3\xB1\x9F\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x50"],
        ["\xF3\xB1\x9F\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7D"],
        ["\xF3\xB1\x9F\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4D"],
        ["\xF3\xB1\x9F\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5D"],
        ["\xF3\xB1\x9F\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5C"],
        ["\xF3\xB1\x9F\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4E"],
        ["\xF3\xB1\x9F\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6B"],
        ["\xF3\xB1\x9F\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x60"],
        ["\xF3\xB1\x9F\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4B"],
        ["\xF3\xB1\x9F\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x61"],
        ["\xF3\xB1\x9F\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF0"],
        ["\xF3\xB1\x9F\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF1"],
        ["\xF3\xB1\x9F\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF2"],
        ["\xF3\xB1\x9F\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF3"],
        ["\xF3\xB1\x9F\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF4"],
        ["\xF3\xB1\x9F\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF5"],
        ["\xF3\xB1\x9F\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF6"],
        ["\xF3\xB1\x9F\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF7"],
        ["\xF3\xB1\x9F\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF8"],
        ["\xF3\xB1\x9F\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xF9"],
        ["\xF3\xB1\x9F\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7A"],
        ["\xF3\xB1\x9F\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5E"],
        ["\xF3\xB1\x9F\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4C"],
        ["\xF3\xB1\x9F\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7E"],
        ["\xF3\xB1\x9F\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6E"],
        ["\xF3\xB1\x9F\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6F"],
        ["\xF3\xB1\x9F\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x7C"],
        ["\xF3\xB1\x9F\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC1"],
        ["\xF3\xB1\x9F\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC2"],
        ["\xF3\xB1\x9F\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC3"],
        ["\xF3\xB1\x9F\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC4"],
        ["\xF3\xB1\x9F\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC5"],
        ["\xF3\xB1\x9F\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC6"],
        ["\xF3\xB1\x9F\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC7"],
        ["\xF3\xB1\x9F\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC8"],
        ["\xF3\xB1\x9F\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC9"],
        ["\xF3\xB1\x9F\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD1"],
        ["\xF3\xB1\x9F\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD2"],
        ["\xF3\xB1\x9F\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD3"],
        ["\xF3\xB1\x9F\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD4"],
        ["\xF3\xB1\x9F\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD5"],
        ["\xF3\xB1\x9F\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD6"],
        ["\xF3\xB1\x9F\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD7"],
        ["\xF3\xB1\x9F\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD8"],
        ["\xF3\xB1\x9F\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD9"],
        ["\xF3\xB1\x9F\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE2"],
        ["\xF3\xB1\x9F\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE3"],
        ["\xF3\xB1\x9F\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE4"],
        ["\xF3\xB1\x9F\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE5"],
        ["\xF3\xB1\x9F\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE6"],
        ["\xF3\xB1\x9F\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE7"],
        ["\xF3\xB1\x9F\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE8"],
        ["\xF3\xB1\x9F\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xE9"],
        ["\xF3\xB1\x9F\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x4A"],
        ["\xF3\xB1\x9F\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5B"],
        ["\xF3\xB1\xA0\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5A"],
        ["\xF3\xB1\xA0\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x5F"],
        ["\xF3\xB1\xA0\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6D"],
        ["\xF3\xB1\xA0\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x79"],
        ["\xF3\xB1\xA0\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x57"],
        ["\xF3\xB1\xA0\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x59"],
        ["\xF3\xB1\xA0\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x62"],
        ["\xF3\xB1\xA0\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x63"],
        ["\xF3\xB1\xA0\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x64"],
        ["\xF3\xB1\xA0\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x65"],
        ["\xF3\xB1\xA0\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x66"],
        ["\xF3\xB1\xA0\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x67"],
        ["\xF3\xB1\xA0\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x68"],
        ["\xF3\xB1\xA0\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x69"],
        ["\xF3\xB1\xA0\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x70"],
        ["\xF3\xB1\xA0\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x71"],
        ["\xF3\xB1\xA0\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x72"],
        ["\xF3\xB1\xA0\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x73"],
        ["\xF3\xB1\xA0\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x74"],
        ["\xF3\xB1\xA0\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x75"],
        ["\xF3\xB1\xA0\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x76"],
        ["\xF3\xB1\xA0\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x77"],
        ["\xF3\xB1\xA0\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x78"],
        ["\xF3\xB1\xA0\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x80"],
        ["\xF3\xB1\xA0\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x8B"],
        ["\xF3\xB1\xA0\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x9B"],
        ["\xF3\xB1\xA0\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x9C"],
        ["\xF3\xB1\xA0\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xA0"],
        ["\xF3\xB1\xA0\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xAB"],
        ["\xF3\xB1\xA0\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xB0"],
        ["\xF3\xB1\xA0\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xC0"],
        ["\xF3\xB1\xA0\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\x6A"],
        ["\xF3\xB1\xA0\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xD0"],
        ["\xF3\xB1\xA0\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6D\xA1"],
        ["\xF3\xB1\xA0\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x4F"],
        ["\xF3\xB1\xA0\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x7F"],
        ["\xF3\xB1\xA0\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x7B"],
        ["\xF3\xB1\xA0\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE0"],
        ["\xF3\xB1\xA0\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x6C"],
        ["\xF3\xB1\xA0\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x50"],
        ["\xF3\xB1\xA0\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x7D"],
        ["\xF3\xB1\xA0\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x4D"],
        ["\xF3\xB1\xA0\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x5D"],
        ["\xF3\xB1\xA0\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x5C"],
        ["\xF3\xB1\xA0\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x4E"],
        ["\xF3\xB1\xA0\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x6B"],
        ["\xF3\xB1\xA0\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x60"],
        ["\xF3\xB1\xA0\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x4B"],
        ["\xF3\xB1\xA0\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x61"],
        ["\xF3\xB1\xA0\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF0"],
        ["\xF3\xB1\xA0\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF1"],
        ["\xF3\xB1\xA0\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF2"],
        ["\xF3\xB1\xA0\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF3"],
        ["\xF3\xB1\xA0\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF4"],
        ["\xF3\xB1\xA0\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF5"],
        ["\xF3\xB1\xA0\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF6"],
        ["\xF3\xB1\xA0\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF7"],
        ["\xF3\xB1\xA0\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF8"],
        ["\xF3\xB1\xA0\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xF9"],
        ["\xF3\xB1\xA0\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x7A"],
        ["\xF3\xB1\xA0\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x5E"],
        ["\xF3\xB1\xA0\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x4C"],
        ["\xF3\xB1\xA0\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x7E"],
        ["\xF3\xB1\xA0\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x6E"],
        ["\xF3\xB1\xA1\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x6F"],
        ["\xF3\xB1\xA1\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x7C"],
        ["\xF3\xB1\xA1\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC1"],
        ["\xF3\xB1\xA1\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC2"],
        ["\xF3\xB1\xA1\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC3"],
        ["\xF3\xB1\xA1\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC4"],
        ["\xF3\xB1\xA1\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC5"],
        ["\xF3\xB1\xA1\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC6"],
        ["\xF3\xB1\xA1\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC7"],
        ["\xF3\xB1\xA1\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC8"],
        ["\xF3\xB1\xA1\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC9"],
        ["\xF3\xB1\xA1\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD1"],
        ["\xF3\xB1\xA1\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD2"],
        ["\xF3\xB1\xA1\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD3"],
        ["\xF3\xB1\xA1\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD4"],
        ["\xF3\xB1\xA1\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD5"],
        ["\xF3\xB1\xA1\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD6"],
        ["\xF3\xB1\xA1\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD7"],
        ["\xF3\xB1\xA1\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD8"],
        ["\xF3\xB1\xA1\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD9"],
        ["\xF3\xB1\xA1\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE2"],
        ["\xF3\xB1\xA1\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE3"],
        ["\xF3\xB1\xA1\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE4"],
        ["\xF3\xB1\xA1\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE5"],
        ["\xF3\xB1\xA1\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE6"],
        ["\xF3\xB1\xA1\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE7"],
        ["\xF3\xB1\xA1\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE8"],
        ["\xF3\xB1\xA1\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xE9"],
        ["\xF3\xB1\xA1\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x4A"],
        ["\xF3\xB1\xA1\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x5B"],
        ["\xF3\xB1\xA1\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x5A"],
        ["\xF3\xB1\xA1\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x5F"],
        ["\xF3\xB1\xA1\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x6D"],
        ["\xF3\xB1\xA1\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x79"],
        ["\xF3\xB1\xA1\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x57"],
        ["\xF3\xB1\xA1\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x59"],
        ["\xF3\xB1\xA1\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x62"],
        ["\xF3\xB1\xA1\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x63"],
        ["\xF3\xB1\xA1\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x64"],
        ["\xF3\xB1\xA1\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x65"],
        ["\xF3\xB1\xA1\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x66"],
        ["\xF3\xB1\xA1\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x67"],
        ["\xF3\xB1\xA1\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x68"],
        ["\xF3\xB1\xA1\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x69"],
        ["\xF3\xB1\xA1\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x70"],
        ["\xF3\xB1\xA1\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x71"],
        ["\xF3\xB1\xA1\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x72"],
        ["\xF3\xB1\xA1\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x73"],
        ["\xF3\xB1\xA1\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x74"],
        ["\xF3\xB1\xA1\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x75"],
        ["\xF3\xB1\xA1\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x76"],
        ["\xF3\xB1\xA1\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x77"],
        ["\xF3\xB1\xA1\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x78"],
        ["\xF3\xB1\xA1\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x80"],
        ["\xF3\xB1\xA1\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x8B"],
        ["\xF3\xB1\xA1\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\xF3\xB1\xA1\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x9C"],
        ["\xF3\xB1\xA1\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA0"],
        ["\xF3\xB1\xA1\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xAB"],
        ["\xF3\xB1\xA1\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xB0"],
        ["\xF3\xB1\xA1\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xC0"],
        ["\xF3\xB1\xA1\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x6A"],
        ["\xF3\xB1\xA1\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xD0"],
        ["\xF3\xB1\xA1\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\xA1"],
        ["\xF3\xB1\xA2\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],
        ["\xF3\xB1\xA2\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7F"],
        ["\xF3\xB1\xA2\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\xF3\xB1\xA2\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],
        ["\xF3\xB1\xA2\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\xF3\xB1\xA2\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],
        ["\xF3\xB1\xA2\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\xF3\xB1\xA2\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\xF3\xB1\xA2\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\xF3\xB1\xA2\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\xF3\xB1\xA2\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\xF3\xB1\xA2\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],
        ["\xF3\xB1\xA2\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\xF3\xB1\xA2\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\xF3\xB1\xA2\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],
        ["\xF3\xB1\xA2\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF0"],
        ["\xF3\xB1\xA2\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\xF3\xB1\xA2\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],
        ["\xF3\xB1\xA2\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF3"],
        ["\xF3\xB1\xA2\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],
        ["\xF3\xB1\xA2\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF5"],
        ["\xF3\xB1\xA2\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\xF3\xB1\xA2\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF7"],
        ["\xF3\xB1\xA2\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],
        ["\xF3\xB1\xA2\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],
        ["\xF3\xB1\xA2\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\xF3\xB1\xA2\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\xF3\xB1\xA2\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\xF3\xB1\xA2\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\xF3\xB1\xA2\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\xF3\xB1\xA2\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\xF3\xB1\xA2\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],
        ["\xF3\xB1\xA2\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],
        ["\xF3\xB1\xA2\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],
        ["\xF3\xB1\xA2\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],
        ["\xF3\xB1\xA2\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],
        ["\xF3\xB1\xA2\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC5"],
        ["\xF3\xB1\xA2\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC6"],
        ["\xF3\xB1\xA2\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC7"],
        ["\xF3\xB1\xA2\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC8"],
        ["\xF3\xB1\xA2\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC9"],
        ["\xF3\xB1\xA2\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\xF3\xB1\xA2\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD2"],
        ["\xF3\xB1\xA2\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD3"],
        ["\xF3\xB1\xA2\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],
        ["\xF3\xB1\xA2\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD5"],
        ["\xF3\xB1\xA2\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD6"],
        ["\xF3\xB1\xA2\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],
        ["\xF3\xB1\xA2\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD8"],
        ["\xF3\xB1\xA2\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],
        ["\xF3\xB1\xA2\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],
        ["\xF3\xB1\xA2\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],
        ["\xF3\xB1\xA2\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],
        ["\xF3\xB1\xA2\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],
        ["\xF3\xB1\xA2\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],
        ["\xF3\xB1\xA2\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],
        ["\xF3\xB1\xA2\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE8"],
        ["\xF3\xB1\xA2\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],
        ["\xF3\xB1\xA2\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\xF3\xB1\xA2\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\xF3\xB1\xA2\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\xF3\xB1\xA2\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\xF3\xB1\xA2\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\xF3\xB1\xA2\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\xF3\xB1\xA3\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\xF3\xB1\xA3\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\xF3\xB1\xA3\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\xF3\xB1\xA3\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],
        ["\xF3\xB1\xA3\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\xF3\xB1\xA3\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\xF3\xB1\xA3\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\xF3\xB1\xA3\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\xF3\xB1\xA3\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\xF3\xB1\xA3\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\xF3\xB1\xA3\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\xF3\xB1\xA3\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\xF3\xB1\xA3\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\xF3\xB1\xA3\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\xF3\xB1\xA3\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\xF3\xB1\xA3\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\xF3\xB1\xA3\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\xF3\xB1\xA3\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\xF3\xB1\xA3\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\xF3\xB1\xA3\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x80"],
        ["\xF3\xB1\xA3\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x8B"],
        ["\xF3\xB1\xA3\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x9B"],
        ["\xF3\xB1\xA3\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x9C"],
        ["\xF3\xB1\xA3\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xA0"],
        ["\xF3\xB1\xA3\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],
        ["\xF3\xB1\xA3\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xB0"],
        ["\xF3\xB1\xA3\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xC0"],
        ["\xF3\xB1\xA3\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\xF3\xB1\xA3\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],
        ["\xF3\xB1\xA3\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x57\xA1"],
        ["\xF3\xB1\xA3\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\xF3\xB1\xA3\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7F"],
        ["\xF3\xB1\xA3\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\xF3\xB1\xA3\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\xF3\xB1\xA3\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\xF3\xB1\xA3\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\xF3\xB1\xA3\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\xF3\xB1\xA3\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\xF3\xB1\xA3\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\xF3\xB1\xA3\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\xF3\xB1\xA3\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\xF3\xB1\xA3\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\xF3\xB1\xA3\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\xF3\xB1\xA3\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\xF3\xB1\xA3\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\xF3\xB1\xA3\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\xF3\xB1\xA3\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],
        ["\xF3\xB1\xA3\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\xF3\xB1\xA3\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\xF3\xB1\xA3\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\xF3\xB1\xA3\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],
        ["\xF3\xB1\xA3\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF6"],
        ["\xF3\xB1\xA3\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],
        ["\xF3\xB1\xA3\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\xF3\xB1\xA3\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xF9"],
        ["\xF3\xB1\xA3\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\xF3\xB1\xA3\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\xF3\xB1\xA3\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\xF3\xB1\xA3\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\xF3\xB1\xA3\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\xF3\xB1\xA3\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\xF3\xB1\xA3\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\xF3\xB1\xA3\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\xF3\xB1\xA3\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC2"],
        ["\xF3\xB1\xA4\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\xF3\xB1\xA4\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],
        ["\xF3\xB1\xA4\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\xF3\xB1\xA4\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC6"],
        ["\xF3\xB1\xA4\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC7"],
        ["\xF3\xB1\xA4\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\xF3\xB1\xA4\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\xF3\xB1\xA4\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD1"],
        ["\xF3\xB1\xA4\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],
        ["\xF3\xB1\xA4\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],
        ["\xF3\xB1\xA4\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\xF3\xB1\xA4\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD5"],
        ["\xF3\xB1\xA4\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],
        ["\xF3\xB1\xA4\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\xF3\xB1\xA4\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],
        ["\xF3\xB1\xA4\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\xF3\xB1\xA4\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],
        ["\xF3\xB1\xA4\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\xF3\xB1\xA4\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\xF3\xB1\xA4\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE5"],
        ["\xF3\xB1\xA4\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\xF3\xB1\xA4\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\xF3\xB1\xA4\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE8"],
        ["\xF3\xB1\xA4\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],
        ["\xF3\xB1\xA4\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\xF3\xB1\xA4\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\xF3\xB1\xA4\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\xF3\xB1\xA4\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\xF3\xB1\xA4\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\xF3\xB1\xA4\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\xF3\xB1\xA4\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\xF3\xB1\xA4\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\xF3\xB1\xA4\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\xF3\xB1\xA4\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\xF3\xB1\xA4\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\xF3\xB1\xA4\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\xF3\xB1\xA4\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\xF3\xB1\xA4\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x5B"],
        ["\xF3\xB1\xA4\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],
        ["\xF3\xB1\xA4\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xF3\xB1\xA4\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],
        ["\xF3\xB1\xA4\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\xF3\xB1\xA4\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\xF3\xB1\xA4\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\xF3\xB1\xA4\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\xF3\xB1\xA4\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\xF3\xB1\xA4\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\xF3\xB1\xA4\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\xF3\xB1\xA4\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],
        ["\xF3\xB1\xA4\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x80"],
        ["\xF3\xB1\xA4\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x8B"],
        ["\xF3\xB1\xA4\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x9B"],
        ["\xF3\xB1\xA4\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x9C"],
        ["\xF3\xB1\xA4\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xA0"],
        ["\xF3\xB1\xA4\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xAB"],
        ["\xF3\xB1\xA4\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],
        ["\xF3\xB1\xA4\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\xF3\xB1\xA4\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\xF3\xB1\xA4\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\xF3\xB1\xA4\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\xF3\xB1\xA4\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\xF3\xB1\xA4\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7F"],
        ["\xF3\xB1\xA4\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\xF3\xB1\xA4\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\xF3\xB1\xA5\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\xF3\xB1\xA5\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\xF3\xB1\xA5\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\xF3\xB1\xA5\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\xF3\xB1\xA5\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\xF3\xB1\xA5\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\xF3\xB1\xA5\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\xF3\xB1\xA5\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\xF3\xB1\xA5\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\xF3\xB1\xA5\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\xF3\xB1\xA5\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\xF3\xB1\xA5\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\xF3\xB1\xA5\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF1"],
        ["\xF3\xB1\xA5\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\xF3\xB1\xA5\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\xF3\xB1\xA5\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],
        ["\xF3\xB1\xA5\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\xF3\xB1\xA5\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF6"],
        ["\xF3\xB1\xA5\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],
        ["\xF3\xB1\xA5\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\xF3\xB1\xA5\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xF9"],
        ["\xF3\xB1\xA5\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\xF3\xB1\xA5\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\xF3\xB1\xA5\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\xF3\xB1\xA5\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],
        ["\xF3\xB1\xA5\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\xF3\xB1\xA5\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\xF3\xB1\xA5\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\xF3\xB1\xA5\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\xF3\xB1\xA5\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],
        ["\xF3\xB1\xA5\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\xF3\xB1\xA5\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\xF3\xB1\xA5\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\xF3\xB1\xA5\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],
        ["\xF3\xB1\xA5\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC7"],
        ["\xF3\xB1\xA5\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],
        ["\xF3\xB1\xA5\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],
        ["\xF3\xB1\xA5\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\xF3\xB1\xA5\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\xF3\xB1\xA5\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD3"],
        ["\xF3\xB1\xA5\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],
        ["\xF3\xB1\xA5\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\xF3\xB1\xA5\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\xF3\xB1\xA5\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],
        ["\xF3\xB1\xA5\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\xF3\xB1\xA5\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\xF3\xB1\xA5\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"],
        ["\xF3\xB1\xA5\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\xF3\xB1\xA5\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\xF3\xB1\xA5\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\xF3\xB1\xA5\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\xF3\xB1\xA5\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],
        ["\xF3\xB1\xA5\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE8"],
        ["\xF3\xB1\xA5\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],
        ["\xF3\xB1\xA5\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\xF3\xB1\xA5\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],
        ["\xF3\xB1\xA5\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\xF3\xB1\xA5\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\x9B"],
        ["\xF3\xB1\xA5\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\xF3\xB1\xA5\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\xF3\xB1\xA5\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\xF3\xB1\xA5\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\xF3\xB1\xA5\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\xF3\xB1\xA5\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\xF3\xB1\xA6\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\xF3\xB1\xA6\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\xF3\xB1\xA6\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\xF3\xB1\xA6\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],
        ["\xF3\xB1\xA6\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\xF3\xB1\xA6\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\xF3\xB1\xA6\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\xF3\xB1\xA6\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\xF3\xB1\xA6\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\xF3\xB1\xA6\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\xF3\xB1\xA6\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],
        ["\xF3\xB1\xA6\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\xF3\xB1\xA6\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\xF3\xB1\xA6\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\xF3\xB1\xA6\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\xF3\xB1\xA6\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x80"],
        ["\xF3\xB1\xA6\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x8B"],
        ["\xF3\xB1\xA6\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x9B"],
        ["\xF3\xB1\xA6\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x9C"],
        ["\xF3\xB1\xA6\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xA0"],
        ["\xF3\xB1\xA6\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],
        ["\xF3\xB1\xA6\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\xF3\xB1\xA6\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xC0"],
        ["\xF3\xB1\xA6\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\xF3\xB1\xA6\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\xF3\xB1\xA6\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x62\xA1"],
        ["\xF3\xB1\xA6\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\xF3\xB1\xA6\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7F"],
        ["\xF3\xB1\xA6\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\xF3\xB1\xA6\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\xF3\xB1\xA6\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\xF3\xB1\xA6\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\xF3\xB1\xA6\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\xF3\xB1\xA6\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\xF3\xB1\xA6\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\xF3\xB1\xA6\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\xF3\xB1\xA6\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\xF3\xB1\xA6\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\xF3\xB1\xA6\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\xF3\xB1\xA6\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\xF3\xB1\xA6\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\xF3\xB1\xA6\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],
        ["\xF3\xB1\xA6\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\xF3\xB1\xA6\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF2"],
        ["\xF3\xB1\xA6\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],
        ["\xF3\xB1\xA6\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF4"],
        ["\xF3\xB1\xA6\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF5"],
        ["\xF3\xB1\xA6\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\xF3\xB1\xA6\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],
        ["\xF3\xB1\xA6\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\xF3\xB1\xA6\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],
        ["\xF3\xB1\xA6\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\xF3\xB1\xA6\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],
        ["\xF3\xB1\xA6\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\xF3\xB1\xA6\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\xF3\xB1\xA6\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\xF3\xB1\xA6\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\xF3\xB1\xA6\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\xF3\xB1\xA6\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\xF3\xB1\xA6\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],
        ["\xF3\xB1\xA6\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\xF3\xB1\xA6\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\xF3\xB1\xA6\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC5"],
        ["\xF3\xB1\xA6\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\xF3\xB1\xA7\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],
        ["\xF3\xB1\xA7\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],
        ["\xF3\xB1\xA7\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC9"],
        ["\xF3\xB1\xA7\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD1"],
        ["\xF3\xB1\xA7\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],
        ["\xF3\xB1\xA7\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\xF3\xB1\xA7\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD4"],
        ["\xF3\xB1\xA7\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD5"],
        ["\xF3\xB1\xA7\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD6"],
        ["\xF3\xB1\xA7\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],
        ["\xF3\xB1\xA7\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\xF3\xB1\xA7\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],
        ["\xF3\xB1\xA7\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE2"],
        ["\xF3\xB1\xA7\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],
        ["\xF3\xB1\xA7\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\xF3\xB1\xA7\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE5"],
        ["\xF3\xB1\xA7\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\xF3\xB1\xA7\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE7"],
        ["\xF3\xB1\xA7\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\xF3\xB1\xA7\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xE9"],
        ["\xF3\xB1\xA7\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\xF3\xB1\xA7\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\xF3\xB1\xA7\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\xF3\xB1\xA7\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\xF3\xB1\xA7\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\xF3\xB1\xA7\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\xF3\xB1\xA7\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\xF3\xB1\xA7\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\xF3\xB1\xA7\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\xF3\xB1\xA7\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\xF3\xB1\xA7\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\xF3\xB1\xA7\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\xF3\xB1\xA7\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\xF3\xB1\xA7\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\xF3\xB1\xA7\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\xF3\xB1\xA7\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\xF3\xB1\xA7\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\xF3\xB1\xA7\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\xF3\xB1\xA7\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\xF3\xB1\xA7\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\xF3\xB1\xA7\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\xF3\xB1\xA7\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\xF3\xB1\xA7\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\xF3\xB1\xA7\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\xF3\xB1\xA7\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\xF3\xB1\xA7\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x80"],
        ["\xF3\xB1\xA7\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x8B"],
        ["\xF3\xB1\xA7\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x9B"],
        ["\xF3\xB1\xA7\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x9C"],
        ["\xF3\xB1\xA7\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xA0"],
        ["\xF3\xB1\xA7\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],
        ["\xF3\xB1\xA7\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\xF3\xB1\xA7\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],
        ["\xF3\xB1\xA7\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\xF3\xB1\xA7\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xD0"],
        ["\xF3\xB1\xA7\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],
        ["\xF3\xB1\xA7\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\xF3\xB1\xA7\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7F"],
        ["\xF3\xB1\xA7\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\xF3\xB1\xA7\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE0"],
        ["\xF3\xB1\xA7\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\xF3\xB1\xA7\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],
        ["\xF3\xB1\xA7\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],
        ["\xF3\xB1\xA7\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\xF3\xB1\xA8\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\xF3\xB1\xA8\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\xF3\xB1\xA8\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\xF3\xB1\xA8\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\xF3\xB1\xA8\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\xF3\xB1\xA8\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\xF3\xB1\xA8\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\xF3\xB1\xA8\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],
        ["\xF3\xB1\xA8\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF1"],
        ["\xF3\xB1\xA8\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],
        ["\xF3\xB1\xA8\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF3"],
        ["\xF3\xB1\xA8\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],
        ["\xF3\xB1\xA8\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\xF3\xB1\xA8\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\xF3\xB1\xA8\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\xF3\xB1\xA8\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\xF3\xB1\xA8\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\xF3\xB1\xA8\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\xF3\xB1\xA8\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\xF3\xB1\xA8\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\xF3\xB1\xA8\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\xF3\xB1\xA8\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\xF3\xB1\xA8\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\xF3\xB1\xA8\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],
        ["\xF3\xB1\xA8\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],
        ["\xF3\xB1\xA8\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\xF3\xB1\xA8\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\xF3\xB1\xA8\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],
        ["\xF3\xB1\xA8\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC5"],
        ["\xF3\xB1\xA8\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC6"],
        ["\xF3\xB1\xA8\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\xF3\xB1\xA8\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC8"],
        ["\xF3\xB1\xA8\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC9"],
        ["\xF3\xB1\xA8\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\xF3\xB1\xA8\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\xF3\xB1\xA8\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\xF3\xB1\xA8\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD4"],
        ["\xF3\xB1\xA8\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD5"],
        ["\xF3\xB1\xA8\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\xF3\xB1\xA8\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],
        ["\xF3\xB1\xA8\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\xF3\xB1\xA8\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],
        ["\xF3\xB1\xA8\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\xF3\xB1\xA8\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\xF3\xB1\xA8\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\xF3\xB1\xA8\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\xF3\xB1\xA8\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],
        ["\xF3\xB1\xA8\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\xF3\xB1\xA8\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\xF3\xB1\xA8\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xE9"],
        ["\xF3\xB1\xA8\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\xF3\xB1\xA8\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\xF3\xB1\xA8\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\xF3\xB1\xA8\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\xF3\xB1\xA8\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\xF3\xB1\xA8\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\xF3\xB1\xA8\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\xF3\xB1\xA8\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\xF3\xB1\xA8\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\xF3\xB1\xA8\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\xF3\xB1\xA8\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\xF3\xB1\xA8\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\xF3\xB1\xA8\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\xF3\xB1\xA8\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\xF3\xB1\xA9\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\xF3\xB1\xA9\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\xF3\xB1\xA9\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\xF3\xB1\xA9\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\xF3\xB1\xA9\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\xF3\xB1\xA9\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\xF3\xB1\xA9\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\xF3\xB1\xA9\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\xF3\xB1\xA9\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\xF3\xB1\xA9\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\xF3\xB1\xA9\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\xF3\xB1\xA9\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x80"],
        ["\xF3\xB1\xA9\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x8B"],
        ["\xF3\xB1\xA9\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x9B"],
        ["\xF3\xB1\xA9\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x9C"],
        ["\xF3\xB1\xA9\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xA0"],
        ["\xF3\xB1\xA9\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],
        ["\xF3\xB1\xA9\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xB0"],
        ["\xF3\xB1\xA9\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],
        ["\xF3\xB1\xA9\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\xF3\xB1\xA9\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\xF3\xB1\xA9\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\xF3\xB1\xA9\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\xF3\xB1\xA9\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7F"],
        ["\xF3\xB1\xA9\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\xF3\xB1\xA9\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],
        ["\xF3\xB1\xA9\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\xF3\xB1\xA9\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\xF3\xB1\xA9\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\xF3\xB1\xA9\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\xF3\xB1\xA9\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\xF3\xB1\xA9\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\xF3\xB1\xA9\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\xF3\xB1\xA9\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],
        ["\xF3\xB1\xA9\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\xF3\xB1\xA9\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\xF3\xB1\xA9\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\xF3\xB1\xA9\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF0"],
        ["\xF3\xB1\xA9\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\xF3\xB1\xA9\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],
        ["\xF3\xB1\xA9\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF3"],
        ["\xF3\xB1\xA9\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],
        ["\xF3\xB1\xA9\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF5"],
        ["\xF3\xB1\xA9\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF6"],
        ["\xF3\xB1\xA9\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\xF3\xB1\xA9\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\xF3\xB1\xA9\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],
        ["\xF3\xB1\xA9\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\xF3\xB1\xA9\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\xF3\xB1\xA9\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\xF3\xB1\xA9\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\xF3\xB1\xA9\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\xF3\xB1\xA9\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\xF3\xB1\xA9\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\xF3\xB1\xA9\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC1"],
        ["\xF3\xB1\xA9\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],
        ["\xF3\xB1\xA9\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"],
        ["\xF3\xB1\xA9\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\xF3\xB1\xA9\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],
        ["\xF3\xB1\xA9\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC6"],
        ["\xF3\xB1\xA9\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\xF3\xB1\xA9\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC8"],
        ["\xF3\xB1\xA9\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC9"],
        ["\xF3\xB1\xA9\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\xF3\xB1\xAA\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\xF3\xB1\xAA\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\xF3\xB1\xAA\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD4"],
        ["\xF3\xB1\xAA\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD5"],
        ["\xF3\xB1\xAA\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD6"],
        ["\xF3\xB1\xAA\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD7"],
        ["\xF3\xB1\xAA\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD8"],
        ["\xF3\xB1\xAA\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD9"],
        ["\xF3\xB1\xAA\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],
        ["\xF3\xB1\xAA\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],
        ["\xF3\xB1\xAA\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE4"],
        ["\xF3\xB1\xAA\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE5"],
        ["\xF3\xB1\xAA\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\xF3\xB1\xAA\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\xF3\xB1\xAA\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE8"],
        ["\xF3\xB1\xAA\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\xF3\xB1\xAA\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\xF3\xB1\xAA\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\xF3\xB1\xAA\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\xF3\xB1\xAA\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\xF3\xB1\xAA\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\xF3\xB1\xAA\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\xF3\xB1\xAA\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\xF3\xB1\xAA\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\xF3\xB1\xAA\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\xF3\xB1\xAA\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\xF3\xB1\xAA\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],
        ["\xF3\xB1\xAA\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\xF3\xB1\xAA\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],
        ["\xF3\xB1\xAA\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],
        ["\xF3\xB1\xAA\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\xF3\xB1\xAA\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\xF3\xB1\xAA\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\xF3\xB1\xAA\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\xF3\xB1\xAA\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\xF3\xB1\xAA\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\xF3\xB1\xAA\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\xF3\xB1\xAA\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\xF3\xB1\xAA\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\xF3\xB1\xAA\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\xF3\xB1\xAA\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\xF3\xB1\xAA\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x80"],
        ["\xF3\xB1\xAA\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x8B"],
        ["\xF3\xB1\xAA\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x9B"],
        ["\xF3\xB1\xAA\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x9C"],
        ["\xF3\xB1\xAA\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xA0"],
        ["\xF3\xB1\xAA\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xAB"],
        ["\xF3\xB1\xAA\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],
        ["\xF3\xB1\xAA\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],
        ["\xF3\xB1\xAA\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\xF3\xB1\xAA\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xD0"],
        ["\xF3\xB1\xAA\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x65\xA1"],
        ["\xF3\xB1\xAA\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\xF3\xB1\xAA\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7F"],
        ["\xF3\xB1\xAA\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\xF3\xB1\xAA\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE0"],
        ["\xF3\xB1\xAA\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\xF3\xB1\xAA\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\xF3\xB1\xAA\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\xF3\xB1\xAA\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\xF3\xB1\xAA\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\xF3\xB1\xAA\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\xF3\xB1\xAA\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\xF3\xB1\xAA\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\xF3\xB1\xAB\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\xF3\xB1\xAB\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\xF3\xB1\xAB\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\xF3\xB1\xAB\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF0"],
        ["\xF3\xB1\xAB\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],
        ["\xF3\xB1\xAB\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\xF3\xB1\xAB\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF3"],
        ["\xF3\xB1\xAB\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF4"],
        ["\xF3\xB1\xAB\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF5"],
        ["\xF3\xB1\xAB\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF6"],
        ["\xF3\xB1\xAB\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF7"],
        ["\xF3\xB1\xAB\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF8"],
        ["\xF3\xB1\xAB\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xF9"],
        ["\xF3\xB1\xAB\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\xF3\xB1\xAB\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\xF3\xB1\xAB\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\xF3\xB1\xAB\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\xF3\xB1\xAB\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\xF3\xB1\xAB\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\xF3\xB1\xAB\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\xF3\xB1\xAB\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC1"],
        ["\xF3\xB1\xAB\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\xF3\xB1\xAB\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"],
        ["\xF3\xB1\xAB\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],
        ["\xF3\xB1\xAB\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC5"],
        ["\xF3\xB1\xAB\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC6"],
        ["\xF3\xB1\xAB\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC7"],
        ["\xF3\xB1\xAB\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC8"],
        ["\xF3\xB1\xAB\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC9"],
        ["\xF3\xB1\xAB\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD1"],
        ["\xF3\xB1\xAB\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD2"],
        ["\xF3\xB1\xAB\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],
        ["\xF3\xB1\xAB\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],
        ["\xF3\xB1\xAB\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD5"],
        ["\xF3\xB1\xAB\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD6"],
        ["\xF3\xB1\xAB\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD7"],
        ["\xF3\xB1\xAB\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD8"],
        ["\xF3\xB1\xAB\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD9"],
        ["\xF3\xB1\xAB\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE2"],
        ["\xF3\xB1\xAB\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE3"],
        ["\xF3\xB1\xAB\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE4"],
        ["\xF3\xB1\xAB\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE5"],
        ["\xF3\xB1\xAB\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE6"],
        ["\xF3\xB1\xAB\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE7"],
        ["\xF3\xB1\xAB\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE8"],
        ["\xF3\xB1\xAB\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xE9"],
        ["\xF3\xB1\xAB\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],
        ["\xF3\xB1\xAB\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\xF3\xB1\xAB\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\xF3\xB1\xAB\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\xF3\xB1\xAB\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\xF3\xB1\xAB\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],
        ["\xF3\xB1\xAB\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\xF3\xB1\xAB\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\xF3\xB1\xAB\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\xF3\xB1\xAB\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\xF3\xB1\xAB\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\xF3\xB1\xAB\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\xF3\xB1\xAB\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\xF3\xB1\xAB\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\xF3\xB1\xAB\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\xF3\xB1\xAB\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\xF3\xB1\xAB\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\xF3\xB1\xAB\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\xF3\xB1\xAC\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\xF3\xB1\xAC\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\xF3\xB1\xAC\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],
        ["\xF3\xB1\xAC\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\xF3\xB1\xAC\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\xF3\xB1\xAC\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\xF3\xB1\xAC\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],
        ["\xF3\xB1\xAC\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x80"],
        ["\xF3\xB1\xAC\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x8B"],
        ["\xF3\xB1\xAC\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x9B"],
        ["\xF3\xB1\xAC\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x9C"],
        ["\xF3\xB1\xAC\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xA0"],
        ["\xF3\xB1\xAC\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\xF3\xB1\xAC\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],
        ["\xF3\xB1\xAC\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],
        ["\xF3\xB1\xAC\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\xF3\xB1\xAC\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],
        ["\xF3\xB1\xAC\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],
        ["\xF3\xB1\xAC\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],
        ["\xF3\xB1\xAC\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7F"],
        ["\xF3\xB1\xAC\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],
        ["\xF3\xB1\xAC\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE0"],
        ["\xF3\xB1\xAC\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],
        ["\xF3\xB1\xAC\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],
        ["\xF3\xB1\xAC\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],
        ["\xF3\xB1\xAC\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],
        ["\xF3\xB1\xAC\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],
        ["\xF3\xB1\xAC\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],
        ["\xF3\xB1\xAC\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],
        ["\xF3\xB1\xAC\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],
        ["\xF3\xB1\xAC\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],
        ["\xF3\xB1\xAC\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],
        ["\xF3\xB1\xAC\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],
        ["\xF3\xB1\xAC\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF0"],
        ["\xF3\xB1\xAC\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"],
        ["\xF3\xB1\xAC\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF2"],
        ["\xF3\xB1\xAC\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF3"],
        ["\xF3\xB1\xAC\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF4"],
        ["\xF3\xB1\xAC\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF5"],
        ["\xF3\xB1\xAC\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF6"],
        ["\xF3\xB1\xAC\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],
        ["\xF3\xB1\xAC\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF8"],
        ["\xF3\xB1\xAC\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xF9"],
        ["\xF3\xB1\xAC\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],
        ["\xF3\xB1\xAC\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],
        ["\xF3\xB1\xAC\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],
        ["\xF3\xB1\xAC\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],
        ["\xF3\xB1\xAC\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],
        ["\xF3\xB1\xAC\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],
        ["\xF3\xB1\xAC\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],
        ["\xF3\xB1\xAC\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC1"],
        ["\xF3\xB1\xAC\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC2"],
        ["\xF3\xB1\xAC\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC3"],
        ["\xF3\xB1\xAC\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC4"],
        ["\xF3\xB1\xAC\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC5"],
        ["\xF3\xB1\xAC\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC6"],
        ["\xF3\xB1\xAC\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC7"],
        ["\xF3\xB1\xAC\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC8"],
        ["\xF3\xB1\xAC\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC9"],
        ["\xF3\xB1\xAC\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD1"],
        ["\xF3\xB1\xAC\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD2"],
        ["\xF3\xB1\xAC\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD3"],
        ["\xF3\xB1\xAC\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD4"],
        ["\xF3\xB1\xAC\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD5"],
        ["\xF3\xB1\xAD\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD6"],
        ["\xF3\xB1\xAD\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD7"],
        ["\xF3\xB1\xAD\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD8"],
        ["\xF3\xB1\xAD\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],
        ["\xF3\xB1\xAD\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE2"],
        ["\xF3\xB1\xAD\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE3"],
        ["\xF3\xB1\xAD\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE4"],
        ["\xF3\xB1\xAD\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE5"],
        ["\xF3\xB1\xAD\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE6"],
        ["\xF3\xB1\xAD\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE7"],
        ["\xF3\xB1\xAD\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE8"],
        ["\xF3\xB1\xAD\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xE9"],
        ["\xF3\xB1\xAD\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],
        ["\xF3\xB1\xAD\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],
        ["\xF3\xB1\xAD\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],
        ["\xF3\xB1\xAD\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],
        ["\xF3\xB1\xAD\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],
        ["\xF3\xB1\xAD\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],
        ["\xF3\xB1\xAD\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],
        ["\xF3\xB1\xAD\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],
        ["\xF3\xB1\xAD\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],
        ["\xF3\xB1\xAD\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],
        ["\xF3\xB1\xAD\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],
        ["\xF3\xB1\xAD\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],
        ["\xF3\xB1\xAD\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],
        ["\xF3\xB1\xAD\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],
        ["\xF3\xB1\xAD\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],
        ["\xF3\xB1\xAD\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],
        ["\xF3\xB1\xAD\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],
        ["\xF3\xB1\xAD\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],
        ["\xF3\xB1\xAD\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],
        ["\xF3\xB1\xAD\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],
        ["\xF3\xB1\xAD\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],
        ["\xF3\xB1\xAD\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],
        ["\xF3\xB1\xAD\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],
        ["\xF3\xB1\xAD\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],
        ["\xF3\xB1\xAD\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],
        ["\xF3\xB1\xAD\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x80"],
        ["\xF3\xB1\xAD\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x8B"],
        ["\xF3\xB1\xAD\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x9B"],
        ["\xF3\xB1\xAD\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x9C"],
        ["\xF3\xB1\xAD\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xA0"],
        ["\xF3\xB1\xAD\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xAB"],
        ["\xF3\xB1\xAD\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xB0"],
        ["\xF3\xB1\xAD\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xC0"],
        ["\xF3\xB1\xAD\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],
        ["\xF3\xB1\xAD\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\xF3\xB1\xAD\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x67\xA1"],
        ["\xF3\xB1\xAD\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],
        ["\xF3\xB1\xAD\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x4C\xC9"],
        ["\xF3\xB1\xAD\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],
        ["\xF3\xB1\xAD\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE0"],
        ["\xF3\xB1\xAD\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],
        ["\xF3\xB1\xAD\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\xF3\xB1\xAD\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],
        ["\xF3\xB1\xAD\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],
        ["\xF3\xB1\xAD\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],
        ["\xF3\xB1\xAD\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],
        ["\xF3\xB1\xAD\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],
        ["\xF3\xB1\xAD\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],
        ["\xF3\xB1\xAD\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],
        ["\xF3\xB1\xAD\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],
        ["\xF3\xB1\xAD\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],
        ["\xF3\xB1\xAD\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF0"],
        ["\xF3\xB1\xAE\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF1"],
        ["\xF3\xB1\xAE\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF2"],
        ["\xF3\xB1\xAE\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF3"],
        ["\xF3\xB1\xAE\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF4"],
        ["\xF3\xB1\xAE\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF5"],
        ["\xF3\xB1\xAE\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF6"],
        ["\xF3\xB1\xAE\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF7"],
        ["\xF3\xB1\xAE\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF8"],
        ["\xF3\xB1\xAE\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xF9"],
        ["\xF3\xB1\xAE\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],
        ["\xF3\xB1\xAE\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],
        ["\xF3\xB1\xAE\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],
        ["\xF3\xB1\xAE\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],
        ["\xF3\xB1\xAE\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\xF3\xB1\xAE\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\xF3\xB1\xAE\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],
        ["\xF3\xB1\xAE\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC1"],
        ["\xF3\xB1\xAE\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC2"],
        ["\xF3\xB1\xAE\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC3"],
        ["\xF3\xB1\xAE\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC4"],
        ["\xF3\xB1\xAE\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC5"],
        ["\xF3\xB1\xAE\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC6"],
        ["\xF3\xB1\xAE\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC7"],
        ["\xF3\xB1\xAE\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC8"],
        ["\xF3\xB1\xAE\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC9"],
        ["\xF3\xB1\xAE\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD1"],
        ["\xF3\xB1\xAE\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD2"],
        ["\xF3\xB1\xAE\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD3"],
        ["\xF3\xB1\xAE\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD4"],
        ["\xF3\xB1\xAE\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD5"],
        ["\xF3\xB1\xAE\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD6"],
        ["\xF3\xB1\xAE\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD7"],
        ["\xF3\xB1\xAE\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD8"],
        ["\xF3\xB1\xAE\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD9"],
        ["\xF3\xB1\xAE\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE2"],
        ["\xF3\xB1\xAE\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE3"],
        ["\xF3\xB1\xAE\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE4"],
        ["\xF3\xB1\xAE\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE5"],
        ["\xF3\xB1\xAE\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE6"],
        ["\xF3\xB1\xAE\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE7"],
        ["\xF3\xB1\xAE\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xE8"],
        ["\xF3\xB1\xAE\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],
        ["\xF3\xB1\xAE\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],
        ["\xF3\xB1\xAE\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],
        ["\xF3\xB1\xAE\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],
        ["\xF3\xB1\xAE\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],
        ["\xF3\xB1\xAE\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],
        ["\xF3\xB1\xAE\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],
        ["\xF3\xB1\xAE\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],
        ["\xF3\xB1\xAE\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],
        ["\xF3\xB1\xAE\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],
        ["\xF3\xB1\xAE\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],
        ["\xF3\xB1\xAE\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],
        ["\xF3\xB1\xAE\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],
        ["\xF3\xB1\xAE\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],
        ["\xF3\xB1\xAE\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],
        ["\xF3\xB1\xAE\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],
        ["\xF3\xB1\xAE\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],
        ["\xF3\xB1\xAE\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],
        ["\xF3\xB1\xAE\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],
        ["\xF3\xB1\xAE\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],
        ["\xF3\xB1\xAE\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],
        ["\xF3\xB1\xAE\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],
        ["\xF3\xB1\xAE\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],
        ["\xF3\xB1\xAF\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],
        ["\xF3\xB1\xAF\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],
        ["\xF3\xB1\xAF\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],
        ["\xF3\xB1\xAF\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x80"],
        ["\xF3\xB1\xAF\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x8B"],
        ["\xF3\xB1\xAF\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x9B"],
        ["\xF3\xB1\xAF\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x9C"],
        ["\xF3\xB1\xAF\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA0"],
        ["\xF3\xB1\xAF\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xAB"],
        ["\xF3\xB1\xAF\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xB0"],
        ["\xF3\xB1\xAF\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xC0"],
        ["\xF3\xB1\xAF\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],
        ["\xF3\xB1\xAF\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xD0"],
        ["\xF3\xB1\xAF\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x68\xA1"],
        ["\xF3\xB1\xAF\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4F"],
        ["\xF3\xB1\xAF\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7F"],
        ["\xF3\xB1\xAF\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7B"],
        ["\xF3\xB1\xAF\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC7\x67"],
        ["\xF3\xB1\xAF\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6C"],
        ["\xF3\xB1\xAF\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x50"],
        ["\xF3\xB1\xAF\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7D"],
        ["\xF3\xB1\xAF\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4D"],
        ["\xF3\xB1\xAF\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5D"],
        ["\xF3\xB1\xAF\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5C"],
        ["\xF3\xB1\xAF\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4E"],
        ["\xF3\xB1\xAF\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6B"],
        ["\xF3\xB1\xAF\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x60"],
        ["\xF3\xB1\xAF\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4B"],
        ["\xF3\xB1\xAF\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x61"],
        ["\xF3\xB1\xAF\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF0"],
        ["\xF3\xB1\xAF\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF1"],
        ["\xF3\xB1\xAF\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF2"],
        ["\xF3\xB1\xAF\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF3"],
        ["\xF3\xB1\xAF\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF4"],
        ["\xF3\xB1\xAF\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF5"],
        ["\xF3\xB1\xAF\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF6"],
        ["\xF3\xB1\xAF\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF7"],
        ["\xF3\xB1\xAF\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF8"],
        ["\xF3\xB1\xAF\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xF9"],
        ["\xF3\xB1\xAF\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7A"],
        ["\xF3\xB1\xAF\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5E"],
        ["\xF3\xB1\xAF\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4C"],
        ["\xF3\xB1\xAF\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7E"],
        ["\xF3\xB1\xAF\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6E"],
        ["\xF3\xB1\xAF\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6F"],
        ["\xF3\xB1\xAF\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x7C"],
        ["\xF3\xB1\xAF\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC1"],
        ["\xF3\xB1\xAF\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC2"],
        ["\xF3\xB1\xAF\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC3"],
        ["\xF3\xB1\xAF\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC4"],
        ["\xF3\xB1\xAF\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC5"],
        ["\xF3\xB1\xAF\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC6"],
        ["\xF3\xB1\xAF\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC7"],
        ["\xF3\xB1\xAF\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC8"],
        ["\xF3\xB1\xAF\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC9"],
        ["\xF3\xB1\xAF\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD1"],
        ["\xF3\xB1\xAF\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD2"],
        ["\xF3\xB1\xAF\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD3"],
        ["\xF3\xB1\xAF\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD4"],
        ["\xF3\xB1\xAF\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD5"],
        ["\xF3\xB1\xAF\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD6"],
        ["\xF3\xB1\xAF\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD7"],
        ["\xF3\xB1\xAF\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD8"],
        ["\xF3\xB1\xAF\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD9"],
        ["\xF3\xB1\xB0\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE2"],
        ["\xF3\xB1\xB0\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE3"],
        ["\xF3\xB1\xB0\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE4"],
        ["\xF3\xB1\xB0\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE5"],
        ["\xF3\xB1\xB0\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE6"],
        ["\xF3\xB1\xB0\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE7"],
        ["\xF3\xB1\xB0\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE8"],
        ["\xF3\xB1\xB0\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xE9"],
        ["\xF3\xB1\xB0\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x4A"],
        ["\xF3\xB1\xB0\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5B"],
        ["\xF3\xB1\xB0\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5A"],
        ["\xF3\xB1\xB0\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x5F"],
        ["\xF3\xB1\xB0\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6D"],
        ["\xF3\xB1\xB0\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x79"],
        ["\xF3\xB1\xB0\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x57"],
        ["\xF3\xB1\xB0\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x59"],
        ["\xF3\xB1\xB0\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x62"],
        ["\xF3\xB1\xB0\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x63"],
        ["\xF3\xB1\xB0\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x64"],
        ["\xF3\xB1\xB0\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x65"],
        ["\xF3\xB1\xB0\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x66"],
        ["\xF3\xB1\xB0\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x67"],
        ["\xF3\xB1\xB0\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x68"],
        ["\xF3\xB1\xB0\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x69"],
        ["\xF3\xB1\xB0\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x70"],
        ["\xF3\xB1\xB0\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x71"],
        ["\xF3\xB1\xB0\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x72"],
        ["\xF3\xB1\xB0\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x73"],
        ["\xF3\xB1\xB0\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x74"],
        ["\xF3\xB1\xB0\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x75"],
        ["\xF3\xB1\xB0\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x76"],
        ["\xF3\xB1\xB0\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x77"],
        ["\xF3\xB1\xB0\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x78"],
        ["\xF3\xB1\xB0\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x80"],
        ["\xF3\xB1\xB0\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x8B"],
        ["\xF3\xB1\xB0\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x9B"],
        ["\xF3\xB1\xB0\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x9C"],
        ["\xF3\xB1\xB0\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xA0"],
        ["\xF3\xB1\xB0\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xAB"],
        ["\xF3\xB1\xB0\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xB0"],
        ["\xF3\xB1\xB0\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xC0"],
        ["\xF3\xB1\xB0\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\x6A"],
        ["\xF3\xB1\xB0\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xD0"],
        ["\xF3\xB1\xB0\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x69\xA1"],
        ["\xF3\xB1\xB0\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4F"],
        ["\xF3\xB1\xB0\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7F"],
        ["\xF3\xB1\xB0\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7B"],
        ["\xF3\xB1\xB0\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE0"],
        ["\xF3\xB1\xB0\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6C"],
        ["\xF3\xB1\xB0\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x50"],
        ["\xF3\xB1\xB0\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7D"],
        ["\xF3\xB1\xB0\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4D"],
        ["\xF3\xB1\xB0\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5D"],
        ["\xF3\xB1\xB0\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5C"],
        ["\xF3\xB1\xB0\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4E"],
        ["\xF3\xB1\xB0\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6B"],
        ["\xF3\xB1\xB0\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x60"],
        ["\xF3\xB1\xB0\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4B"],
        ["\xF3\xB1\xB0\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x61"],
        ["\xF3\xB1\xB0\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF0"],
        ["\xF3\xB1\xB0\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF1"],
        ["\xF3\xB1\xB0\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF2"],
        ["\xF3\xB1\xB0\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF3"],
        ["\xF3\xB1\xB0\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF4"],
        ["\xF3\xB1\xB1\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF5"],
        ["\xF3\xB1\xB1\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF6"],
        ["\xF3\xB1\xB1\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF7"],
        ["\xF3\xB1\xB1\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF8"],
        ["\xF3\xB1\xB1\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xF9"],
        ["\xF3\xB1\xB1\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7A"],
        ["\xF3\xB1\xB1\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5E"],
        ["\xF3\xB1\xB1\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4C"],
        ["\xF3\xB1\xB1\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7E"],
        ["\xF3\xB1\xB1\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6E"],
        ["\xF3\xB1\xB1\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6F"],
        ["\xF3\xB1\xB1\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x7C"],
        ["\xF3\xB1\xB1\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC1"],
        ["\xF3\xB1\xB1\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC2"],
        ["\xF3\xB1\xB1\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC3"],
        ["\xF3\xB1\xB1\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC4"],
        ["\xF3\xB1\xB1\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC5"],
        ["\xF3\xB1\xB1\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC6"],
        ["\xF3\xB1\xB1\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC7"],
        ["\xF3\xB1\xB1\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC8"],
        ["\xF3\xB1\xB1\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC9"],
        ["\xF3\xB1\xB1\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD1"],
        ["\xF3\xB1\xB1\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD2"],
        ["\xF3\xB1\xB1\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD3"],
        ["\xF3\xB1\xB1\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD4"],
        ["\xF3\xB1\xB1\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD5"],
        ["\xF3\xB1\xB1\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD6"],
        ["\xF3\xB1\xB1\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD7"],
        ["\xF3\xB1\xB1\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD8"],
        ["\xF3\xB1\xB1\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD9"],
        ["\xF3\xB1\xB1\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE2"],
        ["\xF3\xB1\xB1\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE3"],
        ["\xF3\xB1\xB1\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE4"],
        ["\xF3\xB1\xB1\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE5"],
        ["\xF3\xB1\xB1\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE6"],
        ["\xF3\xB1\xB1\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE7"],
        ["\xF3\xB1\xB1\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE8"],
        ["\xF3\xB1\xB1\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xE9"],
        ["\xF3\xB1\xB1\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x4A"],
        ["\xF3\xB1\xB1\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5B"],
        ["\xF3\xB1\xB1\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF4\xD9"],
        ["\xF3\xB1\xB1\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x5F"],
        ["\xF3\xB1\xB1\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6D"],
        ["\xF3\xB1\xB1\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x79"],
        ["\xF3\xB1\xB1\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x57"],
        ["\xF3\xB1\xB1\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x59"],
        ["\xF3\xB1\xB1\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x62"],
        ["\xF3\xB1\xB1\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x63"],
        ["\xF3\xB1\xB1\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x64"],
        ["\xF3\xB1\xB1\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x65"],
        ["\xF3\xB1\xB1\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x66"],
        ["\xF3\xB1\xB1\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x67"],
        ["\xF3\xB1\xB1\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x68"],
        ["\xF3\xB1\xB1\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x69"],
        ["\xF3\xB1\xB1\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x70"],
        ["\xF3\xB1\xB1\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x71"],
        ["\xF3\xB1\xB1\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x72"],
        ["\xF3\xB1\xB1\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x73"],
        ["\xF3\xB1\xB1\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x74"],
        ["\xF3\xB1\xB1\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x75"],
        ["\xF3\xB1\xB1\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x76"],
        ["\xF3\xB1\xB1\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x77"],
        ["\xF3\xB1\xB1\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x78"],
        ["\xF3\xB1\xB1\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x80"],
        ["\xF3\xB1\xB2\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x8B"],
        ["\xF3\xB1\xB2\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x9B"],
        ["\xF3\xB1\xB2\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x9C"],
        ["\xF3\xB1\xB2\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xA0"],
        ["\xF3\xB1\xB2\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xAB"],
        ["\xF3\xB1\xB2\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xB0"],
        ["\xF3\xB1\xB2\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xC0"],
        ["\xF3\xB1\xB2\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\x6A"],
        ["\xF3\xB1\xB2\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xD0"],
        ["\xF3\xB1\xB2\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x70\xA1"],
        ["\xF3\xB1\xB2\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4F"],
        ["\xF3\xB1\xB2\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7F"],
        ["\xF3\xB1\xB2\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7B"],
        ["\xF3\xB1\xB2\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE0"],
        ["\xF3\xB1\xB2\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6C"],
        ["\xF3\xB1\xB2\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x50"],
        ["\xF3\xB1\xB2\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7D"],
        ["\xF3\xB1\xB2\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4D"],
        ["\xF3\xB1\xB2\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5D"],
        ["\xF3\xB1\xB2\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5C"],
        ["\xF3\xB1\xB2\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4E"],
        ["\xF3\xB1\xB2\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6B"],
        ["\xF3\xB1\xB2\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x60"],
        ["\xF3\xB1\xB2\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4B"],
        ["\xF3\xB1\xB2\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x61"],
        ["\xF3\xB1\xB2\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF0"],
        ["\xF3\xB1\xB2\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF1"],
        ["\xF3\xB1\xB2\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF2"],
        ["\xF3\xB1\xB2\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF3"],
        ["\xF3\xB1\xB2\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF4"],
        ["\xF3\xB1\xB2\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF5"],
        ["\xF3\xB1\xB2\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF6"],
        ["\xF3\xB1\xB2\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF7"],
        ["\xF3\xB1\xB2\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF8"],
        ["\xF3\xB1\xB2\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xF9"],
        ["\xF3\xB1\xB2\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7A"],
        ["\xF3\xB1\xB2\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5E"],
        ["\xF3\xB1\xB2\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4C"],
        ["\xF3\xB1\xB2\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7E"],
        ["\xF3\xB1\xB2\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6E"],
        ["\xF3\xB1\xB2\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6F"],
        ["\xF3\xB1\xB2\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x7C"],
        ["\xF3\xB1\xB2\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC1"],
        ["\xF3\xB1\xB2\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC2"],
        ["\xF3\xB1\xB2\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC3"],
        ["\xF3\xB1\xB2\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC4"],
        ["\xF3\xB1\xB2\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC5"],
        ["\xF3\xB1\xB2\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC6"],
        ["\xF3\xB1\xB2\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC7"],
        ["\xF3\xB1\xB2\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC8"],
        ["\xF3\xB1\xB2\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC9"],
        ["\xF3\xB1\xB2\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD1"],
        ["\xF3\xB1\xB2\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD2"],
        ["\xF3\xB1\xB2\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD3"],
        ["\xF3\xB1\xB2\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC1\x4D"],
        ["\xF3\xB1\xB2\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD5"],
        ["\xF3\xB1\xB2\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD6"],
        ["\xF3\xB1\xB2\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD7"],
        ["\xF3\xB1\xB2\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD8"],
        ["\xF3\xB1\xB2\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD9"],
        ["\xF3\xB1\xB2\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE2"],
        ["\xF3\xB1\xB2\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE3"],
        ["\xF3\xB1\xB2\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE4"],
        ["\xF3\xB1\xB2\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE5"],
        ["\xF3\xB1\xB3\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE6"],
        ["\xF3\xB1\xB3\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE7"],
        ["\xF3\xB1\xB3\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE8"],
        ["\xF3\xB1\xB3\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xE9"],
        ["\xF3\xB1\xB3\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x4A"],
        ["\xF3\xB1\xB3\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5B"],
        ["\xF3\xB1\xB3\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5A"],
        ["\xF3\xB1\xB3\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x5F"],
        ["\xF3\xB1\xB3\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6D"],
        ["\xF3\xB1\xB3\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x79"],
        ["\xF3\xB1\xB3\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x57"],
        ["\xF3\xB1\xB3\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x59"],
        ["\xF3\xB1\xB3\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x62"],
        ["\xF3\xB1\xB3\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x63"],
        ["\xF3\xB1\xB3\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x64"],
        ["\xF3\xB1\xB3\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x65"],
        ["\xF3\xB1\xB3\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x66"],
        ["\xF3\xB1\xB3\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x67"],
        ["\xF3\xB1\xB3\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x68"],
        ["\xF3\xB1\xB3\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x69"],
        ["\xF3\xB1\xB3\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x70"],
        ["\xF3\xB1\xB3\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x71"],
        ["\xF3\xB1\xB3\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x72"],
        ["\xF3\xB1\xB3\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x73"],
        ["\xF3\xB1\xB3\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x74"],
        ["\xF3\xB1\xB3\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x75"],
        ["\xF3\xB1\xB3\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x76"],
        ["\xF3\xB1\xB3\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x77"],
        ["\xF3\xB1\xB3\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x78"],
        ["\xF3\xB1\xB3\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x80"],
        ["\xF3\xB1\xB3\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x8B"],
        ["\xF3\xB1\xB3\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x9B"],
        ["\xF3\xB1\xB3\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x9C"],
        ["\xF3\xB1\xB3\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xA0"],
        ["\xF3\xB1\xB3\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xAB"],
        ["\xF3\xB1\xB3\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xB0"],
        ["\xF3\xB1\xB3\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xC0"],
        ["\xF3\xB1\xB3\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\x6A"],
        ["\xF3\xB1\xB3\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xD0"],
        ["\xF3\xB1\xB3\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x71\xA1"],
        ["\xF3\xB1\xB3\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4F"],
        ["\xF3\xB1\xB3\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7F"],
        ["\xF3\xB1\xB3\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7B"],
        ["\xF3\xB1\xB3\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE0"],
        ["\xF3\xB1\xB3\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6C"],
        ["\xF3\xB1\xB3\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x50"],
        ["\xF3\xB1\xB3\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7D"],
        ["\xF3\xB1\xB3\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4D"],
        ["\xF3\xB1\xB3\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5D"],
        ["\xF3\xB1\xB3\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5C"],
        ["\xF3\xB1\xB3\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4E"],
        ["\xF3\xB1\xB3\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6B"],
        ["\xF3\xB1\xB3\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x60"],
        ["\xF3\xB1\xB3\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4B"],
        ["\xF3\xB1\xB3\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x61"],
        ["\xF3\xB1\xB3\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF0"],
        ["\xF3\xB1\xB3\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF1"],
        ["\xF3\xB1\xB3\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF2"],
        ["\xF3\xB1\xB3\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF3"],
        ["\xF3\xB1\xB3\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF4"],
        ["\xF3\xB1\xB3\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF5"],
        ["\xF3\xB1\xB3\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF6"],
        ["\xF3\xB1\xB3\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF7"],
        ["\xF3\xB1\xB3\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF8"],
        ["\xF3\xB1\xB4\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xF9"],
        ["\xF3\xB1\xB4\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7A"],
        ["\xF3\xB1\xB4\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5E"],
        ["\xF3\xB1\xB4\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4C"],
        ["\xF3\xB1\xB4\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7E"],
        ["\xF3\xB1\xB4\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6E"],
        ["\xF3\xB1\xB4\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6F"],
        ["\xF3\xB1\xB4\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x7C"],
        ["\xF3\xB1\xB4\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC1"],
        ["\xF3\xB1\xB4\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC2"],
        ["\xF3\xB1\xB4\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC3"],
        ["\xF3\xB1\xB4\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC4"],
        ["\xF3\xB1\xB4\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC5"],
        ["\xF3\xB1\xB4\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC6"],
        ["\xF3\xB1\xB4\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC7"],
        ["\xF3\xB1\xB4\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC8"],
        ["\xF3\xB1\xB4\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC9"],
        ["\xF3\xB1\xB4\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD1"],
        ["\xF3\xB1\xB4\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD2"],
        ["\xF3\xB1\xB4\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD3"],
        ["\xF3\xB1\xB4\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD4"],
        ["\xF3\xB1\xB4\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD5"],
        ["\xF3\xB1\xB4\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD6"],
        ["\xF3\xB1\xB4\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD7"],
        ["\xF3\xB1\xB4\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD8"],
        ["\xF3\xB1\xB4\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD9"],
        ["\xF3\xB1\xB4\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE2"],
        ["\xF3\xB1\xB4\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE3"],
        ["\xF3\xB1\xB4\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE4"],
        ["\xF3\xB1\xB4\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE5"],
        ["\xF3\xB1\xB4\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE6"],
        ["\xF3\xB1\xB4\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE7"],
        ["\xF3\xB1\xB4\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE8"],
        ["\xF3\xB1\xB4\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xE9"],
        ["\xF3\xB1\xB4\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x4A"],
        ["\xF3\xB1\xB4\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5B"],
        ["\xF3\xB1\xB4\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5A"],
        ["\xF3\xB1\xB4\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x5F"],
        ["\xF3\xB1\xB4\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6D"],
        ["\xF3\xB1\xB4\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x79"],
        ["\xF3\xB1\xB4\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x57"],
        ["\xF3\xB1\xB4\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x59"],
        ["\xF3\xB1\xB4\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x62"],
        ["\xF3\xB1\xB4\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x63"],
        ["\xF3\xB1\xB4\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x64"],
        ["\xF3\xB1\xB4\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x65"],
        ["\xF3\xB1\xB4\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x66"],
        ["\xF3\xB1\xB4\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x67"],
        ["\xF3\xB1\xB4\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x68"],
        ["\xF3\xB1\xB4\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x69"],
        ["\xF3\xB1\xB4\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x70"],
        ["\xF3\xB1\xB4\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x71"],
        ["\xF3\xB1\xB4\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x72"],
        ["\xF3\xB1\xB4\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC6\x9B"],
        ["\xF3\xB1\xB4\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x74"],
        ["\xF3\xB1\xB4\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x75"],
        ["\xF3\xB1\xB4\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x76"],
        ["\xF3\xB1\xB4\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x77"],
        ["\xF3\xB1\xB4\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x78"],
        ["\xF3\xB1\xB4\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x80"],
        ["\xF3\xB1\xB4\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x8B"],
        ["\xF3\xB1\xB4\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x9B"],
        ["\xF3\xB1\xB4\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x9C"],
        ["\xF3\xB1\xB4\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xA0"],
        ["\xF3\xB1\xB5\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xAB"],
        ["\xF3\xB1\xB5\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xB0"],
        ["\xF3\xB1\xB5\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xC0"],
        ["\xF3\xB1\xB5\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\x6A"],
        ["\xF3\xB1\xB5\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xD0"],
        ["\xF3\xB1\xB5\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x72\xA1"],
        ["\xF3\xB1\xB5\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4F"],
        ["\xF3\xB1\xB5\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7F"],
        ["\xF3\xB1\xB5\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7B"],
        ["\xF3\xB1\xB5\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE0"],
        ["\xF3\xB1\xB5\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6C"],
        ["\xF3\xB1\xB5\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x50"],
        ["\xF3\xB1\xB5\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7D"],
        ["\xF3\xB1\xB5\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4D"],
        ["\xF3\xB1\xB5\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5D"],
        ["\xF3\xB1\xB5\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5C"],
        ["\xF3\xB1\xB5\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4E"],
        ["\xF3\xB1\xB5\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6B"],
        ["\xF3\xB1\xB5\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x60"],
        ["\xF3\xB1\xB5\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4B"],
        ["\xF3\xB1\xB5\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x61"],
        ["\xF3\xB1\xB5\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF0"],
        ["\xF3\xB1\xB5\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF1"],
        ["\xF3\xB1\xB5\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF2"],
        ["\xF3\xB1\xB5\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF3"],
        ["\xF3\xB1\xB5\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF4"],
        ["\xF3\xB1\xB5\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF5"],
        ["\xF3\xB1\xB5\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF6"],
        ["\xF3\xB1\xB5\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF7"],
        ["\xF3\xB1\xB5\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF8"],
        ["\xF3\xB1\xB5\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xF9"],
        ["\xF3\xB1\xB5\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7A"],
        ["\xF3\xB1\xB5\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5E"],
        ["\xF3\xB1\xB5\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4C"],
        ["\xF3\xB1\xB5\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7E"],
        ["\xF3\xB1\xB5\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6E"],
        ["\xF3\xB1\xB5\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6F"],
        ["\xF3\xB1\xB5\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x7C"],
        ["\xF3\xB1\xB5\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC1"],
        ["\xF3\xB1\xB5\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC2"],
        ["\xF3\xB1\xB5\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC3"],
        ["\xF3\xB1\xB5\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC4"],
        ["\xF3\xB1\xB5\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC5"],
        ["\xF3\xB1\xB5\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC6"],
        ["\xF3\xB1\xB5\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC7"],
        ["\xF3\xB1\xB5\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC8"],
        ["\xF3\xB1\xB5\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC9"],
        ["\xF3\xB1\xB5\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD1"],
        ["\xF3\xB1\xB5\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD2"],
        ["\xF3\xB1\xB5\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD3"],
        ["\xF3\xB1\xB5\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD4"],
        ["\xF3\xB1\xB5\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD5"],
        ["\xF3\xB1\xB5\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD6"],
        ["\xF3\xB1\xB5\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD7"],
        ["\xF3\xB1\xB5\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD8"],
        ["\xF3\xB1\xB5\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD9"],
        ["\xF3\xB1\xB5\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE2"],
        ["\xF3\xB1\xB5\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE3"],
        ["\xF3\xB1\xB5\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE4"],
        ["\xF3\xB1\xB5\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE5"],
        ["\xF3\xB1\xB5\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE6"],
        ["\xF3\xB1\xB5\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE7"],
        ["\xF3\xB1\xB5\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE8"],
        ["\xF3\xB1\xB5\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xE9"],
        ["\xF3\xB1\xB6\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x4A"],
        ["\xF3\xB1\xB6\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5B"],
        ["\xF3\xB1\xB6\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5A"],
        ["\xF3\xB1\xB6\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x5F"],
        ["\xF3\xB1\xB6\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6D"],
        ["\xF3\xB1\xB6\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x79"],
        ["\xF3\xB1\xB6\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x57"],
        ["\xF3\xB1\xB6\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x59"],
        ["\xF3\xB1\xB6\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x62"],
        ["\xF3\xB1\xB6\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x63"],
        ["\xF3\xB1\xB6\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x64"],
        ["\xF3\xB1\xB6\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x65"],
        ["\xF3\xB1\xB6\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x66"],
        ["\xF3\xB1\xB6\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x67"],
        ["\xF3\xB1\xB6\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x68"],
        ["\xF3\xB1\xB6\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x69"],
        ["\xF3\xB1\xB6\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x70"],
        ["\xF3\xB1\xB6\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x71"],
        ["\xF3\xB1\xB6\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x72"],
        ["\xF3\xB1\xB6\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x73"],
        ["\xF3\xB1\xB6\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x74"],
        ["\xF3\xB1\xB6\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x75"],
        ["\xF3\xB1\xB6\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x76"],
        ["\xF3\xB1\xB6\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x77"],
        ["\xF3\xB1\xB6\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x78"],
        ["\xF3\xB1\xB6\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x80"],
        ["\xF3\xB1\xB6\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x8B"],
        ["\xF3\xB1\xB6\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x9B"],
        ["\xF3\xB1\xB6\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x9C"],
        ["\xF3\xB1\xB6\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xA0"],
        ["\xF3\xB1\xB6\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xAB"],
        ["\xF3\xB1\xB6\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xB0"],
        ["\xF3\xB1\xB6\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xC0"],
        ["\xF3\xB1\xB6\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\x6A"],
        ["\xF3\xB1\xB6\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xD0"],
        ["\xF3\xB1\xB6\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x73\xA1"],
        ["\xF3\xB1\xB6\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x4F"],
        ["\xF3\xB1\xB6\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x7F"],
        ["\xF3\xB1\xB6\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x7B"],
        ["\xF3\xB1\xB6\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE0"],
        ["\xF3\xB1\xB6\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x6C"],
        ["\xF3\xB1\xB6\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x50"],
        ["\xF3\xB1\xB6\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x7D"],
        ["\xF3\xB1\xB6\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x4D"],
        ["\xF3\xB1\xB6\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x5D"],
        ["\xF3\xB1\xB6\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x5C"],
        ["\xF3\xB1\xB6\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x4E"],
        ["\xF3\xB1\xB6\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x6B"],
        ["\xF3\xB1\xB6\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x60"],
        ["\xF3\xB1\xB6\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x4B"],
        ["\xF3\xB1\xB6\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x61"],
        ["\xF3\xB1\xB6\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF0"],
        ["\xF3\xB1\xB6\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF1"],
        ["\xF3\xB1\xB6\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF2"],
        ["\xF3\xB1\xB6\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF3"],
        ["\xF3\xB1\xB6\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF4"],
        ["\xF3\xB1\xB6\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF5"],
        ["\xF3\xB1\xB6\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF6"],
        ["\xF3\xB1\xB6\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF7"],
        ["\xF3\xB1\xB6\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF8"],
        ["\xF3\xB1\xB6\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xF9"],
        ["\xF3\xB1\xB6\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x7A"],
        ["\xF3\xB1\xB6\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x5E"],
        ["\xF3\xB1\xB6\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x4C"],
        ["\xF3\xB1\xB7\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x7E"],
        ["\xF3\xB1\xB7\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x6E"],
        ["\xF3\xB1\xB7\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x6F"],
        ["\xF3\xB1\xB7\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x7C"],
        ["\xF3\xB1\xB7\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC1"],
        ["\xF3\xB1\xB7\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC2"],
        ["\xF3\xB1\xB7\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC3"],
        ["\xF3\xB1\xB7\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC4"],
        ["\xF3\xB1\xB7\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC5"],
        ["\xF3\xB1\xB7\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC6"],
        ["\xF3\xB1\xB7\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC7"],
        ["\xF3\xB1\xB7\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC8"],
        ["\xF3\xB1\xB7\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC9"],
        ["\xF3\xB1\xB7\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD1"],
        ["\xF3\xB1\xB7\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD2"],
        ["\xF3\xB1\xB7\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD3"],
        ["\xF3\xB1\xB7\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD4"],
        ["\xF3\xB1\xB7\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD5"],
        ["\xF3\xB1\xB7\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD6"],
        ["\xF3\xB1\xB7\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD7"],
        ["\xF3\xB1\xB7\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD8"],
        ["\xF3\xB1\xB7\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD9"],
        ["\xF3\xB1\xB7\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE2"],
        ["\xF3\xB1\xB7\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE3"],
        ["\xF3\xB1\xB7\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE4"],
        ["\xF3\xB1\xB7\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE5"],
        ["\xF3\xB1\xB7\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE6"],
        ["\xF3\xB1\xB7\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE7"],
        ["\xF3\xB1\xB7\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE8"],
        ["\xF3\xB1\xB7\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xE9"],
        ["\xF3\xB1\xB7\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x4A"],
        ["\xF3\xB1\xB7\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x5B"],
        ["\xF3\xB1\xB7\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x5A"],
        ["\xF3\xB1\xB7\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x5F"],
        ["\xF3\xB1\xB7\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x6D"],
        ["\xF3\xB1\xB7\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x79"],
        ["\xF3\xB1\xB7\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x57"],
        ["\xF3\xB1\xB7\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x59"],
        ["\xF3\xB1\xB7\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x62"],
        ["\xF3\xB1\xB7\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x63"],
        ["\xF3\xB1\xB7\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x64"],
        ["\xF3\xB1\xB7\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x65"],
        ["\xF3\xB1\xB7\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x66"],
        ["\xF3\xB1\xB7\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x67"],
        ["\xF3\xB1\xB7\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x68"],
        ["\xF3\xB1\xB7\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x69"],
        ["\xF3\xB1\xB7\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x70"],
        ["\xF3\xB1\xB7\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x71"],
        ["\xF3\xB1\xB7\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x72"],
        ["\xF3\xB1\xB7\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x73"],
        ["\xF3\xB1\xB7\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x74"],
        ["\xF3\xB1\xB7\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x75"],
        ["\xF3\xB1\xB7\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x76"],
        ["\xF3\xB1\xB7\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x77"],
        ["\xF3\xB1\xB7\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x78"],
        ["\xF3\xB1\xB7\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x80"],
        ["\xF3\xB1\xB7\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x8B"],
        ["\xF3\xB1\xB7\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x9B"],
        ["\xF3\xB1\xB7\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x9C"],
        ["\xF3\xB1\xB7\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xA0"],
        ["\xF3\xB1\xB7\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xAB"],
        ["\xF3\xB1\xB7\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xB0"],
        ["\xF3\xB1\xB7\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xC0"],
        ["\xF3\xB1\xB7\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\x6A"],
        ["\xF3\xB1\xB8\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xD0"],
        ["\xF3\xB1\xB8\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x74\xA1"],
        ["\xF3\xB1\xB8\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x4F"],
        ["\xF3\xB1\xB8\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x7F"],
        ["\xF3\xB1\xB8\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x7B"],
        ["\xF3\xB1\xB8\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE0"],
        ["\xF3\xB1\xB8\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x6C"],
        ["\xF3\xB1\xB8\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x50"],
        ["\xF3\xB1\xB8\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x7D"],
        ["\xF3\xB1\xB8\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x4D"],
        ["\xF3\xB1\xB8\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x5D"],
        ["\xF3\xB1\xB8\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x5C"],
        ["\xF3\xB1\xB8\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x4E"],
        ["\xF3\xB1\xB8\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x6B"],
        ["\xF3\xB1\xB8\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x60"],
        ["\xF3\xB1\xB8\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x4B"],
        ["\xF3\xB1\xB8\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x61"],
        ["\xF3\xB1\xB8\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF0"],
        ["\xF3\xB1\xB8\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF1"],
        ["\xF3\xB1\xB8\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF2"],
        ["\xF3\xB1\xB8\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF3"],
        ["\xF3\xB1\xB8\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF4"],
        ["\xF3\xB1\xB8\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF5"],
        ["\xF3\xB1\xB8\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF6"],
        ["\xF3\xB1\xB8\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF7"],
        ["\xF3\xB1\xB8\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF8"],
        ["\xF3\xB1\xB8\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xF9"],
        ["\xF3\xB1\xB8\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x7A"],
        ["\xF3\xB1\xB8\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x5E"],
        ["\xF3\xB1\xB8\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x4C"],
        ["\xF3\xB1\xB8\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x7E"],
        ["\xF3\xB1\xB8\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x6E"],
        ["\xF3\xB1\xB8\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x6F"],
        ["\xF3\xB1\xB8\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x7C"],
        ["\xF3\xB1\xB8\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC1"],
        ["\xF3\xB1\xB8\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC2"],
        ["\xF3\xB1\xB8\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC3"],
        ["\xF3\xB1\xB8\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC4"],
        ["\xF3\xB1\xB8\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC5"],
        ["\xF3\xB1\xB8\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC6"],
        ["\xF3\xB1\xB8\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC7"],
        ["\xF3\xB1\xB8\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC8"],
        ["\xF3\xB1\xB8\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC9"],
        ["\xF3\xB1\xB8\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD1"],
        ["\xF3\xB1\xB8\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD2"],
        ["\xF3\xB1\xB8\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD3"],
        ["\xF3\xB1\xB8\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD4"],
        ["\xF3\xB1\xB8\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD5"],
        ["\xF3\xB1\xB8\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD6"],
        ["\xF3\xB1\xB8\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD7"],
        ["\xF3\xB1\xB8\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD8"],
        ["\xF3\xB1\xB8\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD9"],
        ["\xF3\xB1\xB8\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE2"],
        ["\xF3\xB1\xB8\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE3"],
        ["\xF3\xB1\xB8\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE4"],
        ["\xF3\xB1\xB8\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE5"],
        ["\xF3\xB1\xB8\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x6F\xE8"],
        ["\xF3\xB1\xB8\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE7"],
        ["\xF3\xB1\xB8\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE8"],
        ["\xF3\xB1\xB8\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xE9"],
        ["\xF3\xB1\xB8\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x4A"],
        ["\xF3\xB1\xB8\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x5B"],
        ["\xF3\xB1\xB8\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x5A"],
        ["\xF3\xB1\xB8\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x5F"],
        ["\xF3\xB1\xB9\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x6D"],
        ["\xF3\xB1\xB9\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x79"],
        ["\xF3\xB1\xB9\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x57"],
        ["\xF3\xB1\xB9\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x59"],
        ["\xF3\xB1\xB9\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x62"],
        ["\xF3\xB1\xB9\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x63"],
        ["\xF3\xB1\xB9\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x64"],
        ["\xF3\xB1\xB9\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x65"],
        ["\xF3\xB1\xB9\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x66"],
        ["\xF3\xB1\xB9\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x67"],
        ["\xF3\xB1\xB9\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x68"],
        ["\xF3\xB1\xB9\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x69"],
        ["\xF3\xB1\xB9\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x70"],
        ["\xF3\xB1\xB9\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x71"],
        ["\xF3\xB1\xB9\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x72"],
        ["\xF3\xB1\xB9\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x73"],
        ["\xF3\xB1\xB9\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x74"],
        ["\xF3\xB1\xB9\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x75"],
        ["\xF3\xB1\xB9\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x76"],
        ["\xF3\xB1\xB9\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x77"],
        ["\xF3\xB1\xB9\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x78"],
        ["\xF3\xB1\xB9\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF7\x4A"],
        ["\xF3\xB1\xB9\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x8B"],
        ["\xF3\xB1\xB9\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x9B"],
        ["\xF3\xB1\xB9\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x9C"],
        ["\xF3\xB1\xB9\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xA0"],
        ["\xF3\xB1\xB9\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xAB"],
        ["\xF3\xB1\xB9\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xB0"],
        ["\xF3\xB1\xB9\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xC0"],
        ["\xF3\xB1\xB9\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\x6A"],
        ["\xF3\xB1\xB9\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xD0"],
        ["\xF3\xB1\xB9\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x75\xA1"],
        ["\xF3\xB1\xB9\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x4F"],
        ["\xF3\xB1\xB9\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x7F"],
        ["\xF3\xB1\xB9\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x7B"],
        ["\xF3\xB1\xB9\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE0"],
        ["\xF3\xB1\xB9\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x6C"],
        ["\xF3\xB1\xB9\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x50"],
        ["\xF3\xB1\xB9\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x7D"],
        ["\xF3\xB1\xB9\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x4D"],
        ["\xF3\xB1\xB9\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x5D"],
        ["\xF3\xB1\xB9\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x5C"],
        ["\xF3\xB1\xB9\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x4E"],
        ["\xF3\xB1\xB9\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x6B"],
        ["\xF3\xB1\xB9\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x60"],
        ["\xF3\xB1\xB9\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x4B"],
        ["\xF3\xB1\xB9\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x61"],
        ["\xF3\xB1\xB9\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF0"],
        ["\xF3\xB1\xB9\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF1"],
        ["\xF3\xB1\xB9\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF2"],
        ["\xF3\xB1\xB9\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF3"],
        ["\xF3\xB1\xB9\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],
        ["\xF3\xB1\xB9\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF5"],
        ["\xF3\xB1\xB9\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],
        ["\xF3\xB1\xB9\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF7"],
        ["\xF3\xB1\xB9\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF8"],
        ["\xF3\xB1\xB9\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xF9"],
        ["\xF3\xB1\xB9\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x7A"],
        ["\xF3\xB1\xB9\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x5E"],
        ["\xF3\xB1\xB9\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x4C"],
        ["\xF3\xB1\xB9\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x7E"],
        ["\xF3\xB1\xB9\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x6E"],
        ["\xF3\xB1\xB9\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x6F"],
        ["\xF3\xB1\xB9\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x7C"],
        ["\xF3\xB1\xBA\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC1"],
        ["\xF3\xB1\xBA\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC2"],
        ["\xF3\xB1\xBA\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC3"],
        ["\xF3\xB1\xBA\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC4"],
        ["\xF3\xB1\xBA\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC5"],
        ["\xF3\xB1\xBA\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC6"],
        ["\xF3\xB1\xBA\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC7"],
        ["\xF3\xB1\xBA\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC8"],
        ["\xF3\xB1\xBA\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC9"],
        ["\xF3\xB1\xBA\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD1"],
        ["\xF3\xB1\xBA\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD2"],
        ["\xF3\xB1\xBA\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD3"],
        ["\xF3\xB1\xBA\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD4"],
        ["\xF3\xB1\xBA\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD5"],
        ["\xF3\xB1\xBA\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD6"],
        ["\xF3\xB1\xBA\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD7"],
        ["\xF3\xB1\xBA\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD8"],
        ["\xF3\xB1\xBA\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD9"],
        ["\xF3\xB1\xBA\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],
        ["\xF3\xB1\xBA\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],
        ["\xF3\xB1\xBA\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],
        ["\xF3\xB1\xBA\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],
        ["\xF3\xB1\xBA\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],
        ["\xF3\xB1\xBA\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],
        ["\xF3\xB1\xBA\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE8"],
        ["\xF3\xB1\xBA\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],
        ["\xF3\xB1\xBA\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x4A"],
        ["\xF3\xB1\xBA\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x5B"],
        ["\xF3\xB1\xBA\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x5A"],
        ["\xF3\xB1\xBA\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x5F"],
        ["\xF3\xB1\xBA\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x6D"],
        ["\xF3\xB1\xBA\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x79"],
        ["\xF3\xB1\xBA\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x57"],
        ["\xF3\xB1\xBA\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x59"],
        ["\xF3\xB1\xBA\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x62"],
        ["\xF3\xB1\xBA\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x63"],
        ["\xF3\xB1\xBA\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x64"],
        ["\xF3\xB1\xBA\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x65"],
        ["\xF3\xB1\xBA\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x66"],
        ["\xF3\xB1\xBA\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x67"],
        ["\xF3\xB1\xBA\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x68"],
        ["\xF3\xB1\xBA\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x69"],
        ["\xF3\xB1\xBA\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x70"],
        ["\xF3\xB1\xBA\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x71"],
        ["\xF3\xB1\xBA\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x72"],
        ["\xF3\xB1\xBA\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x73"],
        ["\xF3\xB1\xBA\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x74"],
        ["\xF3\xB1\xBA\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x75"],
        ["\xF3\xB1\xBA\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x76"],
        ["\xF3\xB1\xBA\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x77"],
        ["\xF3\xB1\xBA\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x78"],
        ["\xF3\xB1\xBA\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x80"],
        ["\xF3\xB1\xBA\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x8B"],
        ["\xF3\xB1\xBA\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x9B"],
        ["\xF3\xB1\xBA\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x9C"],
        ["\xF3\xB1\xBA\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA0"],
        ["\xF3\xB1\xBA\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xAB"],
        ["\xF3\xB1\xBA\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xB0"],
        ["\xF3\xB1\xBA\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xC0"],
        ["\xF3\xB1\xBA\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\x6A"],
        ["\xF3\xB1\xBA\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xD0"],
        ["\xF3\xB1\xBA\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x76\xA1"],
        ["\xF3\xB1\xBA\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x4F"],
        ["\xF3\xB1\xBA\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x7F"],
        ["\xF3\xB1\xBB\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x7B"],
        ["\xF3\xB1\xBB\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE0"],
        ["\xF3\xB1\xBB\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x6C"],
        ["\xF3\xB1\xBB\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x50"],
        ["\xF3\xB1\xBB\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x7D"],
        ["\xF3\xB1\xBB\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x4D"],
        ["\xF3\xB1\xBB\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x5D"],
        ["\xF3\xB1\xBB\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x5C"],
        ["\xF3\xB1\xBB\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x4E"],
        ["\xF3\xB1\xBB\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x6B"],
        ["\xF3\xB1\xBB\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x60"],
        ["\xF3\xB1\xBB\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x4B"],
        ["\xF3\xB1\xBB\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x61"],
        ["\xF3\xB1\xBB\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF0"],
        ["\xF3\xB1\xBB\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF1"],
        ["\xF3\xB1\xBB\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF2"],
        ["\xF3\xB1\xBB\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF3"],
        ["\xF3\xB1\xBB\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF4"],
        ["\xF3\xB1\xBB\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF5"],
        ["\xF3\xB1\xBB\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF6"],
        ["\xF3\xB1\xBB\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF7"],
        ["\xF3\xB1\xBB\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF8"],
        ["\xF3\xB1\xBB\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xF9"],
        ["\xF3\xB1\xBB\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x7A"],
        ["\xF3\xB1\xBB\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x5E"],
        ["\xF3\xB1\xBB\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x4C"],
        ["\xF3\xB1\xBB\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x7E"],
        ["\xF3\xB1\xBB\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x6E"],
        ["\xF3\xB1\xBB\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x6F"],
        ["\xF3\xB1\xBB\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x7C"],
        ["\xF3\xB1\xBB\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC1"],
        ["\xF3\xB1\xBB\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC2"],
        ["\xF3\xB1\xBB\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC3"],
        ["\xF3\xB1\xBB\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC4"],
        ["\xF3\xB1\xBB\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC5"],
        ["\xF3\xB1\xBB\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC6"],
        ["\xF3\xB1\xBB\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC7"],
        ["\xF3\xB1\xBB\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC8"],
        ["\xF3\xB1\xBB\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC9"],
        ["\xF3\xB1\xBB\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD1"],
        ["\xF3\xB1\xBB\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD2"],
        ["\xF3\xB1\xBB\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD3"],
        ["\xF3\xB1\xBB\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],
        ["\xF3\xB1\xBB\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD5"],
        ["\xF3\xB1\xBB\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD6"],
        ["\xF3\xB1\xBB\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD7"],
        ["\xF3\xB1\xBB\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD8"],
        ["\xF3\xB1\xBB\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD9"],
        ["\xF3\xB1\xBB\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE2"],
        ["\xF3\xB1\xBB\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE3"],
        ["\xF3\xB1\xBB\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE4"],
        ["\xF3\xB1\xBB\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE5"],
        ["\xF3\xB1\xBB\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE6"],
        ["\xF3\xB1\xBB\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE7"],
        ["\xF3\xB1\xBB\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE8"],
        ["\xF3\xB1\xBB\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xE9"],
        ["\xF3\xB1\xBB\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x4A"],
        ["\xF3\xB1\xBB\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x5B"],
        ["\xF3\xB1\xBB\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x5A"],
        ["\xF3\xB1\xBB\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x5F"],
        ["\xF3\xB1\xBB\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x6D"],
        ["\xF3\xB1\xBB\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x79"],
        ["\xF3\xB1\xBB\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x57"],
        ["\xF3\xB1\xBB\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x59"],
        ["\xF3\xB1\xBC\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x62"],
        ["\xF3\xB1\xBC\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x63"],
        ["\xF3\xB1\xBC\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x64"],
        ["\xF3\xB1\xBC\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x65"],
        ["\xF3\xB1\xBC\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x66"],
        ["\xF3\xB1\xBC\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x67"],
        ["\xF3\xB1\xBC\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x68"],
        ["\xF3\xB1\xBC\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x69"],
        ["\xF3\xB1\xBC\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x70"],
        ["\xF3\xB1\xBC\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x71"],
        ["\xF3\xB1\xBC\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x72"],
        ["\xF3\xB1\xBC\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x73"],
        ["\xF3\xB1\xBC\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x74"],
        ["\xF3\xB1\xBC\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x75"],
        ["\xF3\xB1\xBC\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x76"],
        ["\xF3\xB1\xBC\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x77"],
        ["\xF3\xB1\xBC\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x78"],
        ["\xF3\xB1\xBC\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF2\x5D"],
        ["\xF3\xB1\xBC\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x8B"],
        ["\xF3\xB1\xBC\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x9B"],
        ["\xF3\xB1\xBC\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x9C"],
        ["\xF3\xB1\xBC\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xA0"],
        ["\xF3\xB1\xBC\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xAB"],
        ["\xF3\xB1\xBC\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xB0"],
        ["\xF3\xB1\xBC\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xC0"],
        ["\xF3\xB1\xBC\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\x6A"],
        ["\xF3\xB1\xBC\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xD0"],
        ["\xF3\xB1\xBC\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x77\xA1"],
        ["\xF3\xB1\xBC\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x4F"],
        ["\xF3\xB1\xBC\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x7F"],
        ["\xF3\xB1\xBC\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x7B"],
        ["\xF3\xB1\xBC\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE0"],
        ["\xF3\xB1\xBC\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x6C"],
        ["\xF3\xB1\xBC\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x50"],
        ["\xF3\xB1\xBC\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x7D"],
        ["\xF3\xB1\xBC\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x4D"],
        ["\xF3\xB1\xBC\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x5D"],
        ["\xF3\xB1\xBC\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x5C"],
        ["\xF3\xB1\xBC\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x4E"],
        ["\xF3\xB1\xBC\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x6B"],
        ["\xF3\xB1\xBC\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x60"],
        ["\xF3\xB1\xBC\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x4B"],
        ["\xF3\xB1\xBC\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x61"],
        ["\xF3\xB1\xBC\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF0"],
        ["\xF3\xB1\xBC\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF1"],
        ["\xF3\xB1\xBC\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF2"],
        ["\xF3\xB1\xBC\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF3"],
        ["\xF3\xB1\xBC\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF4"],
        ["\xF3\xB1\xBC\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF5"],
        ["\xF3\xB1\xBC\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF6"],
        ["\xF3\xB1\xBC\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF7"],
        ["\xF3\xB1\xBC\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF8"],
        ["\xF3\xB1\xBC\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xF9"],
        ["\xF3\xB1\xBC\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x7A"],
        ["\xF3\xB1\xBC\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x5E"],
        ["\xF3\xB1\xBC\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x4C"],
        ["\xF3\xB1\xBC\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x7E"],
        ["\xF3\xB1\xBC\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x6E"],
        ["\xF3\xB1\xBC\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x6F"],
        ["\xF3\xB1\xBC\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x7C"],
        ["\xF3\xB1\xBC\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC1"],
        ["\xF3\xB1\xBC\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC2"],
        ["\xF3\xB1\xBC\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC3"],
        ["\xF3\xB1\xBC\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC4"],
        ["\xF3\xB1\xBD\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC5"],
        ["\xF3\xB1\xBD\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC6"],
        ["\xF3\xB1\xBD\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC7"],
        ["\xF3\xB1\xBD\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC8"],
        ["\xF3\xB1\xBD\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC9"],
        ["\xF3\xB1\xBD\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD1"],
        ["\xF3\xB1\xBD\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD2"],
        ["\xF3\xB1\xBD\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD3"],
        ["\xF3\xB1\xBD\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD4"],
        ["\xF3\xB1\xBD\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD5"],
        ["\xF3\xB1\xBD\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD6"],
        ["\xF3\xB1\xBD\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD7"],
        ["\xF3\xB1\xBD\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD8"],
        ["\xF3\xB1\xBD\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD9"],
        ["\xF3\xB1\xBD\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE2"],
        ["\xF3\xB1\xBD\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE3"],
        ["\xF3\xB1\xBD\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE4"],
        ["\xF3\xB1\xBD\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE5"],
        ["\xF3\xB1\xBD\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE6"],
        ["\xF3\xB1\xBD\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE7"],
        ["\xF3\xB1\xBD\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE8"],
        ["\xF3\xB1\xBD\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xE9"],
        ["\xF3\xB1\xBD\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x4A"],
        ["\xF3\xB1\xBD\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x5B"],
        ["\xF3\xB1\xBD\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x5A"],
        ["\xF3\xB1\xBD\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x5F"],
        ["\xF3\xB1\xBD\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x6D"],
        ["\xF3\xB1\xBD\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x79"],
        ["\xF3\xB1\xBD\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x57"],
        ["\xF3\xB1\xBD\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x59"],
        ["\xF3\xB1\xBD\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x62"],
        ["\xF3\xB1\xBD\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x63"],
        ["\xF3\xB1\xBD\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x64"],
        ["\xF3\xB1\xBD\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x65"],
        ["\xF3\xB1\xBD\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x66"],
        ["\xF3\xB1\xBD\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x67"],
        ["\xF3\xB1\xBD\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x68"],
        ["\xF3\xB1\xBD\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x69"],
        ["\xF3\xB1\xBD\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x70"],
        ["\xF3\xB1\xBD\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x71"],
        ["\xF3\xB1\xBD\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x72"],
        ["\xF3\xB1\xBD\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x73"],
        ["\xF3\xB1\xBD\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x74"],
        ["\xF3\xB1\xBD\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x75"],
        ["\xF3\xB1\xBD\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x76"],
        ["\xF3\xB1\xBD\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x77"],
        ["\xF3\xB1\xBD\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x78"],
        ["\xF3\xB1\xBD\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x80"],
        ["\xF3\xB1\xBD\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x8B"],
        ["\xF3\xB1\xBD\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x9B"],
        ["\xF3\xB1\xBD\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x9C"],
        ["\xF3\xB1\xBD\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xA0"],
        ["\xF3\xB1\xBD\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xAB"],
        ["\xF3\xB1\xBD\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xB0"],
        ["\xF3\xB1\xBD\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xC0"],
        ["\xF3\xB1\xBD\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\x6A"],
        ["\xF3\xB1\xBD\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xD0"],
        ["\xF3\xB1\xBD\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x78\xA1"],
        ["\xF3\xB1\xBD\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF6\xC6"],
        ["\xF3\xB1\xBD\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD2\x69"],
        ["\xF3\xB1\xBD\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xF3\xB1\xBD\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x79\x9B"],
        ["\xF3\xB1\xBD\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\xF3\xB1\xBD\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\xF3\xB2\xAB\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x8E"],
        ["\xF3\xB2\xAB\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x8F"],
        ["\xF3\xB2\xAB\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x90"],
        ["\xF3\xB2\xAB\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x91"],
        ["\xF3\xB2\xAB\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x92"],
        ["\xF3\xB2\xAB\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x93"],
        ["\xF3\xB2\xAB\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x94"],
        ["\xF3\xB2\xAB\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x95"],
        ["\xF3\xB2\xAB\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x96"],
        ["\xF3\xB2\xAB\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x97"],
        ["\xF3\xB2\xAB\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xFB"],
        ["\xF3\xB2\xAB\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xEF"],
        ["\xF3\xB2\xAB\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xFA"],
        ["\xF3\xB2\xAB\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\xF3\xB2\xAB\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x49"],
        ["\xF3\xB2\xAB\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x89"],
        ["\xF3\xB2\xAB\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],
        ["\xF3\xB2\xAB\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\xF3\xB2\xAB\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\xF3\xB2\xAB\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFE"],
        ["\xF3\xB2\xAB\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\xF3\xB2\xAC\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\xF3\xB2\xAC\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x86"],
        ["\xF3\xB2\xAC\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\xF3\xB2\xAC\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\xF3\xB2\xAC\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\xF3\xB2\xAC\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\xF3\xB2\xAC\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\xF3\xB2\xAC\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\xF3\xB2\xAC\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\xF3\xB2\xAC\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\xF3\xB2\xAC\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\xF3\xB2\xAC\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\xF3\xB2\xAC\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\xF3\xB2\xAC\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\xF3\xB2\xAC\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\xF3\xB2\xAC\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\xF3\xB2\xAC\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\xF3\xB2\xAC\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\xF3\xB2\xAC\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\xF3\xB2\xAC\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\xF3\xB2\xAC\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\xF3\xB2\xAC\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\xF3\xB2\xAC\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\xF3\xB2\xAC\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x97"],
        ["\xF3\xB2\xAC\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\xF3\xB2\xAC\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\xF3\xB2\xAC\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\xF3\xB2\xAC\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xDC"],
        ["\xF3\xB2\xAC\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xED"],
        ["\xF3\xB2\xAC\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\xF3\xB2\xAC\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x48"],
        ["\xF3\xB2\xAC\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\xF3\xB2\xAC\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x92"],
        ["\xF3\xB2\xAC\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x94"],
        ["\xF3\xB2\xAC\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\xF3\xB2\xAC\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\xF3\xB2\xAC\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCA"],
        ["\xF3\xB2\xAC\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCE"],
        ["\xF3\xB2\xAC\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xDB"],
        ["\xF3\xB2\xAC\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x47"],
        ["\xF3\xB2\xAC\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x54"],
        ["\xF3\xB2\xAC\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x81"],
        ["\xF3\xB2\xAC\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8D"],
        ["\xF3\xB2\xAC\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8F"],
        ["\xF3\xB2\xAC\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA8"],
        ["\xF3\xB2\xAC\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA4"],
        ["\xF3\xB2\xAC\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBC"],
        ["\xF3\xB2\xAC\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB2"],
        ["\xF3\xB2\xAC\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDA"],
        ["\xF3\xB2\xAC\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAC"],
        ["\xF3\xB2\xAC\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xBE"],
        ["\xF3\xB2\xAC\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB5"],
        ["\xF3\xB2\xAC\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB7"],
        ["\xF3\xB2\xAC\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB8"],
        ["\xF3\xB2\xAC\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB9"],
        ["\xF3\xB2\xAC\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xF3\xB2\xAC\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\xF3\xB2\xAC\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\xF3\xB2\xAC\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\xF3\xB2\xAC\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x9E"],
        ["\xF3\xB2\xAC\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA4"],
        ["\xF3\xB2\xAC\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA3"],
        ["\xF3\xB2\xAC\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xA8"],
        ["\xF3\xB2\xAC\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBB"],
        ["\xF3\xB2\xAD\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB6"],
        ["\xF3\xB2\xAD\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x84"],
        ["\xF3\xB2\xAD\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9D"],
        ["\xF3\xB2\xAD\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\xF3\xB2\xAD\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\xF3\xB2\xAD\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\xF3\xB2\xAD\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\xF3\xB2\xAD\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\xF3\xB2\xAD\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\xF3\xB2\xAD\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\xF3\xB2\xAD\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\xF3\xB2\xAD\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\xF3\xB2\xAD\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\xF3\xB2\xAD\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\xF3\xB2\xAD\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\xF3\xB2\xAD\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\xF3\xB2\xAD\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\xF3\xB2\xAD\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\xF3\xB2\xAD\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\xF3\xB2\xAD\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\xF3\xB2\xAD\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\xF3\xB2\xAD\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\xF3\xB2\xAD\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xFE"],
        ["\xF3\xB2\xAD\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\xF3\xB2\xAD\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\xF3\xB2\xAD\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB7"],
        ["\xF3\xB2\xAD\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\xF3\xB2\xAD\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\xF3\xB2\xAD\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\xF3\xB2\xAD\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\xF3\xB2\xAD\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\xF3\xB2\xAD\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\xF3\xB2\xAD\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\xF3\xB2\xAD\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x48"],
        ["\xF3\xB2\xAD\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\xF3\xB2\xAD\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\xF3\xB2\xAD\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\xF3\xB2\xAD\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\xF3\xB2\xAD\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\xF3\xB2\xAD\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\xF3\xB2\xAD\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\xF3\xB2\xAD\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\xF3\xB2\xAD\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\xF3\xB2\xAD\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\xF7"],
        ["\xF3\xB2\xAD\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\xF3\xB2\xAD\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\xF3\xB2\xAD\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\xF3\xB2\xAD\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\xF3\xB2\xAD\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\xF3\xB2\xAD\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\xF3\xB2\xAD\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\xF3\xB2\xAD\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\xF3\xB2\xAD\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\xF3\xB2\xAD\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\xF3\xB2\xAD\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\xF3\xB2\xAD\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\xF3\xB2\xAD\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\xF3\xB2\xAD\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\xF3\xB2\xAD\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\xF3\xB2\xAD\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\xF3\xB2\xAD\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\xF3\xB2\xAD\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\xF3\xB2\xAD\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\xF3\xB2\xAD\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\xF3\xB2\xAE\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\xF3\xB2\xAE\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\xF3\xB2\xAE\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\xF3\xB2\xAE\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\xF3\xB2\xAE\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\xF3\xB2\xAE\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\xF3\xB2\xAE\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\xF3\xB2\xAE\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\xF3\xB2\xAE\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\xF3\xB2\xAE\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\xF3\xB2\xAE\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\xF3\xB2\xAE\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\xF3\xB2\xAE\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\xF3\xB2\xAE\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\xF3\xB2\xAE\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\xF3\xB2\xAE\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\xF3\xB2\xAE\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\xF3\xB2\xAE\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\xF3\xB2\xAE\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\xF3\xB2\xAE\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\xF3\xB2\xAE\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\xF3\xB2\xAE\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\xF3\xB2\xAE\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\xF3\xB2\xAE\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\xF3\xB2\xAE\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\xF3\xB2\xAE\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\xF3\xB2\xAE\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\xF3\xB2\xAE\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\xF3\xB2\xAE\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\xF3\xB2\xAE\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\xF3\xB2\xAE\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\xF3\xB2\xAE\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\xF3\xB2\xAE\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\xF3\xB2\xAE\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\xF3\xB2\xAE\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\xF3\xB2\xAE\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\xF3\xB2\xAE\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\xF3\xB2\xAE\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\xF3\xB2\xAE\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\xF3\xB2\xAE\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\xF3\xB2\xAE\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\xF3\xB2\xAE\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\xF3\xB2\xAE\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\xF3\xB2\xAE\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\xF3\xB2\xAE\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\xF3\xB2\xAE\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\xF3\xB2\xAE\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\xF3\xB2\xAE\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\xF3\xB2\xAE\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\xF3\xB2\xAE\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\xF3\xB2\xAE\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\xF3\xB2\xAE\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\xF3\xB2\xAE\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\xF3\xB2\xAE\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\xF3\xB2\xAE\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\xF3\xB2\xAE\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\xF3\xB2\xAE\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\xF3\xB2\xAE\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\xF3\xB2\xAE\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\xF3\xB2\xAE\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\xF3\xB2\xAE\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\xF3\xB2\xAE\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\xF3\xB2\xAE\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\xF3\xB2\xAE\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\xF3\xB2\xAF\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\xF3\xB2\xAF\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\xF3\xB2\xAF\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\xF3\xB2\xAF\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\xF3\xB2\xAF\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\xF3\xB2\xAF\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\xF3\xB2\xAF\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\xF3\xB2\xAF\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\xF3\xB2\xAF\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\xF3\xB2\xAF\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\xF3\xB2\xAF\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\xF3\xB2\xAF\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\xF3\xB2\xAF\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\xF3\xB2\xAF\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\xF3\xB2\xAF\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\xF3\xB2\xAF\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x98"],
        ["\xF3\xB2\xAF\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\xF3\xB2\xAF\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\xF3\xB2\xAF\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\xF3\xB2\xAF\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\xF3\xB2\xAF\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\xF3\xB2\xAF\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\xF3\xB2\xAF\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\xF3\xB2\xAF\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\xF3\xB2\xAF\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\xF3\xB2\xAF\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\xF3\xB2\xAF\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\xF3\xB2\xAF\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\xF3\xB2\xAF\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\xF3\xB2\xAF\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\xF3\xB2\xAF\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\xF3\xB2\xAF\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\xF3\xB2\xAF\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\xF3\xB2\xAF\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\xF3\xB2\xAF\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\xF3\xB2\xAF\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\xF3\xB2\xAF\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\xF3\xB2\xAF\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\xF3\xB2\xAF\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\xF3\xB2\xAF\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\xF3\xB2\xAF\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\xF3\xB2\xAF\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\xF3\xB2\xAF\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\xF3\xB2\xAF\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\xF3\xB2\xAF\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\xF3\xB2\xAF\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\xF3\xB2\xAF\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\xF3\xB2\xAF\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\xF3\xB2\xAF\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\xF3\xB2\xAF\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\xF3\xB2\xAF\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\xF3\xB2\xAF\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\xF3\xB2\xAF\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFD"],
        ["\xF3\xB2\xAF\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x49"],
        ["\xF3\xB2\xAF\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x93"],
        ["\xF3\xB2\xAF\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],
        ["\xF3\xB2\xAF\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xB4"],
        ["\xF3\xB2\xAF\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x44"],
        ["\xF3\xB2\xAF\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x9D"],
        ["\xF3\xB2\xAF\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xBA"],
        ["\xF3\xB2\xAF\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xBF"],
        ["\xF3\xB2\xAF\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],
        ["\xF3\xB2\xAF\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],
        ["\xF3\xB2\xAF\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],
        ["\xF3\xB2\xB0\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],
        ["\xF3\xB2\xB0\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],
        ["\xF3\xB2\xB0\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],
        ["\xF3\xB2\xB0\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xFE"],
        ["\xF3\xB2\xB0\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x8D"],
        ["\xF3\xB2\xB0\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x8C"],
        ["\xF3\xB2\xB0\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x93"],
        ["\xF3\xB2\xB0\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x96"],
        ["\xF3\xB2\xB0\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x98"],
        ["\xF3\xB2\xB0\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],
        ["\xF3\xB2\xB0\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xFD"],
        ["\xF3\xB2\xB0\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\x93"],
        ["\xF3\xB2\xB0\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],
        ["\xF3\xB2\xB0\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],
        ["\xF3\xB2\xB0\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],
        ["\xF3\xB2\xB0\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],
        ["\xF3\xB2\xB0\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],
        ["\xF3\xB2\xB0\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x88"],
        ["\xF3\xB2\xB0\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x87"],
        ["\xF3\xB2\xB0\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x89"],
        ["\xF3\xB2\xB0\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x8C"],
        ["\xF3\xB2\xB0\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x92"],
        ["\xF3\xB2\xB0\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x8F"],
        ["\xF3\xB2\xB0\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x8E"],
        ["\xF3\xB2\xB0\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x97"],
        ["\xF3\xB2\xB0\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x95"],
        ["\xF3\xB2\xB0\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x9E"],
        ["\xF3\xB2\xB0\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xBC"],
        ["\xF3\xB2\xB0\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],
        ["\xF3\xB2\xB0\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],
        ["\xF3\xB2\xB0\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xBD"],
        ["\xF3\xB2\xB0\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xBB"],
        ["\xF3\xB2\xB0\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],
        ["\xF3\xB2\xB0\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],
        ["\xF3\xB2\xB0\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],
        ["\xF3\xB2\xB0\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xDA"],
        ["\xF3\xB2\xB0\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xDB"],
        ["\xF3\xB2\xB0\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],
        ["\xF3\xB2\xB0\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xEF"],
        ["\xF3\xB2\xB0\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xDC"],
        ["\xF3\xB2\xB0\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xED"],
        ["\xF3\xB2\xB0\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x44"],
        ["\xF3\xB2\xB0\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x46"],
        ["\xF3\xB2\xB0\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x43"],
        ["\xF3\xB2\xB0\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xFE"],
        ["\xF3\xB2\xB0\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xEA"],
        ["\xF3\xB2\xB0\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x84"],
        ["\xF3\xB2\xB0\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x49"],
        ["\xF3\xB2\xB0\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x56"],
        ["\xF3\xB2\xB0\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x87"],
        ["\xF3\xB2\xB0\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x52"],
        ["\xF3\xB2\xB0\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x85"],
        ["\xF3\xB2\xB0\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x83"],
        ["\xF3\xB2\xB0\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x82"],
        ["\xF3\xB2\xB0\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x8C"],
        ["\xF3\xB2\xB0\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x94"],
        ["\xF3\xB2\xB0\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],
        ["\xF3\xB2\xB0\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],
        ["\xF3\xB2\xB0\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],
        ["\xF3\xB2\xB0\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],
        ["\xF3\xB2\xB0\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],
        ["\xF3\xB2\xB0\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],
        ["\xF3\xB2\xB0\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],
        ["\xF3\xB2\xB0\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xFC"],
        ["\xF3\xB2\xB1\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x89"],
        ["\xF3\xB2\xB1\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x91"],
        ["\xF3\xB2\xB1\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x92"],
        ["\xF3\xB2\xB1\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x95"],
        ["\xF3\xB2\xB1\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xA9"],
        ["\xF3\xB2\xB1\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xAA"],
        ["\xF3\xB2\xB1\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xAD"],
        ["\xF3\xB2\xB1\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xAF"],
        ["\xF3\xB2\xB1\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xBB"],
        ["\xF3\xB2\xB1\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xBC"],
        ["\xF3\xB2\xB1\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xBE"],
        ["\xF3\xB2\xB1\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x41"],
        ["\xF3\xB2\xB1\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x44"],
        ["\xF3\xB2\xB1\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x83"],
        ["\xF3\xB2\xB1\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x84"],
        ["\xF3\xB2\xB1\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x87"],
        ["\xF3\xB2\xB1\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x88"],
        ["\xF3\xB2\xB1\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x94"],
        ["\xF3\xB2\xB1\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xAD"],
        ["\xF3\xB2\xB1\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xBC"],
        ["\xF3\xB2\xB1\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xBE"],
        ["\xF3\xB2\xB1\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xDC"],
        ["\xF3\xB2\xB1\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xDB"],
        ["\xF3\xB2\xB1\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xDF"],
        ["\xF3\xB2\xB1\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xFB"],
        ["\xF3\xB2\xB1\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x48"],
        ["\xF3\xB2\xB1\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x56"],
        ["\xF3\xB2\xB1\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x9A"],
        ["\xF3\xB2\xB1\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xA9"],
        ["\xF3\xB2\xB1\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xBA"],
        ["\xF3\xB2\xB1\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xBC"],
        ["\xF3\xB2\xB1\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xCD"],
        ["\xF3\xB2\xB6\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xCB"],
        ["\xF3\xB2\xB6\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xCC"],
        ["\xF3\xB2\xB6\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xCD"],
        ["\xF3\xB2\xB6\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB2"],
        ["\xF3\xB2\xB6\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xAD"],
        ["\xF3\xB2\xB6\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB6"],
        ["\xF3\xB2\xB6\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xB5"],
        ["\xF3\xB2\xB6\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xBE"],
        ["\xF3\xB2\xB7\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xCE"],
        ["\xF3\xB2\xB7\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xDA"],
        ["\xF3\xB2\xB7\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xCD"],
        ["\xF3\xB2\xB7\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"],
        ["\xF3\xB2\xB7\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB3"],
        ["\xF3\xB2\xB7\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB6"],
        ["\xF3\xB2\xB7\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB4"],
        ["\xF3\xB2\xB7\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xB5"],
        ["\xF3\xB2\xB7\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xBD"],
        ["\xF3\xB2\xB8\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xAC"],
        ["\xF3\xB2\xB8\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\xED"],
        ["\xF3\xB2\xBB\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xEB"],
        ["\xF3\xB2\xBC\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xDF"],
        ["\xF3\xB2\xBC\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xEA"],
        ["\xF3\xB2\xBC\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\xDE"],
        ["\xF3\xB2\xBE\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xFA"],
        ["\xF3\xB2\xBE\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xFB"],
        ["\xF3\xB3\x80\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\xF3\xB3\x80\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\xF3\xB3\x80\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\xF3\xB3\x80\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\xF3\xB3\x80\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\xF3\xB3\x80\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\xF3\xB3\x80\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\xF3\xB3\x80\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x8E"],
        ["\xF3\xB3\x80\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\xF3\xB3\x80\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\xF3\xB3\x80\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\xF3\xB3\x80\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\xF3\xB3\x80\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\xF3\xB3\x80\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\xF3\xB3\x80\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\xF3\xB3\x80\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x81"],
        ["\xF3\xB3\x80\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x83"],
        ["\xF3\xB3\x80\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x82"],
        ["\xF3\xB3\x80\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x84"],
        ["\xF3\xB3\x80\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x85"],
        ["\xF3\xB3\x80\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x86"],
        ["\xF3\xB3\x80\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x88"],
        ["\xF3\xB3\x80\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x87"],
        ["\xF3\xB3\x80\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x89"],
        ["\xF3\xB3\x81\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x8A"],
        ["\xF3\xB3\x81\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x8C"],
        ["\xF3\xB3\x81\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x8D"],
        ["\xF3\xB3\x81\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x8F"],
        ["\xF3\xB3\x81\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x90"],
        ["\xF3\xB3\x81\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x91"],
        ["\xF3\xB3\x81\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x92"],
        ["\xF3\xB3\x81\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x96"],
        ["\xF3\xB3\x81\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x95"],
        ["\xF3\xB3\x81\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x97"],
        ["\xF3\xB3\x81\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x98"],
        ["\xF3\xB3\x81\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x99"],
        ["\xF3\xB3\x83\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x93"],
        ["\xF3\xB3\x83\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\xF3\xB3\x84\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xDB"],
        ["\xF3\xB3\x84\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xDC"],
        ["\xF3\xB3\x84\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xDD"],
        ["\xF3\xB3\x84\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xDE"],
        ["\xF3\xB3\x84\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xDF"],
        ["\xF3\xB3\x84\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xEA"],
        ["\xF3\xB3\x84\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xEB"],
        ["\xF3\xB3\x84\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xEC"],
        ["\xF3\xB3\x84\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xED"],
        ["\xF3\xB3\x84\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x43\xEE"],
        ["\xF3\xB3\x84\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xBB"],
        ["\xF3\xB3\x84\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xBC"],
        ["\xF3\xB3\x84\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xCA"],
        ["\xF3\xB3\x84\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xCB"],
        ["\xF3\xB3\x84\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xCC"],
        ["\xF3\xB3\x84\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xCD"],
        ["\xF3\xB3\x84\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xCE"],
        ["\xF3\xB3\x84\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xCF"],
        ["\xF3\xB3\x85\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xDA"],
        ["\xF3\xB3\x85\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xDB"],
        ["\xF3\xB3\x85\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xDC"],
        ["\xF3\xB3\x85\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xDD"],
        ["\xF3\xB3\x85\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xDE"],
        ["\xF3\xB3\x85\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x8C"],
        ["\xF3\xB3\x85\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x8D"],
        ["\xF3\xB3\x85\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x8E"],
        ["\xF3\xB3\x85\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x8F"],
        ["\xF3\xB3\x85\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x90"],
        ["\xF3\xB3\x85\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x91"],
        ["\xF3\xB3\x85\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x92"],
        ["\xF3\xB3\x85\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x93"],
        ["\xF3\xB3\x85\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x94"],
        ["\xF3\xB3\x85\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x95"],
        ["\xF3\xB3\x85\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x96"],
        ["\xF3\xB3\x85\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x97"],
        ["\xF3\xB3\x85\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x98"],
        ["\xF3\xB3\x85\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x99"],
        ["\xF3\xB3\x85\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x44\x9A"],
        ["\xF3\xB3\x85\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xFD"],
        ["\xF3\xB3\x85\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xDF"],
        ["\xF3\xB3\x85\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xFE"],
        ["\xF3\xB3\x85\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x41"],
        ["\xF3\xB3\x85\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x42"],
        ["\xF3\xB3\x85\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x43"],
        ["\xF3\xB3\x85\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x44"],
        ["\xF3\xB3\x85\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x45"],
        ["\xF3\xB3\x85\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x46"],
        ["\xF3\xB3\x85\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\x47"],
        ["\xF3\xB3\x85\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xFA"],
        ["\xF3\xB3\x85\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEF"],
        ["\xF3\xB3\x85\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEA"],
        ["\xF3\xB3\x85\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEB"],
        ["\xF3\xB3\x85\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEC"],
        ["\xF3\xB3\x85\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xED"],
        ["\xF3\xB3\x85\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x41\xEE"],
        ["\xF3\xB3\x86\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xA6"],
        ["\xF3\xB3\x86\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x42\xA7"],
        ["\xF3\xB3\x87\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\xF3\xB3\x87\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\xF3\xB3\x87\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\xF3\xB3\x87\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\xF3\xB3\x87\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\xF3\xB3\x87\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\xF3\xB3\x87\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\xF3\xB3\x87\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\xF3\xB3\x87\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\xF3\xB3\x87\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\xF3\xB3\x87\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xFE"],
        ["\xF3\xB3\x87\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\xF3\xB3\x87\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\xF3\xB3\x87\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\xF3\xB3\x87\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\xF3\xB3\x87\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\xF3\xB3\x87\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\xF3\xB3\x87\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xBA"],
        ["\xF3\xB3\x88\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\xF3\xB3\x88\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\xF3\xB3\x88\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\xF3\xB3\x88\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\xF3\xB3\x88\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\xF3\xB3\x88\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\xF3\xB3\x88\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\xF3\xB3\x88\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\xF3\xB3\x88\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\xF3\xB3\x88\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x43"],
        ["\xF3\xB3\x88\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x44"],
        ["\xF3\xB3\x88\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x58"],
        ["\xF3\xB3\x88\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9D"],
        ["\xF3\xB3\x88\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x9F"],
        ["\xF3\xB3\x88\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA7"],
        ["\xF3\xB3\x88\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBA"],
        ["\xF3\xB3\x88\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAF"],
        ["\xF3\xB3\x88\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB5"],
        ["\xF3\xB3\x88\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCC"],
        ["\xF3\xB3\x89\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDC"],
        ["\xF3\xB3\x89\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xFA"],
        ["\xF3\xB3\x89\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x45"],
        ["\xF3\xB3\x89\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x42"],
        ["\xF3\xB3\x89\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x49"],
        ["\xF3\xB3\x89\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x54"],
        ["\xF3\xB3\x89\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x83"],
        ["\xF3\xB3\x89\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x82"],
        ["\xF3\xB3\x89\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x84"],
        ["\xF3\xB3\x89\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8C"],
        ["\xF3\xB3\x89\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8E"],
        ["\xF3\xB3\x89\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x97"],
        ["\xF3\xB3\x89\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x9F"],
        ["\xF3\xB3\x89\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA4"],
        ["\xF3\xB3\x89\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA5"],
        ["\xF3\xB3\x89\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCE"],
        ["\xF3\xB3\x89\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCD"],
        ["\xF3\xB3\x89\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\xF3\xB3\x89\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCF"],
        ["\xF3\xB3\x89\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],
        ["\xF3\xB3\x89\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xFA"],
        ["\xF3\xB3\x89\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xFE"],
        ["\xF3\xB3\x89\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\xF3\xB3\x89\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\xF3\xB3\x89\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\xF3\xB3\x89\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\xF3\xB3\x89\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\xF3\xB3\x89\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\xF3\xB3\x89\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\xF3\xB3\x89\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAD"],
        ["\xF3\xB3\x89\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBE"],
        ["\xF3\xB3\x89\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBC"],
        ["\xF3\xB3\x8A\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB7"],
        ["\xF3\xB3\x8A\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB5"],
        ["\xF3\xB3\x8A\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCD"],
        ["\xF3\xB3\x8A\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDB"],
        ["\xF3\xB3\x8A\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDA"],
        ["\xF3\xB3\x8A\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDD"],
        ["\xF3\xB3\x8A\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xFD"],
        ["\xF3\xB3\x8A\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xEE"],
        ["\xF3\xB3\x8A\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xFB"],
        ["\xF3\xB3\x8A\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x42"],
        ["\xF3\xB3\x8A\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x58"],
        ["\xF3\xB3\xB8\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x89"],
        ["\xF3\xB3\xB8\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x91"],
        ["\xF3\xB3\xB8\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\xF3\xB3\xB8\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\xF3\xB3\xB8\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xFE"],
        ["\xF3\xB3\xB8\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\xF3\xB3\xB8\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\xF3\xB3\xB9\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\xF3\xB3\xB9\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\xF3\xB3\xB9\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\xF3\xB4\x83\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xF3\xB4\xAE\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\xF3\xB4\xAE\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\xF3\xB4\xAE\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\xF3\xB4\xAE\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\xF3\xB4\xAE\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\xF3\xB4\xAE\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\xF3\xB4\xAE\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\xF3\xB4\xAE\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\xF3\xB4\xAE\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\xF3\xB4\xAE\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\xF3\xB4\xAE\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\xF3\xB4\xAE\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\xF3\xB4\xAE\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\xF3\xB4\xAE\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\x92"],
        ["\xF3\xB4\xAE\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\xF3\xB4\xAE\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\xF3\xB4\xAE\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\xF3\xB4\xAE\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\xF3\xB4\xAE\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\xF3\xB4\xAE\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\xF3\xB4\xAE\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\xF3\xB4\xAE\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\xF3\xB4\xAE\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\xF3\xB4\xAE\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\xF3\xB4\xAF\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\xF3\xB4\xAF\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\xF3\xB4\xAF\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\xF3\xB4\xAF\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\xF3\xB4\xAF\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\xF3\xB4\xAF\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\xF3\xB4\xAF\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\xF3\xB4\xAF\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\xF3\xB4\xAF\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\xF3\xB4\xAF\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\xF3\xB4\xAF\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\xF3\xB4\xAF\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\xF3\xB4\xAF\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\xF3\xB4\xAF\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\xF3\xB4\xAF\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\xF3\xB4\xAF\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\xF3\xB4\xAF\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\xF3\xB4\xAF\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\xF3\xB4\xAF\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\xF3\xB4\xAF\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\xF3\xB4\xAF\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\xF3\xB4\xAF\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\xF3\xB4\xAF\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\xF3\xB4\xAF\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\xF3\xB4\xAF\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\xF3\xB4\xAF\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\xF3\xB4\xB0\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\xF3\xB4\xB0\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\xF3\xB4\xB0\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\xF3\xB4\xB0\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\xF3\xB4\xB0\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\xF3\xB4\xB0\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\xF3\xB4\xB0\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\xF3\xB4\xB0\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\xF3\xB4\xB0\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\xF3\xB4\xB0\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\xF3\xB4\xB0\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\xF3\xB4\xB0\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\xF3\xB4\xB0\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\xF3\xB4\xB0\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\xF3\xB4\xB0\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\xF3\xB4\xB0\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\xF3\xB4\xB0\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\xF3\xB4\xB0\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\xF3\xB4\xB0\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\xF3\xB4\xB0\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\xF3\xB4\xB0\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\xF3\xB4\xB0\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\xF3\xB4\xB0\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\xF3\xB4\xB0\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\xF3\xB4\xB0\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\xF3\xB4\xB0\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\xF3\xB4\xB0\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\xF3\xB4\xB0\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\xF3\xB4\xB0\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\xF3\xB4\xB0\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\xF3\xB4\xB1\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\xF3\xB4\xB1\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\xF3\xB4\xB1\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\xF3\xB4\xB1\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\xF3\xB4\xB1\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\xF3\xB4\xB1\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\xF3\xB4\xB1\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\xF3\xB4\xB1\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\xF3\xB4\xB1\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\xF3\xB4\xB1\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\xF3\xB4\xB1\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\xF3\xB4\xB1\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\xF3\xB4\xB1\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\xF3\xB4\xB1\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\xF3\xB4\xB1\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\xF3\xB4\xB1\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\xF3\xB4\xB1\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\xF3\xB4\xB1\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\xF3\xB4\xB1\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\xF3\xB4\xB2\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\xF3\xB4\xB2\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\xF3\xB4\xB2\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\xF3\xB4\xB2\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\xF3\xB4\xB2\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\xF3\xB4\xB2\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\xF3\xB4\xB2\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\xF3\xB4\xB2\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\xF3\xB4\xB2\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\xF3\xB4\xB2\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\xF3\xB4\xB2\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\xF3\xB4\xB2\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\xF3\xB4\xB2\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\xF3\xB4\xB2\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\xF3\xB4\xB2\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\xF3\xB4\xB2\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\xF3\xB4\xB2\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\xF3\xB4\xB2\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\xF3\xB4\xB2\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\xF3\xB4\xB2\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\xF3\xB4\xB2\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\xF3\xB4\xB2\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\xF3\xB4\xB2\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\xF3\xB4\xB2\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\xF3\xB4\xB2\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\xF3\xB4\xB2\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\xF3\xB4\xB2\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\xF3\xB4\xB2\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\xF3\xB4\xB2\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\xF3\xB4\xB2\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\xF3\xB4\xB2\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\xF3\xB4\xB3\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\xF3\xB4\xB3\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\xF3\xB4\xB3\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\xF3\xB4\xB3\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFD"],
        ["\xF3\xB4\xB3\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\xF3\xB4\xB3\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\xF3\xB4\xB3\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\xF3\xB4\xB3\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\xF3\xB4\xB3\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\xF3\xB4\xB3\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\xF3\xB4\xB3\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\xF3\xB4\xB3\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\xF3\xB4\xB3\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\xF3\xB4\xB3\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\xF3\xB4\xB3\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\xF3\xB4\xB3\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\xF3\xB4\xB3\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\xF3\xB4\xB3\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\xF3\xB4\xB3\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\xF3\xB4\xB3\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\xF3\xB4\xB3\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\xF3\xB4\xB3\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\xF3\xB4\xB4\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\xF3\xB4\xB4\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\xF3\xB4\xB4\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\xF3\xB4\xB4\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\xF3\xB4\xB4\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\xF3\xB4\xB4\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\xF3\xB4\xB4\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\xF3\xB4\xB4\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\xF3\xB4\xB4\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\xF3\xB4\xB4\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\xF3\xB4\xB4\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\xF3\xB4\xB4\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\xF3\xB4\xB4\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\xF3\xB4\xB4\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\xF3\xB4\xB4\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\xF3\xB4\xB4\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\xF3\xB4\xB4\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\xF3\xB4\xB4\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\xF3\xB4\xB4\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\xF3\xB4\xB4\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\xF3\xB4\xB4\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\xF3\xB4\xB4\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\xF3\xB4\xB4\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\xF3\xB4\xB4\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\xF3\xB4\xB4\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\xF3\xB4\xB4\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\xF3\xB4\xB4\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\xF3\xB4\xB4\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\xF3\xB4\xB5\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\xF3\xB4\xB5\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\xF3\xB4\xB5\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\xF3\xB4\xB5\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\xF3\xB4\xB5\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\xF3\xB4\xB5\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\xF3\xB4\xB5\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\xF3\xB4\xB5\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\xF3\xB4\xB5\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\xF3\xB4\xB5\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\xF3\xB4\xB5\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\xF3\xB4\xB5\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\xF3\xB4\xB5\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\xF3\xB4\xB5\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\xF3\xB4\xB5\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\xF3\xB4\xB5\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\xF3\xB4\xB5\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\xF3\xB4\xB5\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\xF3\xB4\xB5\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\xF3\xB4\xB5\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\xF3\xB4\xB5\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\xF3\xB4\xB6\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x82"],
        ["\xF3\xB4\xB6\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x86"],
        ["\xF3\xB4\xB6\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\xF3\xB4\xB6\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\xF3\xB4\xB6\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8C"],
        ["\xF3\xB4\xB6\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x98"],
        ["\xF3\xB4\xB6\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\xF3\xB4\xB6\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\xF3\xB4\xB6\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\xF3\xB4\xB6\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\xF3\xB4\xB6\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\xF3\xB4\xB6\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xFE"],
        ["\xF3\xB4\xB6\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\xF3\xB4\xB6\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\xF3\xB4\xB6\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\xF3\xB4\xB6\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\xF3\xB4\xB6\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\xF3\xB4\xB6\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\xF3\xB4\xB6\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\xF3\xB4\xB6\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\xF3\xB4\xB6\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\xF3\xB4\xB6\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\xF3\xB4\xB6\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\xF3\xB4\xB6\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\xF3\xB4\xB6\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\xF3\xB4\xB6\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\xF3\xB4\xB6\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\xF3\xB4\xB6\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\xF3\xB4\xB6\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\xF3\xB4\xB6\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\xF3\xB4\xB6\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\xF3\xB4\xB6\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\xF3\xB4\xB6\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\xF3\xB4\xB6\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\xF3\xB4\xB7\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\xF3\xB4\xB7\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\xF3\xB4\xB7\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\xF3\xB4\xB7\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\xF3\xB4\xB7\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\xF3\xB4\xB7\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\xF3\xB4\xB7\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\xF3\xB4\xB7\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\xF3\xB4\xB7\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\xF3\xB4\xB7\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\xF3\xB4\xB7\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\xF3\xB4\xB7\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\xF3\xB4\xB7\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\xF3\xB4\xB7\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFD"],
        ["\xF3\xB4\xB7\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\xF3\xB4\xB7\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\xF3\xB4\xB7\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\xF3\xB4\xB7\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\xF3\xB4\xB7\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\xF3\xB4\xB7\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\xF3\xB4\xB7\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xEC"],
        ["\xF3\xB4\xB7\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\xF3\xB4\xB7\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\xF3\xB4\xB7\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\xF3\xB4\xB8\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\xF3\xB4\xB8\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\xF3\xB4\xB8\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\xF3\xB4\xB8\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\xF3\xB4\xB8\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\xF3\xB4\xB8\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\xF3\xB4\xB8\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\xF3\xB4\xB8\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\xF3\xB4\xB8\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xFE"],
        ["\xF3\xB4\xB8\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x51"],
        ["\xF3\xB4\xB8\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x8A"],
        ["\xF3\xB4\xB9\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x89"],
        ["\xF3\xB4\xB9\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x8D"],
        ["\xF3\xB4\xB9\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x90"],
        ["\xF3\xB4\xB9\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x98"],
        ["\xF3\xB4\xB9\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x9F"],
        ["\xF3\xB4\xB9\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],
        ["\xF3\xB4\xB9\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],
        ["\xF3\xB4\xB9\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xBE"],
        ["\xF3\xB4\xB9\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xB2"],
        ["\xF3\xB4\xB9\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xDE"],
        ["\xF3\xB4\xB9\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xEA"],
        ["\xF3\xB4\xB9\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xFC"],
        ["\xF3\xB4\xB9\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xFE"],
        ["\xF3\xB4\xB9\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x46"],
        ["\xF3\xB4\xB9\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x53"],
        ["\xF3\xB4\xB9\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x54"],
        ["\xF3\xB4\xB9\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x88"],
        ["\xF3\xB4\xB9\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x92"],
        ["\xF3\xB4\xB9\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x9A"],
        ["\xF3\xB4\xB9\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xA3"],
        ["\xF3\xB4\xB9\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xBB"],
        ["\xF3\xB4\xB9\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xA7"],
        ["\xF3\xB4\xB9\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xAF"],
        ["\xF3\xB4\xB9\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xBD"],
        ["\xF3\xB4\xBA\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xBE"],
        ["\xF3\xB4\xBA\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8D"],
        ["\xF3\xB4\xBA\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],
        ["\xF3\xB4\xBA\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],
        ["\xF3\xB4\xBA\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x47"],
        ["\xF3\xB4\xBA\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x88"],
        ["\xF3\xB4\xBA\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x8F"],
        ["\xF3\xB4\xBA\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],
        ["\xF3\xB4\xBA\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],
        ["\xF3\xB4\xBA\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],
        ["\xF3\xB4\xBA\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],
        ["\xF3\xB4\xBA\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],
        ["\xF3\xB4\xBA\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],
        ["\xF3\xB4\xBA\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],
        ["\xF3\xB4\xBA\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],
        ["\xF3\xB4\xBA\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],
        ["\xF3\xB4\xBA\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\xF3\xB4\xBA\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],
        ["\xF3\xB4\xBA\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xFE"],
        ["\xF3\xB4\xBA\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\x42"],
        ["\xF3\xB4\xBA\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\x41"],
        ["\xF3\xB4\xBA\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\x84"],
        ["\xF3\xB4\xBA\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],
        ["\xF3\xB4\xBA\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],
        ["\xF3\xB4\xBA\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],
        ["\xF3\xB4\xBA\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],
        ["\xF3\xB4\xBA\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],
        ["\xF3\xB4\xBA\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],
        ["\xF3\xB4\xBB\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],
        ["\xF3\xB4\xBB\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],
        ["\xF3\xB4\xBB\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],
        ["\xF3\xB4\xBB\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],
        ["\xF3\xB4\xBB\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xFA"],
        ["\xF3\xB4\xBB\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xFB"],
        ["\xF3\xB4\xBB\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xFE"],
        ["\xF3\xB4\xBB\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x54"],
        ["\xF3\xB4\xBB\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x41"],
        ["\xF3\xB4\xBB\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x94"],
        ["\xF3\xB4\xBB\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x8D"],
        ["\xF3\xB4\xBB\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x96"],
        ["\xF3\xB4\xBB\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],
        ["\xF3\xB4\xBB\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],
        ["\xF3\xB4\xBB\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],
        ["\xF3\xB4\xBB\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x47"],
        ["\xF3\xB4\xBB\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x96"],
        ["\xF3\xB4\xBB\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x8E"],
        ["\xF3\xB4\xBB\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],
        ["\xF3\xB4\xBB\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],
        ["\xF3\xB4\xBB\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xCA"],
        ["\xF3\xB4\xBB\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xCC"],
        ["\xF3\xB4\xBB\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],
        ["\xF3\xB4\xBC\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xCF"],
        ["\xF3\xB4\xBC\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],
        ["\xF3\xB4\xBC\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],
        ["\xF3\xB4\xBC\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\xFD"],
        ["\xF3\xB4\xBC\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],
        ["\xF3\xB4\xBC\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x46"],
        ["\xF3\xB4\xBC\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x47"],
        ["\xF3\xB4\xBC\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x51"],
        ["\xF3\xB4\xBC\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x58"],
        ["\xF3\xB4\xBC\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEA"],
        ["\xF3\xB4\xBC\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x93"],
        ["\xF3\xB4\xBC\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xA2"],
        ["\xF3\xB4\xBC\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xA2"],
        ["\xF3\xB4\xBC\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xAE"],
        ["\xF3\xB4\xBC\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x8D"],
        ["\xF3\xB4\xBC\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xB5"],
        ["\xF3\xB4\xBC\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xDC"],
        ["\xF3\xB4\xBC\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xB9"],
        ["\xF3\xB4\xBC\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xCD"],
        ["\xF3\xB4\xBC\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xDF"],
        ["\xF3\xB4\xBC\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xEB"],
        ["\xF3\xB4\xBC\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xEC"],
        ["\xF3\xB4\xBC\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xFC"],
        ["\xF3\xB4\xBC\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xFD"],
        ["\xF3\xB4\xBC\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x42"],
        ["\xF3\xB4\xBC\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xC5\x6F"],
        ["\xF3\xB4\xBC\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x46"],
        ["\xF3\xB4\xBC\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x52"],
        ["\xF3\xB4\xBC\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x54"],
        ["\xF3\xB4\xBD\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xA2"],
        ["\xF3\xB4\xBD\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x9F"],
        ["\xF3\xB4\xBD\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xA8"],
        ["\xF3\xB4\xBD\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xA7"],
        ["\xF3\xB4\xBD\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xA9"],
        ["\xF3\xB4\xBD\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xB5"],
        ["\xF3\xB4\xBD\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xB6"],
        ["\xF3\xB4\xBD\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xCD"],
        ["\xF3\xB4\xBD\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xDE"],
        ["\xF3\xB4\xBD\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xDD"],
        ["\xF3\xB4\xBD\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xEE"],
        ["\xF3\xB4\xBD\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xFA"],
        ["\xF3\xB4\xBD\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x45"],
        ["\xF3\xB4\xBD\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x51"],
        ["\xF3\xB4\xBD\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x83"],
        ["\xF3\xB4\xBD\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x89"],
        ["\xF3\xB4\xBD\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x8C"],
        ["\xF3\xB4\xBD\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x90"],
        ["\xF3\xB4\xBD\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x96"],
        ["\xF3\xB4\xBD\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x95"],
        ["\xF3\xB4\xBD\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x9F"],
        ["\xF3\xB4\xBD\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x9D"],
        ["\xF3\xB4\xBD\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xA8"],
        ["\xF3\xB4\xBD\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xAD"],
        ["\xF3\xB4\xBE\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xB6"],
        ["\xF3\xB4\xBE\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xB7"],
        ["\xF3\xB4\xBE\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xF9\x72"],
        ["\xF3\xB4\xBE\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xDB"],
        ["\xF3\xB4\xBE\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xDF"],
        ["\xF3\xB4\xBE\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\xF3\xB4\xBE\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xEF"],
        ["\xF3\xB4\xBE\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x91"],
        ["\xF3\xB4\xBE\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x41"],
        ["\xF3\xB4\xBE\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\xF3\xB4\xBE\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\xF3\xB4\xBE\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\xF3\xB4\xBE\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\xF3\xB4\xBE\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\xF3\xB4\xBE\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\xF3\xB4\xBE\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\xF3\xB4\xBE\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\xF3\xB4\xBE\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\xF3\xB4\xBF\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\xF3\xB4\xBF\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\xF3\xB4\xBF\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\xF3\xB4\xBF\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\xF3\xB4\xBF\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\xF3\xB4\xBF\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\xF3\xB4\xBF\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\xF3\xB4\xBF\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\xF3\xB4\xBF\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\xF3\xB4\xBF\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\xF3\xB4\xBF\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\xF3\xB4\xBF\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\xF3\xB4\xBF\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\xF3\xB4\xBF\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\xF3\xB4\xBF\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\xF3\xB4\xBF\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\xF3\xB5\x80\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\xF3\xB5\x80\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\xF3\xB5\x80\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\xF3\xB5\x80\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\xF3\xB5\x80\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\xF3\xB5\x80\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\xF3\xB5\x80\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\xF3\xB5\x80\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\xF3\xB5\x80\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\xF3\xB5\x80\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\xF3\xB5\x81\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\xF3\xB5\x81\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\xF3\xB5\x81\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\xF3\xB5\x81\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\xF3\xB5\x81\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8E"],
        ["\xF3\xB5\x81\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\xF3\xB5\x81\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\xF3\xB5\x81\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\xF3\xB5\x81\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\xF3\xB5\x81\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\xF3\xB5\x81\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xCF"],
        ["\xF3\xB5\x81\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\xF3\xB5\x82\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xDF"],
        ["\xF3\xB5\x82\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x46"],
        ["\xF3\xB5\x82\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8A"],
        ["\xF3\xB5\x82\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\x8C"],
        ["\xF3\xB5\x82\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xA3"],
        ["\xF3\xB5\x82\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xAE"],
        ["\xF3\xB5\x82\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xB3"],
        ["\xF3\xB5\x82\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xBF"],
        ["\xF3\xB5\x82\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCA"],
        ["\xF3\xB5\x82\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCE"],
        ["\xF3\xB5\x82\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCB"],
        ["\xF3\xB5\x82\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xCD"],
        ["\xF3\xB5\x82\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xDE"],
        ["\xF3\xB5\x83\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x85\xFB"],
        ["\xF3\xB5\x83\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x44"],
        ["\xF3\xB5\x83\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x53"],
        ["\xF3\xB5\x83\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x55"],
        ["\xF3\xB5\x83\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x8F"],
        ["\xF3\xB5\x83\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\x92"],
        ["\xF3\xB5\x83\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA8"],
        ["\xF3\xB5\x83\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xAF"],
        ["\xF3\xB5\x83\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xB2"],
        ["\xF3\xB5\x84\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDA"],
        ["\xF3\xB5\x84\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xCB"],
        ["\xF3\xB5\x84\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDF"],
        ["\xF3\xB5\x84\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xDE"],
        ["\xF3\xB5\x84\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xEE"],
        ["\xF3\xB5\x84\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\xF3\xB5\x84\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xFD"],
        ["\xF3\xB5\x84\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\xF3\xB5\x84\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\xF3\xB5\x84\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\x95"],
        ["\xF3\xB5\x84\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xAE"],
        ["\xF3\xB5\x84\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xBF"],
        ["\xF3\xB5\x84\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xB8"],
        ["\xF3\xB5\x84\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCE"],
        ["\xF3\xB5\x84\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCB"],
        ["\xF3\xB5\x84\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xCC"],
        ["\xF3\xB5\x85\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDF"],
        ["\xF3\xB5\x85\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xDE"],
        ["\xF3\xB5\x85\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xFE"],
        ["\xF3\xB5\x85\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x87\xED"],
        ["\xF3\xB5\x85\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x44"],
        ["\xF3\xB5\x85\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x54"],
        ["\xF3\xB5\x85\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x53"],
        ["\xF3\xB5\x85\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x55"],
        ["\xF3\xB5\x85\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x83"],
        ["\xF3\xB5\x85\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8D"],
        ["\xF3\xB5\x85\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x88\x8E"],
        ["\xF3\xB5\x85\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\xF3\xB5\x85\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\x47"],
        ["\xF3\xB5\x85\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\xF3\xB5\x86\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\xF3\xB5\x86\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\xF3\xB5\x86\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\xF3\xB5\x86\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\xF3\xB5\x86\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\xF3\xB5\x86\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\xF3\xB5\x86\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\xF3\xB5\x86\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\xF3\xB5\x86\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\xF3\xB5\x86\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\xF3\xB5\x86\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\xF3\xB5\x86\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\xF3\xB5\x86\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\xF3\xB5\x86\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\xF3\xB5\x86\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\xF3\xB5\x86\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\xF3\xB5\x86\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\xF3\xB5\x86\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\xF3\xB5\x86\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\xF3\xB5\x86\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\xF3\xB5\x86\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8C\xFD"],
        ["\xF3\xB5\x87\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\xF3\xB5\x87\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\xF3\xB5\x87\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\xF3\xB5\x87\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\xF3\xB5\x87\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\xF3\xB5\x87\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\xF3\xB5\x87\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\xF3\xB5\x87\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\xF3\xB5\x87\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\xF3\xB5\x87\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\xF3\xB5\x87\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\xF3\xB5\x87\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\xF3\xB5\x87\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\xF3\xB5\x88\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\xF3\xB5\x88\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\xF3\xB5\x88\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\xF3\xB5\x88\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\xF3\xB5\x88\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\xF3\xB5\x88\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\xF3\xB5\x88\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\xF3\xB5\x88\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\xF3\xB5\x88\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\xF3\xB5\x88\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\xF3\xB5\x88\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\xF3\xB5\x88\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\xF3\xB5\x88\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\xF3\xB5\x88\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\xF3\xB5\x88\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\xF3\xB5\x88\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\xF3\xB5\x88\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xFE"],
        ["\xF3\xB5\x88\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\xF3\xB5\x88\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\xF3\xB5\x89\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\xF3\xB5\x89\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\xF3\xB5\x89\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\xF3\xB5\x89\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\xF3\xB5\x89\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\xF3\xB5\x89\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\xF3\xB5\x89\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x84\xEF"],
        ["\xF3\xB5\x89\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\xF3\xB5\x89\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\xF3\xB5\x89\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\xF3\xB5\x8A\x83",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\xF3\xB5\x8A\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\xF3\xB5\x8A\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\xF3\xB5\x8A\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\xF3\xB5\x8A\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\xF3\xB5\x8A\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\xF3\xB5\x8A\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\xF3\xB5\x8A\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\xF3\xB5\x8A\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\xF3\xB5\x8A\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\xF3\xB5\x8A\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\xF3\xB5\x8A\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\xF3\xB5\x8B\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\xF3\xB5\x8B\x82",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\xF3\xB5\x8B\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\xF3\xB5\x8B\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\xF3\xB5\x8B\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\xF3\xB5\x8B\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\xF3\xB5\x8B\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\xF3\xB5\x8B\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\xF3\xB5\x8B\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\xF3\xB5\x8B\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\xF3\xB5\x8B\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\x58"],
        ["\xF3\xB5\x8B\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\xF3\xB5\x8B\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\xF3\xB5\x8B\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xB4"],
        ["\xF3\xB5\x8B\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\xF3\xB5\x8B\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\xF3\xB5\x8B\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\xF3\xB5\x8B\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\xF3\xB5\x8B\xBF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\xF3\xB5\x8C\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\xF3\xB5\x8C\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\xF3\xB5\x8C\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\xF3\xB5\x8C\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\xF3\xB5\x8C\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\xF3\xB5\x8C\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\xF3\xB5\x8C\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\xF3\xB5\x8C\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\xF3\xB5\x8C\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\xF3\xB5\x8C\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\xF3\xB5\x8C\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\xF3\xB5\x8C\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\xF3\xB5\x8C\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\xF3\xB5\x8C\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\xF3\xB5\x8C\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\xF3\xB5\x8C\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\xF3\xB5\x8C\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\xF3\xB5\x8D\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x92\xFE"],
        ["\xF3\xB5\x8D\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\xF3\xB5\x8D\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\xF3\xB5\x8D\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\xF3\xB5\x8D\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\xF3\xB5\x8D\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\xF3\xB5\x8D\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\xF3\xB5\x8D\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\xF3\xB5\x8D\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\xF3\xB5\x8D\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\xF3\xB5\x8D\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\xF3\xB5\x8D\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\xF3\xB5\x8D\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\xF3\xB5\x8D\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\xF3\xB5\x8E\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\xF3\xB5\x8E\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\xF3\xB5\x8E\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\xF3\xB5\x8E\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\xF3\xB5\x8E\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\xF3\xB5\x8E\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\xF3\xB5\x8E\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\xF3\xB5\x8E\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\xF3\xB5\x8E\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\xF3\xB5\x8E\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\xF3\xB5\x8E\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\xF3\xB5\x8E\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\xF3\xB5\x8E\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\xF3\xB5\x8E\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\xF3\xB5\x8E\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\xF3\xB5\x8F\x85",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\xF3\xB5\x8F\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],
        ["\xF3\xB5\x8F\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\xF3\xB5\x8F\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\xF3\xB5\x8F\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\xF3\xB5\x8F\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\xF3\xB5\x8F\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\xF3\xB5\x8F\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\xF3\xB5\x8F\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\xF3\xB5\x8F\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\xF3\xB5\x8F\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\xF3\xB5\x8F\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\xF3\xB5\x8F\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\xF3\xB5\x8F\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\xF3\xB5\x8F\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\xF3\xB5\x8F\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\xF3\xB5\x8F\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\xF3\xB5\x8F\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\xF3\xB5\x8F\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\xF3\xB5\x8F\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\xF3\xB5\x8F\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\xF3\xB5\x90\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x95\xFD"],
        ["\xF3\xB5\x90\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\xF3\xB5\x90\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\xF3\xB5\x90\x96",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\xF3\xB5\x90\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\xF3\xB5\x90\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\xF3\xB5\x90\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\xF3\xB5\x90\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\xF3\xB5\x90\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\xF3\xB5\x90\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\xF3\xB5\x90\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\xF3\xB5\x91\x80",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\xF3\xB5\x91\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\xF3\xB5\x91\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\xF3\xB5\x91\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\xF3\xB5\x91\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFE"],
        ["\xF3\xB5\x91\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xFD"],
        ["\xF3\xB5\x91\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\xF3\xB5\x91\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\xF3\xB5\x91\xAF",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\xF3\xB5\x91\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\xF3\xB5\x91\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\xF3\xB5\x91\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\xF3\xB5\x92\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\xF3\xB5\x92\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\xF3\xB5\x92\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\xF3\xB5\x92\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\xF3\xB5\x92\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\xF3\xB5\x92\x91",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA7\x88"],
        ["\xF3\xB5\x92\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\xF3\xB5\x92\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\xF3\xB5\x92\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\xF3\xB5\x92\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\xF3\xB5\x92\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\xF3\xB5\x92\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\xF3\xB5\x92\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x83"],
        ["\xF3\xB5\x92\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x8A"],
        ["\xF3\xB5\x92\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x95"],
        ["\xF3\xB5\x92\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9D"],
        ["\xF3\xB5\x92\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9A"],
        ["\xF3\xB5\x92\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\x9E"],
        ["\xF3\xB5\x92\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\xF3\xB5\x92\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\xF3\xB5\x92\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\xF3\xB5\x93\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\xF3\xB5\x93\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\xF3\xB5\x93\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\xF3\xB5\x93\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\xF3\xB5\x93\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\xF3\xB5\x93\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\xF3\xB5\x93\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\xF3\xB5\x93\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\xF3\xB5\x93\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\xF3\xB5\x93\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\xF3\xB5\x93\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\xF3\xB5\x93\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\xF3\xB5\x93\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\xF3\xB5\x93\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\xF3\xB5\x93\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\xF3\xB5\x93\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\xF3\xB5\x94\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\xF3\xB5\x94\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\xF3\xB5\x94\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\xF3\xB5\x94\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\x8A"],
        ["\xF3\xB5\x94\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\xF3\xB5\x94\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\xF3\xB5\x94\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\xF3\xB5\x94\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\xF3\xB5\x94\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\xF3\xB5\x94\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\xF3\xB5\x94\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\xF3\xB5\x94\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\xF3\xB5\x95\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\xF3\xB5\x95\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\xF3\xB5\x95\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\xF3\xB5\x95\x8A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\xF3\xB5\x95\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\xF3\xB5\x95\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\xF3\xB5\x95\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\xF3\xB5\x95\x9A",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\xF3\xB5\x95\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\xF3\xB5\x95\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\xF3\xB5\x95\xA1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\xF3\xB5\x95\xA2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\xF3\xB5\x95\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\xF3\xB5\x95\xB0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\xF3\xB5\x95\xB2",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xFE"],
        ["\xF3\xB5\x95\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\xF3\xB5\x95\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\xF3\xB5\x95\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\xF3\xB5\x95\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\xF3\xB5\x96\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\xF3\xB5\x96\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\xF3\xB5\x96\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\xF3\xB5\x96\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\xF3\xB5\x96\xAC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\xF3\xB5\x96\xB4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\xF3\xB5\x96\xB5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\xF3\xB5\x96\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\xF3\xB5\x96\xBA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\xF3\xB5\x97\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\xF3\xB5\x97\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\xF3\xB5\x97\xA7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\xF3\xB5\x97\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\xF3\xB5\x97\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\xF3\xB5\x97\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\xF3\xB5\x97\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\xF3\xB5\x98\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\xF3\xB5\x98\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\xF3\xB5\x98\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\xF3\xB5\x99\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\x99"],
        ["\xF3\xB5\x99\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],
        ["\xF3\xB5\x99\x8C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],
        ["\xF3\xB5\x99\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],
        ["\xF3\xB5\x99\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xAF"],
        ["\xF3\xB5\x99\xAE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xBA"],
        ["\xF3\xB5\x99\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xBD"],
        ["\xF3\xB5\x9A\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xB7"],
        ["\xF3\xB5\x9A\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xB5"],
        ["\xF3\xB5\x9A\x8D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xB8"],
        ["\xF3\xB5\x9A\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xB9"],
        ["\xF3\xB5\x9A\x94",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],
        ["\xF3\xB5\x9A\x95",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xCE"],
        ["\xF3\xB5\x9A\x9F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA2\xEE"],
        ["\xF3\xB5\x9A\xA4",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x41"],
        ["\xF3\xB5\x9A\xA6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x43"],
        ["\xF3\xB5\x9A\xB3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\xF3\xB5\x9A\xB6",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x90"],
        ["\xF3\xB5\x9B\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\x9E"],
        ["\xF3\xB5\x9B\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xAD"],
        ["\xF3\xB5\x9B\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xA6"],
        ["\xF3\xB5\x9B\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xA8"],
        ["\xF3\xB5\x9B\x8E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],
        ["\xF3\xB5\x9B\x8F",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],
        ["\xF3\xB5\x9B\x97",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],
        ["\xF3\xB5\x9B\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x43"],
        ["\xF3\xB5\x9B\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x45"],
        ["\xF3\xB5\x9B\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x46"],
        ["\xF3\xB5\x9B\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\xF3\xB5\x9B\xB7",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x85"],
        ["\xF3\xB5\x9B\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x89"],
        ["\xF3\xB5\x9C\x81",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\x99"],
        ["\xF3\xB5\x9C\xBB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA4\xFB"],
        ["\xF3\xB5\x9D\x87",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA5\x8F"],
        ["\xF3\xB5\x9E\x8B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],
        ["\xF3\xB5\x9E\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],
        ["\xF3\xB5\x9F\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x41"],
        ["\xF3\xB5\x9F\xA5",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x86\xA7"],
        ["\xF3\xB5\x9F\xAD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x88"],
        ["\xF3\xB5\xA0\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xB3"],
        ["\xF3\xB5\xA0\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\xDE"],
        ["\xF3\xB5\xA0\x9B",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\xF3\xB5\xA1\xAA",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xBA"],
        ["\xF3\xB5\xA1\xB8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xB3"],
        ["\xF3\xB5\xA1\xBC",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xB7"],
        ["\xF3\xB5\xA2\x88",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xDA"],
        ["\xF3\xB5\xA2\x90",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA9\xFC"],
        ["\xF3\xB5\xA2\x93",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x41"],
        ["\xF3\xB5\xA2\x98",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x54"],
        ["\xF3\xB5\xA2\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x49"],
        ["\xF3\xB5\xA2\x9D",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x81"],
        ["\xF3\xB5\xA2\xA8",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x84"],
        ["\xF3\xB5\xA2\xA9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x86"],
        ["\xF3\xB5\xA2\xAB",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x87"],
        ["\xF3\xB5\xA2\xB9",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x8D"],
        ["\xF3\xB5\xA2\xBD",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x8E"],
        ["\xF3\xB5\xA2\xBE",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x8F"],
        ["\xF3\xB5\xA3\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x93"],
        ["\xF3\xB5\xA3\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\x98"],
        ["\xF3\xB5\xA3\x92",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xA4"],
        ["\xF3\xB5\xA3\x99",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xA6"],
        ["\xF3\xB5\xA3\x9C",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xA7"],
        ["\xF3\xB5\xA3\x9E",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xAC"],
        ["\xF3\xB5\xA3\xA0",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xA8\x9E"],
        ["\xF3\xB5\xA3\xA3",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xAE"],
        ["\xF3\xB5\xA3\xB1",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xBD"],
        ["\xF3\xB5\xA4\x84",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xDD"],
        ["\xF3\xB5\xA4\x86",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xDE"],
        ["\xF3\xB5\xA4\x89",'jipse','utf8jp',{'INPUT_LAYOUT'=>'D'},"\xAA\xEB"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e::RoundTrip;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::RoundTrip::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
