######################################################################
#
# 0021_cp932_vs_utf8_test.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x00"],
        ["\x01",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x01"],
        ["\x02",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x02"],
        ["\x03",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x03"],
        ["\x04",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x04"],
        ["\x05",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x05"],
        ["\x06",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x06"],
        ["\x07",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x07"],
        ["\x08",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x08"],
        ["\x09",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x09"],
        ["\x0A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x0A"],
        ["\x0B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x0B"],
        ["\x0C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x0C"],
        ["\x0D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x0D"],
        ["\x0E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x0E"],
        ["\x0F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x0F"],
        ["\x10",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x10"],
        ["\x11",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x11"],
        ["\x12",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x12"],
        ["\x13",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x13"],
        ["\x14",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x14"],
        ["\x15",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x15"],
        ["\x16",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x16"],
        ["\x17",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x17"],
        ["\x18",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x18"],
        ["\x19",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x19"],
        ["\x1A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x1A"],
        ["\x1B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x1B"],
        ["\x1C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x1C"],
        ["\x1D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x1D"],
        ["\x1E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x1E"],
        ["\x1F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x1F"],
        ["\x20",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x20"],
        ["\x21",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x21"],
        ["\x22",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x22"],
        ["\x23",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x23"],
        ["\x24",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x24"],
        ["\x25",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x25"],
        ["\x26",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x26"],
        ["\x27",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x27"],
        ["\x28",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x28"],
        ["\x29",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x29"],
        ["\x2A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x2A"],
        ["\x2B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x2B"],
        ["\x2C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x2C"],
        ["\x2D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x2D"],
        ["\x2E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x2E"],
        ["\x2F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x2F"],
        ["\x30",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x30"],
        ["\x31",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x31"],
        ["\x32",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x32"],
        ["\x33",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x33"],
        ["\x34",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x34"],
        ["\x35",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x35"],
        ["\x36",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x36"],
        ["\x37",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x37"],
        ["\x38",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x38"],
        ["\x39",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x39"],
        ["\x3A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x3A"],
        ["\x3B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x3B"],
        ["\x3C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x3C"],
        ["\x3D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x3D"],
        ["\x3E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x3E"],
        ["\x3F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x3F"],
        ["\x40",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x40"],
        ["\x41",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\x42",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\x43",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\x44",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\x45",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\x46",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\x47",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\x48",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\x49",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\x4A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x4A"],
        ["\x4B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x4B"],
        ["\x4C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x4C"],
        ["\x4D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x4D"],
        ["\x4E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x4E"],
        ["\x4F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x4F"],
        ["\x50",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x50"],
        ["\x51",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\x52",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\x53",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\x54",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\x55",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\x56",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\x57",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x57"],
        ["\x58",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\x59",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x59"],
        ["\x5A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x5A"],
        ["\x5B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x5B"],
        ["\x5C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x5C"],
        ["\x5D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x5D"],
        ["\x5E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x5E"],
        ["\x5F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x5F"],
        ["\x60",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x60"],
        ["\x61",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x61"],
        ["\x62",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x62"],
        ["\x63",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x63"],
        ["\x64",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x64"],
        ["\x65",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x65"],
        ["\x66",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x66"],
        ["\x67",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x67"],
        ["\x68",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x68"],
        ["\x69",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x69"],
        ["\x6A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x6A"],
        ["\x6B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x6B"],
        ["\x6C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x6C"],
        ["\x6D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x6D"],
        ["\x6E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x6E"],
        ["\x6F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x6F"],
        ["\x70",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x70"],
        ["\x71",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x71"],
        ["\x72",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x72"],
        ["\x73",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x73"],
        ["\x74",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x74"],
        ["\x75",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x75"],
        ["\x76",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x76"],
        ["\x77",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x77"],
        ["\x78",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x78"],
        ["\x79",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x79"],
        ["\x7A",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x7A"],
        ["\x7B",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x7B"],
        ["\x7C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x7C"],
        ["\x7D",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x7D"],
        ["\x7E",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x7E"],
        ["\x7F",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\x7F"],

        ["\x81\x5C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x95"],
        ["\x81\x60",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],
        ["\x81\x61",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA5"],
        ["\x81\x7C",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8D"],
        ["\x81\x91",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],
        ["\x81\x92",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],
        ["\x81\xCA",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA2"],
        ["\xFA\x55",'utf8','cp932',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA4"],

        ["\x00",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x00"],
        ["\x01",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x01"],
        ["\x02",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x02"],
        ["\x03",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x03"],
        ["\x04",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x04"],
        ["\x05",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x05"],
        ["\x06",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x06"],
        ["\x07",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x07"],
        ["\x08",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x08"],
        ["\x09",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x09"],
        ["\x0A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x0A"],
        ["\x0B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x0B"],
        ["\x0C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x0C"],
        ["\x0D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x0D"],
        ["\x0E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x0E"],
        ["\x0F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x0F"],
        ["\x10",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x10"],
        ["\x11",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x11"],
        ["\x12",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x12"],
        ["\x13",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x13"],
        ["\x14",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x14"],
        ["\x15",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x15"],
        ["\x16",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x16"],
        ["\x17",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x17"],
        ["\x18",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x18"],
        ["\x19",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x19"],
        ["\x1A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x1A"],
        ["\x1B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x1B"],
        ["\x1C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x1C"],
        ["\x1D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x1D"],
        ["\x1E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x1E"],
        ["\x1F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x1F"],
        ["\x20",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x20"],
        ["\x21",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x21"],
        ["\x22",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x22"],
        ["\x23",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x23"],
        ["\x24",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x24"],
        ["\x25",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x25"],
        ["\x26",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x26"],
        ["\x27",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x27"],
        ["\x28",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x28"],
        ["\x29",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x29"],
        ["\x2A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x2A"],
        ["\x2B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x2B"],
        ["\x2C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x2C"],
        ["\x2D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x2D"],
        ["\x2E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x2E"],
        ["\x2F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x2F"],
        ["\x30",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x30"],
        ["\x31",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x31"],
        ["\x32",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x32"],
        ["\x33",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x33"],
        ["\x34",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x34"],
        ["\x35",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x35"],
        ["\x36",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x36"],
        ["\x37",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x37"],
        ["\x38",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x38"],
        ["\x39",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x39"],
        ["\x3A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x3A"],
        ["\x3B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x3B"],
        ["\x3C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x3C"],
        ["\x3D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x3D"],
        ["\x3E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x3E"],
        ["\x3F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x3F"],
        ["\x40",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x40"],
        ["\x41",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x41"],
        ["\x42",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x42"],
        ["\x43",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x43"],
        ["\x44",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x44"],
        ["\x45",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x45"],
        ["\x46",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x46"],
        ["\x47",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x47"],
        ["\x48",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x48"],
        ["\x49",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x49"],
        ["\x4A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x4A"],
        ["\x4B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x4B"],
        ["\x4C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x4C"],
        ["\x4D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x4D"],
        ["\x4E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x4E"],
        ["\x4F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x4F"],
        ["\x50",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x50"],
        ["\x51",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x51"],
        ["\x52",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x52"],
        ["\x53",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x53"],
        ["\x54",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x54"],
        ["\x55",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x55"],
        ["\x56",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x56"],
        ["\x57",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x57"],
        ["\x58",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x58"],
        ["\x59",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x59"],
        ["\x5A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x5A"],
        ["\x5B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x5B"],
        ["\x5C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x5C"],
        ["\x5D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x5D"],
        ["\x5E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x5E"],
        ["\x5F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x5F"],
        ["\x60",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x60"],
        ["\x61",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x61"],
        ["\x62",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x62"],
        ["\x63",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x63"],
        ["\x64",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x64"],
        ["\x65",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x65"],
        ["\x66",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x66"],
        ["\x67",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x67"],
        ["\x68",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x68"],
        ["\x69",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x69"],
        ["\x6A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x6A"],
        ["\x6B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x6B"],
        ["\x6C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C"],
        ["\x6D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x6D"],
        ["\x6E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x6E"],
        ["\x6F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F"],
        ["\x70",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x70"],
        ["\x71",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x71"],
        ["\x72",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x72"],
        ["\x73",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x73"],
        ["\x74",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x74"],
        ["\x75",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x75"],
        ["\x76",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x76"],
        ["\x77",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x77"],
        ["\x78",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x78"],
        ["\x79",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x79"],
        ["\x7A",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x7A"],
        ["\x7B",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x7B"],
        ["\x7C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C"],
        ["\x7D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x7D"],
        ["\x7E",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x7E"],
        ["\x7F",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F"],

        ["\xE2\x80\x95",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\xE3\x80\x9C",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\xE2\x88\xA5",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\xEF\xBC\x8D",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\xEF\xBF\xA0",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\xEF\xBF\xA1",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\xEF\xBF\xA2",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\xEF\xBF\xA4",'cp932','utf8',{'INPUT_LAYOUT'=>'D'},"\xFA\x55"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
