# Generated by default/object.tt
package Paws::Honeycode::ResultSet;
  use Moose;
  has Headers => (is => 'ro', isa => 'ArrayRef[Paws::Honeycode::ColumnMetadata]', request_name => 'headers', traits => ['NameInRequest'], required => 1);
  has Rows => (is => 'ro', isa => 'ArrayRef[Paws::Honeycode::ResultRow]', request_name => 'rows', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::ResultSet

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::ResultSet object:

  $service_obj->Method(Att1 => { Headers => $value, ..., Rows => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::ResultSet object:

  $result = $service_obj->Method(...);
  $result->Att1->Headers

=head1 DESCRIPTION

ResultSet contains the results of the request for a single block or
list defined on the screen.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Headers => ArrayRef[L<Paws::Honeycode::ColumnMetadata>]

List of headers for all the data cells in the block. The header
identifies the name and default format of the data cell. Data cells
appear in the same order in all rows as defined in the header. The
names and formats are not repeated in the rows. If a particular row
does not have a value for a data cell, a blank value is used.

For example, a task list that displays the task name, due date and
assigned person might have headers [ { "name": "Task Name"}, {"name":
"Due Date", "format": "DATE"}, {"name": "Assigned", "format":
"CONTACT"} ]. Every row in the result will have the task name as the
first item, due date as the second item and assigned person as the
third item. If a particular task does not have a due date, that row
will still have a blank value in the second element and the assigned
person will still be in the third element.


=head2 B<REQUIRED> Rows => ArrayRef[L<Paws::Honeycode::ResultRow>]

List of rows returned by the request. Each row has a row Id and a list
of data cells in that row. The data cells will be present in the same
order as they are defined in the header.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

