/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.afm.AFMParser;
import org.apache.fontbox.afm.FontMetric;
import org.apache.fontbox.cff.AFMFormatter;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.Type1FontFormatter;
import org.apache.fontbox.cff.charset.CFFCharset;
import org.apache.fontbox.cff.encoding.CFFEncoding;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.common.PDMatrix;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorAFM;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDType1CFont
extends PDSimpleFont {
    private CFFFont cffFont = null;
    private Map<Integer, String> codeToName = new HashMap<Integer, String>();
    private Map<Integer, String> codeToCharacter = new HashMap<Integer, String>();
    private Map<String, Integer> characterToCode = new HashMap<String, Integer>();
    private FontMetric fontMetric = null;
    private Font awtFont = null;
    private Map<String, Float> glyphWidths = new HashMap<String, Float>();
    private Map<String, Float> glyphHeights = new HashMap<String, Float>();
    private Float avgWidth = null;
    private PDRectangle fontBBox = null;
    private PDMatrix fontMatrix = null;
    private static final Log log = LogFactory.getLog(PDType1CFont.class);
    private static final byte[] SPACE_BYTES = new byte[]{32};

    public PDType1CFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.load();
    }

    @Override
    public String encode(byte[] bytes, int offset, int length) throws IOException {
        String character = this.getCharacter(bytes, offset, length);
        if (character == null) {
            log.debug((Object)("No character for code " + (bytes[offset] & 0xFF) + " in " + this.cffFont.getName()));
            return null;
        }
        return character;
    }

    private String getCharacter(byte[] bytes, int offset, int length) {
        if (length != 1) {
            return null;
        }
        Integer code = bytes[offset] & 0xFF;
        return this.codeToCharacter.get(code);
    }

    @Override
    public float getFontWidth(byte[] bytes, int offset, int length) throws IOException {
        String name = this.getName(bytes, offset, length);
        if (name == null && !Arrays.equals(SPACE_BYTES, bytes)) {
            log.debug((Object)("No name for code " + (bytes[offset] & 0xFF) + " in " + this.cffFont.getName()));
            return 0.0f;
        }
        Float width = this.glyphWidths.get(name);
        if (width == null) {
            width = Float.valueOf(this.fontMetric.getCharacterWidth(name));
            this.glyphWidths.put(name, width);
        }
        return width.floatValue();
    }

    @Override
    public float getFontHeight(byte[] bytes, int offset, int length) throws IOException {
        String name = this.getName(bytes, offset, length);
        if (name == null) {
            log.debug((Object)("No name for code " + (bytes[offset] & 0xFF) + " in " + this.cffFont.getName()));
            return 0.0f;
        }
        Float height = this.glyphHeights.get(name);
        if (height == null) {
            height = Float.valueOf(this.fontMetric.getCharacterHeight(name));
            this.glyphHeights.put(name, height);
        }
        return height.floatValue();
    }

    private String getName(byte[] bytes, int offset, int length) {
        if (length != 1) {
            return null;
        }
        Integer code = bytes[offset] & 0xFF;
        return this.codeToName.get(code);
    }

    @Override
    public float getStringWidth(String string) throws IOException {
        float width = 0.0f;
        for (int i = 0; i < string.length(); ++i) {
            String character = string.substring(i, i + 1);
            Integer code = this.getCode(character);
            if (code == null) {
                log.debug((Object)("No code for character " + character));
                return 0.0f;
            }
            width += this.getFontWidth(new byte[]{(byte)code.intValue()}, 0, 1);
        }
        return width;
    }

    private Integer getCode(String character) {
        return this.characterToCode.get(character);
    }

    @Override
    public PDFontDescriptor getFontDescriptor() throws IOException {
        return new PDFontDescriptorAFM(this.fontMetric);
    }

    @Override
    public float getAverageFontWidth() throws IOException {
        if (this.avgWidth == null) {
            this.avgWidth = Float.valueOf(this.fontMetric.getAverageCharacterWidth());
        }
        return this.avgWidth.floatValue();
    }

    @Override
    public PDRectangle getFontBoundingBox() throws IOException {
        if (this.fontBBox == null) {
            this.fontBBox = new PDRectangle(this.fontMetric.getFontBBox());
        }
        return this.fontBBox;
    }

    @Override
    public PDMatrix getFontMatrix() {
        if (this.fontMatrix == null) {
            List numbers = (List)this.cffFont.getProperty("FontMatrix");
            if (numbers != null && numbers.size() == 6) {
                COSArray array = new COSArray();
                for (Number number : numbers) {
                    array.add(new COSFloat(number.floatValue()));
                }
                this.fontMatrix = new PDMatrix(array);
            } else {
                this.fontMatrix = super.getFontMatrix();
            }
        }
        return this.fontMatrix;
    }

    @Override
    public void drawString(String string, Graphics g, float fontSize, AffineTransform at, float x, float y) throws IOException {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.writeFont(g2d, at, this.awtFont, fontSize, x, y, string);
    }

    private void load() throws IOException {
        Map nameToCharacter;
        byte[] cffBytes = this.loadBytes();
        CFFParser cffParser = new CFFParser();
        List fonts = cffParser.parse(cffBytes);
        this.cffFont = (CFFFont)fonts.get(0);
        CFFEncoding encoding = this.cffFont.getEncoding();
        PDFEncoding pdfEncoding = new PDFEncoding(encoding);
        CFFCharset charset = this.cffFont.getCharset();
        PDFCharset pdfCharset = new PDFCharset(charset);
        Map charStringsDict = this.cffFont.getCharStringsDict();
        LinkedHashMap pdfCharStringsDict = new LinkedHashMap();
        pdfCharStringsDict.put(".notdef", charStringsDict.get(".notdef"));
        LinkedHashMap<Integer, String> codeToNameMap = new LinkedHashMap<Integer, String>();
        Collection mappings = this.cffFont.getMappings();
        for (CFFFont.Mapping mapping : mappings) {
            Integer code = mapping.getCode();
            String name = mapping.getName();
            codeToNameMap.put(code, name);
        }
        HashSet knownNames = new HashSet(codeToNameMap.values());
        Map<Integer, String> codeToNameOverride = this.loadOverride();
        for (Map.Entry<Integer, String> entry : codeToNameOverride.entrySet()) {
            Integer code = entry.getKey();
            String name = entry.getValue();
            if (!knownNames.contains(name)) continue;
            codeToNameMap.put(code, name);
        }
        try {
            Field nameToCharacterField = Encoding.class.getDeclaredField("NAME_TO_CHARACTER");
            nameToCharacterField.setAccessible(true);
            nameToCharacter = (Map)nameToCharacterField.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : codeToNameMap.entrySet()) {
            Integer code = (Integer)entry.getKey();
            String name = (String)entry.getValue();
            String uniName = "uni";
            String character = (String)nameToCharacter.get(COSName.getPDFName(name));
            if (character != null) {
                for (int j = 0; j < character.length(); ++j) {
                    uniName = uniName + PDType1CFont.hexString(character.charAt(j), 4);
                }
            } else {
                uniName = uniName + PDType1CFont.hexString(code, 4);
                character = String.valueOf((char)code.intValue());
            }
            pdfEncoding.register(code, code);
            pdfCharset.register(code, uniName);
            this.codeToName.put(code, uniName);
            this.codeToCharacter.put(code, character);
            this.characterToCode.put(character, code);
            pdfCharStringsDict.put(uniName, charStringsDict.get(name));
        }
        this.cffFont.setEncoding((CFFEncoding)pdfEncoding);
        this.cffFont.setCharset((CFFCharset)pdfCharset);
        charStringsDict.clear();
        charStringsDict.putAll(pdfCharStringsDict);
        this.fontMetric = PDType1CFont.prepareFontMetric(this.cffFont);
        this.awtFont = PDType1CFont.prepareAwtFont(this.cffFont);
        Number defaultWidthX = (Number)this.cffFont.getProperty("defaultWidthX");
        this.glyphWidths.put(null, Float.valueOf(defaultWidthX.floatValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadBytes() throws IOException {
        COSStream ff3Stream;
        COSDictionary fontDic = (COSDictionary)this.font.getDictionaryObject(COSName.FONT_DESC);
        if (fontDic != null && (ff3Stream = (COSStream)fontDic.getDictionaryObject("FontFile3")) != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            InputStream is = ff3Stream.getUnfilteredStream();
            try {
                int count;
                byte[] buf = new byte[512];
                while ((count = is.read(buf)) >= 0) {
                    os.write(buf, 0, count);
                }
            }
            finally {
                is.close();
            }
            return os.toByteArray();
        }
        throw new IOException();
    }

    private Map<Integer, String> loadOverride() throws IOException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        COSBase encoding = this.font.getDictionaryObject(COSName.ENCODING);
        if (encoding instanceof COSName) {
            COSName name = (COSName)encoding;
            result.putAll(this.loadEncoding(name));
        } else if (encoding instanceof COSDictionary) {
            COSArray differences;
            COSDictionary encodingDic = (COSDictionary)encoding;
            COSName baseName = (COSName)encodingDic.getDictionaryObject(COSName.BASE_ENCODING);
            if (baseName != null) {
                result.putAll(this.loadEncoding(baseName));
            }
            if ((differences = (COSArray)encodingDic.getDictionaryObject(COSName.DIFFERENCES)) != null) {
                result.putAll(this.loadDifferences(differences));
            }
        }
        return result;
    }

    private Map<Integer, String> loadEncoding(COSName name) throws IOException {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        EncodingManager encodingManager = new EncodingManager();
        Encoding encoding = encodingManager.getEncoding(name);
        for (Map.Entry<Integer, COSName> entry : encoding.getCodeToNameMap().entrySet()) {
            result.put(entry.getKey(), entry.getValue().getName());
        }
        return result;
    }

    private Map<Integer, String> loadDifferences(COSArray differences) {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        Integer code = null;
        for (int i = 0; i < differences.size(); ++i) {
            COSBase element = differences.get(i);
            if (element instanceof COSNumber) {
                COSNumber number = (COSNumber)element;
                code = number.intValue();
                continue;
            }
            if (!(element instanceof COSName)) continue;
            COSName name = (COSName)element;
            result.put(code, name.getName());
            code = code + 1;
        }
        return result;
    }

    private static String hexString(int code, int length) {
        String string = Integer.toHexString(code);
        while (string.length() < length) {
            string = "0" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontMetric prepareFontMetric(CFFFont font) throws IOException {
        byte[] afmBytes = AFMFormatter.format((CFFFont)font);
        ByteArrayInputStream is = new ByteArrayInputStream(afmBytes);
        try {
            AFMParser afmParser = new AFMParser((InputStream)is);
            afmParser.parse();
            FontMetric result = afmParser.getResult();
            BoundingBox bounds = result.getFontBBox();
            List<Integer> numbers = Arrays.asList((int)bounds.getLowerLeftX(), (int)bounds.getLowerLeftY(), (int)bounds.getUpperRightX(), (int)bounds.getUpperRightY());
            font.addValueToTopDict("FontBBox", numbers);
            FontMetric fontMetric = result;
            return fontMetric;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static Font prepareAwtFont(CFFFont font) throws IOException {
        byte[] type1Bytes = Type1FontFormatter.format((CFFFont)font);
        ByteArrayInputStream is = new ByteArrayInputStream(type1Bytes);
        try {
            Font font2 = Font.createFont(1, is);
            return font2;
        }
        catch (FontFormatException ffe) {
            throw new WrappedIOException(ffe);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static class PDFCharset
    extends CFFCharset {
        private CFFCharset parentCharset = null;

        private PDFCharset(CFFCharset parent) {
            this.parentCharset = parent;
        }

        public boolean isFontSpecific() {
            return true;
        }

        public void register(int sid, String name) {
            super.register(sid, name);
        }
    }

    private static class PDFEncoding
    extends CFFEncoding {
        private CFFEncoding parentEncoding = null;

        private PDFEncoding(CFFEncoding parent) {
            this.parentEncoding = parent;
        }

        public boolean isFontSpecific() {
            return true;
        }

        public void register(int code, int sid) {
            super.register(code, sid);
        }
    }
}

