######################################################################
#
# makealldists.pl - make all encoding distributions from Char
#
# Copyright (c) 2010, 2011, 2012, 2013, 2015 INABA Hitoshi <ina@cpan.org>
#
######################################################################

use strict;
use File::Copy;

my @encoding = (
    'Sjis',
    'USASCII',
    'UTF2',
    'GB18030',
    'EUCJP',
    'EUCTW',
    'HP15',
    'INFORMIXV6ALS',
    'Big5HKSCS',
    'Big5Plus',
    'UHC',
    'KPS9566',
    'GBK',
    'OldUTF8',
    'Latin1',
    'Latin2',
    'Latin3',
    'Latin4',
    'Cyrillic',
    'Arabic',
    'Greek',
    'Hebrew',
    'Latin5',
    'Latin6',
    'TIS620',
    'Latin7',
    'Latin8',
    'Latin9',
    'Latin10',
    'JIS8',
    'KOI8R',
    'KOI8U',
    'Windows1252',
    'Windows1258',
);

for my $encoding (@encoding) {
    sleep(1);
    mkdir($encoding,0777);

    open(TEST,">test.pl") || die "Can't open file: test.pl, q(;_;)bad!!\n";
    binmode TEST;
    print TEST <<END;
# encoding: $encoding;
use Char;

\$| = 1;
print "1..1\\n";
print "ok - 1\\n";
exit;
END
    close(TEST);
    mysystem(qq{$^X test.pl});

    open(TEST,">test.pl") || die "Can't open file: test.pl, q(;_;)bad!!\n";
    binmode TEST;
    print TEST <<END;
use $encoding;

\$| = 1;
print "1..1\\n";
print "ok - 1\\n";
exit;
END
    close(TEST);
    mysystem(qq{$^X test.pl});

    for my $file (
        "$encoding.pm",
        "E\L$encoding\E.pm",
        'test.pl',
        'Changes',
        'pMakefile.PL',
    ){
        mycopy($file, "$encoding/$file");
    }

    for my $file (
        'README',
        'META.yml',
        'Makefile.PL',
    ) {
        open(FILE1,$file) || die "Can't open file: $file, q(;_;)bad!!\n";
        binmode FILE1;
        open(FILE2,">$encoding/$file") || die "Can't open file: $encoding/$file, q(;_;)bad!!\n";
        binmode FILE2;
        while (<FILE1>) {
            s!Character Oriented Perl by Magic Comment!Source code filter to escape $encoding script!;
            s!# encoding: [^ \n]+!# encoding: $encoding!;
            s!\bChar\b!$encoding!g;
            print FILE2 $_;
        }
        close(FILE1);
        close(FILE2);
    }

    mycopy("README2ND/README2ND.$encoding","$encoding/README2ND");

    mkdir("$encoding/Char",0777);
    open(FILE,">$encoding/Char/$encoding.pm") || die "Can't open file: $encoding/Char/$encoding.pm, q(;_;)bad!!\n";
    binmode FILE;
    print FILE <<END;
# This is a dummy file to implement CPAN naming goals.
package Char::$encoding;

# On The Naming of Modules/NAMES TO AVOID/Top-level namespaces
# https://pause.perl.org/pause/query?ACTION=pause_namingmodules#Top_level_namespaces

1;

__END__
END
    close(FILE);

    open(ENCODING_MANIFEST,">$encoding/MANIFEST") || die "Can't open file: $encoding/MANIFEST, q(;_;)bad!!\n";
    binmode ENCODING_MANIFEST;
    for my $file (
        "Char/$encoding.pm",
        "$encoding.pm",
        "E\L$encoding\E.pm",
        'README',
        'Changes',
        'META.yml',
        'Makefile.PL',
        'pMakefile.PL',
        'test.pl',
        'README2ND',
        'MANIFEST',
    ) {
        check_usascii("$encoding/$file");
        print ENCODING_MANIFEST $file, "\n";
    }

    open(CHAR_MANIFEST,'MANIFEST') || die "Can't open file: MANIFEST, q(;_;)bad!!\n";
    binmode CHAR_MANIFEST;
    mkdir("$encoding/t", 0777);
    mkdir("$encoding/t/$encoding", 0777);
    while (my $file = <CHAR_MANIFEST>) {
        chomp $file;
        if ($file =~ m{^x?t/$encoding/.*\.t$}) {
            open(FILE1,$file) || die "Can't open file: $file, q(;_;)bad!!\n";
            binmode FILE1;
            (my $file2 = $file) =~ s#^xt/#t/#;
            print ENCODING_MANIFEST $file2, "\n";
            open(FILE2,">$encoding/$file2") || die "Can't open file: $encoding/$file2, q(;_;)bad!!\n";
            binmode FILE2;
            while (<FILE1>) {
                s!# encoding: [^ \n]+!# encoding: $encoding!;
                s!\bChar\b!$encoding!g;
                print FILE2 $_;
            }
            close(FILE1);
            close(FILE2);
        }
    }
    close(CHAR_MANIFEST);

    close(ENCODING_MANIFEST);

    mychdir($encoding);
    mysystem(qq{$^X pMakefile.PL});
    if ($^O eq 'MSWin32') {
        mysystem(qq{$^X pmake.bat dist});
    }
    else {
        mysystem(qq{$^X ./pmake dist});
    }
    mysystem(qq{$^X test.pl});
    mychdir('..');
}

print STDERR "\nALL OK, d('o')good!!\n";
exit 0;

sub mysystem {
    if (system($_[0]) != 0) {
        die "error at system($_[0]), q(;_;)bad!!\n";
    }
}

sub mychdir {
    if (chdir($_[0]) == 0) {
        die "error at chdir($_[0]), q(;_;)bad!!\n";
    }
}

sub mycopy {
    if (copy($_[0],$_[1]) == 0) {
        die qq{error at copy("$_[0]","$_[1]"), q(;_;)bad!!\n};
    }
}

sub check_usascii {
    my($file) = @_;
    if (open(FILE,$file)) {
        while (<FILE>) {
            if (not /^[\x0A\x20-\x7E]+$/) {
                die "error not US-ASCII: $file, q(;_;)bad!!\n";
            }
        }
        close(FILE);
    }
    else {
        die "error open: $file, q(;_;)bad!!\n";
    }
}

__END__

=pod

=head1 NAME

makealldists.pl - make all encoding distributions from Char

=head1 SYNOPSIS

  perl makealldists.pl

=head1 DEPENDENCIES

This software requires perl5.00503 or later.

=head1 AUTHOR

INABA Hitoshi E<lt>ina@cpan.orgE<gt>

This project was originated by INABA Hitoshi.

=head1 LICENSE AND COPYRIGHT

This software is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.

This software is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

=head1 SEE ALSO

 CPAN Directory INABA Hitoshi
 http://search.cpan.org/~ina/

 BackPAN
 http://backpan.perl.org/authors/id/I/IN/INA/

 Recent Perl packages by "INABA Hitoshi"
 http://code.activestate.com/ppm/author:INABA-Hitoshi/

=cut

